package jp.sourceforge.nicoro;

import static jp.sourceforge.nicoro.Log.LOG_TAG;

import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.preference.PreferenceManager;
import android.support.v4.app.ListFragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.AsyncTaskLoader;
import android.support.v4.content.Loader;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.Spinner;

import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;

public class MylistFragment extends ListFragment
implements WebBrowserFragmentStarter, LoaderManager.LoaderCallbacks<ChangeReference<JSONObject>> {
    private static final boolean DEBUG_LOGD = Release.IS_DEBUG & true;
//    private static final boolean DEBUG_LOGV = Release.IS_DEBUG & false;

    private static final int MSG_ID_LOAD_OCCURED_ERROR = 0;
    private static final int MSG_ID_CHANGE_LIST = 1;
    private static final int MSG_ID_ADAPTER_ON_STOP = 2;

    private static final String KEY_GROUP_ID = "group_id";

    private static final String KEY_STATE_MYLIST_GROUP = "MylistGroup";
    private static final String KEY_STATE_MYLIST_GROUP_SELECT = "SpinnerMylist";
    private static final String KEY_STATE_MYLIST_SORT = "SpinnerSort";

    private Context mContext;
//    private SharedPreferences mSharedPreferences;

    private MylistListAdapter mAdapter;

    private ListEmptyProgressManager mEmptyProgress;
    private Spinner mSpinnerMylist;
    private Spinner mSpinnerSort;

    private CallbackMessage<String, Void> mBrowserStarter;

    private String mLastGroupId;

    private JSONObject mMylistGroup;

    private ArrayList<Comparator<JSONObject>> mMylistComparators;

    private String mResStringInfoCountPlay;
    private String mResStringInfoCountComment;
    private String mResStringInfoCountMylist;
    private String mResStringUpload;
    private int mResIntegerMylistSortNewCreate;
    private int mResIntegerMylistSortOldCreate;
    private int mResIntegerMylistSortTitleAscending;
    private int mResIntegerMylistSortTitleDescending;
    private int mResIntegerMylistSortMylistCommentAscending;
    private int mResIntegerMylistSortMylistCommentDescending;
    private int mResIntegerMylistSortNewUpload;
    private int mResIntegerMylistSortOldUpload;
    private int mResIntegerMylistSortManyViews;
    private int mResIntegerMylistSortFewViews;
    private int mResIntegerMylistSortNewComment;
    private int mResIntegerMylistSortOldComment;
    private int mResIntegerMylistSortManyComments;
    private int mResIntegerMylistSortFewComments;
    private int mResIntegerMylistSortManyMylists;
    private int mResIntegerMylistSortFewMylists;
    private int mResIntegerMylistSortLongPlayTime;
    private int mResIntegerMylistSortShortPlayTime;

    private Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            if (isRemoving()) {
                if (DEBUG_LOGD) {
                    Log.d(LOG_TAG, Log.buf().append("Fragment is removing. ignore message=")
                            .append(msg.toString()).toString());
                }
                return;
            }
            switch (msg.what) {
                case MSG_ID_LOAD_OCCURED_ERROR:
                    mAdapter.setItems(null);
                    mAdapter.notifyDataSetChanged();
                    mEmptyProgress.setEmptyText(R.string.empty_mylist_fragment_error);
                    mEmptyProgress.showEmptyText();
                    // TODO エラーダイアログどうするか
                    break;
                case MSG_ID_CHANGE_LIST:
                    // 重複イベントは削除
                    removeMessages(MSG_ID_CHANGE_LIST);

                    selectMylistGroup(mSpinnerMylist.getSelectedItemPosition());
                    break;
                case MSG_ID_ADAPTER_ON_STOP:
                    // XXX 非表示なのにGC後のリスト操作が入るとIllegalStateExceptionの可能性
                    mAdapter.onStop();
                    break;

                default:
                    assert false : msg.what;
                    break;
            }
        }
    };

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        mContext = getActivity().getApplicationContext();
//        mSharedPreferences = PreferenceManager.getDefaultSharedPreferences(mContext);

        Resources res = mContext.getResources();
        mResStringInfoCountPlay = res.getString(R.string.info_count_play);
        mResStringInfoCountComment = res.getString(R.string.info_count_comment);
        mResStringInfoCountMylist = res.getString(R.string.info_count_mylist);
        mResStringUpload = res.getString(R.string.upload);

        mResIntegerMylistSortNewCreate = res.getInteger(
                R.integer.mylist_sort_new_create);
        mResIntegerMylistSortOldCreate = res.getInteger(
                R.integer.mylist_sort_old_create);
        mResIntegerMylistSortTitleAscending = res.getInteger(
                R.integer.mylist_sort_title_ascending);
        mResIntegerMylistSortTitleDescending = res.getInteger(
                R.integer.mylist_sort_title_descending);
        mResIntegerMylistSortMylistCommentAscending = res.getInteger(
                R.integer.mylist_sort_mylist_comment_ascending);
        mResIntegerMylistSortMylistCommentDescending = res.getInteger(
                R.integer.mylist_sort_mylist_comment_descending);
        mResIntegerMylistSortNewUpload = res.getInteger(
                R.integer.mylist_sort_new_upload);
        mResIntegerMylistSortOldUpload = res.getInteger(
                R.integer.mylist_sort_old_upload);
        mResIntegerMylistSortManyViews = res.getInteger(
                R.integer.mylist_sort_many_views);
        mResIntegerMylistSortFewViews = res.getInteger(
                R.integer.mylist_sort_few_views);
        mResIntegerMylistSortNewComment = res.getInteger(
                R.integer.mylist_sort_new_comment);
        mResIntegerMylistSortOldComment = res.getInteger(
                R.integer.mylist_sort_old_comment);
        mResIntegerMylistSortManyComments = res.getInteger(
                R.integer.mylist_sort_many_comments);
        mResIntegerMylistSortFewComments = res.getInteger(
                R.integer.mylist_sort_few_comments);
        mResIntegerMylistSortManyMylists = res.getInteger(
                R.integer.mylist_sort_many_my_lists);
        mResIntegerMylistSortFewMylists = res.getInteger(
                R.integer.mylist_sort_few_my_lists);
        mResIntegerMylistSortLongPlayTime = res.getInteger(
                R.integer.mylist_sort_long_play_time);
        mResIntegerMylistSortShortPlayTime = res.getInteger(
                R.integer.mylist_sort_short_play_time);

        setMylistComparators();
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
            Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.mylist_list, container, false);
        mEmptyProgress = new ListEmptyProgressManager(v);
        mEmptyProgress.setEmptyText(R.string.empty_mylist_fragment_pre);
        mEmptyProgress.showEmptyText();

        mSpinnerMylist = Util.findViewById(v, R.id.spinner_mylist);
        mSpinnerMylist.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
//                selectMylistGroup(position);
                mHandler.sendEmptyMessage(MSG_ID_CHANGE_LIST);
            }
            @Override
            public void onNothingSelected(AdapterView<?> parent) {
            }
        });

        mSpinnerSort = Util.findViewById(v, R.id.spinner_sort);
        mSpinnerSort.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                mAdapter.sort(mMylistComparators.get(position));
                mAdapter.notifyDataSetChanged();
            }
            @Override
            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
        ArrayAdapter<?> adapter = ArrayAdapter.createFromResource(mContext,
                R.array.mylist_sort, R.layout.mylist_spinner_item);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        mSpinnerSort.setAdapter(adapter);

        return v;
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

        ListView listView = getListView();
        mAdapter = new MylistListAdapter();
        listView.setAdapter(mAdapter);
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view,
                    int position, long id) {
                if (mBrowserStarter != null) {
                    Object obj = mAdapter.getItem(position);
                    if (obj instanceof JSONObject) {
                        JSONObject item = (JSONObject) obj;
                        try {
                            JSONObject itemData = item.getJSONObject("item_data");
                            String watchId = itemData.getString("watch_id");
                            String url = "http://www.nicovideo.jp/watch/" + watchId;

                            mBrowserStarter.sendMessageSuccess(url);
                        } catch (JSONException e) {
                            Log.e(LOG_TAG, e.toString(), e);
                        }
                    }
                }
            }
        });

        if (savedInstanceState == null) {
        } else {
            String mylistGroup = savedInstanceState.getString(
                    KEY_STATE_MYLIST_GROUP);
            if (mylistGroup != null) {
                try {
                    setMylistGroup(new JSONObject(mylistGroup));
                    int select = savedInstanceState.getInt(
                            KEY_STATE_MYLIST_GROUP_SELECT, -1);
                    if (select >= 0 && select < mSpinnerMylist.getCount()) {
                        mSpinnerMylist.setSelection(select);
                    }
                    int sort = savedInstanceState.getInt(
                            KEY_STATE_MYLIST_SORT, -1);
                    if (sort >= 0 && sort < mSpinnerSort.getCount()) {
                        mSpinnerSort.setSelection(sort);
                    }
                } catch (JSONException e) {
                    Log.e(LOG_TAG, e.toString(), e);
                }
            }
        }
        if (mMylistGroup == null) {
            getLoaderManager().initLoader(R.id.loader_mylistgroup, null, this);
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        mHandler.removeMessages(MSG_ID_ADAPTER_ON_STOP);
        mAdapter.onStart();
    }

    @Override
    public void onPause() {
        super.onPause();
    }

    @Override
    public void onStop() {
        super.onStop();
        mLastGroupId = null;
        // リスト操作割り込みを避けるため少し遅らせて実行
        mHandler.sendEmptyMessageDelayed(MSG_ID_ADAPTER_ON_STOP, 500);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        mAdapter.setItems(null);
        mAdapter.notifyDataSetChanged();
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);

        if (mMylistGroup != null) {
            outState.putString(KEY_STATE_MYLIST_GROUP,
                    mMylistGroup.toString());
            outState.putInt(KEY_STATE_MYLIST_GROUP_SELECT,
                    mSpinnerMylist.getSelectedItemPosition());
            outState.putInt(KEY_STATE_MYLIST_SORT,
                    mSpinnerSort.getSelectedItemPosition());
        }
    }

    @Override
    public void setBrowserStarterCallback(CallbackMessage<String, Void> callback) {
        mBrowserStarter = callback;
    }

    @Override
    public void onLowMemory() {
        super.onLowMemory();

        // TODO 色々とメモリ足りないっぽい
        // JSONの消費メモリ大またはLoaderがメモリリーク？
        // 500件のJSONArrayは結構痛いっぽい

        // TODO 下手にdestroyすると逆効果？
//        if (mMylistGroup != null) {
//            getLoaderManager().destroyLoader(R.id.loader_mylistgroup);
//        }
//        if (mAdapter.getCount() != 0) {
//            getLoaderManager().destroyLoader(R.id.loader_mylist);
//        }
    }

    private void setMylistGroup(JSONObject json) {
        if (json == null) {
            mHandler.sendEmptyMessage(MSG_ID_LOAD_OCCURED_ERROR);
            return;
        }
        try {
            JSONArray group = json.getJSONArray("mylistgroup");
            int length = group.length();
            ArrayList<String> arrayName = new ArrayList<String>(length + 1);
            for (int i = 0; i < length; ++i) {
                JSONObject mylist = group.getJSONObject(i);
                // TODO nameにHTML文字（例：&lt;）が含まれる場合がある
                String name = Util.getJSONStringNotShared(mylist, "name");
                arrayName.add(name);
            }
            // とりあえずマイリスト
            arrayName.add(getString(R.string.deflist));

            mMylistGroup = json;
            ArrayAdapter<String> adapter = new ArrayAdapter<String>(mContext,
                    R.layout.mylist_spinner_item, arrayName);
            adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
            mSpinnerMylist.setAdapter(adapter);
            // とりあえずマイリストを最初に選択
            mSpinnerMylist.setSelection(arrayName.size() - 1);
        } catch (JSONException e) {
            Log.e(LOG_TAG, e.toString(), e);
            mHandler.sendEmptyMessage(MSG_ID_LOAD_OCCURED_ERROR);
        }
    }

    void selectMylistGroup(int position) {
        if (mMylistGroup == null) {
            if (DEBUG_LOGD) {
                Log.d(LOG_TAG, "mylistgroup has not been loaded yet");
            }
            mAdapter.setItems(null);
            mAdapter.notifyDataSetChanged();
            return;
        }
        try {
            JSONArray group = mMylistGroup.getJSONArray("mylistgroup");
            int length = group.length();
            String groupId;
            if (position >= length) {
                // とりあえずマイリスト
                groupId = "";
            } else {
                JSONObject mylist = group.getJSONObject(position);
                groupId = Util.getJSONStringNotShared(mylist, "id");
            }
            if (TextUtils.equals(mLastGroupId, groupId)) {
                // 前回と同じ場合は読み込み省略
                return;
            }
            mLastGroupId = groupId;
            Bundle args;
            if (groupId.length() == 0) {
                args = null;
            } else {
                args = new Bundle(1);
                args.putString(KEY_GROUP_ID, groupId);
            }
            getLoaderManager().restartLoader(R.id.loader_mylist, args, this);

            mEmptyProgress.showEmptyProgress();
            mAdapter.setItems(null);
            mAdapter.notifyDataSetChanged();
        } catch (JSONException e) {
            Log.e(LOG_TAG, e.toString(), e);
            mHandler.sendEmptyMessage(MSG_ID_LOAD_OCCURED_ERROR);
        }
    }

    private void setMylist(JSONObject json) {
        if (json == null) {
            mHandler.sendEmptyMessage(MSG_ID_LOAD_OCCURED_ERROR);
            return;
        }
        mEmptyProgress.setEmptyText(R.string.empty_mylist_fragment_pre);
        mEmptyProgress.showEmptyText();
        mAdapter.setItems(json);
        mAdapter.notifyDataSetChanged();
    }

    private void setMylistComparators() {
        int sortSize = mResIntegerMylistSortShortPlayTime + 1;
        mMylistComparators = new ArrayList<Comparator<JSONObject>>(sortSize);
        for (int i = 0; i < sortSize; ++i) {
            mMylistComparators.add(null);
        }
        mMylistComparators.set(mResIntegerMylistSortNewCreate,
                new Comparator<JSONObject>() {
            @Override
            public int compare(JSONObject object1, JSONObject object2) {
                return -compareOldCreate(object1, object2);
            }
        });
        mMylistComparators.set(mResIntegerMylistSortOldCreate,
                new Comparator<JSONObject>() {
            @Override
            public int compare(JSONObject object1, JSONObject object2) {
                return compareOldCreate(object1, object2);
            }
        });
        mMylistComparators.set(mResIntegerMylistSortTitleAscending,
                new Comparator<JSONObject>() {
            @Override
            public int compare(JSONObject object1, JSONObject object2) {
                return compareTitleAscending(object1, object2);
            }
        });
        mMylistComparators.set(mResIntegerMylistSortTitleDescending,
                new Comparator<JSONObject>() {
            @Override
            public int compare(JSONObject object1, JSONObject object2) {
                return -compareTitleAscending(object1, object2);
            }
        });
        mMylistComparators.set(mResIntegerMylistSortMylistCommentAscending,
                new Comparator<JSONObject>() {
            @Override
            public int compare(JSONObject object1, JSONObject object2) {
                return compareMylistCommentAscending(object1, object2);
            }
        });
        mMylistComparators.set(mResIntegerMylistSortMylistCommentDescending,
                new Comparator<JSONObject>() {
            @Override
            public int compare(JSONObject object1, JSONObject object2) {
                return -compareMylistCommentAscending(object1, object2);
            }
        });
        mMylistComparators.set(mResIntegerMylistSortNewUpload,
                new Comparator<JSONObject>() {
            @Override
            public int compare(JSONObject object1, JSONObject object2) {
                return -compareOldUpload(object1, object2);
            }
        });
        mMylistComparators.set(mResIntegerMylistSortOldUpload,
                new Comparator<JSONObject>() {
            @Override
            public int compare(JSONObject object1, JSONObject object2) {
                return compareOldUpload(object1, object2);
            }
        });
        mMylistComparators.set(mResIntegerMylistSortManyViews,
                new Comparator<JSONObject>() {
            @Override
            public int compare(JSONObject object1, JSONObject object2) {
                return -compareFewViews(object1, object2);
            }
        });
        mMylistComparators.set(mResIntegerMylistSortFewViews,
                new Comparator<JSONObject>() {
            @Override
            public int compare(JSONObject object1, JSONObject object2) {
                return compareFewViews(object1, object2);
            }
        });
        mMylistComparators.set(mResIntegerMylistSortNewComment,
                new Comparator<JSONObject>() {
            @Override
            public int compare(JSONObject object1, JSONObject object2) {
                return -compareOldComment(object1, object2);
            }
        });
        mMylistComparators.set(mResIntegerMylistSortOldComment,
                new Comparator<JSONObject>() {
            @Override
            public int compare(JSONObject object1, JSONObject object2) {
                return compareOldComment(object1, object2);
            }
        });
        mMylistComparators.set(mResIntegerMylistSortManyComments,
                new Comparator<JSONObject>() {
            @Override
            public int compare(JSONObject object1, JSONObject object2) {
                return -compareFewComments(object1, object2);
            }
        });
        mMylistComparators.set(mResIntegerMylistSortFewComments,
                new Comparator<JSONObject>() {
            @Override
            public int compare(JSONObject object1, JSONObject object2) {
                return compareFewComments(object1, object2);
            }
        });
        mMylistComparators.set(mResIntegerMylistSortManyMylists,
                new Comparator<JSONObject>() {
            @Override
            public int compare(JSONObject object1, JSONObject object2) {
                return -compareFewMylists(object1, object2);
            }
        });
        mMylistComparators.set(mResIntegerMylistSortFewMylists,
                new Comparator<JSONObject>() {
            @Override
            public int compare(JSONObject object1, JSONObject object2) {
                return compareFewMylists(object1, object2);
            }
        });
        mMylistComparators.set(mResIntegerMylistSortLongPlayTime,
                new Comparator<JSONObject>() {
            @Override
            public int compare(JSONObject object1, JSONObject object2) {
                return -compareShortPlayTime(object1, object2);
            }
        });
        mMylistComparators.set(mResIntegerMylistSortShortPlayTime,
                new Comparator<JSONObject>() {
            @Override
            public int compare(JSONObject object1, JSONObject object2) {
                return compareShortPlayTime(object1, object2);
            }
        });
    }

    // 基本compareメソッドはすべて昇順

    static int compareLongValue(JSONObject object1, JSONObject object2, String key) {
        if (object1 == null) {
            if (object2 == null) {
                return 0;
            } else {
                return 1;
            }
        } else if (object2 == null) {
            return -1;
        }
        long val1 = object1.optLong(key);
        long val2 = object2.optLong(key);
        if (val1 < val2) {
            return -1;
        } else if (val1 == val2) {
            return 0;
        } else {
            return 1;
        }
    }
    static int compareStringValue(JSONObject object1, JSONObject object2, String key) {
        if (object1 == null) {
            if (object2 == null) {
                return 0;
            } else {
                return 1;
            }
        } else if (object2 == null) {
            return -1;
        }
        String val1 = object1.optString(key);
        String val2 = object2.optString(key);
        return val1.compareTo(val2);
    }
    static int compareItemDataLongValue(JSONObject object1, JSONObject object2, String key) {
        if (object1 == null) {
            if (object2 == null) {
                return 0;
            } else {
                return 1;
            }
        } else if (object2 == null) {
            return -1;
        }
        JSONObject data1 = object1.optJSONObject("item_data");
        JSONObject data2 = object2.optJSONObject("item_data");
        return compareLongValue(data1, data2, key);
    }
    static int compareItemDataStringValue(JSONObject object1, JSONObject object2, String key) {
        if (object1 == null) {
            if (object2 == null) {
                return 0;
            } else {
                return 1;
            }
        } else if (object2 == null) {
            return -1;
        }
        JSONObject data1 = object1.optJSONObject("item_data");
        JSONObject data2 = object2.optJSONObject("item_data");
        return compareStringValue(data1, data2, key);
    }

    static int compareOldCreate(JSONObject object1, JSONObject object2) {
        return compareLongValue(object1, object2, "create_time");
    }
    static int compareTitleAscending(JSONObject object1, JSONObject object2) {
        return compareItemDataStringValue(object1, object2, "title");
    }
    static int compareMylistCommentAscending(JSONObject object1, JSONObject object2) {
        return compareStringValue(object1, object2, "description");
    }
    static int compareOldUpload(JSONObject object1, JSONObject object2) {
        return compareItemDataLongValue(object1, object2, "first_retrieve");
    }
    static int compareFewViews(JSONObject object1, JSONObject object2) {
        return compareItemDataLongValue(object1, object2, "view_counter");
    }
    static int compareOldComment(JSONObject object1, JSONObject object2) {
        // TODO コメントの古い・新しいがこのキーなのか自信ない
        // というかそもそもJSONデータの中にあるかどうかも不明
        return compareItemDataLongValue(object1, object2, "update_time");
    }
    static int compareFewComments(JSONObject object1, JSONObject object2) {
        return compareItemDataLongValue(object1, object2, "num_res");
    }
    static int compareFewMylists(JSONObject object1, JSONObject object2) {
        return compareItemDataLongValue(object1, object2, "mylist_counter");
    }
    static int compareShortPlayTime(JSONObject object1, JSONObject object2) {
        return compareItemDataLongValue(object1, object2, "length_seconds");
    }

    private class MylistListAdapter extends BaseAdapter {
        private CacheReference<ArrayList<JSONObject>> mItems;
        private Comparator<JSONObject> mComparator;
        private DateFormat mDateFormat = DateFormat.getDateTimeInstance(
                DateFormat.LONG, DateFormat.DEFAULT);
        private ThumbnailCacher mThumbnailCacher =
            NicoroApplication.getInstance(getActivity())
                .getThumbnailCacher();

        @Override
        public int getCount() {
            ArrayList<JSONObject> items = (mItems == null ? null : mItems.get());
            if (items == null) {
                return 0;
            } else {
                return items.size();
            }
        }

        @Override
        public Object getItem(int position) {
            ArrayList<JSONObject> items = (mItems == null ? null : mItems.get());
            if (items == null || items.size() == 0) {
                return null;
            } else {
                return items.get(position);
            }
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            View view;
            ListItem listItem;
            if (convertView == null) {
                LayoutInflater inflater = getActivity().getLayoutInflater();
                view = inflater.inflate(R.layout.mylist, parent, false);
                listItem = new ListItem();
                view.setTag(listItem);
                listItem.thumbnail = Util.findViewById(view, R.id.thumbnail);
                listItem.time = Util.findViewById(view, R.id.time);
                listItem.title = Util.findViewById(view, R.id.title);
                listItem.view = Util.findViewById(view, R.id.view);
                listItem.comment = Util.findViewById(view, R.id.comment);
                listItem.mylist = Util.findViewById(view, R.id.mylist);
                listItem.length = Util.findViewById(view, R.id.length);
            } else {
                view = convertView;
                listItem = (ListItem) convertView.getTag();
            }

            String thumbnail = null;
            String title = null;
            String viewCounter = null;
            String mylist = null;
            String comment = null;
            int lengthSeconds = 0;
            long firstRetrive = 0;

            ArrayList<JSONObject> items = (mItems == null ? null : mItems.get());
            if (items != null) {
                JSONObject item = items.get(position);
                JSONObject itemData = item.optJSONObject("item_data");
                if (itemData != null) {
                    thumbnail = Util.optJSONStringNotShared(itemData, "thumbnail_url", null);
                    title = Util.optJSONStringNotShared(itemData, "title", null);
                    viewCounter = Util.optJSONStringNotShared(itemData, "view_counter", null);
                    mylist = Util.optJSONStringNotShared(itemData, "mylist_counter", null);
                    comment = Util.optJSONStringNotShared(itemData, "num_res", null);
                    lengthSeconds = itemData.optInt("length_seconds");
                    firstRetrive = itemData.optLong("first_retrieve");
                }
            }

            AsyncBitmapDrawable drawable;
            ViewGroup.LayoutParams params = listItem.thumbnail.getLayoutParams();
            if (thumbnail == null) {
                drawable = new AsyncBitmapDrawable(null,
                        params.width, params.height);
            } else {
                Bitmap bitmap = mThumbnailCacher.getThumbnail(thumbnail);
                if (bitmap == null) {
                    drawable = new AsyncBitmapDrawable(params.width, params.height);
                    mThumbnailCacher.loadThumbnail(thumbnail,
                            new CallbackMessage<Bitmap, Void>(
                                    drawable.getHandler(), 0));
                } else {
                    drawable = new AsyncBitmapDrawable(bitmap,
                            params.width, params.height);
                }
            }
            listItem.thumbnail.setImageDrawable(drawable);

            listItem.title.setText(title);

            listItem.view.getTextBuilderWithClear().append(mResStringInfoCountPlay)
                .append(viewCounter);
            listItem.view.notifyUpdateText();

            listItem.comment.getTextBuilderWithClear().append(mResStringInfoCountComment)
                .append(comment);
            listItem.comment.notifyUpdateText();

            listItem.mylist.getTextBuilderWithClear().append(mResStringInfoCountMylist)
                .append(mylist);
            listItem.mylist.notifyUpdateText();

            listItem.time.getTextBuilderWithClear().append(mDateFormat.format(
                    new Date(firstRetrive * 1000L)))
                    .append(" ").append(mResStringUpload);
            listItem.time.notifyUpdateText();

            Util.appendPlayTime(listItem.length.getTextBuilderWithClear(),
                    lengthSeconds / 60, lengthSeconds % 60);
            listItem.length.notifyUpdateText();

            return view;
        }

        public void setItems(JSONObject json) {
            ArrayList<JSONObject> items = (mItems == null ? null : mItems.get());
            if (json == null) {
                if (items != null) {
                    items.clear();
                }
            } else {
                try {
                    JSONArray array = json.getJSONArray("mylistitem");
                    // sortのためArrayListに再配置
                    int length = array.length();
                    if (mItems == null) {
                        items = new ArrayList<JSONObject>(array.length());
                        mItems = new CacheReference<ArrayList<JSONObject>>(items);
                    } else if (items == null) {
                        items = new ArrayList<JSONObject>(array.length());
                        mItems.reset(items);
                    } else {
                        items.clear();
                        items.ensureCapacity(length);
                    }
                    for (int i = 0; i < length; ++i) {
                        JSONObject obj = array.optJSONObject(i);
                        if (obj != null) {
                            items.add(obj);
                        }
                    }

                    if (mComparator != null) {
                        Collections.sort(items, mComparator);
                    }
                } catch (JSONException e) {
                    Log.e(LOG_TAG, e.toString(), e);
                    items = (mItems == null ? null : mItems.get());
                    if (items != null) {
                        items.clear();
                    }
                    mHandler.sendEmptyMessage(MSG_ID_LOAD_OCCURED_ERROR);
                }
            }
        }

        public void sort(Comparator<JSONObject> comparator) {
            mComparator = comparator;
            ArrayList<JSONObject> items = (mItems == null ? null : mItems.get());
            if (items != null) {
                Collections.sort(items, comparator);
            }
        }

        public void onStart() {
            if (mItems != null) {
                ArrayList<JSONObject> items = mItems.strengthen();
                if (items == null) {
                    // 再取得
//                    mLastGroupId = null; // onItemSelectedとかぶる
                    mHandler.sendEmptyMessage(MSG_ID_CHANGE_LIST);
                    notifyDataSetChanged();
                }
            }
        }
        public void onStop() {
            if (mItems != null) {
                mItems.weaken();
            }
        }
    }

    private static class ListItem {
        public ImageView thumbnail;
        public VariableLabelView time;
        public VariableLabelView title;
        public VariableLabelView view;
        public VariableLabelView comment;
        public VariableLabelView mylist;
        public VariableLabelView length;
    }

    /**
     *
     * AsyncThreadのpoolにしばらくResultのインスタンスが残るらしいため、
     * 弱参照切り替えクラスを使用
     */
    private static class JSONLoader extends AsyncTaskLoader<ChangeReference<JSONObject>> {
        private final String mHostname;
        private final String mUri;
        private volatile HttpUriRequest mHttpRequest;

        public JSONLoader(Context context, String hostname, String uri) {
            super(context);
            mHostname = hostname;
            mUri = uri;
        }

        @Override
        public ChangeReference<JSONObject> loadInBackground() {
            // TODO ここでCookie取得すべきかどうか
            // 再認証が必要な場合、戻り値のJSONがstatus=fail、errorオブジェクトのcode=NOAUTHになる
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(getContext());
            String userSession = sp.getString(NicoroConfig.COOKIE_USER_SESSION, null);

            HttpUriRequest httpRequest = Util.createRequestGetSingleLineDataFromAPI(
                    mUri,
                    userSession, null);
            mHttpRequest = httpRequest;
            DefaultHttpClient httpClient = Util.createHttpClient();
            JSONObject result = null;
            try {
                httpClient.getCookieStore().clear();
                result = Util.getJSONFromAPI(httpClient,
                        mHostname, httpRequest);
            } catch (ClientProtocolException e) {
                Log.e(LOG_TAG, e.toString(), e);
            } catch (IOException e) {
                if (httpRequest.isAborted()) {
                    Log.w(LOG_TAG, e.toString(), e);
                } else {
                    Log.e(LOG_TAG, e.toString(), e);
                }
            } catch (JSONException e) {
                Log.e(LOG_TAG, e.toString(), e);
            } finally {
                httpClient.getConnectionManager().shutdown();
            }
            mHttpRequest = null;
            if (result == null) {
                return null;
            } else {
                return new ChangeReference<JSONObject>(result);
            }
        }

        @Override
        protected void onReset() {
            abortHttpRequest();
            mHttpRequest = null;
        }

        @Override
        protected void onStartLoading() {
            forceLoad();
        }

        @Override
        protected void onStopLoading() {
            mHttpRequest = null;
        }

        @Override
        public void onCanceled(ChangeReference<JSONObject> data) {
            if (data != null) {
                data.weaken();
            }
        }

        private void abortHttpRequest() {
            HttpUriRequest httpRequest = mHttpRequest;
            if (httpRequest != null && !httpRequest.isAborted()) {
                httpRequest.abort();
            }
        }
    }

    @Override
    public Loader<ChangeReference<JSONObject>> onCreateLoader(int id, Bundle args) {
        switch (id) {
            case R.id.loader_mylistgroup:
                return new JSONLoader(mContext, "www.nicovideo.jp",
                        "/api/mylistgroup/list");
            case R.id.loader_mylist:
                String groupId = (args == null) ? null : args.getString(KEY_GROUP_ID);
                if (groupId == null) {
                    // とりあえずマイリスト
                    return new JSONLoader(mContext, "www.nicovideo.jp",
                            "/api/deflist/list");
                } else {
                    return new JSONLoader(mContext, "www.nicovideo.jp",
                            "/api/mylist/list?group_id=" + groupId);
                }
            default:
                assert false : id;
                return null;
        }
    }

    @Override
    public void onLoadFinished(Loader<ChangeReference<JSONObject>> loader,
            ChangeReference<JSONObject> data) {
        if (data == null) {
            // 読み込みエラー
            mHandler.sendEmptyMessage(MSG_ID_LOAD_OCCURED_ERROR);
        } else {
            JSONObject json = data.strengthen();
            assert json != null;
            // 取り出したら元の値は弱参照に切り替え
            data.weaken();
            if (isRemoving()) {
                // removeされていたら表示には反映しない
                return;
            }
            int id = loader.getId();
            switch (id) {
                case R.id.loader_mylistgroup:
                    setMylistGroup(json);
                    break;
                case R.id.loader_mylist:
                    setMylist(json);
                    break;
                default:
                    assert false : id;
                    break;
            }
        }
    }

    @Override
    public void onLoaderReset(Loader<ChangeReference<JSONObject>> loader) {
    }
}
