package jp.sourceforge.nicoro;

import android.app.Dialog;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;

public class CloseDialogFragment extends DialogFragment {
    private String mTitle;
    private String mMessage;
    private boolean mTryFinishActivity;
    private boolean mIsError;

    private CloseDialogFragment(String title, String message,
            boolean tryFinishActivity, boolean isError) {
        mTitle = title;
        mMessage = message;
        mTryFinishActivity = tryFinishActivity;
        mIsError = isError;
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        String title;
        if (mIsError) {
            title = getString(R.string.error);
        } else {
            title = mTitle;
        }
        return Util.createCloseDialog(getActivity(),
                title, mMessage, mTryFinishActivity);
    }

    public static CloseDialogFragment createDialog(String title, String message,
            boolean tryFinishActivity) {
        return new CloseDialogFragment(title, message, tryFinishActivity,
                false);
    }
    public static CloseDialogFragment createErrorDialog(String message,
            boolean tryFinishActivity) {
        return new CloseDialogFragment(null, message, tryFinishActivity,
                true);
    }
}
