package jp.sourceforge.nicoro;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.provider.Browser;
import android.support.v4.app.FragmentActivity;

public class Bookmarks extends FragmentActivity {
    public static final String INTENT_EXTRA_URL =
        ListMenuActivity.INTENT_EXTRA_BOOKMARKS_ADD_URL;
    public static final String INTENT_EXTRA_TITLE =
        ListMenuActivity.INTENT_EXTRA_BOOKMARKS_ADD_TITLE;

    private static final int MSG_ID_START_BROWSER = 1;

    private Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case MSG_ID_START_BROWSER:
                    String url = (String) msg.obj;
                    MainFragmentActivity.startBrowserActivity(
                            Bookmarks.this, url);
                    finish();
                    break;
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        CallbackMessage<String, Void> callback =
            new CallbackMessage<String, Void>(mHandler, MSG_ID_START_BROWSER);
        String tag = getString(R.string.tag_bookmarks_fragment);
        BookmarksFragment fragment;
        if (savedInstanceState == null) {
            fragment = new BookmarksFragment();
            getSupportFragmentManager().beginTransaction().add(
                    android.R.id.content, fragment,
                    tag).commit();
        } else {
            fragment = Util.findFragmentByTag(getSupportFragmentManager(),
                    tag);
        }
        Intent intent = getIntent();
        ListMenuFragment.updateFragmentBookmarks(intent, fragment);
        fragment.setBrowserStarterCallback(callback);
    }

    public static void addBookmark(Activity activity, String title, String url) {
		Matcher matcher = Pattern.compile(NicoroAPIManager.PATTERN_NICOVIDEO_URL).matcher(url);
		if (matcher.find()) {
			Browser.saveBookmark(activity, title, url);
		} else {
			Util.showErrorToast(activity.getApplicationContext(),
					R.string.toast_bookmark_url_not_nicovideo);
		}
    }
}
