package jp.sourceforge.nicoro;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.FragmentActivity;

public class AccessHistoryActivity extends FragmentActivity {
    private static final int MSG_ID_START_BROWSER = 1;

    private Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case MSG_ID_START_BROWSER:
                    String url = (String) msg.obj;
                    MainFragmentActivity.startBrowserActivity(
                            AccessHistoryActivity.this, url);
                    finish();
                    break;
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        CallbackMessage<String, Void> browserStarter =
            new CallbackMessage<String, Void>(mHandler, MSG_ID_START_BROWSER);
        String tag = getString(R.string.tag_access_history_fragment);
        AccessHistoryFragment fragment;
        if (savedInstanceState == null) {
            fragment = new AccessHistoryFragment();
            getSupportFragmentManager().beginTransaction().add(
                    android.R.id.content, fragment,
                    tag).commit();
        } else {
            fragment = Util.findFragmentByTag(getSupportFragmentManager(),
                    tag);
        }
        fragment.setBrowserStarterCallback(browserStarter);
    }
}
