package jp.sourceforge.nicoro;

import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;

import dalvik.system.VMRuntime;


import jp.sourceforge.nicoro.R;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.preference.PreferenceManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.ImageView;

public class NicoroFFmpegPlayer extends AbstractNicoroPlayer {
	private static final boolean DEBUG_LOGV = Release.IS_DEBUG && false;
	private static final boolean DEBUG_LOGD = Release.IS_DEBUG && true;
	private static final String LOG_TAG = "NicoRo";
	
	/**
	 * 
	 * AVCODEC_MAX_AUDIO_FRAME_SIZE以上でなければならない
	 */
	private static final int AUDIO_BUFFER_BYTE_SIZE = 192000 + 0;
	
	private static final int VIDEO_BUFFER_CACHE_SIZE = 20;
	
	private static final int MSG_ID_VIDEO_CACHED = MSG_ID_SUB_OFFSET + 0;
	private static final int MSG_ID_SURFACE_CREATED = MSG_ID_SUB_OFFSET + 1;
	private static final int MSG_ID_SURFACE_DESTROYED = MSG_ID_SUB_OFFSET + 2;
	
	private static final int CODE_DECODE_FRAME_VIDEO = 0;
	private static final int CODE_DECODE_FRAME_AUDIO = 1;
	private static final int CODE_DECODE_FRAME_VIDEO_SKIP = 2;
	private static final int CODE_DECODE_FRAME_SKIP = 3;
	private static final int CODE_DECODE_FRAME_ERROR_OR_END = -1;
	
	private SurfaceView mSurfaceView;
	private SurfaceHolder mSurfaceHolder;
	private ImageView mIconPause;
	/*private*/ volatile boolean mIsFinish;
	/*private*/ volatile boolean mIsDecodedComplete;
	/*private*/ AudioTrack mAudioTrack;
	/*private*/ short[] mAudioBufferSecond;
	/*private*/ int mAudioBufferSecondOffset;
	
	private boolean mIsSurfaceOk;
	private boolean mIsVideoCachedOk;
	
	private int mWidthSurface = 0;
	private int mHeightSurface = 0;

    private int mDrawOffsetY = 0;

	private Thread mThreadDecode = null;
	private Thread mThreadPlay = null;

    private Matrix mMatrixScale = new Matrix();
    
    private Paint mPaint = new Paint();
    
    /*private*/ ConcurrentLinkedQueue<CacheReference<int[]>> mVideoBufferPool =
    	new ConcurrentLinkedQueue<CacheReference<int[]>>();
    /*private*/ ConcurrentLinkedQueue<CacheReference<int[]>> mVideoBufferCached =
    	new ConcurrentLinkedQueue<CacheReference<int[]>>();
	
//    private boolean mSkipTest;
//    private int mSkipDrawTest = 0;
    
    private volatile boolean mIsPlaying = false;
    
    private boolean mIsPause = false;
    
    /*private*/ int mAudioSampleByteSize;
    
    // NativeのNicoroクラスのポインタ
    /*private*/ volatile long mNativeInstance;
	
    // Nativeからアクセスされるもの
	private int mWidth = 0;
	private int mHeight = 0;
	/*private*/ short[] mAudioBuffer;
	/*private*/ int mAudioBufferSize;
	/** 動画デコード時間 分子 */
	/*private*/ int mTimeNumVideo = 0;
	/** 動画デコード時間 分母 */
	/*private*/ int mTimeDenVideo = 0;
	/** 音声デコード時間 分子 */
	/*private*/ int mTimeNumAudio = 0;
	/** 音声デコード時間 分母 */
	/*private*/ int mTimeDenAudio = 0;
    
    private class DecoderThread implements Runnable {
		@Override
		public void run() {
	    	mAudioBufferSize = 0;
	    	mAudioBufferSecondOffset = 0;
	    	
			// キャッシュ
			while (!mIsFinish) {
				if (mAudioBufferSecondOffset > mAudioBufferSecond.length * 7 / 8) {
					// キャッシュ終了
					break;
				}
				
				CacheReference<int[]> drawBufferRef = mVideoBufferPool.poll();
				int[] drawBuffer;
				if (drawBufferRef != null) {
					drawBuffer = drawBufferRef.strengthen();
				} else {
					drawBuffer = null;
				}
				if (drawBuffer == null) {
					try {
						drawBuffer = createDrawBuffer();
						if (drawBuffer == null) {
							// キャッシュ終了
//							drawBuffer = null;
							break;
						}
						if (drawBufferRef != null) {
							drawBufferRef.reset(drawBuffer);
						} else {
							drawBufferRef = new CacheReference<int[]>(drawBuffer);
						}
					} catch (OutOfMemoryError e) {
						// キャッシュ終了
						break;
					}
				}
				int frameType = decodeFrame(mNativeInstance, drawBuffer, false);
				switch (frameType) {
				case CODE_DECODE_FRAME_VIDEO:
					mVideoBufferCached.add(drawBufferRef);
					break;
				case CODE_DECODE_FRAME_AUDIO:
					drawBufferRef.weaken();
					mVideoBufferPool.add(drawBufferRef);	// 戻す
					
					if (DEBUG_LOGD) {
						Log.d(LOG_TAG,
								"AudioCache: mAudioBufferSecondOffset=" + mAudioBufferSecondOffset
								+ " mAudioBufferSize=" + mAudioBufferSize);
					}
					System.arraycopy(mAudioBuffer, 0, mAudioBufferSecond, mAudioBufferSecondOffset, mAudioBufferSize / 2);
					mAudioBufferSecondOffset += mAudioBufferSize / 2;
					
					break;
				case CODE_DECODE_FRAME_VIDEO_SKIP:		// Video, but skip decode
					drawBufferRef.weaken();
					mVideoBufferPool.add(drawBufferRef);	// 戻す
					break;
				case CODE_DECODE_FRAME_SKIP:
					drawBufferRef.weaken();
					mVideoBufferPool.add(drawBufferRef);	// 戻す
					break;
				case CODE_DECODE_FRAME_ERROR_OR_END:
					drawBufferRef.weaken();
					mVideoBufferPool.add(drawBufferRef);	// 戻す
					break;
				default:	// some error
					drawBufferRef.weaken();
					mVideoBufferPool.add(drawBufferRef);	// 戻す
					break;
				}
			}
			
			if (mIsFinish) {
				return;
			}
			
			// キャッシュぶんの音声再生開始
	    	int writtenSize = mAudioTrack.write(mAudioBufferSecond, 0, mAudioBufferSecondOffset);
	    	if (writtenSize < 0) {
	    		Log.d(LOG_TAG, "AudioTrack write NG");
	    	}
	    	if (DEBUG_LOGD) {
	    		Log.d(LOG_TAG, "writtenSize=" + writtenSize);
	    	}
			mAudioBufferSecondOffset = 0;
			mAudioTrack.flush();
			
			// 再生開始
			assert mThreadPlay == null;
			mThreadPlay = new Thread(new PlayerThread());
			mThreadPlay.start();
			
			while (!mIsFinish) {
				// TODO: とりあえずAudioTrack開始までポーリング
				int dummyFrame = 256 * 1024 / mAudioSampleByteSize;
//				int dummyFrame = 1;
				int playbackHeadPosition = mAudioTrack.getPlaybackHeadPosition();
				if (DEBUG_LOGD) {
					Log.d(LOG_TAG, "PlayerThread wait: AudioTrack: getPlaybackHeadPosition=" + playbackHeadPosition);
				}
				if (mAudioTrack.getPlaybackHeadPosition() >= dummyFrame) {
					break;
				}
				
				try {
					Thread.sleep(1L);
				} catch (InterruptedException e) {
		    		Log.d(LOG_TAG, "", e);
				}
			}
			
	    	long startTime = System.currentTimeMillis();
	    	
			MAIN_LOOP : while (!mIsFinish) {
				// TODO: 演算方法すごく仮
				boolean skipVideoFrame;
//				if (mTimeDenVideo != 0
//						&& ((float)System.currentTimeMillis() - (float)startTime)
//						> ((float)mTimeNumVideo / (float)mTimeDenVideo)) {
//					skipVideoFrame = true;
//				} else {
//					skipVideoFrame = false;
//				}
				
				// テスト
//				skipVideoFrame = mSkipTest;
//				mSkipTest = !mSkipTest;
//				skipVideoFrame = true;
				skipVideoFrame = false;
				
				CacheReference<int[]> drawBufferRef = mVideoBufferPool.poll();
				int[] drawBuffer;
				if (drawBufferRef != null) {
					drawBuffer = drawBufferRef.strengthen();
				} else {
					drawBuffer = null;
				}
		    	if (drawBuffer == null) {
					try {
						drawBuffer = createDrawBuffer();
						if (drawBuffer == null) {
				    		// バッファが来るまで待つ
							try {
								Thread.sleep(1L);
							} catch (InterruptedException e2) {
					    		Log.d(LOG_TAG, "", e2);
							}
				    		continue;
						}
						if (drawBufferRef != null) {
							drawBufferRef.reset(drawBuffer);
						} else {
							drawBufferRef = new CacheReference<int[]>(drawBuffer);
						}
					} catch (OutOfMemoryError e) {
			    		// バッファが来るまで待つ
						try {
							Thread.sleep(1L);
						} catch (InterruptedException e2) {
				    		Log.d(LOG_TAG, "", e2);
						}
			    		continue;
					}
		    	}
				int retDecodeFrame = decodeFrame(mNativeInstance, drawBuffer, skipVideoFrame);
				switch (retDecodeFrame) {
				case CODE_DECODE_FRAME_VIDEO:		// Video
					if (DEBUG_LOGV) {
						Log.v(LOG_TAG, "Decode time Video: " + mTimeNumVideo + "/" + mTimeDenVideo
								+ " = " + ((mTimeDenVideo != 0) ? ((float)mTimeNumVideo / (float)mTimeDenVideo) : "NAN"));
					}
//					if (skipVideoFrame) {
//						drawBufferRef.weaken();
//						mVideoBufferPool.add(drawBufferRef);	// 戻す
//					} else {
//						mVideoBufferCached.add(drawBufferRef);
//					}
					mVideoBufferCached.add(drawBufferRef);
					break;
				case CODE_DECODE_FRAME_AUDIO:		// Audio
					if (DEBUG_LOGV) {
						Log.v(LOG_TAG, "Decode time Audio: " + mTimeNumAudio + "/" + mTimeDenAudio
								+ " = " + ((mTimeDenAudio != 0) ? ((float)mTimeNumAudio / (float)mTimeDenAudio) : "NAN"));
					}
					drawBufferRef.weaken();
					mVideoBufferPool.add(drawBufferRef);	// 戻す
					writeBufferToAudioTrack();
					break;
				case CODE_DECODE_FRAME_VIDEO_SKIP:		// Video, but skip decode
					if (DEBUG_LOGV) {
						Log.v(LOG_TAG, "Decode time Video(skip): " + mTimeNumVideo + "/" + mTimeDenVideo
								+ " = " + ((mTimeDenVideo != 0) ? ((float)mTimeNumVideo / (float)mTimeDenVideo) : "NAN"));
					}
					drawBufferRef.weaken();
					mVideoBufferPool.add(drawBufferRef);	// 戻す
					break;
				case CODE_DECODE_FRAME_SKIP:
					if (DEBUG_LOGV) {
						Log.v(LOG_TAG, "Decode time Video(skip): " + mTimeNumVideo + "/" + mTimeDenVideo
								+ " = " + ((mTimeDenVideo != 0) ? ((float)mTimeNumVideo / (float)mTimeDenVideo) : "NAN"));
					}
					drawBufferRef.weaken();
					mVideoBufferPool.add(drawBufferRef);	// 戻す
					break;
				case CODE_DECODE_FRAME_ERROR_OR_END:
					drawBufferRef.weaken();
					mVideoBufferPool.add(drawBufferRef);	// 一応戻す
					mIsDecodedComplete = true;
					break MAIN_LOOP;
				default:	// some error
					assert false;
					drawBufferRef.weaken();
					mVideoBufferPool.add(drawBufferRef);	// 一応戻す
					break MAIN_LOOP;
				}
			}
		}
    }
    
    private class PlayerThread implements Runnable {
		@Override
		public void run() {
			
			while (!mIsFinish) {
				// TODO: とりあえずAudioTrack開始までポーリング
				final int dummyFrame = 256 * 1024 / mAudioSampleByteSize;
//				final int dummyFrame = 1;
				int playbackHeadPosition = mAudioTrack.getPlaybackHeadPosition();
				if (DEBUG_LOGD) {
					Log.d(LOG_TAG, "PlayerThread wait: AudioTrack: getPlaybackHeadPosition=" + playbackHeadPosition);
				}
				if (mAudioTrack.getPlaybackHeadPosition() >= dummyFrame) {
					break;
				}
				
				try {
					Thread.sleep(1L);
				} catch (InterruptedException e) {
		    		Log.d(LOG_TAG, "", e);
				}
			}
			
			while (!mIsFinish) {
				if (mIsPause) {
					try {
						Thread.sleep(10L);
					} catch (InterruptedException e) {
			    		Log.d(LOG_TAG, "", e);
					}
					continue;
				}
				
				long beginTime = System.currentTimeMillis();
				
				CacheReference<int[]> drawBufferRef = mVideoBufferCached.poll();
				int[] drawBuffer;
				if (drawBufferRef != null) {
					drawBuffer = drawBufferRef.strengthen();
					assert drawBuffer != null;
				} else {
					drawBuffer = null;
				}
				if (drawBuffer != null) {
					if (DEBUG_LOGV) {
						Log.v(LOG_TAG, "PlayerThread: drawBufferToSurface");
					}
					drawBufferToSurface(drawBuffer);
					assert drawBufferRef != null;
					drawBufferRef.weaken();
					mVideoBufferPool.add(drawBufferRef);
				} else {
					if (mIsDecodedComplete) {
						// デコード完了済みで再生するものも残っておらず
						break;
					}
				}
				
				if (DEBUG_LOGV) {
					Log.v(LOG_TAG, "PlayerThread: mVideoBufferCached.size="
							+ mVideoBufferCached.size()
							+ " mVideoBufferPool.size="
							+ mVideoBufferPool.size());
				}

				long afterTime = System.currentTimeMillis();
				// TODO: スリープ時間適当
				if ((afterTime - beginTime) < 33L) {
					try {
						Thread.sleep(33L - (afterTime - beginTime));
					} catch (InterruptedException e) {
			    		Log.d(LOG_TAG, "", e);
					}
				}
			}
			
			// 音声データ残っていたら待つ
			while (!mIsFinish) {
				AudioTrack audioTrack = mAudioTrack;
				if (audioTrack == null) {
					break;
				}
				if (audioTrack.getPlayState() != AudioTrack.PLAYSTATE_PLAYING) {
					break;
				}
				try {
					Thread.sleep(33L);
				} catch (InterruptedException e) {
		    		Log.d(LOG_TAG, "", e);
				}
			}
			AudioTrack audioTrack = mAudioTrack;
			if (audioTrack != null) {
				audioTrack.release();
			}
	    	mAudioTrack = null;
		}
    }
    
    public NicoroFFmpegPlayer() {
    	mHandler = new MessageHandler() {
    		@Override
    		public void handleMessage(Message msg) {
    			if (mHandler == null) {
    				if (DEBUG_LOGD) {
    					Log.d(LOG_TAG, "Activity was destroyed. ignore message=" + msg.toString());
    				}
    				return;
    			}
    			switch (msg.what) {
    			case MSG_ID_VIDEO_CACHED:
    				mIsVideoCachedOk = true;
    				if (canStartPlay()) {
    					startPlay();
    				}
    				break;
    			case MSG_ID_SURFACE_CREATED:
    				mIsSurfaceOk = true;
    				if (canStartPlay()) {
    					startPlay();
    				}
    				break;
    			case MSG_ID_SURFACE_DESTROYED:
    				mIsSurfaceOk = false;
    				break;
    			default:
    				super.handleMessage(msg);
    				break;
    			}
    		}
    	};
    }
    
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
//    	VMRuntime.getRuntime().setMinimumHeapSize(Long.MAX_VALUE);
        
        Intent intent = getIntent();
        mVideoLoader = createVideoLoader(intent, getApplicationContext());
        if (mVideoLoader != null) {
        	mVideoLoader.setEventListener(new VideoLoader.EventListener() {
				@Override
				public void onCached(VideoLoader videoLoader) {
					if (mHandler != null) {
						mHandler.sendEmptyMessage(MSG_ID_VIDEO_CACHED);
					}
				}
				@Override
				public void onFinished(VideoLoader videoLoader) {
					// TODO 自動生成されたメソッド・スタブ
					
				}
				@Override
				public void onOccurredError(VideoLoader videoLoader, String errorMessage) {
					if (mHandler != null) {
						Message message = mHandler.obtainMessage(MSG_ID_VIDEO_OCCURRED_ERROR, errorMessage);
						mHandler.sendMessage(message);
					}
				}
				@Override
				public void onNotifyProgress(int num, int den) {
					if (mHandler != null) {
						if (!mIsPlaying) {
							mHandler.removeMessages(MSG_ID_VIDEO_NOTIFY_PROGRESS);
							Message message = mHandler.obtainMessage(MSG_ID_VIDEO_NOTIFY_PROGRESS, num, den);
							mHandler.sendMessage(message);
						}
					}
				}
        	});
        	mVideoLoader.startLoad();
        }

        mIsSurfaceOk = false;
        mIsVideoCachedOk = false;
        
        setContentView(R.layout.nicoro_ffmpegplayer);
        mSurfaceView = (SurfaceView) findViewById(R.id.surface);
		DisplayMetrics metrics = new DisplayMetrics();
		getWindowManager().getDefaultDisplay().getMetrics(metrics);
		mSurfaceView.getLayoutParams().width =
//			(int) (metrics.heightPixels * 4 / 3 / metrics.density);
			(int) (metrics.heightPixels * 4 / 3);
		mSurfaceView.getLayoutParams().height =
//			(int) (metrics.heightPixels / metrics.density);
			(int) (metrics.heightPixels);
		mSurfaceView.requestLayout();
        mSurfaceHolder = mSurfaceView.getHolder();
        mSurfaceHolder.addCallback(new SurfaceHolder.Callback() {
			@Override
			public void surfaceChanged(SurfaceHolder holder, int format,
					int width, int height) {
				if (DEBUG_LOGD) {
					Log.d(LOG_TAG, "surfaceChanged: format=" + format + " width=" + width + " height=" + height);
				}
				mWidthSurface = width;
				mHeightSurface = height;
				setScaleMatrix();
			}
			@Override
			public void surfaceCreated(SurfaceHolder holder) {
				if (mHandler != null) {
					mHandler.sendEmptyMessage(MSG_ID_SURFACE_CREATED);
				}
			}
			@Override
			public void surfaceDestroyed(SurfaceHolder holder) {
				if (mHandler != null) {
					mHandler.sendEmptyMessage(MSG_ID_SURFACE_DESTROYED);
				}
				mIsFinish = true;
			}
        });
        
        mSurfaceView.setOnTouchListener(new View.OnTouchListener() {
        	private int mLastPlaybackHeadPosition;
        	
			@Override
			public boolean onTouch(View v, MotionEvent event) {
				if (event.getAction() == MotionEvent.ACTION_DOWN) {
					if (mAudioTrack != null) {
						final int dummyFrame = 256 * 1024 / mAudioSampleByteSize;
						if (mAudioTrack.getPlaybackHeadPosition() < dummyFrame) {
							return false;
						}
					}
					
					if (!mIsPause) {
						mIconPause.setVisibility(View.VISIBLE);
						if (mAudioTrack != null) {
							mLastPlaybackHeadPosition = mAudioTrack.getPlaybackHeadPosition();
							mAudioTrack.pause();
						}
						mIsPause = true;
					} else {
						mIconPause.setVisibility(View.INVISIBLE);
						if (mAudioTrack != null) {
							mAudioTrack.play();
							mAudioTrack.setPlaybackHeadPosition(mLastPlaybackHeadPosition);
						}
						mIsPause = false;
					}
					return true;
				}
				return false;
			}
		});
		
		mIconPause = (ImageView) findViewById(R.id.icon_pause);
		mIconPause.setAlpha(192);
        
		initializeView();
        
		mIsPlaying = false;
		mIsPause = false;
		
    	SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences(getApplicationContext());
    	boolean bitmapFilter = sharedPreferences.getBoolean(
				getString(R.string.pref_key_ffmpeg_bitmap_filter), false);
		mPaint.setFilterBitmap(bitmapFilter);
    }
    
    @Override
    protected void onDestroy() {
    	mIsFinish = true;
    	if (mThreadPlay != null) {
	    	try {
				mThreadPlay.join(1000L * 2);
			} catch (InterruptedException e) {
	    		Log.d(LOG_TAG, "", e);
			}
			mThreadPlay = null;
    	}
    	if (mThreadDecode != null) {
	    	try {
				mThreadDecode.join(1000L * 2);
			} catch (InterruptedException e) {
	    		Log.d(LOG_TAG, "", e);
			}
			mThreadDecode = null;
    	}
    	synchronized (this) {
    		long nativeInstance = mNativeInstance;
    		mNativeInstance = 0L;
    		destroyNative(nativeInstance);
		}
    	super.onDestroy();
    	mSurfaceView = null;
    	mSurfaceHolder = null;
    	mAudioTrack = null;
    	mAudioBufferSecond = null;
    	mMatrixScale = null;
    	mPaint = null;
    	mVideoBufferPool = null;
    	mVideoBufferCached = null;
    	mAudioBuffer = null;
    }
    
    @Override
    protected void finalize() throws Throwable {
    	try {
    		super.finalize();
    	} finally {
        	mIsFinish = true;
        	try {
        		if (mThreadPlay != null) {
        			mThreadPlay.join(1000L * 2);
        		}
    		} catch (InterruptedException e) {
        		Log.d(LOG_TAG, "", e);
    		}
        	try {
        		if (mThreadDecode != null) {
        			mThreadDecode.join(1000L * 2);
        		}
    		} catch (InterruptedException e) {
        		Log.d(LOG_TAG, "", e);
    		}
    		synchronized (this) {
        		long nativeInstance = mNativeInstance;
        		mNativeInstance = 0L;
        		destroyNative(nativeInstance);
			}
    	}
    }
    
	@Override
	protected boolean canStartPlay() {
		return mIsSurfaceOk && mIsVideoCachedOk && mIsMessageOk;
	}
    
	@Override
    protected void startPlay() {
		super.startPlay();
    	System.gc();
    	
		long nativeInstance = mNativeInstance;
		mNativeInstance = 0L;
		destroyNative(nativeInstance);
        mNativeInstance = createNative();
        
    	loadStream(mNativeInstance);

        createAudioTrack(mNativeInstance);
		createDrawBuffer(mNativeInstance);
		
		int audioBufferByteSize;
//		audioBufferByteSize = AUDIO_BUFFER_BYTE_SIZE;
		audioBufferByteSize = mAudioTrack.getSampleRate() * mAudioSampleByteSize;
		if (audioBufferByteSize < AUDIO_BUFFER_BYTE_SIZE) {
			audioBufferByteSize = AUDIO_BUFFER_BYTE_SIZE;
		}
    	mAudioBuffer = new short[audioBufferByteSize/2];
    	mAudioBufferSize = 0;
    	mAudioBufferSecond = new short[audioBufferByteSize/2];
    	mAudioBufferSecondOffset = 0;
        
    	mIsPlaying = true;
    	mIsPause = false;
		mIsFinish = false;
		mIsDecodedComplete = false;
		assert mThreadDecode == null;
		mThreadDecode = new Thread(new DecoderThread());
		mThreadDecode.setPriority(
				mThreadDecode.getThreadGroup().getMaxPriority());
		mThreadDecode.start();
    }
    
	@Override
	protected StringBuilder appendCurrentPlayTime(StringBuilder builder) {
		// TODO: 時間適当
		if (mTimeDenVideo != 0) {
			int pos = mTimeNumVideo / mTimeDenVideo;
			int hours = pos / (60 * 60);
			int minutes = pos / 60 % 60;
			int seconds = pos % 60;
			if (hours != 0) {
				builder.append(hours).append(':');
			}
			if (minutes < 10) {
				builder.append('0');
			}
			builder.append(minutes).append(':');
			if (seconds < 10) {
				builder.append('0');
			}
			return builder.append(seconds);
		} else {
			return builder.append("00:00");
		}
	}
	
    private void setScaleMatrix() {
    	if (mMatrixScale == null) {
    		return;
    	}
    	mMatrixScale.reset();
    	if (mWidth == 0 || mHeight == 0 || mWidthSurface == 0 || mHeightSurface == 0) {
    		return;
    	}
    	float scaleWidth = (float) mWidthSurface / (float) mWidth;
    	float scaleHeight = (float) mHeightSurface / (float) mHeight;
    	float scale;
    	if (scaleWidth < scaleHeight) {
    		scale = scaleWidth;
        	mDrawOffsetY = (int) ((mHeightSurface / scale - mHeight) / 2);
    	} else {
    		scale = scaleHeight;
        	mDrawOffsetY = 0;
    	}
        mMatrixScale.postScale(scale, scale);
    }
    
    /*private*/ int[] createDrawBuffer() {
    	assert (mWidth > 0 && mHeight > 0);
    	Runtime runtime = Runtime.getRuntime();
    	long freeSize = runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
//    	final int MARGIN_SIZE = 6 * 1024 * 1024;
    	final long MARGIN_SIZE = runtime.maxMemory() / 2;
    	if (freeSize > (mWidth * mHeight * 4) + MARGIN_SIZE) {
    		return new int[mWidth * mHeight];
    	} else {
    		return null;
    	}
    }
    
    /*private*/ void drawBufferToSurface(int[] drawBuffer) {
//		// デコードじゃなくて描画のスキップテスト
//		mSkipTest = !mSkipTest;
//		if (mSkipTest) {
//			return;
//		}
//    	++mSkipDrawTest;
//    	if (mSkipDrawTest < 10) {
//    		return;
//    	} else {
//    		mSkipDrawTest = 0;
//    	}

    	Canvas canvas = mSurfaceHolder.lockCanvas();
        if (canvas == null) {
        	Log.d(LOG_TAG, "lockCanvas NG");
        	return;
        }
        
        try {
	        // 一応外側消去
	        canvas.drawColor(0xFF000000);
	        canvas.setMatrix(mMatrixScale);
	        canvas.drawBitmap(drawBuffer, 0, mWidth,
	        		0, mDrawOffsetY,
	        		mWidth, mHeight,
	        		false, mPaint);
	        // TODO vpos不正確
        	canvas.setMatrix(null);
	        drawMessage(canvas,
	        		mChatsWait,
	        		mChatsRunningNaka,
	        		mChatsRunningShita,
	        		mChatsRunningUe,
	        		100 * mTimeNumVideo / mTimeDenVideo,
//	        		mWidth, mHeight);
	        		canvas.getWidth(), canvas.getHeight());
        } finally {
        	canvas.setMatrix(null);
        	mSurfaceHolder.unlockCanvasAndPost(canvas);
        }
    }
    
    /*private*/ void writeBufferToAudioTrack() {
    	if (DEBUG_LOGV) {
    		Log.v(LOG_TAG, "writeBufferToAudioTrack: mAudioBufferSize=" + mAudioBufferSize);
    	}
    	if (mAudioTrack == null) {
    		Log.d(LOG_TAG, "mAudioTrack is null");
    		return;
    	}
		
		System.arraycopy(mAudioBuffer, 0, mAudioBufferSecond, mAudioBufferSecondOffset, mAudioBufferSize / 2);
		mAudioBufferSecondOffset += mAudioBufferSize / 2;
		
//		if (mAudioBufferSecondOffset > 44100 * 2 / 10) {
//		if (mAudioBufferSecondOffset > mAudioBufferSecond.length / 2) {
	    	int writtenSize = mAudioTrack.write(mAudioBufferSecond, 0, mAudioBufferSecondOffset);
	    	if (writtenSize < 0) {
	    		Log.d(LOG_TAG, "AudioTrack write NG");
	    	}
	    	if (DEBUG_LOGV) {
	    		Log.v(LOG_TAG, "writtenSize=" + writtenSize);
	    	}
			mAudioBufferSecondOffset = 0;
//			mAudioTrack.flush();
//		}
    }
    
    // Nativeからアクセスされるもの
    
    void createAudioTrackFromNativeCallback(int sample_rate, int channels, int sample_fmt) {
    	if (DEBUG_LOGD) {
    		Log.d(LOG_TAG, "createAudioTrackFromNativeCallback: sample_rate=" + sample_rate + " channels=" + channels + " sample_fmt=" + sample_fmt);
    	}
    	int sampleRateInHz = sample_rate;
    	mAudioSampleByteSize = 1;
    	int channelConfig;
    	switch (channels) {
    	case 1:
    		channelConfig = AudioFormat.CHANNEL_CONFIGURATION_MONO;
    		mAudioSampleByteSize *= 1;
    		break;
    	case 2:
			channelConfig = AudioFormat.CHANNEL_CONFIGURATION_STEREO;
			mAudioSampleByteSize *= 2;
			break;
		default:
			channelConfig = AudioFormat.CHANNEL_CONFIGURATION_INVALID;
    		break;
    	}
    	int audioFormat;
    	switch (sample_fmt) {
    	case 0:		// SAMPLE_FMT_U8
    		audioFormat = AudioFormat.ENCODING_PCM_8BIT;
    		mAudioSampleByteSize *= 1;
    		break;
    	case 1:		// SAMPLE_FMT_S16
    		audioFormat = AudioFormat.ENCODING_PCM_16BIT;
    		mAudioSampleByteSize *= 2;
    		break;
    	default:
    		audioFormat = AudioFormat.ENCODING_INVALID;
    		break;
    	}
    	
    	if (mAudioTrack != null) {
    		mAudioTrack.release();
    	}
    	int bufferSize = AUDIO_BUFFER_BYTE_SIZE;
        mAudioTrack = new AudioTrack(AudioManager.STREAM_MUSIC,
        		sampleRateInHz,
        		channelConfig,
        		audioFormat,
        		bufferSize,
        		AudioTrack.MODE_STREAM);
        mAudioTrack.play();
        
        // ダミーデータ書き込み
        byte[] dummy = new byte[256 * 1024];
        mAudioTrack.write(dummy, 0, 256 * 1024);
        mAudioTrack.flush();
    }

    void createDrawBufferFromNativeCallback(int width, int height) {
    	if (DEBUG_LOGD) {
    		Log.d(LOG_TAG, "createDrawBufferFromNativeCallback: width=" + width + " height=" + height);
    	}
    	
//    	final Display display = getWindowManager().getDefaultDisplay();
//    	int displayWidth = display.getWidth();
//    	int displayHeight = display.getHeight();
    	int displayWidth = mSurfaceView.getLayoutParams().width;
    	int displayHeight = mSurfaceView.getLayoutParams().height;
    	if (width > displayWidth || height > displayHeight) {
    		if (displayWidth * height < displayHeight * width) {
    			// widthで合わせる
    			mWidth = displayWidth;
    			mHeight = height * displayWidth / width;
    		} else {
    			// heightで合わせる
    			mWidth = width * displayHeight / height;
    			mHeight = displayHeight;
    		}
    	} else {
        	mWidth = width;
        	mHeight = height;
    	}
    	if (DEBUG_LOGD) {
    		Log.d(LOG_TAG, "mWidth=" + mWidth + " mHeight=" + mHeight);
    	}
    	
    	final Runtime runtime = Runtime.getRuntime();
    	int videoBufferCacheSize = (int) (runtime.freeMemory()
    			/ (mWidth * mHeight * 4));
    	videoBufferCacheSize = Math.min(videoBufferCacheSize, VIDEO_BUFFER_CACHE_SIZE);
    	videoBufferCacheSize = Math.max(videoBufferCacheSize, 1);
    	if (DEBUG_LOGD) {
    		Log.d(LOG_TAG, "videoBufferCacheSize=" + videoBufferCacheSize);
    	}
    	
//    	try {
//	    	for (int i = 0; i < videoBufferCacheSize; ++i) {
//	    		mVideoBufferPool.add(createDrawBuffer());
//	    	}
//    	} catch (OutOfMemoryError e) {
//    		Log.w(LOG_TAG, "OutOfMemoryError at caching video buffer");
//    	}
    	
    	setScaleMatrix();
    }
 
    // Nativeメソッド
    
    private native long createNative();
    private native void destroyNative(long nativeInstance);
    private native void loadFile(long nativeInstance, String file);
    private native void loadStream(long nativeInstance);
    private native void createAudioTrack(long nativeInstance);
    private native void createDrawBuffer(long nativeInstance);
    /*private*/ native int decodeFrame(long nativeInstance, int[] drawBuffer, boolean skipVideoFrame);
    
    static {
    	System.loadLibrary("nicoro-jni");
    }
}