package jp.sourceforge.nicoro;

import static jp.sourceforge.nicoro.Log.LOG_TAG;

import jp.sourceforge.nicoro.R;
import android.content.SharedPreferences;
import android.content.pm.PackageManager.NameNotFoundException;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;

public class NicoroConfig extends PreferenceActivity {
    private static final boolean DEBUG_LOGD = Release.IS_DEBUG && true;

	// 設定画面では扱わないオプションのキー
	public static final String COOKIE_USER_SESSION = "cookie_user_session";
	public static final String LAST_URL = "last_url";
	public static final String USER_AGENT = "user_agent";
    public static final String AUTHFLAG = "authflag";

	private static final String MA = "ma";
	private static final String PW = "pw";

	private static int BIT = 0xc55c5cc5;

	private String mResPrefKeyWithoutFlash;

	public NicoroConfig() {
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		addPreferencesFromResource(R.xml.nicoro_config);

		Resources res = getResources();
		mResPrefKeyWithoutFlash = res.getString(R.string.pref_key_without_flash);
	}

	@Override
	public void onConfigurationChanged(Configuration newConfig) {
		super.onConfigurationChanged(newConfig);
	}

	@Override
	public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen,
	        Preference preference) {
        String key = preference.getKey();
	    if (DEBUG_LOGD) {
	        Log.d(LOG_TAG, Log.buf().append(getClass().getSimpleName())
	                .append("#onPreferenceTreeClick: preferenceScreen=")
	                .append(preferenceScreen)
	                .append(" preference=").append(preference)
	                .append(" key=").append(key)
	                .toString());
	    }

	    if (key != null) {
    	    if (key.equals(mResPrefKeyWithoutFlash)) {
    	        CheckBoxPreference checkBox = (CheckBoxPreference) preference;
    	        if (!checkBox.isChecked()) {
    	            if (!isFlashPlayerInstalled()) {
    	                checkBox.setChecked(true);
    	                Util.showErrorToast(getApplicationContext(),
    	                        R.string.toast_flash_player_not_found);
    	                return true;
    	            }
    	        }
    	    }
	    }
        return super.onPreferenceTreeClick(preferenceScreen, preference);
	}

    private boolean isFlashPlayerInstalled() {
        try {
            String flashVersion = getPackageManager().getPackageInfo(
                    "com.adobe.flashplayer", 0).versionName;
            if (DEBUG_LOGD) {
                Log.d(LOG_TAG, Log.buf().append("flashplayer version=")
                        .append(flashVersion).toString());
            }
            return true;
        } catch (NameNotFoundException e) {
            if (DEBUG_LOGD) {
                Log.d(LOG_TAG, e.toString());
            }
            return false;
        }
    }

	// 設定画面とは関連のないメソッド

	public static String getMA(SharedPreferences sharedPreferences) {
		return convertXor(sharedPreferences.getString(MA, null));
	}
	public static String getPW(SharedPreferences sharedPreferences) {
		return convertXor(sharedPreferences.getString(PW, null));
	}
	/**
	 * {@link SharedPreferences.Editor#commit()} は後で自分で行うこと
	 * @param editor
	 * @param ma
	 */
	public static void putMA(SharedPreferences.Editor editor, String ma) {
		editor.putString(MA, convertXor(ma));
	}
	/**
	 * {@link SharedPreferences.Editor#commit()} は後で自分で行うこと
	 * @param editor
	 * @param pw
	 */
	public static void putPW(SharedPreferences.Editor editor, String pw) {
		editor.putString(PW, convertXor(pw));
	}

	static String convertXor(String src) {
		if (src == null) {
			return null;
		}
		final int len = src.length();
		char[] buf = new char[len];
		for (int i = 0; i < len; ++i) {
			buf[i] = (char) ((src.charAt(i) ^ BIT) & 0xffff);
		}
		return new String(buf);
	}
}
