/**
 * 
 */
package jp.sourceforge.nicoro;

import java.nio.ByteBuffer;

public abstract class VideoDrawBuffer<T> {
	public int frame;
	public long when;
    private CacheReference<T> mBuffer;
	
	public T strengthenBuffer() {
	    if (mBuffer == null) {
	        return null;
	    } else {
	        return mBuffer.strengthen();
	    }
	}
    public void weakenBuffer() {
        if (mBuffer != null) {
            mBuffer.weaken();
        }
    }
    // TODO
//	public void resetBuffer(T buf) {
    public void resetBuffer(Object buf) {
        if (mBuffer == null) {
//            mBuffer = new CacheReference<T>(buf);
            mBuffer = new CacheReference<T>((T) buf);
        } else {
//            mBuffer.reset(buf);
            mBuffer.reset((T) buf);
        }
	}
	public boolean hasBufferRef() {
	    return mBuffer != null;
	}
	public boolean isStrengthBuffer() {
        if (mBuffer == null) {
            return false;
        } else {
            return mBuffer.isStrength();
        }
	}
	
	public static class IntArray32bit extends VideoDrawBuffer<int[]> {
	    
	}
    public static class ByteBuffer16bit extends VideoDrawBuffer<ByteBuffer> {
        
    }
}