package jp.sourceforge.nicoro;

import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

import android.util.Log;
import android.util.Xml;

public class ThumbInfo extends XmlLoader {
	private static final boolean DEBUG_LOGD = Release.IS_DEBUG && true;
	private static final boolean DEBUG_LOGD_PARSE = Release.IS_DEBUG && true;
	private static final String LOG_TAG = "NicoRo";
	
	private String mVideoNumber;

	private EventListener mEventListener = null;
	
	// XML解析データ
	private String mVideoId = null;
	private String mTitle = null;
	private String mDescription = null;
	private String mThumbnailUrl = null;
	private String mFirstRetrieve = null;
	private String mLength = null;
	private int mViewCounter = -1;
	private int mCommentNum = -1;
	private int mMylistCounter = -1;
	private String mLastResBody = null;
	private String mWatchUrl = null;
	private String mThumbType = null;
	
	private String mFormattedLengthForPlayer = null;

	public ThumbInfo(String videoNumber) {
		mVideoNumber = videoNumber;
	}
	
	public int getViewCounter() {
		return mViewCounter;
	}
	public int getCommentNum() {
		return mCommentNum;
	}
	public int getMylistCounter() {
		return mMylistCounter;
	}
	public String getLength() {
		return mLength;
	}
	
	public String getFormattedLengthForPlayer() {
		if (mFormattedLengthForPlayer == null) {
			if (mLength == null) {
				return null;
			}
			Pattern pattern = Pattern.compile("([0-9]+:)?([0-9]+):([0-9]+)");
			Matcher matcher = pattern.matcher(mLength);
			if (matcher.find()) {
				String minutes = matcher.group(2);
				String seconds = matcher.group(3);
				if (minutes.length() == 2 && seconds.length() == 2) {
					// そのまま
					mFormattedLengthForPlayer = mLength;
				} else {
					StringBuilder builder = new StringBuilder(16);
					if (matcher.group(1) != null) {
						builder.append(matcher.group(1));
					}
					if (minutes.length() == 1) {
						builder.append('0');
					}
					builder.append(minutes).append(':');
					if (seconds.length() == 1) {
						builder.append('0');
					}
					builder.append(seconds);
					mFormattedLengthForPlayer = builder.toString();
				}
			} else {
				// 異常時はそのまま
				Log.d(LOG_TAG, "parse failed:" + mLength);
				mFormattedLengthForPlayer = mLength;
			}
		}
		return mFormattedLengthForPlayer;
	}

	@Override
	protected HttpUriRequest createRequest() {
		HttpGet httpRequest = new HttpGet(
				"http://www.nicovideo.jp/api/getthumbinfo/" + mVideoNumber);
		return httpRequest;
	}
	
	@Override
	protected boolean createDataFromXml(String xmlBody) {
		XmlPullParser pullParser = Xml.newPullParser();
		try {
			pullParser.setInput(new StringReader(xmlBody));
			
			int next;
			String name = null;
			while ((next = pullParser.next()) != XmlPullParser.END_DOCUMENT) {
				if (DEBUG_LOGD_PARSE) {
					Log.d(LOG_TAG, "next=" + next);
				}
				switch (next) {
				case XmlPullParser.START_TAG:
					name = pullParser.getName();
					if (DEBUG_LOGD_PARSE) {
						Log.d(LOG_TAG, "<" + name + ">");
					}
					if ("nicovideo_thumb_response".equals(name)) {
						String status = pullParser.getAttributeValue(
								null, "status");
						if ("ok".equals(status)) {
							// OK
						} else if ("fail".equals(status)) {
							return false;
						} else {
							Log.d(LOG_TAG, "nicovideo_thumb_response: unknown attribute status=" + status);
							return false;
						}
					} else {
						// その他のタグはとりあえず無視
					}
					break;
				case XmlPullParser.TEXT:
					if (name != null) {
						String text = pullParser.getText();
						try {
							if ("video_id".equals(name)) {
								mVideoId = text;
							} else if ("title".equals(name)) {
								mTitle = text;
							} else if ("description".equals(name)) {
								mDescription = text;
							} else if ("thumbnail_url".equals(name)) {
								mThumbnailUrl = text;
							} else if ("first_retrieve".equals(name)) {
								mFirstRetrieve = text;
							} else if ("length".equals(name)) {
								mLength = text;
							} else if ("view_counter".equals(name)) {
								mViewCounter = Integer.parseInt(text);
							} else if ("comment_num".equals(name)) {
								mCommentNum = Integer.parseInt(text);
							} else if ("mylist_counter".equals(name)) {
								mMylistCounter = Integer.parseInt(text);
							} else if ("last_res_body".equals(name)) {
								mLastResBody = text;
							} else if ("watch_url".equals(name)) {
								mWatchUrl = text;
							} else if ("thumb_type".equals(name)) {
								mThumbType = text;
							} else {
								// その他のタグはとりあえず無視
							}
						} catch (NumberFormatException e) {
							Log.d(LOG_TAG, "parseInt failed:" + text);
							// できる限り続行
						}
					}
					break;
				case XmlPullParser.END_TAG:
					name = pullParser.getName();
					if (DEBUG_LOGD_PARSE) {
						Log.d(LOG_TAG, "</" + name + ">");
					}
					name = null;
					// とりあえず無視
					break;
				default:
					break;
				}
			}
		} catch (XmlPullParserException e) {
			Log.d(LOG_TAG, "", e);
		} catch (IOException e) {
			Log.d(LOG_TAG, "", e);
		}
		
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "ThumbInfo:"
					+ " video_id=" + mVideoId
					+ " title=" + mTitle
					+ " description=" + mDescription
					+ " thumbnail_url=" + mThumbnailUrl
					+ " first_retrieve=" + mFirstRetrieve
					+ " length=" + mLength
					+ " view_counter=" + mViewCounter
					+ " comment_num=" + mCommentNum
					+ " mylist_counter=" + mMylistCounter
					+ " last_res_body=" + mLastResBody
					+ " watch_url=" + mWatchUrl
					+ " thumb_type=" + mThumbType);
		}
		
		return true;
	}
	
	@Override
	protected void dispatchOnFinished() {
		if (mEventListener != null) {
			mEventListener.onFinished(this);
		}
	}
	@Override
	protected void dispatchOnOccurredError(String errorMessage) {
		if (mEventListener != null) {
			mEventListener.onOccurredError(this, errorMessage);
		}
	}

	public void setEventListener(EventListener eventListener) {
		mEventListener = eventListener;
	}
	
	public interface EventListener {
		/**
		 * ファイル全体の読み込み完了
		 * @param streamLoader
		 */
		public void onFinished(ThumbInfo thumbInfo);
		/**
		 * エラー発生
		 * @param streamLoader
		 * @param errorMessage
		 */
		public void onOccurredError(ThumbInfo thumbInfo, String errorMessage);
	}
}
