package jp.sourceforge.nicoro;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;

import jp.sourceforge.nicoro.R;

import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebBackForwardList;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.Toast;

public class NicoroWebBrowser extends Activity {
	private static final boolean DEBUG_LOGV = Release.IS_DEBUG && false;
	private static final boolean DEBUG_LOGD = Release.IS_DEBUG && true;
	private static final String LOG_TAG = "NicoRo";
	
	private static final String PATTERN_VIDEO_URL =
		"http://www.nicovideo.jp/watch/([a-z0-9]+)";
	private static final String PATTERN_GET_USERID_FROM_USERSESSION =
		"user_session=user_session_([^_]+)_";
	
	private WebView mWebView;
	private Button mButtonPlay;
	private Button mButtonHelp;
	
	/** 動画視聴向けCookie */
	private String mCookieNicoHistory;
	
	// 設定
	private SharedPreferences mSharedPreferences;
	private SharedPreferences.OnSharedPreferenceChangeListener mSharedPreferencesChangeListener;
	/** 認証向けCookie */
	private String mCookieUserSession;
	private String mLastUrl;
	private String mUserAgent;
	
	private String mUserId;
	
	private Matcher mMatcherVideoUrl;
	private Matcher mMatcherGetUserID;
	
	private View.OnClickListener mClickListenerPlay = new View.OnClickListener() {
		@Override
		public void onClick(View v) {
			try {
	//			String url = mWebView.getOriginalUrl();
				String url = mWebView.getUrl();
				
				updateCookieUserSession();
				if (DEBUG_LOGD) {
					Log.d(LOG_TAG, "mCookieUserSession: " + mCookieUserSession);
				}
				mCookieNicoHistory = Util.getCookieValueFromManager(
						url, "nicohistory");
				if (DEBUG_LOGD) {
					Log.d(LOG_TAG, "mCookieNicoHistory: " + mCookieNicoHistory);
				}
				
				if (mCookieUserSession == null
						|| mUserId == null
						|| mCookieNicoHistory == null) {
					throw new FailPlayVideoException();
				}
				
	    		mMatcherVideoUrl = Util.getMatcher(mMatcherVideoUrl,
	    				PATTERN_VIDEO_URL,
	    				url);
				String videoNumber = getFirstMatch(mMatcherVideoUrl);
				if (videoNumber != null) {
					try {
						DefaultHttpClient httpClient = Util.createHttpClient();
						httpClient.getCookieStore().clear();
						String infoBody = getGetflvResult(httpClient, "/api/getflv?v=" + videoNumber, mCookieUserSession);
	    				String urlVideo = getVideoUrl(infoBody);
	    				String urlMessage = getMessageUrl(infoBody);
	    				String threadId = getThreadId(infoBody);
	    				String threadKeyBody = getThreadKeyResult(httpClient, "/api/getthreadkey?thread=" + threadId, mCookieUserSession);
	    				String threadKey = getThreadKey(threadKeyBody);
	    				String force184 = getForce184(threadKeyBody);
	    				
	    				if (urlVideo == null
	    						|| urlMessage == null
	    						|| threadId == null) {
	    					throw new FailPlayVideoException();
	    				}
	    				
	    				Class<?> activityClass = null;
	    				// 動画タイプチェック＆Activity選択
	    				if (urlVideo.indexOf("?v=") >= 0) {
	    					// flv
	    					activityClass = NicoroFFmpegPlayer.class;
	    				} else if (urlVideo.indexOf("?m=") >= 0) {
	    					// mp4
	    					if (mSharedPreferences.getBoolean(
	    							getString(R.string.pref_key_mp4_mediaplayer), true)) {
		    					activityClass = NicoroMediaPlayer.class;
	    					} else {
		    					activityClass = NicoroFFmpegPlayer.class;
	    					}
	    				} else if (urlVideo.indexOf("?s=") >= 0) {
	    					// swf
	    					// 未対応
	    					Log.w(LOG_TAG, "SWF is unsupported");
	    					Util.showErrorDialog(NicoroWebBrowser.this,
	    							"swf形式は未対応です", false);
	    				} else {
	    					// 想定外
	    					Log.w(LOG_TAG, "Unrecognized video URL:" + urlVideo);
	    					// とりあえずデフォルトで起動を試みる
	    					activityClass = NicoroFFmpegPlayer.class;
	    				}
	    				
	    				if (activityClass != null) {
		    				Intent intent = new Intent(getApplicationContext(), activityClass);
	        				intent.putExtra(AbstractNicoroPlayer.INTENT_NAME_VIDEO_URL, urlVideo);
	        				intent.putExtra(AbstractNicoroPlayer.INTENT_NAME_COOKIE, mCookieNicoHistory);
	        				intent.putExtra(AbstractNicoroPlayer.INTENT_NAME_VIDEO_NUMBER, videoNumber);
	        				intent.putExtra(AbstractNicoroPlayer.INTENT_NAME_MESSAGE_URL, urlMessage);
	        				intent.putExtra(AbstractNicoroPlayer.INTENT_NAME_THREAD_ID, threadId);
	        				intent.putExtra(AbstractNicoroPlayer.INTENT_NAME_USER_ID, mUserId);
	        				intent.putExtra(AbstractNicoroPlayer.INTENT_NAME_THREAD_KEY, threadKey);
	        				intent.putExtra(AbstractNicoroPlayer.INTENT_NAME_FORCE_184, force184);
	        				startActivityIfNeeded(intent, 0);
	    				}
					} catch (ClientProtocolException e) {
						Log.d(LOG_TAG, "", e);
					} catch (IOException e) {
						Log.d(LOG_TAG, "", e);
					}
				}
			} catch (FailPlayVideoException e) {
		        if (!checkIsCookieUserSessionValid(mCookieUserSession)) {
		        	// 何らかの理由でログアウト状態
		        	Toast toast = Toast.makeText(v.getContext(),
		        			R.string.toast_play_fail_not_login,
		        			Toast.LENGTH_LONG);
		        	toast.setGravity(Gravity.BOTTOM | Gravity.CENTER_HORIZONTAL,
		        			0, 50);
		        	toast.show();
		        	// ログイン画面へ
		        	mClickListenerNotLogin.onClick(v);
		        } else {
		        	// 原因不明で再生失敗
					Util.showErrorDialog(NicoroWebBrowser.this,
							R.string.errormessage_play_fail_unknown,
							false);
		        }
			}
		}
	};
	private View.OnClickListener mClickListenerNotLogin = new View.OnClickListener() {
		@Override
		public void onClick(View v) {
        	// ログイン画面へ
        	// TODO: ログイン後に元の動画のURLに移動しない
			mWebView.loadUrl("https://secure.nicovideo.jp/secure/login_form");
		}
	};
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

        getWindow().requestFeature(Window.FEATURE_PROGRESS);
		
        setContentView(R.layout.nicoro_webbrowser);
        
        // 例外対策
        CookieSyncManager.createInstance(getApplicationContext());
        
        if (mSharedPreferences == null) {
        	mSharedPreferences = PreferenceManager.getDefaultSharedPreferences(getApplicationContext());
        }
        mCookieUserSession = mSharedPreferences.getString(NicoroConfig.COOKIE_USER_SESSION, null);
		CookieManager cookieManager = CookieManager.getInstance();
        if (checkIsCookieUserSessionValid(mCookieUserSession)) {
        	// 前回保存時のuser session Cookieを有効化
			mMatcherGetUserID = Util.getMatcher(mMatcherGetUserID,
					PATTERN_GET_USERID_FROM_USERSESSION,
					mCookieUserSession);
			mUserId = getFirstMatch(mMatcherGetUserID);
        	cookieManager.setCookie("nicovideo.jp", mCookieUserSession);
        } else {
        	mCookieUserSession = null;
        	mUserId = null;
    		cookieManager.setCookie("nicovideo.jp", "user_session=");
        }
        // レイアウト崩れ対策
    	cookieManager.setCookie("nicovideo.jp", "nofix=1");
        
        mButtonPlay = (Button) findViewById(R.id.button_play);
        
        mButtonHelp = (Button) findViewById(R.id.button_help);
        mButtonHelp.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Intent intent = new Intent(getApplicationContext(), NicoroHelp.class);
				startActivityIfNeeded(intent, 0);
			}
        });
        boolean visibleHelpButton = mSharedPreferences.getBoolean(getString(R.string.pref_key_visible_help_button), true);
        if (visibleHelpButton) {
        	mButtonHelp.setVisibility(View.VISIBLE);
        } else {
        	mButtonHelp.setVisibility(View.GONE);
        }
        
        mWebView = (WebView) findViewById(R.id.webview);
        final WebSettings webSettings = mWebView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        webSettings.setSavePassword(true);
        boolean zoomControl = mSharedPreferences.getBoolean(getString(R.string.pref_key_browser_zoom_controls), true);
        webSettings.setBuiltInZoomControls(zoomControl);
        mWebView.setWebChromeClient(new WebChromeClient() {
        	@Override
        	public void onProgressChanged(WebView view, int newProgress) {
        		super.onProgressChanged(view, newProgress);
        		NicoroWebBrowser.this.setProgress(newProgress * 1000);
        	}
        });
        mWebView.setWebViewClient(new WebViewClient() {
        	@Override
        	public void onLoadResource(WebView view, String url) {
        		super.onLoadResource(view, url);
        		
        		boolean wasLogout;
        		if (url.equals("https://secure.nicovideo.jp/secure/logout")) {
        			// ログアウト
        			mCookieUserSession = null;
        			mUserId = null;
            		CookieManager cookieManager = CookieManager.getInstance();
            		cookieManager.setCookie("nicovideo.jp", "user_session=");
                	wasLogout = true;
        		} else {
        			wasLogout = false;
        		}
        		
        		// ページ移動に備えて基本的にWebViewのcurrent URLで確認
        		String urlCurrent = view.getUrl();
        		if (urlCurrent == null) {
        			urlCurrent = url;
        		}
        		
        		if (!wasLogout) {
	        		if (mCookieUserSession == null && urlCurrent.indexOf("nicovideo.jp") >= 0) {
	        			updateCookieUserSession();
	        		}
        		}
        		
        		mMatcherVideoUrl = Util.getMatcher(mMatcherVideoUrl,
        				PATTERN_VIDEO_URL,
        				urlCurrent);
    			if (mMatcherVideoUrl.find()) {
    				mButtonPlay.setVisibility(View.VISIBLE);
    				
    				if (mCookieUserSession == null) {
    					mButtonPlay.setText(R.string.button_not_login);
    					mButtonPlay.setTextColor(0xffff0000);
        		        mButtonPlay.setOnClickListener(mClickListenerNotLogin);
    				} else {
	    				if (mMatcherVideoUrl.group(1).startsWith("nm")) {
	    					mButtonPlay.setText(R.string.button_play_swf);
	    				} else {
	    					mButtonPlay.setText(R.string.button_play_normal);
	    				}
    					mButtonPlay.setTextColor(0xff000000);
	    				mButtonPlay.setOnClickListener(mClickListenerPlay);
    				}
    			} else {
    				mButtonPlay.setVisibility(View.GONE);
    			}
        		
//    			if (DEBUG_LOG) {
//	        		CookieManager cookieManager = CookieManager.getInstance();
//	        		String cookie = cookieManager.getCookie(urlCurrent);
//	        		if (cookie != null) {
//	        			Log.d(LOG_TAG, "URL=" + url
//	        					+ " Cookie=" + cookie);
//	        		}
//    			}
        		
        		if (urlCurrent.startsWith("http://www.nicovideo.jp/")) { 
			        SharedPreferences.Editor editor = mSharedPreferences.edit();
			        editor.putString(NicoroConfig.LAST_URL, urlCurrent);
					editor.commit();
	        		mLastUrl = urlCurrent;
        		}
        	}
        });
        
        WebBackForwardList backForwardList = null;
        if (savedInstanceState != null) {
        	backForwardList = mWebView.restoreState(savedInstanceState);
        }
        
        String url = null;
        Intent intent = getIntent();
        if (intent != null) {
        	String action = intent.getAction();
        	if (action != null && action.equals(Intent.ACTION_VIEW)) {
	        	Uri uri = intent.getData();
	        	if (uri != null) {
				url = uri.toString();
	        	}
        	}
        }
        if (url == null) {
        	String defaultUrl;
        	if (backForwardList != null) {
        		defaultUrl = backForwardList.getCurrentItem().getUrl();
        	} else {
        		defaultUrl = "http://www.nicovideo.jp/";
        	}
    		mLastUrl = mSharedPreferences.getString(NicoroConfig.LAST_URL, defaultUrl);
        } else {
        	mLastUrl = url;
        }
        
        mUserAgent = mSharedPreferences.getString(NicoroConfig.USER_AGENT,
        		null);
        if (mUserAgent == null) {
        	mUserAgent = mWebView.getSettings().getUserAgentString();
        	SharedPreferences.Editor editor = mSharedPreferences.edit();
        	editor.putString(NicoroConfig.USER_AGENT, mUserAgent);
        	editor.commit();
        }
        
        mSharedPreferencesChangeListener = new SharedPreferences.OnSharedPreferenceChangeListener() {
			@Override
			public void onSharedPreferenceChanged(
					SharedPreferences sharedPreferences, String key) {
				if (key.equals(getString(R.string.pref_key_visible_help_button))) {
			        boolean visibleHelpButton = mSharedPreferences.getBoolean(key, true);
			        if (visibleHelpButton) {
			        	mButtonHelp.setVisibility(View.VISIBLE);
			        } else {
			        	mButtonHelp.setVisibility(View.GONE);
			        }
				} else if (key.equals(getString(R.string.pref_key_browser_zoom_controls))) {
			        boolean zoomControl = mSharedPreferences.getBoolean(key, true);
			        mWebView.getSettings().setBuiltInZoomControls(zoomControl);
				}
			}
        };
        mSharedPreferences.registerOnSharedPreferenceChangeListener(mSharedPreferencesChangeListener);
        
        mWebView.loadUrl(mLastUrl);
	}
	
	@Override
	protected void onPause() {
		super.onPause();
	}
	
	@Override
	protected void onDestroy() {
		super.onDestroy();
        mSharedPreferences.unregisterOnSharedPreferenceChangeListener(mSharedPreferencesChangeListener);
	}
	
	@Override
	public void onConfigurationChanged(Configuration newConfig) {
		super.onConfigurationChanged(newConfig);
	}
	
	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		// 1.6向けなのでonKeyDownでback key監視
		if (keyCode == KeyEvent.KEYCODE_BACK) {
			if (mWebView.canGoBack()) {
				mWebView.goBack();
				return true;
			}
		}
		return super.onKeyDown(keyCode, event);
	}
	
	@Override
	public boolean onKeyUp(int keyCode, KeyEvent event) {
		return super.onKeyUp(keyCode, event);
	}
	
	@Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);
		mWebView.saveState(outState);
	}
	
	@Override
	protected void onRestoreInstanceState(Bundle savedInstanceState) {
		super.onRestoreInstanceState(savedInstanceState);
		mWebView.restoreState(savedInstanceState);
	}
	
	private String getAuthorizeCookie(DefaultHttpClient httpClient) throws ClientProtocolException, IOException {
		HttpPost httpRequest = new HttpPost("/secure/login?site=niconico");
		List<BasicNameValuePair> postParams = new ArrayList<BasicNameValuePair>();
//		postParams.add(new BasicNameValuePair("next_url", ""));
		postParams.add(new BasicNameValuePair("mail", ""));
		postParams.add(new BasicNameValuePair("password", ""));
		httpRequest.setEntity(new UrlEncodedFormEntity(postParams, HTTP.UTF_8));
		httpRequest.setHeader("User-Agent", mUserAgent);
		
		HttpResponse httpResponse = httpClient.execute(new HttpHost("secure.nicovideo.jp", 443, "https"), httpRequest);
		
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "getAuthorizeCookie httpResponse>");
			Util.logHeaders(LOG_TAG, httpResponse.getAllHeaders());
		}
		if (httpResponse.getStatusLine().getStatusCode() != HttpStatus.SC_OK) {
			return null;
		}
		
		List<Cookie> cookies = httpClient.getCookieStore().getCookies();
		String cookieAuthorize = "";
		boolean first = true;
		for (Cookie c : cookies) {
			if (first) {
				first = false;
			} else {
				cookieAuthorize += "; ";
			}
			if (DEBUG_LOGD) {
				Log.d(LOG_TAG, c.getName() + "=" + c.getValue());
			}
			cookieAuthorize += c.getName() + "=" + c.getValue();
		}
		return cookieAuthorize;
	}
	
	private String getVideoCookie(DefaultHttpClient httpClient, String uri, String cookie) throws ClientProtocolException, IOException {
		HttpRequest httpRequest = new HttpGet(uri);
		httpRequest.addHeader("Cookie", cookie);
		httpRequest.setHeader("User-Agent", mUserAgent);
		HttpResponse httpResponse = httpClient.execute(
				new HttpHost("www.nicovideo.jp", 80),
				httpRequest
				);
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "getVideoCookie httpResponse>");
			Util.logHeaders(LOG_TAG, httpResponse.getAllHeaders());
		}
		String cookieVideo = "";
		if (httpResponse.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
			List<Cookie> cookies = httpClient.getCookieStore().getCookies();
			boolean first = true;
			for (Cookie c : cookies) {
				if (first) {
					first = false;
				} else {
					cookieVideo += "; ";
				}
				if (DEBUG_LOGD) {
					Log.d(LOG_TAG, c.getName() + "=" + c.getValue());
				}
				cookieVideo += c.getName() + "=" + c.getValue();
			}
		
		}
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "getVideoCookie: " + cookieVideo);
		}
		return cookieVideo;
	}
	
	private String getGetflvResult(DefaultHttpClient httpClient, String uri,
			String cookie) throws ClientProtocolException, IOException {
		String result = getSingleLineDataFromAPI(httpClient, "www.nicovideo.jp", uri, cookie);
		return result;
	}
	
	private String getThreadKeyResult(DefaultHttpClient httpClient, String uri,
			String cookie) throws ClientProtocolException, IOException {
		String result = getSingleLineDataFromAPI(httpClient, "flapi.nicovideo.jp", uri, cookie);
		return result;
	}
	
	private String getSingleLineDataFromAPI(
			DefaultHttpClient httpClient, String hostname, String uri,
			String cookie) throws ClientProtocolException, IOException {
		String result = null;
		HttpRequest httpRequest = new HttpGet(uri);
		httpRequest.addHeader("Cookie", cookie);
		httpRequest.setHeader("User-Agent", mUserAgent);
		HttpResponse httpResponse = httpClient.execute(
				new HttpHost(hostname, 80),
				httpRequest
				);
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "getSingleLineDataFromAPI httpResponse>>>");
			Util.logHeaders(LOG_TAG, httpResponse.getAllHeaders());
			Log.d(LOG_TAG, "<<<httpResponse end");
		}
		if (httpResponse.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
			if (DEBUG_LOGD) {
				Log.d(LOG_TAG, hostname + uri + " entity>>>");
			}
			HttpEntity httpEntity = httpResponse.getEntity();
			result = "";
			LineNumberReader reader = null;
			try {
				reader = new LineNumberReader(new InputStreamReader(httpEntity.getContent()));
				while (true) {
					String line = reader.readLine();
					if (line == null) {
						break;
					}
					if (DEBUG_LOGD) {
						Log.d(LOG_TAG, line);
					}
					result += URLDecoder.decode(line, HTTP.UTF_8);
				}
				if (DEBUG_LOGD) {
					Log.d(LOG_TAG, "<<<entity end");
					Log.d(LOG_TAG, "result=" + result);
				}
			} finally {
				if (reader != null) {
					reader.close();
				}
			}
		}
		return result;
	}
	
	private String getVideoUrl(String infoBody) {
		if (infoBody != null) {
			Pattern pattern = Pattern.compile("&url=http://(.+?)(/.+?)&");
			Matcher matcher = pattern.matcher(infoBody);
			if (matcher.find()) {
				String url = "http://" + matcher.group(1) + matcher.group(2);
				if (url.indexOf("?s=") >= 0) {
					// swfはURL調整
					url += "as3";
				}
				if (DEBUG_LOGV) {
					Log.v(LOG_TAG, url);
				}
				
				// テスト：エコノミー
//				urlVideo += "low";
				
				return url;
			}
		}
		return null;
	}
	
	private String getMessageUrl(String infoBody) {
		if (infoBody != null) {
			Pattern pattern = Pattern.compile("&ms=http://(.+?)(/.+?)&");
			Matcher matcher = pattern.matcher(infoBody);
			if (matcher.find()) {
				String url = "http://" + matcher.group(1) + matcher.group(2);
				if (DEBUG_LOGV) {
					Log.v(LOG_TAG, url);
				}
				return url;
			}
		}
		return null;
	}
	
	private String getThreadId(String infoBody) {
		if (infoBody != null) {
			String threadId = getFirstMatch(infoBody, "thread_id=(.+?)&");
			if (DEBUG_LOGV) {
				Log.v(LOG_TAG, threadId);
			}
			return threadId;
		}
		return null;
	}
	
	private String getThreadKey(String threadKeyBody) {
		if (threadKeyBody != null) {
			String threadKey = getFirstMatch(threadKeyBody, "threadkey=(.+?)&");
			if (DEBUG_LOGV) {
				Log.v(LOG_TAG, threadKey);
			}
			return threadKey;
		}
		return null;
	}

	private String getForce184(String threadKeyBody) {
		if (threadKeyBody != null) {
			String force184 = getFirstMatch(threadKeyBody, "&force_184=(.+)");
			if (DEBUG_LOGV) {
				Log.v(LOG_TAG, force184);
			}
			return force184;
		}
		return null;
	}
	
	private String getFirstMatch(String input, String patternString) {
		Matcher matcher = Pattern.compile(patternString).matcher(input);
		return getFirstMatch(matcher);
	}
	
	private String getFirstMatch(Matcher matcher) {
		if (matcher.find()) {
			return matcher.group(1);
		}
		return null;
	}
	
	private void downloadVideo(DefaultHttpClient httpClient, String url, String cookie) throws ClientProtocolException, IOException {
		HttpUriRequest httpRequest = new HttpGet(url);
		httpRequest.addHeader("Cookie", cookie);
		httpRequest.setHeader("User-Agent", mUserAgent);
		HttpResponse httpResponse = httpClient.execute(
				httpRequest
				);
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "downloadVideo httpResponse>");
			Util.logHeaders(LOG_TAG, httpResponse.getAllHeaders());
		}
		if (httpResponse.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
			HttpEntity httpEntity = httpResponse.getEntity();
			InputStream inDownload = null;
			FileOutputStream outDownload = null;
			try {
				inDownload = httpEntity.getContent();
				outDownload = new FileOutputStream("/sdcard/nicoro_test.mp4");
				byte[] buffer = new byte[1024*8];
				while (true) {
					int read = inDownload.read(buffer);
					if (read < 0) {
						break;
					}
					outDownload.write(buffer, 0, read);
				}
			} finally {
				if (inDownload != null) {
					inDownload.close();
				}
				if (outDownload != null) {
					outDownload.close();
				}
			}
		}
		Log.d(LOG_TAG, "downloadVideo done.");
	}
	
	private void updateCookieUserSession() {
		String cookieUserSession = Util.getCookieValueFromManager(
				"nicovideo.jp", "user_session");
		if (cookieUserSession == null || cookieUserSession.length() == 0) {
			// ログアウト状態
			mCookieUserSession = null;
			mUserId = null;
		} else if (!cookieUserSession.equals(mCookieUserSession)) {
	        SharedPreferences.Editor editor = mSharedPreferences.edit();
	        editor.putString(NicoroConfig.COOKIE_USER_SESSION, cookieUserSession);
			editor.commit();
			mCookieUserSession = cookieUserSession;
			mMatcherGetUserID = Util.getMatcher(mMatcherGetUserID,
					PATTERN_GET_USERID_FROM_USERSESSION,
					mCookieUserSession);
			mUserId = getFirstMatch(mMatcherGetUserID);
		}
	}
	
	private boolean checkIsCookieUserSessionValid(String cookieUserSession) {
		if (cookieUserSession == null || cookieUserSession.length() == 0) {
			return false;
		}
		
		HttpUriRequest httpRequest = new HttpHead("http://www.nicovideo.jp/");
		httpRequest.addHeader("Cookie", cookieUserSession);
		httpRequest.setHeader("User-Agent", mUserAgent);
		if (DEBUG_LOGD) {
			Util.logHeaders(LOG_TAG, httpRequest.getAllHeaders());
		}
		
		DefaultHttpClient httpClient = Util.createHttpClient();
		httpClient.getCookieStore().clear();
		try {
			HttpResponse httpResponse = httpClient.execute(
					httpRequest
					);
			if (DEBUG_LOGD) {
				Log.d(LOG_TAG, httpResponse.getStatusLine().getReasonPhrase());
				Util.logHeaders(LOG_TAG, httpResponse.getAllHeaders());
			}
			
			int httpStatusCode = httpResponse.getStatusLine().getStatusCode();
			if (httpStatusCode != HttpStatus.SC_OK) {
				return false;
			}
			
			return checkNiconicoAuthflag(httpResponse);
		} catch (ClientProtocolException e) {
			Log.d(LOG_TAG, "", e);
			return false;
		} catch (IOException e) {
			Log.d(LOG_TAG, "", e);
			return false;
		} catch (NumberFormatException e) {
			Log.d(LOG_TAG, "", e);
			return false;
		}
	}
	
	private boolean checkNiconicoAuthflag(HttpResponse httpResponse) {
		Header authflag = httpResponse.getFirstHeader("x-niconico-authflag");
		if (authflag == null) {
			return false;
		}
		try {
			return Integer.parseInt(authflag.getValue()) != 0;
		} catch (NumberFormatException e) {
			return false;
		}
	}
	
	// メニュー関連
	
	private static final int MENU_ID_TOP = (Menu.FIRST + 1);
    private static final int MENU_ID_RELOAD = (Menu.FIRST + 2);
    private static final int MENU_ID_CONFIG = (Menu.FIRST + 3);
    private static final int MENU_ID_HELP = (Menu.FIRST + 4);
    private static final int MENU_ID_FINISH = (Menu.FIRST + 5);

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
    	menu.add(Menu.NONE, MENU_ID_TOP, Menu.NONE, "TOP");
    	menu.add(Menu.NONE, MENU_ID_RELOAD, Menu.NONE, "再読込");
    	menu.add(Menu.NONE, MENU_ID_CONFIG, Menu.NONE, "設定");
    	menu.add(Menu.NONE, MENU_ID_HELP, Menu.NONE, "ヘルプ");
    	menu.add(Menu.NONE, MENU_ID_FINISH, Menu.NONE, "終了");
    	
    	return super.onCreateOptionsMenu(menu);
    }
	
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
    	Intent intent;
    	switch (item.getItemId()) {
    	case MENU_ID_TOP:
    		mWebView.loadUrl("http://www.nicovideo.jp/");
    		return true;
    	case MENU_ID_RELOAD:
    		mWebView.reload();
    		return true;
    	case MENU_ID_CONFIG:
			intent = new Intent(getApplicationContext(), NicoroConfig.class);
			startActivity(intent);
    		return true;
    	case MENU_ID_HELP:
			intent = new Intent(getApplicationContext(), NicoroHelp.class);
			startActivityIfNeeded(intent, 0);
    		return true;
    	case MENU_ID_FINISH:
    		finish();
    		return true;
    	default:
    		assert false;
    		break;
    	}
    	return false;
    }
    
    
    private static class FailPlayVideoException extends Exception {
    }
}
