#define DEBUG_LOGD false

#define  LOG_TAG    "NicoRoJNI"
#if (DEBUG_LOGD)
#define  LOGD(...)  __android_log_print(ANDROID_LOG_DEBUG,LOG_TAG,__VA_ARGS__)
#else
#define  LOGD(...)
#endif /* LOG_TAG */


#include <string.h>
#include <jni.h>

#include <unistd.h>
#include <sys/endian.h>

#include <android/log.h>

#include "NicoroFFmpegPlayer.h"

#include "JniWrapper.h"

#include "jp_sourceforge_nicoro_NicoroFFmpegPlayer.h"

static JavaVM* gVM = NULL;

extern "C"
jint JNI_OnLoad(JavaVM *vm, void *reserved) {
	gVM = vm;
	return JNI_VERSION_1_4;
}

extern "C"
void JNI_OnUnload(JavaVM *vm, void *reserved) {
	gVM = NULL;
}

static bool checkNotNullAndThrow(JNIEnv * env, NicoroFFmpegPlayer* pNicoroFFmpegPlayer) {
	if (pNicoroFFmpegPlayer == NULL) {
		jclass clsj = env->FindClass("java/lang/NullPointerException");
		if (clsj != NULL) {
			env->ThrowNew(clsj, "Native instance is null");
			env->DeleteLocalRef(clsj);
		}
		return false;
	}
	return true;
}

JNIEXPORT jlong JNICALL Java_jp_sourceforge_nicoro_NicoroFFmpegPlayer_createNative
  (JNIEnv * env, jobject thiz) {
	LOGD("NicoroFFmpegPlayer#createNative start");
	return reinterpret_cast<jlong>(new NicoroFFmpegPlayer(gVM));
}

JNIEXPORT void JNICALL Java_jp_sourceforge_nicoro_NicoroFFmpegPlayer_destroyNative
  (JNIEnv * env, jobject thiz, jlong nativeInstance) {
	LOGD("NicoroFFmpegPlayer#destroyNative start");
	NicoroFFmpegPlayer* pNicoroFFmpegPlayer = reinterpret_cast<NicoroFFmpegPlayer *>(nativeInstance);
	if (pNicoroFFmpegPlayer != NULL) {
		delete pNicoroFFmpegPlayer;
	}
}

JNIEXPORT void JNICALL Java_jp_sourceforge_nicoro_NicoroFFmpegPlayer_loadFile
  (JNIEnv * env, jobject thiz, jlong nativeInstance, jstring file) {
	LOGD("NicoroFFmpegPlayer#loadFile start");
	NicoroFFmpegPlayer* pNicoroFFmpegPlayer = reinterpret_cast<NicoroFFmpegPlayer *>(nativeInstance);
	if (!checkNotNullAndThrow(env, pNicoroFFmpegPlayer)) {
		return;
	}

	pNicoroFFmpegPlayer->startJNI(env, thiz);

	JAutoPtrUTFChars fileUtf8(env, file);
	if (fileUtf8.get() != NULL) {
		pNicoroFFmpegPlayer->loadFileUseStream(fileUtf8.get());
	} else {
		LOGD("get filename NG");
	}

	pNicoroFFmpegPlayer->endJNI();
}

JNIEXPORT void JNICALL Java_jp_sourceforge_nicoro_NicoroFFmpegPlayer_loadStream
  (JNIEnv * env, jobject thiz, jlong nativeInstance) {
	LOGD("NicoroFFmpegPlayer#loadStream start");
	NicoroFFmpegPlayer* pNicoroFFmpegPlayer = reinterpret_cast<NicoroFFmpegPlayer *>(nativeInstance);
	if (!checkNotNullAndThrow(env, pNicoroFFmpegPlayer)) {
		return;
	}

	pNicoroFFmpegPlayer->startJNI(env, thiz);
	pNicoroFFmpegPlayer->loadStream(env, thiz);
	pNicoroFFmpegPlayer->endJNI();
}

JNIEXPORT void JNICALL Java_jp_sourceforge_nicoro_NicoroFFmpegPlayer_createAudioTrack
  (JNIEnv * env, jobject thiz, jlong nativeInstance) {
	LOGD("NicoroFFmpegPlayer#createAudioTrack start");
	NicoroFFmpegPlayer* pNicoroFFmpegPlayer = reinterpret_cast<NicoroFFmpegPlayer *>(nativeInstance);
	if (!checkNotNullAndThrow(env, pNicoroFFmpegPlayer)) {
		return;
	}

	pNicoroFFmpegPlayer->startJNI(env, thiz);
	pNicoroFFmpegPlayer->createAudioTrack(env, thiz);
	pNicoroFFmpegPlayer->endJNI();
}

JNIEXPORT void JNICALL Java_jp_sourceforge_nicoro_NicoroFFmpegPlayer_createDrawBuffer
  (JNIEnv * env, jobject thiz, jlong nativeInstance) {
	LOGD("NicoroFFmpegPlayer#createDrawBuffer start");
	NicoroFFmpegPlayer* pNicoro = reinterpret_cast<NicoroFFmpegPlayer *>(nativeInstance);
	if (!checkNotNullAndThrow(env, pNicoro)) {
		return;
	}

	pNicoro->startJNI(env, thiz);
	pNicoro->createDrawBuffer(env, thiz);
	pNicoro->endJNI();
}

JNIEXPORT jint JNICALL Java_jp_sourceforge_nicoro_NicoroFFmpegPlayer_decodeFrame
  (JNIEnv * env, jobject thiz, jlong nativeInstance, jintArray drawBuffer, jboolean skipVideoFrame) {
	LOGD("NicoroFFmpegPlayer#decodeFrame start");
	NicoroFFmpegPlayer* pNicoro = reinterpret_cast<NicoroFFmpegPlayer *>(nativeInstance);
	if (!checkNotNullAndThrow(env, pNicoro)) {
		return NicoroFFmpegPlayer::CODE_DECODE_FRAME_ERROR_OR_END;
	}

	pNicoro->startJNI(env, thiz);
	jint ret = pNicoro->decodeFrame(env, thiz, drawBuffer, skipVideoFrame);
	pNicoro->endJNI();
	return ret;
}
