package jp.sourceforge.nicoro;

import static jp.sourceforge.nicoro.Log.LOG_TAG;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Date;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.DefaultHttpServerConnection;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.util.MonthDisplayHelper;

public class VideoProxyHttpServer extends LooperThread {
	private static final boolean DEBUG_LOGV = Release.IS_DEBUG && true;
	private static final boolean DEBUG_LOGD = Release.IS_DEBUG && true;
	
	private static final int MSG_ID_INITIALIZE = 1;
	private static final int MSG_ID_RECEIVE_REQUEST = 2;
	private static final int MSG_ID_SEND_RESPONSE_HEADER = 3;
	private static final int MSG_ID_SEND_RESPONSE_ENTITY = 4;
	private static final int MSG_ID_CLOSE = 5;
	
	public static final int PROXY_PORT = 52525;
	
	private ServerSocket mServerSocket;
	private Socket mSocket;
	private DefaultHttpServerConnection mHttpServerConnection;
	private VideoLoader mVideoLoader;
	
	private WeakReference<Handler> mRefHandlerOnPreparedServer;
	private int mWhatOnPreparedServer;
	
	public VideoProxyHttpServer(VideoLoader videoLoader) {
		mVideoLoader = videoLoader;
	}
	
	// LooperThread
	
	@Override
	public boolean handleMessage(Message msg) {
		switch (msg.what) {
		case MSG_ID_INITIALIZE: {
			if (DEBUG_LOGV) {
				Log.v(LOG_TAG, "MSG_ID_INITIALIZE");
			}
			ServerSocket serverSocket;
			try {
				serverSocket = new ServerSocket();
				mServerSocket = serverSocket;
				serverSocket.setReuseAddress(true);
				serverSocket.setSoTimeout(180 * 1000);
				serverSocket.bind(new InetSocketAddress("localhost", PROXY_PORT));
				if (DEBUG_LOGD) {
					Log.d(LOG_TAG, serverSocket.toString());
				}
				
				Handler handlerOnPreparedServer =
					(mRefHandlerOnPreparedServer == null) ? null
							: mRefHandlerOnPreparedServer.get();
				if (handlerOnPreparedServer != null) {
					handlerOnPreparedServer.sendEmptyMessage(mWhatOnPreparedServer);
				}
				
				getHandler().sendEmptyMessage(MSG_ID_RECEIVE_REQUEST);
			} catch (IOException e) {
				// TODO 
				Log.e(LOG_TAG, e.toString(), e);
			}
		} break;
		case MSG_ID_RECEIVE_REQUEST: {
			if (DEBUG_LOGV) {
				Log.v(LOG_TAG, "MSG_ID_RECEIVE_REQUEST");
			}
			try {
				mSocket = mServerSocket.accept();
				if (DEBUG_LOGD) {
					Log.d(LOG_TAG, mSocket.toString());
				}
				
//				// TODO テスト
//				if (true) {
//					InputStream in = mSocket.getInputStream();
//					Reader reader = new InputStreamReader(in, "UTF-8");
//					reader = new LineNumberReader(reader);
//					LineNumberReader lnr = (LineNumberReader) reader;
//					while (true) {
//						String s = lnr.readLine();
//						if (s == null) {
//							break;
//						}
//						Log.d(LOG_TAG, lnr.readLine());
//					}
//					lnr.close();
//				}
				
				DefaultHttpServerConnection httpServerConnection =
					new DefaultHttpServerConnection();
				mHttpServerConnection =
					httpServerConnection;
				HttpParams httpParams = new BasicHttpParams();
				HttpConnectionParams.setTcpNoDelay(httpParams, true);
				HttpConnectionParams.setSoTimeout(httpParams, 180 * 1000);
				HttpConnectionParams.setLinger(httpParams, 0);
				HttpConnectionParams.setSocketBufferSize(httpParams, 1024 * 8);
				httpServerConnection.bind(mSocket, httpParams);
				httpServerConnection.setSocketTimeout(180 * 1000);
				if (DEBUG_LOGD) {
					Log.d(LOG_TAG, httpServerConnection.toString());
				}
				
				HttpRequest httpRequest = httpServerConnection.receiveRequestHeader();
				String reqMethod = httpRequest.getRequestLine().getMethod();
				String reqUri = httpRequest.getRequestLine().getUri();
				String reqVersion = httpRequest.getRequestLine().getProtocolVersion().toString();
				
				if (DEBUG_LOGD) {
					Log.d(LOG_TAG, "VideoProxyHttpServer: ===== HttpRequest begin =====");
					Log.d(LOG_TAG, Log.buf().append(reqMethod).append(' ')
							.append(reqUri).append(' ').append(reqVersion).toString());
					Util.logHeaders(LOG_TAG, httpRequest.getAllHeaders());
					Log.d(LOG_TAG, "VideoProxyHttpServer: ===== HttpRequest end =====");
				}
				
				if ("HEAD".equals(reqMethod)) {
					getHandler().obtainMessage(MSG_ID_SEND_RESPONSE_HEADER,
							httpRequest).sendToTarget();
				} else if ("GET".equals(reqMethod)) {
					getHandler().obtainMessage(MSG_ID_SEND_RESPONSE_ENTITY,
							httpRequest).sendToTarget();
				} else {
					// TODO
				}
			} catch (IOException e) {
				// TODO 
				Log.e(LOG_TAG, e.toString(), e);
			} catch (HttpException e) {
				// TODO 
				Log.e(LOG_TAG, e.toString(), e);
			}
			
		} break;
		case MSG_ID_SEND_RESPONSE_HEADER: {
			if (DEBUG_LOGV) {
				Log.v(LOG_TAG, "MSG_ID_SEND_RESPONSE_HEADER");
			}
			try {
				HttpRequest httpRequest = (HttpRequest) msg.obj;
				
				ProtocolVersion responseVersion;
				if (0 <= HttpVersion.HTTP_1_1.compareToVersion(
						httpRequest.getRequestLine().getProtocolVersion())) {
					responseVersion = HttpVersion.HTTP_1_1;
				} else {
					responseVersion = HttpVersion.HTTP_1_0;
				}
				
				HttpResponse httpResponse = new BasicHttpResponse(
						responseVersion,
						HttpStatus.SC_OK,
						null);
				addHeaderForResponse(httpResponse);
				
				if (DEBUG_LOGD) {
					Log.d(LOG_TAG, "VideoProxyHttpServer: ===== HttpResponse begin =====");
					Util.logHeaders(LOG_TAG, httpResponse.getAllHeaders());
					Log.d(LOG_TAG, "VideoProxyHttpServer: ===== HttpResponse end =====");
				}
				
				mHttpServerConnection.sendResponseHeader(httpResponse);
				
				if (!"Keep-Alive".equals(httpRequest.getHeaders("Connection"))) {
					mSocket.close();
					mSocket = null;
					getHandler().sendEmptyMessage(MSG_ID_RECEIVE_REQUEST);
				}
			} catch (IOException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			} catch (HttpException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
		} break;
		case MSG_ID_SEND_RESPONSE_ENTITY: {
			if (DEBUG_LOGV) {
				Log.v(LOG_TAG, "MSG_ID_SEND_RESPONSE_ENTITY");
			}
			try {
				HttpRequest httpRequest = (HttpRequest) msg.obj;
				
				ProtocolVersion responseVersion;
				if (0 <= HttpVersion.HTTP_1_1.compareToVersion(
						httpRequest.getRequestLine().getProtocolVersion())) {
					responseVersion = HttpVersion.HTTP_1_1;
				} else {
					responseVersion = HttpVersion.HTTP_1_0;
				}
				
				HttpResponse httpResponse = new BasicHttpResponse(
						responseVersion,
						HttpStatus.SC_OK,
						null);
				addHeaderForResponse(httpResponse);
				httpResponse.setEntity(createHttpEntity());
				
				if (DEBUG_LOGD) {
					Log.d(LOG_TAG, "VideoProxyHttpServer: ===== HttpResponse begin =====");
					Util.logHeaders(LOG_TAG, httpResponse.getAllHeaders());
					Log.d(LOG_TAG, "VideoProxyHttpServer: ===== HttpResponse end =====");
				}
				
				mHttpServerConnection.sendResponseEntity(httpResponse);
				
				if (!"Keep-Alive".equals(httpRequest.getHeaders("Connection"))) {
					mSocket.close();
					mSocket = null;
					getHandler().sendEmptyMessage(MSG_ID_RECEIVE_REQUEST);
				}
			} catch (HttpException e) {
				// TODO 
				Log.e(LOG_TAG, e.toString(), e);
			} catch (IOException e) {
				// TODO 
				Log.e(LOG_TAG, e.toString(), e);
			}
		} break;
		case MSG_ID_CLOSE: {
			if (DEBUG_LOGV) {
				Log.v(LOG_TAG, "MSG_ID_SEND_CLOSE");
			}
			try {
				mHttpServerConnection.close();
			} catch (IOException e) {
				// TODO 
				Log.e(LOG_TAG, e.toString(), e);
			}
			mHttpServerConnection = null;
			try {
				mSocket.close();
			} catch (IOException e) {
				// TODO 
				Log.e(LOG_TAG, e.toString(), e);
			}
			mSocket = null;
			try {
				mServerSocket.close();
			} catch (IOException e) {
				// TODO 
				Log.e(LOG_TAG, e.toString(), e);
			}
			mServerSocket = null;
		} break;
		default: {
			assert false : msg.what;
		} break;
		}
		
		return true;
	}
	
	
	public void startProxy() {
		start();
		getHandler().sendEmptyMessage(MSG_ID_INITIALIZE);
	}
	
	public void stopProxy() {
		getHandler().sendEmptyMessage(MSG_ID_CLOSE);
		quit();
	}
	
	public Uri getUri() {
		Uri uri = Uri.parse("http://localhost:" + PROXY_PORT + "/file."
				+ mVideoLoader.getMovieType());
//		Uri uri = Uri.parse("http://localhost:" + mSocket.getPort());
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, Log.buf().append("proxy url=")
					.append(uri.toString()).toString());
		}
		return uri;
	}
	
	public void registerOnPreparedServer(Handler handler, int what) {
		mRefHandlerOnPreparedServer = new WeakReference<Handler>(handler);
		mWhatOnPreparedServer = what;
	}

//	private void test() {
//		try {
//			mServerSocket = new ServerSocket();
//			mServerSocket.setReuseAddress(true);
//			mServerSocket.bind(new InetSocketAddress(PROXY_PORT));
//			
//			mSocket = mServerSocket.accept();
//			
//			mHttpServerConnection = new DefaultHttpServerConnection();
//			HttpParams httpParams = new BasicHttpParams();
//			mHttpServerConnection.bind(mSocket, httpParams);
//			
//			HttpRequest httpRequest = mHttpServerConnection.receiveRequestHeader();
//			
//			if (DEBUG_LOGD) {
//				Log.d(LOG_TAG, "VideoProxyHttpServer: ===== HttpRequest begin =====");
//				Util.logHeaders(LOG_TAG, httpRequest.getAllHeaders());
//				Log.d(LOG_TAG, "VideoProxyHttpServer: ===== HttpRequest end =====");
//			}
//			
//			String reqMethod = httpRequest.getRequestLine().getMethod();
//			
//			HttpResponse httpResponse = new BasicHttpResponse(
//					new ProtocolVersion("HTTP/1.0", 1, 0),
//					HttpStatus.SC_OK,
//					null
//					);
//			httpResponse.addHeader("Last-Modified", null/* TODO VideoLoaderから取得した値 */);
//			httpResponse.addHeader("ETag", null/* TODO VideoLoaderから取得した値 */);
//			httpResponse.addHeader("Content-Length", null/* TODO VideoLoaderから取得した値、あとEntityにも反映 */);
//			
//			httpResponse.setEntity(createHttpEntity());
//			
//			mHttpServerConnection.sendResponseEntity(httpResponse);
//			
//		} catch (IOException e) {
//			// TODO 自動生成された catch ブロック
//			e.printStackTrace();
//		} catch (HttpException e) {
//			// TODO 自動生成された catch ブロック
//			e.printStackTrace();
//		}
//		
//	}
	
	private HttpEntity createHttpEntity() {
//		return new AbstractHttpEntity() {
//
//			@Override
//			public InputStream getContent() throws IOException,
//					IllegalStateException {
//				// TODO
//				return createVideoLoaderWrapper(mVideoLoader);
//			}
//
//			@Override
//			public long getContentLength() {
//				// TODO 
//				return mVideoLoader.getContentLength();
//			}
//
//			@Override
//			public boolean isRepeatable() {
////				return true;
//				return false;
//			}
//
//			@Override
//			public boolean isStreaming() {
//				return true;
//			}
//
//			@Override
//			public void writeTo(OutputStream outstream) throws IOException {
//				// TODO これでいいか？
//				byte[] buffer = new byte[1024 * 8];
//				InputStream in = getContent();
//				try {
//					int read;
//					while (true) {
//						read = in.read(buffer);
//						if (read < 0) {
//							break;
//						}
//						outstream.write(buffer, 0, read);
//					}
//				} finally {
//					try {
//						in.close();
//					} catch (IOException e) {
//						Log.w(LOG_TAG, e.toString(), e);
//					}
//				}
//			}
//		};
		
		BasicHttpEntity entity = new BasicHttpEntity();
		entity.setContent(createVideoLoaderWrapper(mVideoLoader));
		entity.setContentLength(mVideoLoader.getContentLength());
//		entity.setChunked(true);
		entity.setContentType(mVideoLoader.getContentType());
		return entity;
	}
	
	private HttpResponse addHeaderForResponse(HttpResponse hr) {
		hr.addHeader("Content-Type",
				mVideoLoader.getContentType());
		hr.addHeader("ETag",
				mVideoLoader.getETag());
		hr.addHeader("Accept-Ranges", "bytes");
		hr.addHeader("Last-Modified",
				mVideoLoader.getLastModified());
		hr.addHeader("Content-Length",
				Long.toString(mVideoLoader.getContentLength()));
		hr.addHeader("Connection", "close");
		hr.addHeader("Date", DateUtils.formatDate(new Date()));
		return hr;
	}
	
	private InputStream createVideoLoaderWrapper(final VideoLoader videoLoader) {
		return videoLoader.createInputStream();
	}
}
