package jp.sourceforge.nicoro;

import static jp.sourceforge.nicoro.Log.LOG_TAG;
import android.graphics.Canvas;
import android.graphics.Paint;

/**
 * 投稿者コメント (char)
 * 
 * TODO 実装がまだ空
 */
public class MessageChatFork extends MessageChat {
	private static final int SCRIPT_COMMAND_DEFAULT = 0;
	private static final int SCRIPT_COMMAND_GYAKU = 2;
	
	private static final int SCRIPT_COMMAND_SUB_GYAKU_SUBE = 0;
	private static final int SCRIPT_COMMAND_SUB_GYAKU_COMME = 1;
	private static final int SCRIPT_COMMAND_SUB_GYAKU_TOUCOMME = 2;
	
	private boolean mIsScript = false;
	private int mScriptCommand;
	private int mScriptCommandSub;
	private boolean mWasRunCommand;

	public MessageChatFork(String m, int v) {
		super(m, v, true);
	}
	
	@Override
	public void setText(String text) {
		if (text != null) {
			if (text.startsWith("＠") || text.startsWith("@")) {
				mIsScript = true;
				
				int separate1 = text.indexOf(' ');
				int separate2 = text.indexOf('　');
				String commandMain;
				int commandParamIndex;
				if (separate1 < 0) {
					if (separate2 < 0) {
						commandMain = text.substring(1);
						commandParamIndex = -1;
					} else {
						commandMain = text.substring(1, separate2);
						commandParamIndex = separate2 + 1;
					}
				} else {
					if (separate2 < 0) {
						commandMain = text.substring(1, separate1);
						commandParamIndex = separate1 + 1;
					} else if (separate1 < separate2) {
						commandMain = text.substring(1, separate1);
						commandParamIndex = separate1 + 1;
					} else {
						commandMain = text.substring(1, separate2);
						commandParamIndex = separate2 + 1;
					}
				}
				if (commandMain.equals("デフォルト")) {
					mScriptCommand = SCRIPT_COMMAND_DEFAULT;
				} else if (commandMain.equals("逆")) {
					mScriptCommand = SCRIPT_COMMAND_GYAKU;
					if (mTime < 0) {
						mTime = 30; // デフォルト値
					}
					if (commandParamIndex < 0) {
						mScriptCommandSub = SCRIPT_COMMAND_SUB_GYAKU_SUBE;
					} else {
						String commandSub = text.substring(commandParamIndex);
						if (commandSub.startsWith("全")) {
							mScriptCommandSub = SCRIPT_COMMAND_SUB_GYAKU_SUBE;
						} else if (commandSub.startsWith("コメ")) {
							mScriptCommandSub = SCRIPT_COMMAND_SUB_GYAKU_COMME;
						} else if (commandSub.startsWith("投コメ")) {
							mScriptCommandSub = SCRIPT_COMMAND_SUB_GYAKU_TOUCOMME;
						} else {
							mScriptCommandSub = SCRIPT_COMMAND_SUB_GYAKU_SUBE;
						}
					}
				} else {
					Log.d(LOG_TAG, Log.buf().append("Unknown script=")
							.append(text).toString());
				}
			} else if (text.startsWith("/")) {
				// TODO ニワン語
				mIsScript = true;
			}
		}
		
		super.setText(text);
	}
	
	@Override
	protected boolean isScript() {
		return mIsScript;
	}
	@Override
	protected boolean isFork() {
		return true;
	}
	
	@Override
	public void prepareAdd(MessageChatController controller,
			Paint paintText, int vpos) {
		super.prepareAdd(controller, paintText, vpos);
//		if (isScript()) {
//			switch (mScriptCommand) {
//			case SCRIPT_COMMAND_DEFAULT:
//				controller.setCommandDefault(this);
//				break;
//			}
//		}
		mWasRunCommand = false;
	}
	
	public void prepareRemove(MessageChatController controller) {
		super.prepareRemove(controller);
		if (isScript()) {
			switch (mScriptCommand) {
			case SCRIPT_COMMAND_DEFAULT:
				controller.clearCommandDefault(this);
				break;
			case SCRIPT_COMMAND_GYAKU:
				controller.clearCommandGyaku(this);
				break;
			}
		}
	}
	
	@Override
	public void draw(int vpos, Canvas canvas, Paint paint,
			MessageChatController controller) {
		if (isScript()) {
			if (!mWasRunCommand) {
				if (vpos >= getVpos()) {
					switch (mScriptCommand) {
					case SCRIPT_COMMAND_DEFAULT:
						controller.setCommandDefault(this);
						break;
					case SCRIPT_COMMAND_GYAKU:
						controller.setCommandGyaku(this);
						break;
					}
					mWasRunCommand = true;
				}
			}
			return;
		}
		super.draw(vpos, canvas, paint, controller);
	}

	public int getDir(boolean isFork) {
		assert mScriptCommand == SCRIPT_COMMAND_GYAKU;
		if (mScriptCommand == SCRIPT_COMMAND_GYAKU) {
			switch (mScriptCommandSub) {
			case SCRIPT_COMMAND_SUB_GYAKU_SUBE:
				return DIR_GYAKU;
			case SCRIPT_COMMAND_SUB_GYAKU_COMME:
				if (isFork) {
					return DIR_NORMAL;
				} else {
					return DIR_GYAKU;
				}
			case SCRIPT_COMMAND_SUB_GYAKU_TOUCOMME:
				if (isFork) {
					return DIR_GYAKU;
				} else {
					return DIR_NORMAL;
				}
			}
		}
		// default
		return DIR_NORMAL;
	}
}
