package jp.sourceforge.nicoro;

import static jp.sourceforge.nicoro.Log.LOG_TAG;

import android.os.Handler;
import android.os.Looper;

public abstract class LooperThread extends Thread implements Handler.Callback {
	private Handler mHandler;
	private Object mWaitPrepare = new Object();
	
	@Override
	public void run() {
		Looper.prepare();
		
		synchronized (mWaitPrepare) {
			mHandler = new Handler(this);
			mWaitPrepare.notifyAll();
		}
		
		Looper.loop();
	}
	
	@Override
	public void start() {
		super.start();
		synchronized (mWaitPrepare) {
			while (mHandler == null) {
				try {
					mWaitPrepare.wait();
				} catch (InterruptedException e) {
					Log.w(LOG_TAG, e.toString(), e);
				}
			}
		}
	}
	
	public Handler getHandler() {
		return mHandler;
	}

	public void quit() {
		mHandler.getLooper().quit();
	}
}
