package jp.sourceforge.nicoro;

import static jp.sourceforge.nicoro.Log.LOG_TAG;

import java.util.Iterator;
import java.util.List;
import java.util.Random;

import jp.sourceforge.nicoro.AbstractNicoroPlayer.MessageData;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;

public class MessageChatController {
	private static final boolean DEBUG_LOGV = Release.IS_DEBUG && false;
	private static final boolean DEBUG_LOGD = Release.IS_DEBUG && true;
	
    private Paint mPaintText = new Paint();
    private Random mRandom = new Random();
    private Matrix mMatrixMessage = new Matrix();
    
    public void setAntiAlias(boolean messageAntialias) {
        mPaintText.setAntiAlias(messageAntialias);
    }

    public void drawMessage(Canvas canvas,
    		MessageData messageData,
    		MessageData messageDataFork,
    		int vpos, int videoWidth, int videoHeight, 
    		boolean messageDisable) {
		final List<MessageChat> chatsWait = messageData.mChatsWait;
    	
		setMatrixToCanvas(canvas, videoWidth, videoHeight);
    	
    	assert chatsWait != null;
    	assert messageData.mChatsRunningNaka != null;
    	assert messageData.mChatsRunningShita != null;
    	assert messageData.mChatsRunningUe != null;
    	
    	if (DEBUG_LOGV) {
    		Log.v(LOG_TAG, Log.buf().append("vpos=").append(vpos).toString());
    	}
    	
    	removeMessageChatByPassage(messageData, vpos);
    	
    	for (Iterator<MessageChat> it = chatsWait.iterator(); it.hasNext(); ) {
    		MessageChat chat = it.next();
    		if (chat.isDisplayedTiming(vpos)) {
    			it.remove();
				addMessageChat(chat, messageData, vpos);
    		}
    	}
    	
    	if (!messageDisable) {
    		drawMessageChatMain(messageData, vpos, canvas);
    	}
    }
    
    public void drawMessageForLive(Canvas canvas,
    		MessageData messageData,
    		MessageData messageDataFork,
    		int vpos, int videoWidth, int videoHeight, 
    		boolean messageDisable, LiveMessageLoader liveMessageLoader) {
		if (liveMessageLoader == null) {
			return;
		}
		
		final List<MessageChat> chatsWait = messageData.mChatsWait;
    	assert chatsWait != null;
    	assert messageData.mChatsRunningNaka != null;
    	assert messageData.mChatsRunningShita != null;
    	assert messageData.mChatsRunningUe != null;
		
    	setMatrixToCanvas(canvas, videoWidth, videoHeight);
    	
    	while (true) {
    		MessageChat chat = liveMessageLoader.poll();
    		if (chat == null) {
    			break;
    		}
    		
    		// 再生側で取り出した時刻で上書き
//    		chat.setVpos(vpos + 100);
    		chat.setVpos(vpos + 200);
    		chatsWait.add(chat);
    	}
    	
    	removeMessageChatByPassage(messageData, vpos);
    	
    	for (Iterator<MessageChat> it = chatsWait.iterator(); it.hasNext(); ) {
    		MessageChat chat = it.next();
    		if (chat.isDisplayedTiming(vpos)) {
    			it.remove();
				addMessageChat(chat, messageData, vpos);
    		}
    	}
		
		drawMessageChatMain(messageData, vpos, canvas);
    }
    
    private void removeMessageChatByPassage(
    		MessageData messageData, int vpos) {
		final List<MessageChat> chatsRunningNaka = messageData.mChatsRunningNaka;
		final List<MessageChat> chatsRunningShita = messageData.mChatsRunningShita;
		final List<MessageChat> chatsRunningUe = messageData.mChatsRunningUe;
		
    	for (Iterator<MessageChat> it = chatsRunningNaka.iterator(); it.hasNext(); ) {
    		MessageChat chat = it.next();
    		if (chat.isRemovedTiming(vpos)) {
    			it.remove();
    			continue;
    		}
    	}
    	for (Iterator<MessageChat> it = chatsRunningShita.iterator(); it.hasNext(); ) {
    		MessageChat chat = it.next();
    		if (chat.isRemovedTiming(vpos)) {
    			it.remove();
    			continue;
    		}
    	}
    	for (Iterator<MessageChat> it = chatsRunningUe.iterator(); it.hasNext(); ) {
    		MessageChat chat = it.next();
    		if (chat.isRemovedTiming(vpos)) {
    			it.remove();
    			continue;
    		}
    	}
    }
    
    private void addMessageChat(
    		MessageChat chat, MessageData messageData, int vpos) {
		final List<MessageChat> chatsRunningNaka = messageData.mChatsRunningNaka;
		final List<MessageChat> chatsRunningShita = messageData.mChatsRunningShita;
		final List<MessageChat> chatsRunningUe = messageData.mChatsRunningUe;
		final Paint paintText = mPaintText;
		final Random random = mRandom;
    	
		chat.computeWidth(paintText);
		chat.computeSpeed();
		chat.computeLineHeight(paintText);
		if (chat.getPos() == MessageChat.POS_NAKA) {
			int nextY = chat.computeNakaNextY(vpos, chatsRunningNaka, random);
			chat.setY(nextY, paintText);
			
			chat.addNakaOrder(chatsRunningNaka);
		} else if (chat.getPos() == MessageChat.POS_SHITA) {
			int nextY = chat.computeShitaNextY(chatsRunningShita, random);
			chat.setY(nextY, paintText);

			chat.addShitaOrder(chatsRunningShita);
		} else if (chat.getPos() == MessageChat.POS_UE) {
			int nextY = chat.computeUeNextY(chatsRunningUe, random);
			chat.setY(nextY, paintText);

			chat.addUeOrder(chatsRunningUe);
		} else {
			assert false;
		}
		
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, Log.buf().append("current-vpos=").append(vpos)
					.append(" vpos=").append(chat.getVpos())
					.append(" chat=").append(chat.getText()).toString());
		}
    }
    
    private void drawMessageChatMain(
    		MessageData messageData, int vpos, Canvas canvas) {
		final List<MessageChat> chatsRunningNaka = messageData.mChatsRunningNaka;
		final List<MessageChat> chatsRunningShita = messageData.mChatsRunningShita;
		final List<MessageChat> chatsRunningUe = messageData.mChatsRunningUe;
    	final Paint paintText = mPaintText;
		
    	for (Iterator<MessageChat> it = chatsRunningNaka.iterator(); it.hasNext(); ) {
    		MessageChat chat = it.next();
    		chat.draw(vpos, canvas, paintText);
    	}
		
    	for (Iterator<MessageChat> it = chatsRunningShita.iterator(); it.hasNext(); ) {
    		MessageChat chat = it.next();
    		chat.draw(vpos, canvas, paintText);
    	}
		
    	for (Iterator<MessageChat> it = chatsRunningUe.iterator(); it.hasNext(); ) {
    		MessageChat chat = it.next();
    		chat.draw(vpos, canvas, paintText);
    	}
    }
    
    private void setMatrixToCanvas(Canvas canvas,
    		int videoWidth, int videoHeight) {
		final Matrix matrixMessage = mMatrixMessage;
		
		matrixMessage.reset();
    	final float scaleY = (float) videoHeight / (float) AbstractNicoroPlayer.REAL_PLAYER_HEIGHT_PX_4_3;
//    	final float scaleX = (float) videoWidth / (float) AbstractNicoroPlayer.REAL_PLAYER_WIDTH_PX;
    	final float scaleX = scaleY;
    	matrixMessage.setScale(
    			scaleX,
    			scaleY);
    	// TODO 適当に横座標ずらす
    	final float translateX = ((float) videoWidth / scaleX - (float) AbstractNicoroPlayer.REAL_PLAYER_WIDTH_PX) / 2.0f;
    	matrixMessage.postTranslate(translateX, 0.0f);
    	canvas.setMatrix(matrixMessage);
//    	canvas.clipRect(0, 0, videoWidth, videoHeight);
    }
}
