package jp.sourceforge.nicoro;

import jp.sourceforge.nicoro.R;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.os.Bundle;
import android.preference.PreferenceActivity;

public class NicoroConfig extends PreferenceActivity {
	
	// 設定画面では扱わないオプションのキー
	public static final String COOKIE_USER_SESSION = "cookie_user_session";
	public static final String LAST_URL = "last_url";
	public static final String USER_AGENT = "user_agent";
	
	private static final String MA = "ma";
	private static final String PW = "pw";
	
	private static int BIT = 0xc55c5cc5;

	public NicoroConfig() {
	}
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		addPreferencesFromResource(R.xml.nicoro_config);
	}
	
	@Override
	public void onConfigurationChanged(Configuration newConfig) {
		super.onConfigurationChanged(newConfig);
	}

	// 設定画面とは関連のないメソッド
	
	public static String getMA(SharedPreferences sharedPreferences) {
		return convertXor(sharedPreferences.getString(MA, null));
	}
	public static String getPW(SharedPreferences sharedPreferences) {
		return convertXor(sharedPreferences.getString(PW, null));
	}
	/**
	 * {@link SharedPreferences.Editor#commit()} は後で自分で行うこと
	 * @param editor
	 * @param ma
	 */
	public static void putMA(SharedPreferences.Editor editor, String ma) {
		editor.putString(MA, convertXor(ma));
	}
	/**
	 * {@link SharedPreferences.Editor#commit()} は後で自分で行うこと
	 * @param editor
	 * @param pw
	 */
	public static void putPW(SharedPreferences.Editor editor, String pw) {
		editor.putString(PW, convertXor(pw));
	}
	
	private static String convertXor(String src) {
		if (src == null) {
			return null;
		}
		final int len = src.length();
		char[] buf = new char[len];
		for (int i = 0; i < len; ++i) {
			buf[i] = (char) ((src.charAt(i) ^ BIT) & 0xffff);
		}
		return new String(buf);
	}
}
