#!/usr/bin/env python2.6.2
# -*- coding: utf-8 -*-

""" Nicolib - NicoLive
Notes:
  にこりぶですよ～。

Example:
  >>> from NicoLive import *
  >>> live = NicoLive()
  >>> live.login("mailaddress", "password")
  >>> live.addObserver(AlertReceiver())      # AlertReceiver(ObserverBase)を実装して下さい
  >>> live.startCommentViewer()
"""

import cookielib
import urllib2

import Nico
import NicoAPI
import CommentServer

__all__ = ["NicoLive"]

class NicoLive(Nico.Nico):
    """ NicoLive - ニコニコ生放送クラス """

    def __init__(self):
        self._api         = NicoAPI.NicoAPI()     # API
        self._observers   = []                    # 通知先(Obsever)
        self._ticket      = None                  # ticket
        self._setCookie()                         # cookie設定

    def _setCookie(self):
        """ cookie設定 """
        self._cj     = cookielib.CookieJar()
        self._opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(self._cj))
        self._api.setOpener(self._opener)
        urllib2.install_opener(self._opener)

    def login(self, mail, password):
        """ Login処理 """
        self._api.login_nicolive(mail, password)

    def getTicket(self, mail, password):
        """ ticketの取得 """
        self._ticket = self._api.getTicket(mail, password)

    def getCommunities(self):
        """ 参加コミュニティを取得 """
        return self._api.getAlertStatus(self._ticket)['communities']

    def addObserver(self, observer):
        """ 通知先(Observer)登録 """
        self._observers.append(observer);

    def _notifyObservers(self, message):
        """ Observerへ通知 """
        [observer.notify(message) for observer in self._observers]

    def startCommentViewer(self, lv):
        """ サーバ情報取得 """
        playerstatus = self._api.getPlayerStatus(lv)
        self._address = playerstatus['addr']
        self._port    = playerstatus['port']
        self._thread  = playerstatus['thread']

        """ コメント取得開始 コメント情報のやり取りはObserverパターン """
        self._commentServer = CommentServer.CommentServer(self._address, self._port, self._thread)
        self._commentServer.addObserver(self._observers.pop())
        self._commentServer.startgetcomment()

    def startAlert(self):
        """ サーバ情報取得 """
        alertstatus = self._api.getAlertStatus(self._ticket)
        self._address     = alertstatus['addr']
        self._port        = alertstatus['port']
        self._thread      = alertstatus['thread']

        """ アラート取得開始 アラート情報のやり取りはObserverパターン """
        self._commentServer = CommentServer.CommentServer(self._address, self._port, self._thread)
        self._commentServer.addObserver(self._observers.pop())
        self._commentServer.startAlert()

