#!/usr/bin/env python2.6.2
# -*- coding: utf-8 -*-

""" Nicolib - NicoAPI
Notes:
  ニコニコ関係のAPIを実装するクラス
"""

import urllib
import xml.etree.cElementTree as etree

class NicoAPI:
    """ ニコニコ関連API URL """
    LOGIN_URL           = 'https://secure.nicovideo.jp/secure/login'
    LOGIN_ANTENNA_URL   = 'https://secure.nicovideo.jp/secure/login?site=nicolive_antenna'
    GETALERTSTATUS_URL  = 'http://live.nicovideo.jp/api/getalertstatus'
    GETPLAYERSTATUS_URL = 'http://live.nicovideo.jp/api/getplayerstatus'
    GETSTREAMINFO_URL   = 'http://live.nicovideo.jp/api/getstreaminfo/'

    def setOpener(self, opener):
        """ Opener設定(NicoLiveとAPIで共通) """
        self._opener = opener

    def login_nicolive(self, mail, password):
        """ NicoLive用Login処理 """
        url    = self.LOGIN_URL
        data   = {'mail':mail, 'password':password}
        params = urllib.urlencode(data)

        try:
            xml = self._opener.open(url, params).read()
        except IOError as e:
            print 'Failed to open "%s".' % url

    def getTicket(self, mail, password):
        """ ticketの取得 """
        url    = self.LOGIN_ANTENNA_URL
        data   = {'mail':mail, 'password':password}
        params = urllib.urlencode(data)

        try:
            xml = self._opener.open(url, params).read()
            element = etree.fromstring(xml)
            if element.get('status') == 'ok':
                # 今は必要最小限の情報のみ取得
                return element.findtext(".//ticket")
            else:
                raise IOError('getTicket status fail')
        except IOError as e:
            print e
            print 'Failed to open "%s".' % url

    def getAlertStatus(self, ticket):
        """ User情報及びCommentServer情報の取得 """
        url    = self.GETALERTSTATUS_URL
        data   = {'ticket':ticket}
        params = urllib.urlencode(data)

        try:
            xml = self._opener.open(url, params).read()
            element = etree.fromstring( xml )
            if element.get('status') == 'ok':
                # 今は必要最小限の情報のみ取得
                data = {}
                data['thread']      = element.findtext(".//thread")
                data['addr']        = element.findtext(".//addr")
                data['port']        = element.findtext(".//port")
                data['communities'] = [community.text for community in element.findall( ".//community_id" )]
                return data
            else:
                raise IOError('getAlertStatus status fail')
        except IOError as e:
            print e
            print 'Failed to open "%s".' % url

    def getPlayerStatus(self, lv):
        """ User情報及びCommentServer情報の取得 """
        url = self.GETPLAYERSTATUS_URL + '?v=' + lv

        try:
            xml = self._opener.open(url).read()
            element = etree.fromstring( xml )
            if element.get('status') == 'ok':
                # 今は必要最小限の情報のみ取得
                data = {}
                data['addr']   = element.findtext( ".//addr" )   # CommentServer Address
                data['port']   = element.findtext( ".//port" )   # CommentServer Port
                data['thread'] = element.findtext( ".//thread" ) # thread
                return data
            else:
                raise IOError('getPlayerStatus status fail')
        except IOError as e:
            print e
            print 'Failed to open "%s".' % url

    def getStreamInfo(self, lv):
        """ ニコニコ生放送番組情報取得 """
        url = self.GETSTREAMINFO_URL + lv

        try:
            xml = self._opener.open(url).read()
            element = etree.fromstring(xml)
            if element.get('status') == 'ok':
                # 今は必要最小限の情報のみ取得
                data = {}
                data['default_community'] = element.findtext( ".//default_community" )
                data['title']             = element.findtext( ".//title" )
                data['description']       = element.findtext( ".//description" )
                data['request_id']        = element.findtext( ".//request_id" )
                data['thumbnai']          = element.findtext( ".//thumbnai" )
                data['name']              = element.findtext( ".//name" )
                return data
            else:
                raise IOError('getStreamInfo status fail')
        except IOError as e:
            print e
            print 'Failed to open "%s".' % url

