#!/usr/bin/env python2.6.2
# -*- coding: utf-8 -*-

""" Nicolib - Nico
Notes:
  ニコニコサービスアクセス基底クラス
"""

import abc
import NicoAPI

class Nico(object):
    __metaclass__ = abc.ABCMeta

    def __init__(self):
        _api     = None  # API
        _cookies = []    # cookie格納用list

    @abc.abstractmethod
    def login(self, mail, password):
        pass
        
    # firefoxからセクション情報取得
    # path: cookies.sqliteのあるパス
    def GetCookie(self, path):
        browser = FirefoxInfo()
        cookie = browser.GetCookie(path)
        pass


# Firefoxから情報取得
class FirefoxInfo:
    # 実装あとで良さそう。
    def GetCookie(self, path):
        pass


# debug code
if __name__ == '__main__':
    lib = Nico()


