#!/usr/bin/env python2.6.2
# -*- coding: utf-8 -*-

""" Nicolib - Message
Notes:
  ニコニコ関係のサーバから送られてくるXMLSocketの受信Mesasgeを
  ParseするLogicを部品化したもの(抽象基底Class)
  本Classを継承、parse methodを実装して利用して下さい。

Example:
  >>> from Message import Message
  >>>
  >>> class CommentMessage(Message):
  >>>   @classmethod
  >>>   def parse(cls, plainMessage):
  >>>     # 実装
"""

import abc

class Message:
    """ Message - XMLSocketの受信Message(抽象基底Class) """
    __metaclass__ = abc.ABCMeta

    @abc.abstractmethod
    def parse(self, plainMessage):
        raise NotImplementedError

