#!/usr/bin/env python2.6.2
# -*- coding: utf-8 -*-

import sys
import time

import NicoLive
import ObserverBase

class CommentReceiver(ObserverBase.ObserverBase):
    def notify(self, message):
        date   = time.gmtime( float(message['date']) )
        now    = "%2s:%2s:%2s" % (date.tm_hour, date.tm_min, date.tm_sec)
        output = "(%s)No.%s, %s, %s" % (now, message['no'], message['user_id'], message['text'])
        
        try:
            print output.encode("cp932")
        except UnicodeEncodeError as e:
            print "encode error"
            print output.encode("utf-8")


# sample code
if __name__ == '__main__':
    mailaddress = "nicolib@bloodpledge.info"
    password    = "nico-lib"

    lib = NicoLive.NicoLive()
    lib.login( mailaddress, password )
    lib.addObserver(CommentReceiver())
    lib.startCommentViewer(sys.argv[1])
    
    raw_input()
    print "--- main thread end ---"

