#!/usr/bin/env python2.6.2
# -*- coding: utf-8 -*-

""" Nicolib - CommentMessage
Notes:
  ■ニコニコ生放送のコメントについて
    コメントは、XMLでchat要素で送られてきます。(ニコニコ生放送の番組通知(通称アラート)と同じような形式)
    下記のような属性を持ちます。

  ■属性
    - date      ... コメント投稿日時(エポックタイム)
    - no        ... コメント番号(投稿順に連番)
    - anonymity ... 184?
    - mail      ... 184などコマンド
    - premium   ... ユーザ属性(0:一般, 1:プレミアム, 2:アラート 3:放送主 6:運営)
    - thread    ... ?
    - user_id   ... ユーザID or ハッシュ
    - vpos      ... 生放送では不要?(ニコニコ動画ではコメント位置情報)

Example:
  >>> comment = コメント情報(XML)                # "<chat ～>コメント内容</chat>"
  >>> data    = CommentMessage.parse(comment)  # コメント情報(XML)をparseして辞書型で返します
"""

import xml.etree.cElementTree as etree
import Message as mes

class CommentMessage(mes.Message):
    """ CommentMessage - ニコニコ生放送のコメント情報 """

    # chat要素に含まれる属性一覧
    _ATTRS = ['date', 'no', 'anonymity', 'mail', 'premium', 'thread', 'user_id', 'vpos']

    def __init__(self):
        raise NotImplementedError

    @classmethod
    def parse(cls, plainMessage):
        """ コメント情報(XML)を解析、辞書型にまとめる
        @param  plainMessage : コメントサーバから送られてきたコメント情報1つ分
                               tag=<chat>のみ受信するはず。それ以外を受信した場合は例外とする。
        @return parseMessage : コメント情報から得られる情報を辞書型で返す
        """
        parseMessage = {}

        try:
            element = etree.fromstring( plainMessage )
            if element.tag == "chat":
                parseMessage = dict([(attr, element.get(attr, 'nodata')) for attr in CommentMessage._ATTRS])
                parseMessage['text'] = element.text      # コメント内容
            else:
                raise Exception("error: unknown tag...<" + element.tag + ">")
        except Exception, message:
            #print "Error:CommentMessage.parse NG", message
            pass

        return parseMessage


# debug code
if __name__ == '__main__':
    xml = '<chat date="125" no="50" premium="2" thread="3" user_id="34" vpos="0">5709,co1,107287</chat>'
    elem = CommentMessage.parse( xml )
    print elem


