#!/usr/bin/env python2.6.2
# -*- coding: utf-8 -*-

""" Nicolib - AlertMessage
Notes:
  ■ニコニコ生放送の番組通知（通称アラート）について
    アラート情報は、XMLでchat要素で送られてきます。(ニコニコ生放送のコメント情報と同じような形式)
    下記のような属性を持ちます。

  ■属性
    - date       ... 放送開始？日時(Unix)
    - no         ... ?(連番)
    - premium    ... ユーザ属性。常に6(運営)
    - thread     ... ?
    - user_id    ... 常に394であるため、辞書には本情報は登録しません。
                     代わりに、chat要素の内容に含まれる放送主のユーザ(下記参照)を辞書に登録します。
    - vpos       ... 常に0(不要？)

  ■AlertMessageで返す内容
    chat要素の内容のみ、カンマ区切りで3つの情報(下記)で送られてくるため
    下記のようにparseし、辞書に格納します。
    ・chat要素に含まれる3つの情報
      [放送ID],[チャンネル＆コミュニティID],[放送主のユーザーID]
    ・parse後の情報(キー名...説明)
      - lv_id        ... 放送ID
      - community_id ... community番号
      - user_id      ... ユーザID

Example:
  >>> alertxml = アラート情報(XML)               # "<chat ～>アラート内容</hoge>"
  >>> data     = AlertMessage.parse(alertxml)    # アラート情報(XML)をparseして辞書型で返します
"""

import xml.etree.cElementTree as etree
import Message as mes

class AlertMessage(mes.Message):
    """ AlertMessage - ニコニコ生放送の番組通知(通称アラート)情報 """

    # <chat> 要素に含まれる属性一覧
    _ATTRS = ['date', 'no', 'premium', 'thread', 'user_id', 'vpos']

    def __init__(self):
        raise NotImplementedError

    @classmethod
    def parse(cls, plainMessage):
        """ アラート情報(XML)を解析、辞書型にまとめる
        @param  plainMessage : コメントサーバから送られてきたアラート情報1つ分
                               tag=<chat>のみ受信するはず。それ以外を受信した場合は例外とする。
        @return parseMessage : アラート情報から得られる情報を辞書型で返す
        """
        parseMessage = {}

        try:
            element = etree.fromstring( plainMessage )
            if element.tag == "chat":
                parseMessage = dict([(attr, element.get(attr, 'nodata')) for attr in AlertMessage._ATTRS])
                (parseMessage['lv_id'], parseMessage['community_id'], parseMessage['user_id']) = element.text.split(',')
            else:
                raise Exception("error: unknown tag...<" + element.tag + ">")
        except Exception, message:
            #print "Error:AlertMessage.parse NG", message
            pass

        return parseMessage


# debug code
if __name__ == '__main__':
    xml = '<chat date="125" no="17" premium="2" thread="5" user_id="394" vpos="0">5755,co1296,1087</chat>'
    elem = AlertMessage.parse( xml )
    print elem

