<?php

class C2DB
{
	private $dbh;
	
	public function __construct()
	{
		$fname = LOG_FILE;
		$this->dbh = new PDO("sqlite:./{$fname}");
		
		self::initialize();
	}
	
	public function __destruct()
	{ }
	
	/**
	 * Initialize Database
	 */
	private function initialize()
	{
		$sql = "SELECT * FROM sqlite_master;";
		$result = $this->dbh->query($sql);
		$fetch = $result->fetch();
		if (empty($fetch)) {
			$sql = "CREATE TABLE messages (uhash TEXT NOT NULL, messages TEXT NOT NULL, post_time INTEGER);";
			$this->dbh->exec($sql);
			
			$uhash = "Administrator";
			$message = "C2チャットへようこそ。特に制約などはありません。法律に抵触しないようチャットをお楽しみください。";
			self::postMessage($uhash, $message, time());
		}
	}
	
	public function postMessage($uhash, $message, $post_time)
	{
		/**
		 * using SQLite, insert ''(twice single-quotation) instead of '(single-quotation)
		 */
		$message = str_replace("'", "''", $message);
		
		$sql = "INSERT INTO messages VALUES ('{$uhash}', '{$message}', {$post_time});";
		$this->dbh->exec($sql);
		
		touch(LOG_FILE, $post_time);
	}
	
	public function getAllMessages()
	{
		$sql = "SELECT rowid,* FROM messages;";
		$result = $this->dbh->query($sql);
		$fetch = $result->fetchAll(PDO::FETCH_ASSOC);
		if ($fetch === false) {
			return null;
		}
		return $fetch;
	}
	
	public function getNewerMessages($rowid)
	{
		$sql = "SELECT rowid,* FROM messages WHERE rowid > $rowid;";
		$result = $this->dbh->query($sql);
		$fetch = $result->fetchAll(PDO::FETCH_ASSOC);
		if ($fetch === false) {
			return null;
		}
		return $fetch;
	}
}
