package namaComment;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.nio.charset.Charset;

/**
 * ニコ生コメント取得クラス？
 * @author もめんと
 *	CommentSeedsクラスとNicoSuperクラスで必要な情報を取得したあと、
 *	コメントサーバに接続してソケット接続をしてコメント取得（厳密に言うとXMLを受信してタグごとに分解）するクラスです。
 *	@author Talisker
 *
 * TODO この生成された型コメントのテンプレートを変更するには次へジャンプ:
 * ウィンドウ - 設定 - Java - コード・スタイル - コード・テンプレート
 */
public abstract class NamaComment extends CommentSeeds implements NicoSocket{

	private boolean allComments = false;

	public NamaComment(String mail, String pass) throws IOException{
		super(mail, pass);
	}
	public NamaComment(String user_session){
		super(user_session);
	}

	@Override
	public final void openConnection(String lvNum) throws Exception{
		super.openConnection(lvNum);
	}

	//ソケット接続時に過去に流れていたコメントを拾うか否かの指定。
	//デフォルトでは過去コメントは拾わない。
	public final void setAllComments(boolean getFlag){
		this.allComments = getFlag;
	}
	public final boolean isAllComments(){
		return this.allComments;
	}

	@Override
	public final void openSocket() throws Exception{
		// コメント鯖のアドレスが取得したとき
		if (this.url != null && this.port != 0) {
			//ソケット繋ぐ。
			Socket socket = new Socket(this.url, this.port);
			socket.setKeepAlive(true);

			// いなたんソースぱくり
		    final String GET_COMMENT_XML = "<thread thread=\"%s\" res_from=\"%d\" version=\"20061206\" />\0";
		    int start = -1;
		    final String output = String.format(GET_COMMENT_XML, this.thread, start);
			DataOutputStream msgOutStream = new DataOutputStream(socket.getOutputStream());
	        msgOutStream.writeBytes(output);

	        InputStream is = socket.getInputStream();
			BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));

			StringBuilder lines = new StringBuilder();
			StringBuilder bufs = new StringBuilder();
			int word = 0;
			String line = "";

			//外ループ
			while(true){
				// 受信メッセージ
				lines = new StringBuilder();
				// 受信
				bufs = new StringBuilder();
				char[] buf = new char[16];
				br.read(buf, 0, buf.length);

				// 区切りがこない間は受信し続ける
				String str = String.valueOf(buf);
				while (str.indexOf("\0") == -1) {
					bufs.append(str);
					buf = new char[16];
					br.read(buf, 0, buf.length);
					str = String.valueOf(buf);
				}
				bufs.append(str);

				// 区切りの左だけ取りだして
				line += bufs.toString();
				String[] blocks = line.split("\0");
				line = blocks.length == 1 ? "" : blocks[1];

//debug				System.out.println("|" + blocks[0]);
				lines.append(blocks[0]+"\0");

				// ２つ以上メッセージがあるときは続ける
				while (line.indexOf("\0") != -1) {
					blocks = line.split("\0");
					line = blocks.length == 1 ? "" : blocks[1];

//debug					System.out.println("|" + blocks[0]);
					lines.append(line.split("\0")[0]+"\0");
				}

				// これなんだろう？
//				while(word != 0){
//					lines.append((char)word);
//				}

				line = lines.toString();
				while (line.indexOf("\0") != -1) {
					String[] tmps = line.split("\0");
					String tmp = tmps[0];

					//<chat />なら
					if (tmp.startsWith("<chat")) {
						this.chatRead(tmp);
					}
					//<thread />なら
					if (tmp.startsWith("<thread")) {
						this.threadRead(tmp);
					}
					line = tmps.length == 1 ? "" : tmps[1];
				}
				//lineを初期化?
			}
		}
		else {
			System.out.println("コメントサーバとれてません");
		}
	}

	@Override
	public final void closeSocket() throws Exception{
		//接続キル
	}
}
