package nicolib.cookie;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import nicolib.util.FileEx;
import nicolib.util.Logger;

/**
 * Firefoxのクッキーを取得するためクラス
 * いまのところWindows限定
 * @author hal
 *
 */
public class FirefoxCookie {
	
	private final static String host = ".nicovideo.jp";
	private final static String name = "user_session";
	
	public static String GetUserSession()
		throws CookieGetException
	{
		try {
			File originalSqlFile = getDefaultCookieFile();
			if(originalSqlFile != null && originalSqlFile.exists()){
				File temp = File.createTempFile("jwhois", ".db");
				FileEx.copyFile(originalSqlFile, temp);
				return readSql(temp.getPath());
			}
			
		} catch (IOException e) {
			Logger.writeException(e);
		}
		return null;
	}
	
	private static String readSql(String path){
		String result = null;
		
		try {
			
			Class.forName("org.sqlite.JDBC");
			Connection c = DriverManager.getConnection("jdbc:sqlite:/" + path.replace('\\', '/'));
			Statement st = c.createStatement();
			
			ResultSet rs = st.executeQuery(String.format("SELECT value FROM moz_cookies WHERE host = '%s' AND name = '%s'", host, name));
			while(rs.next()) {
				result = rs.getString(1);
			}
			
			rs.close();
			st.close();
			c.close();
						
		} catch (SQLException e) {
			Logger.writeException(e, true);
		} catch (ClassNotFoundException e) {
			Logger.writeException(e, true);
		}
		
		return result;
	}
	
	private static File getDefaultCookieFile() throws IOException{
		File appdata = new File(System.getenv("APPDATA"));
		File mozPath = new File(appdata, "Mozilla\\Firefox\\");
		File profPath = new File(mozPath, "profiles.ini");

		if(profPath.exists() && profPath.canRead()){
			boolean isRelative = false;
			String path = null;
			BufferedReader br = new BufferedReader(new FileReader(profPath));
			
			while(br.ready()){
				String line = br.readLine();
				if(line.startsWith("IsRelative")){
					isRelative = line.equals("IsRelative=1");
				}
				if(line.startsWith("Path")){
					path = line.substring(5);
				}
				if(line.equals("Default=1")){
					break;
				}
			}
			
			br.close();
			
			if(path != null){
				if(isRelative){
					File p = new File(mozPath, path);
					return new File(p, "cookies.sqlite");
				}else if(path != null){
					return new File(path);
				}
			}
		}
		
		return null;
	}

}
