package nicolib.comment;

import java.io.ByteArrayInputStream;
import java.util.Date;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import nicolib.util.Logger;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * サーバーから受信した文字列をデータに変換するクラス
 * @author hal
 *
 */
class StreamParser extends DefaultHandler {
	
	private Chat chat = null;
	private ThreadHeader thread = null;
	
	protected SAXParser parser;

	public StreamParser(){
		 
		try {
			SAXParserFactory spfactory = SAXParserFactory.newInstance();
			parser = spfactory.newSAXParser();
		} catch (ParserConfigurationException e) {
			Logger.writeException(e, true);
		} catch (SAXException e) {
			Logger.writeException(e, true);
		}

	}
	
	/**
	 * textで指定されたXML文字列を対応するクラスのインスタンスに変換します
	 * @param text サーバーから受信したXML形式の文字列
	 * @return 変換されたデータ
	 */
	public synchronized Object parse(String text){
		chat = null;
		thread = null;
		
		try {
			ByteArrayInputStream bais = new ByteArrayInputStream(text.getBytes("UTF-8"));
			parser.parse(bais, this);
			
			if(chat != null) return chat;
			else return thread;
			
		} catch (Exception e) {
			Logger.writeException(e, true);
		}
		
		return null;			
	} 

	public void startDocument() {
	}

	public void startElement(String uri, String localName, String qName, Attributes attributes) {
		if(qName.equals("chat")){	
			chat = new Chat();
			parseChatAttributes(attributes, chat);
		}else if(qName.equals("thread")){
			thread = new ThreadHeader();
			parseThreadAttributes(attributes, thread);
		}
	}
	
	private void parseChatAttributes(Attributes attributes, Chat chat){
		String data = attributes.getValue("anonymity");
		if(data != null) chat.anonymity = data.equals("1");
		
		data = attributes.getValue("date");
		if(data != null) chat.date = new Date(Long.parseLong(data));
		
		data = attributes.getValue("mail");
		if(data != null) chat.mail = data;
		
		data = attributes.getValue("no");
		if(data != null) chat.no = Integer.parseInt(data);
		
		data = attributes.getValue("premium");
		if(data != null) chat.premium = Integer.parseInt(data);
		
		data = attributes.getValue("thread");
		if(data != null) chat.thread = Integer.parseInt(data);
		
		data = attributes.getValue("user_id");
		if(data != null) chat.userId = data;
		
		data = attributes.getValue("vpos");
		if(data != null) chat.vpos = Integer.parseInt(data);
	}
	
	private void parseThreadAttributes(Attributes attributes, ThreadHeader thread){
		//<thread last_res=\"533\" resultcode=\"0\" revision=\"1\" server_time=\"1270325950\" thread=\"1019454199\" ticket=\"0x11702e90\"/>
	
		String data = attributes.getValue("last_res");
		if(data != null) thread.lastRes = Integer.parseInt(data);
		
		data = attributes.getValue("resultcode");
		if(data != null) thread.resultCode = Integer.parseInt(data);
		
		data = attributes.getValue("revision");
		if(data != null) thread.revision = Integer.parseInt(data);
		
		data = attributes.getValue("server_time");
		if(data != null) thread.serverTime = new Date(Integer.parseInt(data)*1000);
		
		data = attributes.getValue("thread");
		if(data != null) thread.thread = Integer.parseInt(data);
	
		data = attributes.getValue("ticket");
		if(data != null) thread.ticket = data;
	}

	public void characters(char[] ch, int offset, int length) {
		if(chat != null){
			chat.message = new String(ch, offset, length);
		}
	}

	public void endElement(String uri, String localName, String qName) {
		
	}

	public void endDocument() {

	}

}
