package nicolib.comment;

import nicolib.api.NicoApiException;
import nicolib.api.PlayerStatus;

/**
 * 生放送コメントの送受信を行うクラス
 * （送信は未実装）
 * @author hal
 *
 */
public class LiveTransceiver extends CommentReceiver {
	
	protected PlayerStatus playerStatus;
	protected LiveHandler liveHandler;
		
	public PlayerStatus getPlayerStatus() {
		return playerStatus;
	}
	
	/**
	 * コメント受信通知を受け取るハンドラを設定します
	 * @param liveHandler
	 */
	public void setLiveHandler(LiveHandler liveHandler) {
		super.setHandler(liveHandler);
		this.liveHandler = liveHandler;
	}
	
	/**
	 * 生放送データ解析用オブジェクトを取得します
	 * @return
	 */
	protected StreamParser getParser() {
		if(super.parser == null){
			super.parser = new LiveStreamPaser();
		}
		return super.parser;
	}
	
	/**
	 * 放送IDを指定してコメントサーバーに接続します
	 * @param liveId 放送ID（URL形式でもよい）
	 * @param resFrom コメント取得開始位置
	 * @return 接続を開始できたか
	 * @throws NicoApiException
	 */
	public boolean connectServer(String liveId, int resFrom) 
		throws NicoApiException 
	{
		playerStatus = PlayerStatus.get(liveId);
		
		if(!playerStatus.hasError()){
			return connectServer(playerStatus, resFrom);
		}

		return false;
	}
	
	/**
	 * 事前に取得したPlayerStatusを使用してコメントサーバーに接続します
	 * @param status
	 * @param resFrom コメント取得開始位置
	 * @return 接続を開始できたか
	 */
	public boolean connectServer (PlayerStatus status, int resFrom)
	{
		playerStatus = status;
		return super.connectServer(status.getAddr(), status.getPort(), status.getThread(), resFrom);
	}
	
	/**
	 * 変換されたデータをハンドラに渡します
	 */
	protected void commentServ(Object obj){
		
		if(liveHandler == null) {
			super.commentServ(obj);
			return;
		}
		
		// 処理が軽くなるように頻度の高い物が先に評価されるにする
		if(obj instanceof Chat){
			liveHandler.receiveChat((Chat)obj);
		}else if(obj instanceof ChatResult){
			liveHandler.receiveChatResult((ChatResult)obj);
		}else{
			super.commentServ(obj);
		}

	}
	
}
