package nicolib.comment;

import java.util.Date;

import nicolib.api.live.PlayerStatus;

/**
 *　コメントの表現クラス
 *　生成・破棄のサイクルが一番激しいクラスなのでパッケージ内からはフィールドに直接アクセス可能にしておく
 * @author hal
 * 
 */
public class Chat {
	
	String message;
	String mail;
	String userId;
	int thread;
	int no;
	int vpos;
	boolean anonymity;
	Date date;
	int premium;
	
	public String getMessage() {
		return message;
	}
	
	public String getMail() {
		return mail;
	}
	
	public String getUserId() {
		return userId;
	}
	
	public int getThread() {
		return thread;
	}
	
	public int getNo() {
		return no;
	}
	public int getVpos() {
		return vpos;
	}
	
	public boolean getAnonymity() {
		return anonymity;
	}
	
	public Date getDate() {
		return date;
	}
	
	public int getPremium() {
		return premium;
	}
	
	/**
	 * vposの文字列表現を返す
	 * 予約放送は開始3分前がvpos=0となるのでそのズレを修正するためにPlayerStatusを用いる
	 * @param status
	 * @return
	 */
	public String getVposStr(PlayerStatus status){
		long offset = status.getStartTime().getTime() - status.getBaseTime().getTime();
		long sec = this.vpos / 100 - offset / 1000;
		return String.format("%02d:%02d", sec / 60, sec % 60);
	}
	

	public Chat() {

	}
	
	@Override
	public boolean equals(Object obj) {
		if(obj != null && obj instanceof Chat){
			Chat that = (Chat)obj;
			return that.no == this.no && that.thread == this.thread;
		}
		return false;
	}
	
	@Override
	public int hashCode() {
		int id = this.no + this.thread; 
		return id;
	}
	
	@Override
	public String toString() {
		return message;
	}
	
}
