package nicolib.comment;

import nicolib.api.StreamInfo;

/**
 * アラート通知を受け取るためのインターフェース
 * @author hal
 *
 */
public interface AlertHandler extends CommentHandler{
	
	/**
	 * コメントサーバーからアラート通知が送られてきた時に呼び出されます。
	 * @param chat
	 */
	public void receiveAlertChat(AlertChat chat);
	
	/**
	 * 番組情報APIの取得時に呼び出されます。
	 * AlertReceiver.connectServerのwithStreamInfo引数をtrueにした時のみ発生します。
	 * @param info API取得失敗時にはnullになります
	 * @param chat 元になったAlertChat
	 */
	public void receiveStreamInfo(StreamInfo info, AlertChat chat);
}
