package nicolib.api.live;

import nicolib.api.AsyncLoadHandler;
import nicolib.api.NicoApiException;
import nicolib.api.UrlParamApiBase;

/**
 * コメント投稿用のキー
 * @author hal
 *
 */
public class PostKey extends UrlParamApiBase {

	private static final String API_URLFORMAT = "http://watch.live.nicovideo.jp/api/getpostkey?thread=%d&block_no=%d";
	
	/**
	 * コメント投稿用のキーを取得します
	 * [APIUrl] http://watch.live.nicovideo.jp/api/getpostkey?thread=[スレッド番号]&block_no=[コメントブロック]
	 * @param thread スレッド番号
	 * @param lastCommentNo 現在のコメント番号
	 * @return
	 * @throws NicoApiException
	 */
	public static PostKey get(int thread, int lastCommentNo) throws NicoApiException{
		int commentBlock = getCommentBlock(lastCommentNo);
		
		String url = String.format(API_URLFORMAT, thread, commentBlock);
		PostKey key = new PostKey(commentBlock);
		key.access(url);
		
		return key;
	}

	/**
	 * コメント投稿用のキーを非同期で取得します
	 * [APIUrl] http://watch.live.nicovideo.jp/api/getpostkey?thread=[スレッド番号]&block_no=[コメントブロック]
	 * @param thread スレッド番号
	 * @param lastCommentNo 現在のコメント番号
	 * @param handler
	 * @throws NicoApiException
	 */
	public static void getAsync(int thread, int lastCommentNo, AsyncLoadHandler handler) throws NicoApiException{
		int commentBlock = getCommentBlock(lastCommentNo);
		
		String url = String.format(API_URLFORMAT, thread, commentBlock);
		PostKey key = new PostKey(commentBlock);
		key.access(url);
	}
	
	/**
	 * 最終コメント番号からコメントブロックを計算します
	 * @param lastCommentNo
	 * @return
	 */
	private static int getCommentBlock(int lastCommentNo){
		return (lastCommentNo + 1) / 100;
	}
	
	private int commentBlock;
	
	private PostKey(int commentBlock){
		this.commentBlock = commentBlock;
	}
	
	/**
	 * ポストキー
	 * @return
	 */
	public String getPostKey(){
		return select("postkey");
	}
	
	/**
	 * 最終コメント番号から更新が必要かどうかを調べます
	 * @param lastCommentNo
	 * @return
	 */
	public boolean isNeedRefresh(int lastCommentNo){
		int cblock = getCommentBlock(lastCommentNo);
		return this.commentBlock != cblock;
	}
			
	
	
	
	
	
}
