package nicolib.api.live;

import nicolib.api.AsyncLoadHandler;
import nicolib.api.NicoApiException;
import nicolib.api.XmlApiBase;
import nicolib.util.Logger;

/**
 * ハートビート
 * @author hal
 *
 */
public class HeartBeat extends XmlApiBase {
	
	private static final String API_URLFORMAT = "http://live.nicovideo.jp/api/heartbeat?v=%s";
	
	/**
	 * ハートビートを取得する
	 * [APIUrl] http://live.nicovideo.jp/api/heartbeat?v=[放送ID]
	 * @param id
	 * @return
	 * @throws NicoApiException 
	 */
	public static HeartBeat get(String id) throws NicoApiException{
		String lid = checkAndGetLiveId(id);
		HeartBeat beat = new HeartBeat();
		beat.access(String.format(API_URLFORMAT, lid));
		
		return beat;
	}
	
	/**
	 * ハートビートを非同期で取得する
	 * [APIUrl] http://live.nicovideo.jp/api/heartbeat?v=[放送ID]
	 * @param id
	 * @param handler
	 * @throws NicoApiException
	 */
	public static void getAsync(String id, AsyncLoadHandler handler) throws NicoApiException{
		String lid = checkAndGetLiveId(id);
		HeartBeat beat = new HeartBeat();
		beat.accessAsync(String.format(API_URLFORMAT, lid), handler);
	}
	
	private HeartBeat(){
	}
	
	/**
	 * 来場者数
	 * @return
	 */
	public int getWatchCount(){
		return selectInt("heartbeat/watchCount", 0);
	}
	
	/**
	 * コメント数
	 * @return
	 */
	public int getCommentCount(){
		return selectInt("heartbeat/commentCount", 0);
	}
	
	/**
	 * チケット
	 * @return
	 */
	public String getTicket(){
		return select("heartbeat/ticket");
	}

	@Override
	public String getErrorCode() {
		return select("heartbeat/error/code");
	}

	@Override
	public String getErrorMessage() {
		String errorCode = getErrorCode();
		
		if(hasError()){
			if(errorCode == null){
				return "heartbeatの取得に失敗しました。";
			}else if(errorCode.equals("NOTFOUND_USERLIVESLOT")){
				return "座席が確保されていません。";
			}else if(errorCode.equals("UNKNOWN")){
				return "未知のエラーが発生しました。";
			}else if(errorCode.equals("NOTFOUND_STREAM")){
				return "指定された放送が見つかりませんでした。";
			}else if(errorCode.equals("NOTLOGIN")){
				return "ログインが完了していません。";
			}else{
				Logger.write("heartbeat UnknownErrorCode:" + errorCode);
				return "未定義のエラーが発生しました";
			}
		}else{
			return "エラーはありません";
		}
	}

	@Override
	public boolean hasError() {
		String status = select("heartbeat/@status");
		return status == null || !status.equals("ok");
	}

}
