package nicolib.api.alert;

import nicolib.api.AsyncLoadHandler;
import nicolib.api.NicoApiException;
import nicolib.api.XmlApiBase;
import nicolib.util.Logger;

/**
 * 番組情報取得用API
 * @author hal
 *
 */
public class StreamInfo extends XmlApiBase {

	private static final String API_URLFORMAT = "http://live.nicovideo.jp/api/getstreaminfo/%s";
	
	/**
	 * 指定した放送IDの番組情報取を取得する
	 * [APIUrl] http://live.nicovideo.jp/api/getstreaminfo/[放送ID]
	 * @param id 放送ID（URL形式でもよい）
	 * @return　StreamInfo
	 * @throws NicoApiException
	 */
	public static StreamInfo get(String id) throws NicoApiException{
		String lid = checkAndGetLiveId(id);
		StreamInfo info = new StreamInfo();
		info.access(String.format(API_URLFORMAT, lid));
		
		return info;	
	}
	
	/**
	 * 指定した放送IDの番組情報取を非同期で取得する
	 * [APIUrl] http://live.nicovideo.jp/api/getstreaminfo/[放送ID]
	 * @param id 放送ID（URL形式でもよい）
	 * @param handler
	 * @throws NicoApiException
	 */
	public static void getAsync(String id, AsyncLoadHandler handler) throws NicoApiException{
		String lid = checkAndGetLiveId(id);
		StreamInfo info = new StreamInfo();
		info.accessAsync(String.format(API_URLFORMAT, lid), handler);
		
	}
	
	private StreamInfo(){		
	}
	
	public String getRequestId(){
		return select("getstreaminfo/request_id");
	}
	
	public String getTitle(){
		return select("getstreaminfo/streaminfo/title");
	}
	
	public String getDescription(){
		return select("getstreaminfo/streaminfo/description");
	}
	
	public String getProviderType(){
		return select("getstreaminfo/streaminfo/provider_type");
	}
	
	public String getDefaultCommunity(){
		return select("getstreaminfo/streaminfo/default_community");
	}
	
	public String getCommunityName(){
		return select("getstreaminfo/communityinfo/name");
	}
	
	public String getCommunityThumbnail(){
		return select("getstreaminfo/communityinfo/thumbnail");
	}
	
	@Override
	public String getErrorCode() {
		return select("getstreaminfo/error/code");
	}

	@Override
	public String getErrorMessage() {
		String errorCode = getErrorCode();
		
		if(hasError()){
			if(errorCode == null){
				return "streaminfoの取得に失敗しました。";
			}else if(errorCode.equals("invalid_parameter")){
				return "許可がありません。";
			}else{
				Logger.write("StreamInfo UnknownErrorCode:" + errorCode);
				return "未定義のエラーが発生しました";
			}
		}else{
			return "エラーはありません";
		}
	}

	@Override
	public boolean hasError() {
		String status = select("getstreaminfo/@status");
		return status == null || !status.equals("ok");
	}

}
