package nicolib.api;

/**
 * APIを非同期で取得した際のイベントを扱うインターフェース
 * @author hal
 *
 */
public interface AsyncLoadHandler {
	
	/**
	 * 非同期取得に成功した際に呼び出されます
	 * @param api 目的のクラスにキャストして利用するかselect系メソッドで値を取得してください
	 */
	public void onLoaded(ApiBase api);
	
	/**
	 * 取得中に例外が発生すると呼び出されます
	 * @param e 例外
	 */
	public void onError(NicoApiException e);

}
