package nicolib;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 文字列を適切なデータに変換するためのユーティリティクラス
 * @author hal
 *
 */
public class NicoText {
	private static Pattern liveIdRegex = Pattern.compile("(lv\\d+)");
	private static Pattern userSessionRegex = Pattern.compile("user_session=([^;]*)");
	
	
	/**
	 * コメントやURLなどから放送ID部分のみを抜き出す
	 * @param text
	 * @return 放送ID
	 */
	public static String getLiveId(String text){
		if(text == null) return null;
		Matcher m = liveIdRegex.matcher(text);
		if(m.find()){
			return m.group(1);
		}
		
		return null;
	}
	
	/**
	 * レスポンスヘッダーのクッキーからユーザーセッションを抜き出す
	 * @param text
	 * @return ユーザーセッション
	 */
	public static String getUserSession(String text){
		if(text == null) return null;
		Matcher m = userSessionRegex.matcher(text);
		if(m.find()){
			return m.group(1);
		}
		return null;
	}
	
}
