package jwhois;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;

import nicolib.api.NicoApiException;
import nicolib.api.live.PlayerStatus;
import nicolib.comment.Chat;
import nicolib.comment.ChatReceiver;
import nicolib.comment.ChatReceiverHandler;
import nicolib.comment.ConnectionHandler;
import nicolib.comment.ThreadHeader;

import org.dyno.visual.swing.layouts.Constraints;
import org.dyno.visual.swing.layouts.GroupLayout;
import org.dyno.visual.swing.layouts.Leading;

//VS4E -- DO NOT REMOVE THIS LINE!
public class MainViewDesign extends JFrame {

	private static final long serialVersionUID = 1L;
	private JTable jTable0;
	private JScrollPane jScrollPane0;
	private JButton jButton0;
	private JPanel jPanel0;
	private JButton jButton1;
	private JTextField jTextField0;
	private JLabel jLabel0;
	private ChatReceiver receiver;
	private DefaultTableModel tableModel;
	private JLabel jLabel1;
	private static final String PREFERRED_LOOK_AND_FEEL = "javax.swing.plaf.metal.MetalLookAndFeel";
	public MainViewDesign() {
		initComponents();
	}

	private void initComponents() {
		add(getJScrollPane0(), BorderLayout.CENTER);
		add(getJPanel0(), BorderLayout.NORTH);
		add(getJLabel1(), BorderLayout.SOUTH);
		addWindowListener(new WindowAdapter() {
	
			public void windowOpened(WindowEvent event) {
				windowWindowOpened(event);
			}
		});
		setSize(688, 299);
	}

	private JLabel getJLabel1() {
		if (jLabel1 == null) {
			jLabel1 = new JLabel();
		}
		return jLabel1;
	}

	private JLabel getJLabel0() {
		if (jLabel0 == null) {
			jLabel0 = new JLabel();
			jLabel0.setText("LiveID");
		}
		return jLabel0;
	}

	private JTextField getJTextField0() {
		if (jTextField0 == null) {
			jTextField0 = new JTextField();
			jTextField0.setText("lv0");
		}
		return jTextField0;
	}

	private JButton getJButton1() {
		if (jButton1 == null) {
			jButton1 = new JButton();
			jButton1.setText("Disconnect");
			jButton1.addActionListener(new ActionListener() {
	
				public void actionPerformed(ActionEvent event) {
					jButton1ActionActionPerformed(event);
				}
			});
		}
		return jButton1;
	}

	private JPanel getJPanel0() {
		if (jPanel0 == null) {
			jPanel0 = new JPanel();
			jPanel0.setLayout(new GroupLayout());
			jPanel0.add(getJLabel0(), new Constraints(new Leading(9, 12, 12), new Leading(16, 12, 12)));
			jPanel0.add(getJTextField0(), new Constraints(new Leading(46, 276, 10, 10), new Leading(14, 12, 12)));
			jPanel0.add(getJButton0(), new Constraints(new Leading(331, 10, 10), new Leading(11, 12, 12)));
			jPanel0.add(getJButton1(), new Constraints(new Leading(419, 12, 12), new Leading(12, 12, 12)));
		}
		return jPanel0;
	}

	private JButton getJButton0() {
		if (jButton0 == null) {
			jButton0 = new JButton();
			jButton0.setText("Connect");
			jButton0.addActionListener(new ActionListener() {
	
				public void actionPerformed(ActionEvent event) {
					jButton0ActionPerformed(event);
				}
			});
		}
		return jButton0;
	}

	private JScrollPane getJScrollPane0() {
		if (jScrollPane0 == null) {
			jScrollPane0 = new JScrollPane();
			jScrollPane0.setBorder(null);
			jScrollPane0.setViewportView(getJTable0());
		}
		return jScrollPane0;
	}

	private JTable getJTable0() {
		if (jTable0 == null) {
			jTable0 = new JTable();
			jTable0.setModel(new DefaultTableModel(null, new String[] {"no", "Comment", "Time", "UserId"}) {
				private static final long serialVersionUID = 1L;
				Class<?>[] types = new Class<?>[] {Integer.class, String.class, String.class, String.class};
	
				public Class<?> getColumnClass(int columnIndex) {
					return types[columnIndex];
				}
			});
		}
		return jTable0;
	}

	private static void installLnF() {
		try {
			String lnfClassname = PREFERRED_LOOK_AND_FEEL;
			if (lnfClassname == null)
				lnfClassname = UIManager.getCrossPlatformLookAndFeelClassName();
			UIManager.setLookAndFeel(lnfClassname);
		} catch (Exception e) {
			System.err.println("Cannot install " + PREFERRED_LOOK_AND_FEEL
					+ " on this platform:" + e.getMessage());
		}
	}

	/**
	 * Main entry of the class.
	 * Note: This class is only created so that you can easily preview the result at runtime.
	 * It is not expected to be managed by the designer.
	 * You can modify it as you like.
	 */
	public static void main(String[] args) {
		installLnF();
		SwingUtilities.invokeLater(new Runnable() {
			@Override
			public void run() {
				MainViewDesign frame = new MainViewDesign();
				frame.setDefaultCloseOperation(MainViewDesign.EXIT_ON_CLOSE);
				frame.setTitle("JWhois");
				frame.getContentPane().setPreferredSize(frame.getSize());
				frame.pack();
				frame.setLocationRelativeTo(null);
				frame.setVisible(true);
			}
		});
	}

	private void windowWindowOpened(WindowEvent event) {
		
		jTable0.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		
		DefaultTableColumnModel columnModel
		    = (DefaultTableColumnModel)jTable0.getColumnModel();
	
		columnModel.getColumn(0).setPreferredWidth(50);
		columnModel.getColumn(1).setPreferredWidth(400);
		columnModel.getColumn(2).setPreferredWidth(50);
		columnModel.getColumn(3).setPreferredWidth(100);
		
		LoginDialog dialog = new LoginDialog();
		dialog.setDefaultCloseOperation(LoginDialog.DISPOSE_ON_CLOSE);
		dialog.setTitle("Login");
		dialog.setLocationRelativeTo(null);
		dialog.getContentPane().setPreferredSize(dialog.getSize());
		dialog.pack();
		dialog.setModal(true);
		dialog.setVisible(true);
		
		if(!dialog.getResult()){
			System.exit(0);
		}
		
		tableModel = (DefaultTableModel)jTable0.getModel();
		
		receiver = new ChatReceiver();
		
		
		receiver.setHandler(new ConnectionHandler() {
			
			@Override
			public void connectServer(ThreadHeader thread, String originalText) {
				jLabel1.setText("接続完了");
				clearChats();
			}
			
			@Override
			public void disconnectServer() {
				jLabel1.setText("切断");
			}

		});
		
		receiver.setHandler(new ChatReceiverHandler() {
			
			@Override
			public void receiveChat(Chat chat, String originalText) {
				// TODO 自動生成されたメソッド・スタブ
				addChat(chat);
			}
		});
		
		
	}

	protected void jButton0ActionPerformed(ActionEvent event){
		jLabel1.setText("接続中");
		PlayerStatus status = null;
		try{
			status = PlayerStatus.get(jTextField0.getText());
			if(status.hasError()){
				jLabel1.setText(status.getErrorMessage());
			}else{
				receiver.connectServer(status, -100);
			}
		}catch(NicoApiException e){
			
		}
		
	}
	
	private void jButton1ActionActionPerformed(ActionEvent event) {
		jLabel1.setText("切断中");
		receiver.disconnect();
		
	}
	
	protected void addChat(Chat chat){

		tableModel.insertRow(0, new Object[]{chat.getNo(), chat.getMessage(), chat.getVposStr(receiver.getPlayerStatus()), chat.getUserId()});
		
	}
	
	protected void clearChats(){
		tableModel.setRowCount(0);
	}

	
	
}
