using System;
using System.Collections;
using System.IO;
using System.Xml;
namespace Nicolib.Cookie.BrowserCookie {
	class SafariCookieGet : CookieBase{
	
		public SafariCookieGet(){
			ProcessList.Add( new ProcessInfo( "Safari" , true , Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData),"Apple Computer\\Safari\\Cookies\\Cookies.plist") ) );
		}
	
		string host = "nicovideo.jp";
		string name = "user_session";
		
		private ArrayList getCookieData(string file, string url, string key) {
			// <array>^O̎q<dict>^OB
			// <dict>^Oɂ́ACookiêPGgi[ĂB
			ArrayList cookies = new ArrayList();
			if(File.Exists(file)) {
				classCookies cookie;
				XmlTextReader reader = new XmlTextReader(file);
				while(reader.Read()) {
					switch(reader.NodeType) {
						case XmlNodeType.Element: // The node is an element.
							if(reader.Name.ToLower() == "dict") {
								cookie = getCookie(reader);
								if((url != string.Empty && cookie.domain == url) &&
								   (key == string.Empty || cookie.cookies.Contains(key))) {
									cookies.Add(cookie);
								}
							}
							break;

						case XmlNodeType.Text: //Display the text in each element.
							break;
						case XmlNodeType.EndElement: //Display the end of the element.
							break;
					}
				}
			}
			return cookies;
		}
		private classCookies getCookie(XmlTextReader reader) {
			classCookies cookie = new classCookies();
			string kind = string.Empty;
			string readData = string.Empty;
			string cookieKey = string.Empty;
			string cookieValue = string.Empty;
			string tagName = string.Empty;
			bool isEnd = false;

			while(reader.Read() && !isEnd) {
				switch(reader.NodeType) {
					case XmlNodeType.Element: // The node is an element.
						Console.Write("<" + reader.Name);
						Console.WriteLine(">");

						tagName = reader.Name.ToLower();
						break;

					case XmlNodeType.Text:
						readData = reader.Value;
						Console.WriteLine(readData);

						switch(tagName) {
							case "key":
								kind = readData;
								break;

							case "real":
							case "string":
							case "date":
								switch(kind.ToLower()) {
									case "domain":
										cookie.domain = readData;
										break;

									case "field":
										cookieKey = readData;
										break;

									case "value":
										cookieValue = readData;
										break;

									case "created":
									case "expires":
									case "path":
									default:
										break;
								}
								break;
						}
						break;

					case XmlNodeType.EndElement: //Display the end of the element.
						Console.Write("</" + reader.Name);
						Console.WriteLine(">");
						if(reader.Name.ToLower() == "dict") {
							isEnd = true;
						}
						break;
				}
				if((cookieKey != string.Empty) && (cookieValue != string.Empty)) {
					cookie.addCookie(cookieKey, cookieValue);
					cookieKey = string.Empty;
					cookieValue = string.Empty;
				}
			}

			return cookie;
		}

		protected override string CookieGet(string path) {
			string Data = null;
			ArrayList result = getCookieData(path, host, name);
			if(result.Count > 0) {
				classCookies cookies = (classCookies)result[0];
				Data = ((classCookies.classDomain.classPage.classCookie)(cookies.cookies[name])).value;
			} else {
				return (null);
			}
			return(Data);
		}
	}
}
