using System;
using System.Collections;
using System.IO;
using System.Text;
using System.Collections.Generic;
using CommonSystem;
namespace Nicolib.Cookie.BrowserCookie {
	class InternetExplorerCookieGet : CookieBase {
		private string host = "nicovideo.jp";
		private string name = "user_session";

		public InternetExplorerCookieGet() {
			ProcessList.Add( new ProcessInfo( "IE-1" , false , Environment.GetFolderPath( Environment.SpecialFolder.Cookies ) ) );
			ProcessList.Add( new ProcessInfo( "IE-2" , false , Path.Combine( Environment.GetFolderPath( Environment.SpecialFolder.Cookies ) , "Low\\" ) ) );
			ProcessList.Add( new ProcessInfo( "IE-3" , false , Path.Combine( Environment.GetFolderPath( Environment.SpecialFolder.ApplicationData ) , "Roaming\\Microsoft\\Windows\\Cookies\\" ) ) );	
			ProcessList.Add( new ProcessInfo( "IE-4" , false , Path.Combine( Environment.GetFolderPath( Environment.SpecialFolder.ApplicationData ) , "Roaming\\Microsoft\\Windows\\Cookies\\Low\\" ) ) );	
		}

		#region 
		private class CookieData {
			public string[] data;
			public CookieData() {
				data = new string[8];
			}
		}
		/// <summary>
		/// Cookie܂B
		/// </summary>
		/// <param field="path">ꏊ</param>
		/// <param field="url">URI</param>
		/// <param field="key">L[</param>
		/// <param field="IsSearchSubDir">TufBNg邩</param>
		/// <returns>CookiẽXg</returns>
		private ArrayList searchCookieValues(string path , string url , string key , bool IsSearchSubDir) {
			bool bIsSetDir = false;
			ArrayList result = new ArrayList();
			try {
				Directory.SetCurrentDirectory( path );
				bIsSetDir = true;
			} catch(Exception exc) {
				Log.Write( exc );
			}
			if(bIsSetDir) {
				DirectoryInfo current = new DirectoryInfo( "." );
				foreach(FileInfo file in current.GetFiles()) {
					if(file.Extension.ToLower() == ".txt") {
						result.AddRange( getCookieData( file.FullName , url , key ) );
					}
				}
				foreach(DirectoryInfo dir in current.GetDirectories()) {
					if(IsSearchSubDir) {
						result.AddRange( searchCookieValues( dir.FullName , url , key , IsSearchSubDir ) );
					}
				}
			}
			return result;
		}
		private ArrayList getCookieData(string filename , string url , string key) {
			string line;
			int counter = 0;
			ArrayList dataList = new ArrayList();
			CookieData cookieData = null;
			string tmpURL = "";

			using(StreamReader reader = new StreamReader( filename , Encoding.GetEncoding( "Shift_JIS" ) )) {
				cookieData = new CookieData();
				counter = 0;
				while(!reader.EndOfStream) {
					line = reader.ReadLine();
					if(line == "*") {
						tmpURL = string.Empty;
						if(counter >= 2) {
							tmpURL = getURL( cookieData.data[2] );
						}
						if(cookieData != null &&
							( key == string.Empty || ( key != string.Empty && cookieData.data[0] == key ) ) &&
							( url == string.Empty || ( url != string.Empty && url.IndexOf( tmpURL ) >= 0 ) )) {
							dataList.Add( cookieData );
							cookieData = null;
						}

						cookieData = new CookieData();
						counter = 0;
					} else {
						if(counter < 8 && cookieData != null) {
							cookieData.data[counter] = line;
							counter++;
						}
					}
				}

				tmpURL = string.Empty;
				if(counter >= 2) {
					tmpURL = getURL( cookieData.data[2] );
				}
				if(counter != 0 && cookieData != null &&
					( key == string.Empty || ( key != string.Empty && cookieData.data[0] == key ) ) &&
					( url == string.Empty || ( url != string.Empty && url.IndexOf( tmpURL ) >= 0 ) )) {
					dataList.Add( cookieData );
					cookieData = null;
				}

				reader.Close();
			}
			return dataList;
		}
		private string getURL(string preURL) {
			if(preURL != null) {
				string[] tmp = preURL.Split( new char[] { '/' } );
				return tmp[0];
			} else {
				return ( null );
			}
		}
		#endregion
		
		protected override string CookieGet(string path) {
			string result = null;
			ArrayList cookieList = searchCookieValues( path , host , name , true );
			if(cookieList.Count != 0) {
				CookieData cookieData = (CookieData)cookieList[0];
				result = cookieData.data[1];
			}
			return result;
		}
	}

}
