using System;
using System.Data.SQLite;
using System.IO;
using System.Collections.Generic;
namespace Nicolib.Cookie.BrowserCookie {
	class FirefoxCookieGet : CookieBase {
		private string host = ".nicovideo.jp";
		private string name = "user_session";

		public FirefoxCookieGet() {
			ProcessList.Add( new ProcessInfo( "FirefoxPortable" , true , "Data\\profile\\cookies.sqlite" ) );
			ProcessList.Add( new ProcessInfo( "firefox"         , true , DefaultCookiePath ) );
		}

		/// <summary>
		/// FirefoxjRjRZbV擾
		/// </summary>
		/// <returns>ZbV</returns>
		protected override string CookieGet(string file) {
			string _Value = null;
			using(SQLiteConnection SQLLite = new SQLiteConnection( string.Format( "Data Source={0}" , DbTempFile ) )) {
				SQLLite.Open();
				using(SQLiteCommand SQLCMD = new SQLiteCommand( string.Format( "SELECT value FROM moz_cookies WHERE host = '{0}' AND field = '{1}'" , host , name ) , SQLLite )) {
					using(SQLiteDataReader reader = SQLCMD.ExecuteReader()) {
						if(reader.Read()) {
							_Value = reader.GetString( 0 );
						}
						reader.Close();
						reader.Dispose();
					}
				}
				SQLLite.Close();
				SQLLite.Dispose();
			}
			return ( _Value );
		}

		/// <summary>
		/// ftHgCookiȅꏊ
		/// </summary>
		string DefaultCookiePath {
			get {
				string path         = null;
				string moz_path     = Path.Combine( Environment.GetFolderPath( Environment.SpecialFolder.ApplicationData ) , "Mozilla\\Firefox\\" );
				string profile_path = Path.Combine( moz_path , "profiles.ini" );
				if(File.Exists( profile_path )) {
					using(StreamReader sr = new StreamReader( profile_path )) {
						bool isRelative = false;

						while(!sr.EndOfStream) {
							string line = sr.ReadLine();
							if(line.StartsWith( "IsRelative" )) {
								isRelative = ( line == "IsRelative=1" );
							}
							if(line.StartsWith( "Path" )) {
								path = line.Substring( 5 ).Replace( '/' , '\\' );
							}
						}
						if(isRelative) {
							path = Path.Combine( moz_path , path );
							return ( Path.Combine( path , "cookies.sqlite" ) );
						}
					}
				}
				return ( null );
			}
		}
	}
}
