﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

using SystemCommon;
using ClientCommon;


namespace 顧客分析君
{
    public partial class _211PR詳細 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        public byte mbytMode;    // enm予定実績Mode と同期

        public int mintPR履歴No;
        public int mintPR区分No;
        public string mstrPR名;
        public int mintプロモーション予定No;
        public DateTime mdt公開予定日;
        public Nullable<int> mintプロモーション実績No;
        public Nullable<DateTime> mdt公開実施日;

		//private enum enmプロモーション_予定_対象広告
		//{
		//    プロモーション予定_対象広告No = 0,
		//    PR履歴No = 1,
		//    広告No = 2,
		//    広告名 = 3,
		//    担当者名 = 4,
		//    TEL = 5,
		//    FAX = 6,
		//    メールアドレス = 7,
		//    URL = 8
		//}
		private static class プロモーション_予定_対象広告
		{
            public const byte bytプロモーション予定_対象広告No = 0;
            public const byte bytPR履歴No = 1;
            public const byte byt広告No = 2;
            public const byte byt広告名 = 3;
            public const byte byt担当者名 = 4;
            public const byte bytTEL = 5;
            public const byte bytFAX = 6;
            public const byte bytメールアドレス = 7;
            public const byte bytURL = 8;
		}

		//private enum enmプロモーション_予定_対象商品
		//{
		//    プロモーション予定_対象商品No = 0,
		//    PR履歴No = 1,
		//    商品No = 2,
		//    商品ID = 3,
		//    商品名 = 4,
		//    商品単価 = 5
		//}
		private static class プロモーション_予定_対象商品
		{
            public const byte bytプロモーション予定_対象商品No = 0;
            public const byte bytPR履歴No = 1;
            public const byte byt商品No = 2;
            public const byte byt商品ID = 3;
            public const byte byt商品名 = 4;
            public const byte byt商品単価 = 5;
		}

		//private enum enmプロモーション_予定_対象顧客
		//{
		//    プロモーション予定_対象顧客No = 0,
		//    PR履歴No = 1,
		//    顧客No = 2,
		//    顧客ID = 3,
		//    氏名 = 4,
		//    氏名カナ = 5,
		//    性別 = 6,
		//    生年月日 = 7,
		//    郵便番号 = 8,
		//    住所 = 9,
		//    TEL = 10,
		//    メールアドレス = 11
		//}
		private static class プロモーション_予定_対象顧客
		{
            public const byte bytプロモーション予定_対象顧客No = 0;
            public const byte bytPR履歴No = 1;
            public const byte byt顧客No = 2;
            public const byte byt顧客ID = 3;
            public const byte byt氏名 = 4;
            public const byte byt氏名カナ = 5;
            public const byte byt性別 = 6;
            public const byte byt生年月日 = 7;
            public const byte byt郵便番号 = 8;
            public const byte byt住所 = 9;
            public const byte bytTEL = 10;
            public const byte bytメールアドレス = 11;
		}

		//private enum enmプロモーション_実績_対象広告
		//{
		//    プロモーション実績_対象広告No = 0,
		//    PR履歴No = 1,
		//    広告No = 2,
		//    広告名 = 3,
		//    担当者名 = 4,
		//    TEL = 5,
		//    FAX = 6,
		//    メールアドレス = 7,
		//    URL = 8
		//}
		private static class プロモーション_実績_対象広告
		{
            public const byte bytプロモーション実績_対象広告No = 0;
            public const byte bytPR履歴No = 1;
            public const byte byt広告No = 2;
            public const byte byt広告名 = 3;
            public const byte byt担当者名 = 4;
            public const byte bytTEL = 5;
            public const byte bytFAX = 6;
            public const byte bytメールアドレス = 7;
            public const byte bytURL = 8;
		}

		//private enum enmプロモーション_顧客一覧
		//{
		//    顧客No = 0,
		//    顧客ID = 1,
		//    氏名 = 2,
		//    氏名カナ = 3,
		//    性別 = 4,
		//    生年月日 = 5,
		//    郵便番号 = 6,
		//    住所 = 7,
		//    TEL = 8,
		//    メールアドレス = 9
		//}
		private static class プロモーション_顧客一覧
		{
            public const byte byt顧客No = 0;
            public const byte byt顧客ID = 1;
            public const byte byt氏名 = 2;
            public const byte byt氏名カナ = 3;
            public const byte byt性別 = 4;
            public const byte byt生年月日 = 5;
            public const byte byt郵便番号 = 6;
            public const byte byt住所 = 7;
            public const byte bytTEL = 8;
            public const byte bytメールアドレス = 9;
		}

		//private 顧客分析君.D01業務共通TableAdapters.D01PR区分ta d01PR区分ta;
		//private 顧客分析君.D17PR履歴TableAdapters.D17プロモーション予定_対象広告ta d17プロモーション予定_対象広告ta;
		//private 顧客分析君.D17PR履歴TableAdapters.D17プロモーション予定_対象商品ta d17プロモーション予定_対象商品ta;
		//private 顧客分析君.D17PR履歴TableAdapters.D17プロモーション予定_対象顧客ta d17プロモーション予定_対象顧客ta;
		//private 顧客分析君.D17PR履歴TableAdapters.D17PR履歴ta d17PR履歴ta;
		//private 顧客分析君.D17PR履歴TableAdapters.D17プロモーション予定ta d17プロモーション予定ta;
		//private 顧客分析君.D17PR履歴TableAdapters.D17プロモーション実績ta d17プロモーション実績ta;
		//private 顧客分析君.D17PR履歴TableAdapters.D17プロモーション実績_対象広告ta d17プロモーション実績_対象広告ta;
		//private 顧客分析君.D17PR履歴TableAdapters.D17プロモーション実績_購入顧客ta d17プロモーション実績_購入顧客ta;
		//private 顧客分析君.D17PR履歴TableAdapters.D17プロモーション実績_購入商品ta d17プロモーション実績_購入商品ta;
		//private 顧客分析君.D17PR履歴TableAdapters.D17プロモーション実績_見込顧客ta d17プロモーション実績_見込顧客ta;
		//private 顧客分析君.D17PR履歴TableAdapters.D17プロモーション実績_新規顧客ta d17プロモーション実績_新規顧客ta;
		//private 顧客分析君.D17PR履歴TableAdapters.D17プロモーション実績_掘起顧客ta d17プロモーション実績_掘起顧客ta;
		
		#endregion


        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド 
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _211PR詳細()
        {
			InitializeComponent();

			//this.d01PR区分ta = new 顧客分析君.D01業務共通TableAdapters.D01PR区分ta();
			//this.d17プロモーション予定_対象広告ta = new 顧客分析君.D17PR履歴TableAdapters.D17プロモーション予定_対象広告ta();
			//this.d17プロモーション予定_対象商品ta = new 顧客分析君.D17PR履歴TableAdapters.D17プロモーション予定_対象商品ta();
			//this.d17プロモーション予定_対象顧客ta = new 顧客分析君.D17PR履歴TableAdapters.D17プロモーション予定_対象顧客ta();
			//this.d17PR履歴ta = new 顧客分析君.D17PR履歴TableAdapters.D17PR履歴ta();
			//this.d17プロモーション予定ta = new 顧客分析君.D17PR履歴TableAdapters.D17プロモーション予定ta();
			//this.d17プロモーション実績ta = new 顧客分析君.D17PR履歴TableAdapters.D17プロモーション実績ta();
			//this.d17プロモーション実績_対象広告ta = new 顧客分析君.D17PR履歴TableAdapters.D17プロモーション実績_対象広告ta();
			//this.d17プロモーション実績_購入顧客ta = new 顧客分析君.D17PR履歴TableAdapters.D17プロモーション実績_購入顧客ta();
			//this.d17プロモーション実績_購入商品ta = new 顧客分析君.D17PR履歴TableAdapters.D17プロモーション実績_購入商品ta();
			//this.d17プロモーション実績_見込顧客ta = new 顧客分析君.D17PR履歴TableAdapters.D17プロモーション実績_見込顧客ta();
			//this.d17プロモーション実績_新規顧客ta = new 顧客分析君.D17PR履歴TableAdapters.D17プロモーション実績_新規顧客ta();
			//this.d17プロモーション実績_掘起顧客ta = new 顧客分析君.D17PR履歴TableAdapters.D17プロモーション実績_掘起顧客ta();

			//this.d01PR区分ta.ClearBeforeFill = true;
			//this.d17プロモーション予定_対象広告ta.ClearBeforeFill = true;
			//this.d17プロモーション予定_対象商品ta.ClearBeforeFill = true;
			//this.d17プロモーション予定_対象顧客ta.ClearBeforeFill = true;
			//this.d17PR履歴ta.ClearBeforeFill = true;
			//this.d17プロモーション予定ta.ClearBeforeFill = true;
			//this.d17プロモーション実績ta.ClearBeforeFill = true;
			//this.d17プロモーション実績_対象広告ta.ClearBeforeFill = true;
			//this.d17プロモーション実績_購入顧客ta.ClearBeforeFill = true;
			//this.d17プロモーション実績_購入商品ta.ClearBeforeFill = true;
			//this.d17プロモーション実績_見込顧客ta.ClearBeforeFill = true;
			//this.d17プロモーション実績_新規顧客ta.ClearBeforeFill = true;
			//this.d17プロモーション実績_掘起顧客ta.ClearBeforeFill = true;
		}

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
		////////////////////////////////////////////////////////////////////////
		#region 非公開 共通メソッド Static


		#endregion


		#region 非公開 共通メソッド Non Static

		private void Set列幅_プロモーション_予定()
        {
            dgvプロモーション_予定_対象広告.Columns[プロモーション_予定_対象広告.bytプロモーション予定_対象広告No].Visible = false;
            dgvプロモーション_予定_対象広告.Columns[プロモーション_予定_対象広告.bytPR履歴No].Visible = false;
            dgvプロモーション_予定_対象広告.Columns[プロモーション_予定_対象広告.byt広告No].Visible = false;
            dgvプロモーション_予定_対象広告.Columns[プロモーション_予定_対象広告.byt広告名].Width = C_列幅.広告名;
            dgvプロモーション_予定_対象広告.Columns[プロモーション_予定_対象広告.byt担当者名].Width = C_列幅.氏名;
            dgvプロモーション_予定_対象広告.Columns[プロモーション_予定_対象広告.bytTEL].Width = C_列幅.TEL;
            dgvプロモーション_予定_対象広告.Columns[プロモーション_予定_対象広告.bytFAX].Width = C_列幅.FAX;
            dgvプロモーション_予定_対象広告.Columns[プロモーション_予定_対象広告.bytメールアドレス].Width = C_列幅.メールアドレス;
            dgvプロモーション_予定_対象広告.Columns[プロモーション_予定_対象広告.bytURL].Width = C_列幅.URL;

            dgvプロモーション_予定_対象商品.Columns[プロモーション_予定_対象商品.bytプロモーション予定_対象商品No].Visible = false;
            dgvプロモーション_予定_対象商品.Columns[プロモーション_予定_対象商品.bytPR履歴No].Visible = false;
            dgvプロモーション_予定_対象商品.Columns[プロモーション_予定_対象商品.byt商品No].Visible = false;
            dgvプロモーション_予定_対象商品.Columns[プロモーション_予定_対象商品.byt商品ID].Width = C_列幅.商品ID;
            dgvプロモーション_予定_対象商品.Columns[プロモーション_予定_対象商品.byt商品名].Width = C_列幅.商品名;
            dgvプロモーション_予定_対象商品.Columns[プロモーション_予定_対象商品.byt商品単価].Width = C_列幅.商品単価;

            dgvプロモーション_予定_対象顧客.Columns[プロモーション_予定_対象顧客.bytプロモーション予定_対象顧客No].Visible = false;
            dgvプロモーション_予定_対象顧客.Columns[プロモーション_予定_対象顧客.bytPR履歴No].Visible = false;
            dgvプロモーション_予定_対象顧客.Columns[プロモーション_予定_対象顧客.byt顧客No].Visible = false;
            dgvプロモーション_予定_対象顧客.Columns[プロモーション_予定_対象顧客.byt顧客ID].Width = C_列幅.顧客ID;
            dgvプロモーション_予定_対象顧客.Columns[プロモーション_予定_対象顧客.byt氏名].Width = C_列幅.氏名;
            dgvプロモーション_予定_対象顧客.Columns[プロモーション_予定_対象顧客.byt氏名カナ].Width = C_列幅.氏名カナ;
            dgvプロモーション_予定_対象顧客.Columns[プロモーション_予定_対象顧客.byt性別].Width = C_列幅.性別;
            dgvプロモーション_予定_対象顧客.Columns[プロモーション_予定_対象顧客.byt生年月日].Width = C_列幅.年月日;
            dgvプロモーション_予定_対象顧客.Columns[プロモーション_予定_対象顧客.byt郵便番号].Width = C_列幅.郵便番号;
            dgvプロモーション_予定_対象顧客.Columns[プロモーション_予定_対象顧客.byt住所].Width = C_列幅.住所;
            dgvプロモーション_予定_対象顧客.Columns[プロモーション_予定_対象顧客.bytTEL].Width = C_列幅.TEL;
            dgvプロモーション_予定_対象顧客.Columns[プロモーション_予定_対象顧客.bytメールアドレス].Width = C_列幅.メールアドレス;
        }

        private void Set列幅_プロモーション_実績()
        {
            dgvプロモーション_実績_購入顧客一覧.Columns[プロモーション_顧客一覧.byt顧客No].Visible = false;
            dgvプロモーション_実績_購入顧客一覧.Columns[プロモーション_顧客一覧.byt顧客ID].Width = C_列幅.顧客ID;
            dgvプロモーション_実績_購入顧客一覧.Columns[プロモーション_顧客一覧.byt氏名].Width = C_列幅.氏名;
            dgvプロモーション_実績_購入顧客一覧.Columns[プロモーション_顧客一覧.byt氏名カナ].Width = C_列幅.氏名カナ;
            dgvプロモーション_実績_購入顧客一覧.Columns[プロモーション_顧客一覧.byt性別].Width = C_列幅.性別;
            dgvプロモーション_実績_購入顧客一覧.Columns[プロモーション_顧客一覧.byt生年月日].Width = C_列幅.年月日;
            dgvプロモーション_実績_購入顧客一覧.Columns[プロモーション_顧客一覧.byt郵便番号].Width = C_列幅.郵便番号;
            dgvプロモーション_実績_購入顧客一覧.Columns[プロモーション_顧客一覧.byt住所].Width = C_列幅.住所;
            dgvプロモーション_実績_購入顧客一覧.Columns[プロモーション_顧客一覧.bytTEL].Width = C_列幅.TEL;
            dgvプロモーション_実績_購入顧客一覧.Columns[プロモーション_顧客一覧.bytメールアドレス].Width = C_列幅.メールアドレス;

            dgvプロモーション_実績_新規顧客一覧.Columns[プロモーション_顧客一覧.byt顧客No].Visible = false;
            dgvプロモーション_実績_新規顧客一覧.Columns[プロモーション_顧客一覧.byt顧客ID].Width = C_列幅.顧客ID;
            dgvプロモーション_実績_新規顧客一覧.Columns[プロモーション_顧客一覧.byt氏名].Width = C_列幅.氏名;
            dgvプロモーション_実績_新規顧客一覧.Columns[プロモーション_顧客一覧.byt氏名カナ].Width = C_列幅.氏名カナ;
            dgvプロモーション_実績_新規顧客一覧.Columns[プロモーション_顧客一覧.byt性別].Width = C_列幅.性別;
            dgvプロモーション_実績_新規顧客一覧.Columns[プロモーション_顧客一覧.byt生年月日].Width = C_列幅.年月日;
            dgvプロモーション_実績_新規顧客一覧.Columns[プロモーション_顧客一覧.byt郵便番号].Width = C_列幅.郵便番号;
            dgvプロモーション_実績_新規顧客一覧.Columns[プロモーション_顧客一覧.byt住所].Width = C_列幅.住所;
            dgvプロモーション_実績_新規顧客一覧.Columns[プロモーション_顧客一覧.bytTEL].Width = C_列幅.TEL;
            dgvプロモーション_実績_新規顧客一覧.Columns[プロモーション_顧客一覧.bytメールアドレス].Width = C_列幅.メールアドレス;

            dgvプロモーション_実績_見込顧客一覧.Columns[プロモーション_顧客一覧.byt顧客No].Visible = false;
            dgvプロモーション_実績_見込顧客一覧.Columns[プロモーション_顧客一覧.byt顧客ID].Width = C_列幅.顧客ID;
            dgvプロモーション_実績_見込顧客一覧.Columns[プロモーション_顧客一覧.byt氏名].Width = C_列幅.氏名;
            dgvプロモーション_実績_見込顧客一覧.Columns[プロモーション_顧客一覧.byt氏名カナ].Width = C_列幅.氏名カナ;
            dgvプロモーション_実績_見込顧客一覧.Columns[プロモーション_顧客一覧.byt性別].Width = C_列幅.性別;
            dgvプロモーション_実績_見込顧客一覧.Columns[プロモーション_顧客一覧.byt生年月日].Width = C_列幅.年月日;
            dgvプロモーション_実績_見込顧客一覧.Columns[プロモーション_顧客一覧.byt郵便番号].Width = C_列幅.郵便番号;
            dgvプロモーション_実績_見込顧客一覧.Columns[プロモーション_顧客一覧.byt住所].Width = C_列幅.住所;
            dgvプロモーション_実績_見込顧客一覧.Columns[プロモーション_顧客一覧.bytTEL].Width = C_列幅.TEL;
            dgvプロモーション_実績_見込顧客一覧.Columns[プロモーション_顧客一覧.bytメールアドレス].Width = C_列幅.メールアドレス;

            dgvプロモーション_実績_掘起顧客一覧.Columns[プロモーション_顧客一覧.byt顧客No].Visible = false;
            dgvプロモーション_実績_掘起顧客一覧.Columns[プロモーション_顧客一覧.byt顧客ID].Width = C_列幅.顧客ID;
            dgvプロモーション_実績_掘起顧客一覧.Columns[プロモーション_顧客一覧.byt氏名].Width = C_列幅.氏名;
            dgvプロモーション_実績_掘起顧客一覧.Columns[プロモーション_顧客一覧.byt氏名カナ].Width = C_列幅.氏名カナ;
            dgvプロモーション_実績_掘起顧客一覧.Columns[プロモーション_顧客一覧.byt性別].Width = C_列幅.性別;
            dgvプロモーション_実績_掘起顧客一覧.Columns[プロモーション_顧客一覧.byt生年月日].Width = C_列幅.年月日;
            dgvプロモーション_実績_掘起顧客一覧.Columns[プロモーション_顧客一覧.byt郵便番号].Width = C_列幅.郵便番号;
            dgvプロモーション_実績_掘起顧客一覧.Columns[プロモーション_顧客一覧.byt住所].Width = C_列幅.住所;
            dgvプロモーション_実績_掘起顧客一覧.Columns[プロモーション_顧客一覧.bytTEL].Width = C_列幅.TEL;
            dgvプロモーション_実績_掘起顧客一覧.Columns[プロモーション_顧客一覧.bytメールアドレス].Width = C_列幅.メールアドレス;
        }

        private void Set属性マスタ()
        {
			C06DB共通.d01PR区分ta.Fill(d01業務共通.D01PR区分);
        }

        private void SetPR()
        {
            cmbPR区分.SelectedValue = mintPR区分No;
            txtPR名.Text = mstrPR名;
        }

        private void Setプロモーション_予定()
        {
            dtpプロモーション_予定_公開日.Value = mdt公開予定日;

			C06DB共通.d17プロモーション予定ta.Fill(d17PR履歴.D17プロモーション予定, mintPR履歴No);
            mintプロモーション予定No = int.Parse(d17PR履歴.D17プロモーション予定[0].プロモーション予定No.ToString());
            if (d17PR履歴.D17プロモーション予定[0].Is予定期間frNull() == false)
                dtpプロモーション_予定_予定期間fr.Value = d17PR履歴.D17プロモーション予定[0].予定期間fr;
            if (d17PR履歴.D17プロモーション予定[0].Is予定期間toNull() == false)
                dtpプロモーション_予定_予定期間to.Value = d17PR履歴.D17プロモーション予定[0].予定期間to;
            txtプロモーション_予定_総費用.Text = d17PR履歴.D17プロモーション予定[0].総費用.ToString();
            txtプロモーション_予定_内容.Text = d17PR履歴.D17プロモーション予定[0].内容;
            txtプロモーション_予定_備考.Text = d17PR履歴.D17プロモーション予定[0].備考;
            txtプロモーション_予定_対象商品総数.Text = d17PR履歴.D17プロモーション予定[0].対象商品総数.ToString();
            txtプロモーション_予定_対象既存顧客総数.Text = d17PR履歴.D17プロモーション予定[0].対象既存顧客総数.ToString();
            txtプロモーション_予定_総売上.Text = d17PR履歴.D17プロモーション予定[0].有効日数内の総売上.ToString();
            txtプロモーション_予定_新規顧客獲得数.Text = d17PR履歴.D17プロモーション予定[0].新規顧客獲得数.ToString();
            txtプロモーション_予定_見込顧客獲得数.Text =d17PR履歴.D17プロモーション予定[0].見込顧客獲得数.ToString();
            txtプロモーション_予定_掘起し顧客数.Text = d17PR履歴.D17プロモーション予定[0].掘起し顧客数.ToString();

			C06DB共通.d17プロモーション予定_対象広告ta.Fill(d17PR履歴.D17プロモーション予定_対象広告, mintPR履歴No);
			C06DB共通.d17プロモーション予定_対象商品ta.Fill(d17PR履歴.D17プロモーション予定_対象商品, mintPR履歴No);
			C06DB共通.d17プロモーション予定_対象顧客ta.Fill(d17PR履歴.D17プロモーション予定_対象顧客, mintPR履歴No);
        }

        private void Setプロモーション_実績()
        {
            if (mdt公開実施日 == null)
                dtpプロモーション_実績_公開日.Checked = false;
            else
                dtpプロモーション_実績_公開日.Value = (DateTime)mdt公開実施日;

            if (mintプロモーション実績No != null)
            { 
                //d17プロモーション実績ta.Fill(d17PR履歴.D17プロモーション実績, mintPR履歴No);
                //mintプロモーション実績No = int.Parse(d17PR履歴.D17プロモーション実績[0].プロモーション実績No.ToString());
				C06DB共通.d17プロモーション実績ta.Fill(d17PR履歴.D17プロモーション実績, (int)mintプロモーション実績No);
                if (d17PR履歴.D17プロモーション実績[0].Is実施期間frNull() == false)
                    dtpプロモーション_実績_実施期間fr.Value = d17PR履歴.D17プロモーション実績[0].実施期間fr;
                if (d17PR履歴.D17プロモーション実績[0].Is実施期間toNull() == false)
                    dtpプロモーション_実績_実施期間to.Value = d17PR履歴.D17プロモーション実績[0].実施期間to;
                txtプロモーション_実績_総費用.Text = d17PR履歴.D17プロモーション実績[0].総費用.ToString();
                txtプロモーション_実績_内容.Text = d17PR履歴.D17プロモーション実績[0].内容;
                txtプロモーション_実績_備考.Text = d17PR履歴.D17プロモーション実績[0].備考;

				C06DB共通.d17プロモーション実績_購入商品ta.Fill(d17PR履歴.D17プロモーション実績_購入商品
                    , dtpプロモーション_実績_実施期間fr.Value, dtpプロモーション_実績_実施期間to.Value);
                txtプロモーション_実績_購入商品総数.Text = d17PR履歴.D17プロモーション実績_購入商品.Count.ToString();

				C06DB共通.d17プロモーション実績_購入顧客ta.Fill(d17PR履歴.D17プロモーション実績_購入顧客
                    , dtpプロモーション_実績_実施期間fr.Value, dtpプロモーション_実績_実施期間to.Value);
                txtプロモーション_実績_購入顧客総数.Text = d17PR履歴.D17プロモーション実績_購入顧客.Count.ToString();

				//D03販売履歴TableAdapters.D03販売履歴ta d03販売履歴ta = new 顧客分析君.D03販売履歴TableAdapters.D03販売履歴ta();
				if (C06DB共通.d03販売履歴ta.Scalar総売上_期間指定(dtpプロモーション_実績_実施期間fr.Value
                    , dtpプロモーション_実績_実施期間to.Value).ToString() == "")
                    txtプロモーション_実績_総売上.Text = "0";
                else
					txtプロモーション_実績_総売上.Text = C06DB共通.d03販売履歴ta.Scalar総売上_期間指定(dtpプロモーション_実績_実施期間fr.Value
                    , dtpプロモーション_実績_実施期間to.Value).ToString();

				C06DB共通.d17プロモーション実績_新規顧客ta.Fill(d17PR履歴.D17プロモーション実績_新規顧客
                    , dtpプロモーション_実績_実施期間fr.Value, dtpプロモーション_実績_実施期間to.Value);
                txtプロモーション_実績_新規顧客獲得数.Text = d17PR履歴.D17プロモーション実績_新規顧客.Count.ToString();

				C06DB共通.d17プロモーション実績_見込顧客ta.Fill(d17PR履歴.D17プロモーション実績_見込顧客
                    , dtpプロモーション_実績_実施期間fr.Value, dtpプロモーション_実績_実施期間to.Value);
                txtプロモーション_実績_見込顧客獲得数.Text = d17PR履歴.D17プロモーション実績_見込顧客.Count.ToString();

				//顧客分析君.D01業務共通TableAdapters.D01属性ta d01属性ta;
				//d01属性ta = new 顧客分析君.D01業務共通TableAdapters.D01属性ta();
				C06DB共通.d17プロモーション実績_掘起顧客ta.Fill(d17PR履歴.D17プロモーション実績_掘起顧客
                    , dtpプロモーション_実績_実施期間fr.Value, dtpプロモーション_実績_実施期間to.Value
					, dtpプロモーション_実績_実施期間fr.Value.AddDays(double.Parse(C06DB共通.d01属性ta.Scalar値(84)) * -1));
                txtプロモーション_実績_掘起し顧客数.Text = d17PR履歴.D17プロモーション実績_掘起顧客.Count.ToString();
            }
        }

        private bool IsValidate()
        {
            //必須チェック
            if (cmbPR区分.Text == "")
            {
                string strMsg = string.Format(Properties.Resources.MSG_W_012, Properties.Resources.DGV列名_PR区分);
                MessageBox.Show(strMsg, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                cmbPR区分.Focus();
                return false;
            }

            if (txtPR名.Text == "")
            {
                string strMsg = string.Format(Properties.Resources.MSG_W_012, Properties.Resources.DGV列名_PR名);
                MessageBox.Show(strMsg, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                cmbPR区分.Focus();
                return false;
            }

            if (txtプロモーション_予定_総費用.Text != "")
            {
				if (C11ValidateOnForm.IsValidate符号無し数値型(txtプロモーション_予定_総費用.Text
                    , Properties.Resources.DGV列名_総費用) == false)
                {
                    txtプロモーション_予定_総費用.Focus();
                    return false;
                }
            }

            if (txtプロモーション_予定_対象商品総数.Text != "")
            {
				if (C11ValidateOnForm.IsValidate符号無し数値型(txtプロモーション_予定_対象商品総数.Text, "") == false)
                {
                    txtプロモーション_予定_対象商品総数.Focus();
                    return false;
                }
            }

            if (txtプロモーション_予定_対象既存顧客総数.Text != "")
            {
				if (C11ValidateOnForm.IsValidate符号無し数値型(txtプロモーション_予定_対象既存顧客総数.Text, "") == false)
                {
                    txtプロモーション_予定_対象既存顧客総数.Focus();
                    return false;
                }
            }

            if (txtプロモーション_予定_総売上.Text != "")
            {
				if (C11ValidateOnForm.IsValidate符号無し数値型(txtプロモーション_予定_総売上.Text, "") == false)
                {
                    txtプロモーション_予定_総売上.Focus();
                    return false;
                }
            }

            if (txtプロモーション_予定_新規顧客獲得数.Text != "")
            {
				if (C11ValidateOnForm.IsValidate符号無し数値型(txtプロモーション_予定_新規顧客獲得数.Text, "") == false)
                {
                    txtプロモーション_予定_新規顧客獲得数.Focus();
                    return false;
                }
            }

            if (txtプロモーション_予定_見込顧客獲得数.Text != "")
            {
				if (C11ValidateOnForm.IsValidate符号無し数値型(txtプロモーション_予定_見込顧客獲得数.Text, "") == false)
                {
                    txtプロモーション_予定_見込顧客獲得数.Focus();
                    return false;
                }
            }

            if (txtプロモーション_予定_掘起し顧客数.Text != "")
            {
				if (C11ValidateOnForm.IsValidate符号無し数値型(txtプロモーション_予定_掘起し顧客数.Text, "") == false)
                {
                    txtプロモーション_予定_掘起し顧客数.Focus();
                    return false;
                }
            }

            return true;
        }

        private void Updateプロモーション予定_基本情報()
        {
            int i総費用 = 0;
            int i対象商品総数 = 0;
            int i対象既存顧客総数 = 0;
            int i有効日数内の総売上 = 0;
            int i新規顧客獲得数 = 0;
            int i見込顧客獲得数 = 0;
            int i掘起し顧客数 = 0;

            if (txtプロモーション_予定_総費用.Text != "")
                i総費用 = int.Parse(txtプロモーション_予定_総費用.Text);

            if (txtプロモーション_予定_対象商品総数.Text != "")
                i対象商品総数 = int.Parse(txtプロモーション_予定_対象商品総数.Text);

            if (txtプロモーション_予定_対象既存顧客総数.Text != "")
                i対象既存顧客総数 = int.Parse(txtプロモーション_予定_対象既存顧客総数.Text);

            if (txtプロモーション_予定_総売上.Text != "")
                i有効日数内の総売上 = int.Parse(txtプロモーション_予定_総売上.Text);

            if (txtプロモーション_予定_新規顧客獲得数.Text != "")
                i新規顧客獲得数 = int.Parse(txtプロモーション_予定_新規顧客獲得数.Text);

            if (txtプロモーション_予定_見込顧客獲得数.Text != "")
                i見込顧客獲得数 = int.Parse(txtプロモーション_予定_見込顧客獲得数.Text);

            if (txtプロモーション_予定_掘起し顧客数.Text != "")
                i掘起し顧客数 = int.Parse(txtプロモーション_予定_掘起し顧客数.Text);

			C06DB共通.d17PR履歴ta.Updateプロモーション予定(mintPR履歴No
                                                , dtpプロモーション_予定_公開日.Value
                                                , dtpプロモーション_予定_予定期間fr.Value
                                                , dtpプロモーション_予定_予定期間to.Value
                                                , i総費用
                                                , i対象商品総数
                                                , i対象既存顧客総数
                                                , i有効日数内の総売上
                                                , i新規顧客獲得数
                                                , i見込顧客獲得数
                                                , i掘起し顧客数
                                                , txtプロモーション_予定_内容.Text
                                                , txtプロモーション_予定_備考.Text
                                                , C02業務共通処理.miログインスタッフNo
                                                , mintプロモーション予定No);

        }

        private void Updateプロモーション予定_対象広告()
        {
			C06DB共通.d17プロモーション予定_対象広告ta.DeleteByPR履歴No(mintPR履歴No);

            for (int iRow = 0; iRow < dgvプロモーション_予定_対象広告.RowCount; iRow++)
				C06DB共通.d17プロモーション予定_対象広告ta.InsertCommand(mintPR履歴No, 
                    int.Parse(dgvプロモーション_予定_対象広告.Rows[iRow].Cells[プロモーション_予定_対象広告.byt広告No].Value.ToString()), 
                    C02業務共通処理.miログインスタッフNo);
        }

        private void Updateプロモーション予定_対象商品()
        {
			C06DB共通.d17プロモーション予定_対象商品ta.DeleteByPR履歴No(mintPR履歴No);

            for (int iRow = 0; iRow < dgvプロモーション_予定_対象商品.RowCount; iRow++)
				C06DB共通.d17プロモーション予定_対象商品ta.InsertCommand(mintPR履歴No,
					int.Parse(dgvプロモーション_予定_対象商品.Rows[iRow].Cells[プロモーション_予定_対象商品.byt商品No].Value.ToString()),
                    C02業務共通処理.miログインスタッフNo);
        }

        private void Updateプロモーション予定_対象顧客()
        {
			C06DB共通.d17プロモーション予定_対象顧客ta.DeleteByPR履歴No(mintPR履歴No);

            for (int iRow = 0; iRow < dgvプロモーション_予定_対象顧客.RowCount; iRow++)
				C06DB共通.d17プロモーション予定_対象顧客ta.InsertCommand(mintPR履歴No,
                    int.Parse(dgvプロモーション_予定_対象顧客.Rows[iRow].Cells[プロモーション_予定_対象顧客.byt顧客No].Value.ToString()),
                    C02業務共通処理.miログインスタッフNo);
        }

        private void Updateプロモーション実績_基本情報()
        {
            int i総費用 = 0;

            if (txtプロモーション_実績_総費用.Text != "")
                i総費用 = int.Parse(txtプロモーション_実績_総費用.Text);

			C06DB共通.d17PR履歴ta.Updateプロモーション実績(mintPR履歴No
                                                , dtpプロモーション_実績_公開日.Value
                                                , dtpプロモーション_実績_実施期間fr.Value
                                                , dtpプロモーション_実績_実施期間to.Value
                                                , i総費用
                                                , txtプロモーション_実績_内容.Text
                                                , txtプロモーション_実績_備考.Text
                                                , C02業務共通処理.miログインスタッフNo
                                                , (int)mintプロモーション実績No);
        }

        //private void Updateプロモーション実績_対象広告()
        //{
        //    d17プロモーション実績_対象広告ta.DeleteByPR履歴No(mintPR履歴No);

        //    for (int iRow = 0; iRow < dgvプロモーション_実績_対象広告.RowCount; iRow++)
        //        d17プロモーション実績_対象広告ta.InsertCommand(mintPR履歴No,
        //            int.Parse(dgvプロモーション_実績_対象広告.Rows[iRow].Cells[(int)enmプロモーション_実績_対象広告
        //            .広告No].Value.ToString()),
        //            C02業務共通処理.miログインスタッフNo);
        //}

        private void Setプロモーション予定_対象顧客(D10顧客.D10RFM顧客抽出DataTable dtRFM顧客抽出)
        {
            foreach (D10顧客.D10RFM顧客抽出Row drRFM顧客抽出 in dtRFM顧客抽出)
            {
                D17PR履歴.D17プロモーション予定_対象顧客Row drプロモーション予定_対象顧客
                    = d17PR履歴.D17プロモーション予定_対象顧客.NewD17プロモーション予定_対象顧客Row();

                drプロモーション予定_対象顧客.顧客No = drRFM顧客抽出.顧客No;
                drプロモーション予定_対象顧客.顧客ID = drRFM顧客抽出.顧客ID;
                drプロモーション予定_対象顧客.氏名 = drRFM顧客抽出.氏名;
                drプロモーション予定_対象顧客.氏名カナ = drRFM顧客抽出.氏名カナ;
                drプロモーション予定_対象顧客.性別 = drRFM顧客抽出.性別;
                drプロモーション予定_対象顧客.生年月日 = drRFM顧客抽出.生年月日;
                drプロモーション予定_対象顧客.郵便番号 = drRFM顧客抽出.郵便番号;
                drプロモーション予定_対象顧客.住所 = drRFM顧客抽出.住所;
                drプロモーション予定_対象顧客.TEL = drRFM顧客抽出.TEL;
                drプロモーション予定_対象顧客.メールアドレス = drRFM顧客抽出.メールアドレス;

                d17PR履歴.D17プロモーション予定_対象顧客.AddD17プロモーション予定_対象顧客Row(
                    drプロモーション予定_対象顧客);
            }

            d17PR履歴.D17プロモーション予定_対象顧客.AcceptChanges();
        }

        private void CreateCSVファイル_プロモーション(string strFileName)
        {
            string 一時ファイル = string.Format(@"{0}{1}.csv", Path.GetTempPath(), DateTime.Now.ToString("yyyyMMddHHmmss"));

			//using (StreamWriter sw = new StreamWriter(一時ファイル, false, Encoding.GetEncoding("Shift_JIS")))
			//{
                string strグリッド以外;

                if (mbytMode == C_予定実績Mode.予定)
                {
                    //sw.Write("【【予定】】\r\n");
					File.AppendAllText(一時ファイル, "【【予定】】\r\n", Encoding.GetEncoding("Shift_JIS"));

                    //sw.Write("【基本情報】\r\n");
					File.AppendAllText(一時ファイル, "【基本情報】\r\n", Encoding.GetEncoding("Shift_JIS"));

                    strグリッド以外 = "\"" + lbl公開予定日.Text + ",\"" + lbl予定期間.Text + "\",\"" + lbl総費用.Text + "\",\"" + lbl内容.Text
                        + "\",\"" + lbl備考.Text + "\",\"" + lbl対象商品総数.Text + "\",\"" + lbl対象既存顧客総数.Text + "\",\"" + lbl総売上.Text
                        + "\",\"" + lbl新規顧客獲得数.Text + "\",\"" + lbl見込顧客獲得数.Text + "\",\"" + lbl掘起し顧客数.Text + "\"";
                    strグリッド以外 += "\r\n";
                    strグリッド以外 += "\"" + dtpプロモーション_予定_公開日.Text + ",\"" + dtpプロモーション_予定_予定期間fr.Text + "～"
                        + dtpプロモーション_予定_予定期間to.Text + "\",\"" + txtプロモーション_予定_総費用.Text + "\",\""
                        + txtプロモーション_予定_内容.Text + "\",\"" + txtプロモーション_予定_備考.Text + "\",\""
                        + txtプロモーション_予定_対象商品総数.Text + "\",\"" + txtプロモーション_予定_対象既存顧客総数.Text + "\",\""
                        + txtプロモーション_予定_総売上.Text + "\",\"" + txtプロモーション_予定_新規顧客獲得数.Text + "\",\""
                        + txtプロモーション_予定_見込顧客獲得数.Text + "\",\"" + txtプロモーション_予定_掘起し顧客数.Text + "\"";
                    //sw.Write(strグリッド以外);
					File.AppendAllText(一時ファイル, strグリッド以外, Encoding.GetEncoding("Shift_JIS"));
                    //sw.Write("\r\n");
					//File.AppendAllText(一時ファイル, "\r\n", Encoding.GetEncoding("Shift_JIS"));

                    //sw.Write("【プロモーション対象の広告一覧】\r\n");
					File.AppendAllText(一時ファイル, "\r\n【プロモーション対象の広告一覧】\r\n", Encoding.GetEncoding("Shift_JIS"));

					//C06CSV.Writeグリッドヘッダ(sw, dgvプロモーション_予定_対象広告, 3);
					//C06CSV.Writeグリッド明細(sw, dgvプロモーション_予定_対象広告, 3);
					C06CSV.Writeグリッドヘッダ(一時ファイル, dgvプロモーション_予定_対象広告, 3);
					C06CSV.Writeグリッド明細(一時ファイル, dgvプロモーション_予定_対象広告, 3);

                    //sw.Write("\r\n");
					//File.AppendAllText(一時ファイル, "\r\n", Encoding.GetEncoding("Shift_JIS"));

                    //sw.Write("【プロモーション対象の商品一覧】\r\n");
					File.AppendAllText(一時ファイル, "\r\n【プロモーション対象の商品一覧】\r\n", Encoding.GetEncoding("Shift_JIS"));

					//C06CSV.Writeグリッドヘッダ(sw, dgvプロモーション_予定_対象商品, 3);
					//C06CSV.Writeグリッド明細(sw, dgvプロモーション_予定_対象商品, 3);
					C06CSV.Writeグリッドヘッダ(一時ファイル, dgvプロモーション_予定_対象商品, 3);
					C06CSV.Writeグリッド明細(一時ファイル, dgvプロモーション_予定_対象商品, 3);

                    //sw.Write("\r\n");
					//File.AppendAllText(一時ファイル, "\r\n", Encoding.GetEncoding("Shift_JIS"));

                    //sw.Write("【プロモーション対象の顧客一覧】\r\n");
					File.AppendAllText(一時ファイル, "\r\n【プロモーション対象の顧客一覧】\r\n", Encoding.GetEncoding("Shift_JIS"));

					//C06CSV.Writeグリッドヘッダ(sw, dgvプロモーション_予定_対象顧客, 3);
					//C06CSV.Writeグリッド明細(sw, dgvプロモーション_予定_対象顧客, 3);
					C06CSV.Writeグリッドヘッダ(一時ファイル, dgvプロモーション_予定_対象顧客, 3);
					C06CSV.Writeグリッド明細(一時ファイル, dgvプロモーション_予定_対象顧客, 3);

                    //sw.Write("\r\n");
					File.AppendAllText(一時ファイル, "\r\n", Encoding.GetEncoding("Shift_JIS"));
                }
                else if (mbytMode == C_予定実績Mode.実績)
                {
                    //sw.Write("【【実績】】\r\n");
                    //sw.Write("【基本情報】\r\n");
					File.AppendAllText(一時ファイル, "【【実績】】\r\n", Encoding.GetEncoding("Shift_JIS"));
					File.AppendAllText(一時ファイル, "【基本情報】\r\n", Encoding.GetEncoding("Shift_JIS"));

                    strグリッド以外 = "\"" + lbl実績_公開実施日.Text + ",\"" + lbl実績_実施期間.Text + "\",\"" + lbl実績_総費用.Text + "\",\"" + lbl実績_内容.Text
                        + "\",\"" + lbl実績_備考.Text + "\",\"" + lbl実績_購入商品総数.Text + "\",\"" + lbl実績_購入顧客総数.Text + "\",\"" + lbl実績_総売上.Text
                        + "\",\"" + lbl実績_新規顧客獲得数.Text + "\",\"" + lbl実績_見込顧客獲得数.Text + "\",\"" + lbl実績_掘起し顧客数.Text + "\"";
                    strグリッド以外 += "\r\n";
                    strグリッド以外 += "\"" + dtpプロモーション_実績_公開日.Text + ",\"" + dtpプロモーション_実績_実施期間fr.Text + "～"
                        + dtpプロモーション_実績_実施期間to.Text + "\",\"" + txtプロモーション_実績_総費用.Text + "\",\""
                        + txtプロモーション_実績_内容.Text + "\",\"" + txtプロモーション_実績_備考.Text + "\",\""
                        + txtプロモーション_実績_購入商品総数.Text + "\",\"" + txtプロモーション_実績_購入顧客総数.Text + "\",\""
                        + txtプロモーション_実績_総売上.Text + "\",\"" + txtプロモーション_実績_新規顧客獲得数.Text + "\",\""
                        + txtプロモーション_実績_見込顧客獲得数.Text + "\",\"" + txtプロモーション_実績_掘起し顧客数.Text + "\"";

					//sw.Write(strグリッド以外);
                    //sw.Write("\r\n");
					File.AppendAllText(一時ファイル, strグリッド以外 + "\r\n", Encoding.GetEncoding("Shift_JIS"));
					//File.AppendAllText(一時ファイル, "\r\n", Encoding.GetEncoding("Shift_JIS"));

					//sw.Write(strグリッド以外);
					//sw.Write("\r\n");
					File.AppendAllText(一時ファイル, strグリッド以外 + "\r\n", Encoding.GetEncoding("Shift_JIS"));
					//File.AppendAllText(一時ファイル, "\r\n", Encoding.GetEncoding("Shift_JIS"));

                    //sw.Write("【購入商品一覧】\r\n");
					File.AppendAllText(一時ファイル, "【購入商品一覧】\r\n", Encoding.GetEncoding("Shift_JIS"));

					//C06CSV.Writeグリッドヘッダ(sw, dgvプロモーション_実績_購入商品一覧, 1);
					//C06CSV.Writeグリッド明細(sw, dgvプロモーション_実績_購入商品一覧, 1);
					C06CSV.Writeグリッドヘッダ(一時ファイル, dgvプロモーション_実績_購入商品一覧, 1);
					C06CSV.Writeグリッド明細(一時ファイル, dgvプロモーション_実績_購入商品一覧, 1);

                    //sw.Write("\r\n");
					//File.AppendAllText(一時ファイル, "\r\n", Encoding.GetEncoding("Shift_JIS"));

                    //sw.Write("【購入顧客一覧】\r\n");
					File.AppendAllText(一時ファイル, "\r\n【購入顧客一覧】\r\n", Encoding.GetEncoding("Shift_JIS"));

					//C06CSV.Writeグリッドヘッダ(sw, dgvプロモーション_実績_購入顧客一覧, 1);
					//C06CSV.Writeグリッド明細(sw, dgvプロモーション_実績_購入顧客一覧, 1);
					C06CSV.Writeグリッドヘッダ(一時ファイル, dgvプロモーション_実績_購入顧客一覧, 1);
					C06CSV.Writeグリッド明細(一時ファイル, dgvプロモーション_実績_購入顧客一覧, 1);

                    //sw.Write("\r\n");
					//File.AppendAllText(一時ファイル, "\r\n", Encoding.GetEncoding("Shift_JIS"));

                    //sw.Write("【新規顧客一覧】\r\n");
					File.AppendAllText(一時ファイル, "\r\n【新規顧客一覧】\r\n", Encoding.GetEncoding("Shift_JIS"));

					//C06CSV.Writeグリッドヘッダ(sw, dgvプロモーション_実績_新規顧客一覧, 1);
					//C06CSV.Writeグリッド明細(sw, dgvプロモーション_実績_新規顧客一覧, 1);
					C06CSV.Writeグリッドヘッダ(一時ファイル, dgvプロモーション_実績_新規顧客一覧, 1);
					C06CSV.Writeグリッド明細(一時ファイル, dgvプロモーション_実績_新規顧客一覧, 1);

                    //sw.Write("\r\n");
					//File.AppendAllText(一時ファイル, "\r\n", Encoding.GetEncoding("Shift_JIS"));

                    //sw.Write("【見込顧客一覧】\r\n");
					File.AppendAllText(一時ファイル, "\r\n【見込顧客一覧】\r\n", Encoding.GetEncoding("Shift_JIS"));

					//C06CSV.Writeグリッドヘッダ(sw, dgvプロモーション_実績_見込顧客一覧, 1);
					//C06CSV.Writeグリッド明細(sw, dgvプロモーション_実績_見込顧客一覧, 1);
					C06CSV.Writeグリッドヘッダ(一時ファイル, dgvプロモーション_実績_見込顧客一覧, 1);
					C06CSV.Writeグリッド明細(一時ファイル, dgvプロモーション_実績_見込顧客一覧, 1);

                    //sw.Write("\r\n");
					//File.AppendAllText(一時ファイル, "\r\n", Encoding.GetEncoding("Shift_JIS"));

                    //sw.Write("【掘起顧客一覧】\r\n");
					File.AppendAllText(一時ファイル, "\r\n【掘起顧客一覧】\r\n", Encoding.GetEncoding("Shift_JIS"));

					//C06CSV.Writeグリッドヘッダ(sw, dgvプロモーション_実績_掘起顧客一覧, 1);
					//C06CSV.Writeグリッド明細(sw, dgvプロモーション_実績_掘起顧客一覧, 1);
					C06CSV.Writeグリッドヘッダ(一時ファイル, dgvプロモーション_実績_掘起顧客一覧, 1);
					C06CSV.Writeグリッド明細(一時ファイル, dgvプロモーション_実績_掘起顧客一覧, 1);

                    //sw.Write("\r\n");
					File.AppendAllText(一時ファイル, "\r\n", Encoding.GetEncoding("Shift_JIS"));
                }
			//}

            File.Copy(一時ファイル, strFileName, true);

            if (File.Exists(一時ファイル))
                File.Delete(一時ファイル);
        }

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _211PR詳細_Load(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                Set属性マスタ();
                SetPR();

                if ((int)cmbPR区分.SelectedValue == C_プロモーション区分.プロモーション)
                {
                    if (mbytMode == C_予定実績Mode.予定)
                        Setプロモーション_予定();
                    else if (mbytMode == C_予定実績Mode.実績)
                        Setプロモーション_実績();
                }

                if (mbytMode == C_予定実績Mode.予定)
                {
                    tab予定.Visible = true;
                    tab実績.Visible = false;

                    this.Text = Properties.Resources.画面タイトル_01;
                }
                else if (mbytMode == C_予定実績Mode.実績)
                {
                    tab予定.Visible = false;
                    tab実績.Visible = true;

                    this.Text = Properties.Resources.画面タイトル_02;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "_211PR詳細_Load", ex);
            }
            finally
            {
                Set列幅_プロモーション_予定();
                Set列幅_プロモーション_実績();

                Cursor.Current = Cursors.Arrow;
            }
            dtpプロモーション_実績_公開日.Value = DateTime.Parse("2000/1/1");

        }

        private void _211PR詳細_Resize(object sender, EventArgs e)
        {
            try
            {
                C01FormCommon.画面最小サイズに変更(this, true);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "_211PR詳細_Resize", ex);
            }
        }

        private void dgvプロモーション_予定_広告一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgvプロモーション_予定_対象広告.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgvプロモーション_予定_対象広告.RowHeadersDefaultCellStyle.Font,
                                              dgvプロモーション_予定_対象広告.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "dgvプロモーション_予定_広告一覧_RowPostPaint", ex);
            }
        }

        private void dgvプロモーション_予定_商品一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgvプロモーション_予定_対象商品.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgvプロモーション_予定_対象商品.RowHeadersDefaultCellStyle.Font,
                                              dgvプロモーション_予定_対象商品.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "dgvプロモーション_予定_商品一覧_RowPostPaint", ex);
            }
        }

        private void dgvプロモーション_予定_顧客一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgvプロモーション_予定_対象顧客.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgvプロモーション_予定_対象顧客.RowHeadersDefaultCellStyle.Font,
                                              dgvプロモーション_予定_対象顧客.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "dgvプロモーション_予定_顧客一覧_RowPostPaint", ex);
            }
        }

        //private void dgvプロモーション_実績_広告一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        //{
        //    try
        //    {
        //        C01FormCommon.行数表示(e.RowBounds.Location.X,
        //                                      e.RowBounds.Location.Y,
        //                                      dgvプロモーション_実績_対象広告.RowHeadersWidth,
        //                                      e.RowBounds.Height,
        //                                      e.Graphics,
        //                                      e.RowIndex,
        //                                      dgvプロモーション_実績_対象広告.RowHeadersDefaultCellStyle.Font,
        //                                      dgvプロモーション_実績_対象広告.RowHeadersDefaultCellStyle.ForeColor);
        //    }
        //    catch (Exception ex)
        //    {
        //        C04システム共通.ErrorLog("_211PR詳細", "dgvプロモーション_実績_広告一覧_RowPostPaint", ex);
        //    }
        //}

        //private void dgvプロモーション_実績_商品一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        //{
        //    try
        //    {
        //        C01FormCommon.行数表示(e.RowBounds.Location.X,
        //                                      e.RowBounds.Location.Y,
        //                                      dgvプロモーション_実績_購入商品一覧.RowHeadersWidth,
        //                                      e.RowBounds.Height,
        //                                      e.Graphics,
        //                                      e.RowIndex,
        //                                      dgvプロモーション_実績_購入商品一覧.RowHeadersDefaultCellStyle.Font,
        //                                      dgvプロモーション_実績_購入商品一覧.RowHeadersDefaultCellStyle.ForeColor);
        //    }
        //    catch (Exception ex)
        //    {
        //        C04システム共通.ErrorLog("_211PR詳細", "dgvプロモーション_実績_商品一覧_RowPostPaint", ex);
        //    }
        //}

        //private void dgvプロモーション_実績_顧客一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        //{
        //    try
        //    {
        //        C01FormCommon.行数表示(e.RowBounds.Location.X,
        //                                      e.RowBounds.Location.Y,
        //                                      dgvプロモーション_実績_購入顧客一覧.RowHeadersWidth,
        //                                      e.RowBounds.Height,
        //                                      e.Graphics,
        //                                      e.RowIndex,
        //                                      dgvプロモーション_実績_購入顧客一覧.RowHeadersDefaultCellStyle.Font,
        //                                      dgvプロモーション_実績_購入顧客一覧.RowHeadersDefaultCellStyle.ForeColor);
        //    }
        //    catch (Exception ex)
        //    {
        //        C04システム共通.ErrorLog("_211PR詳細", "dgvプロモーション_実績_顧客一覧_RowPostPaint", ex);
        //    }
        //}

        private void dgvプロモーション_実績_購入商品一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgvプロモーション_実績_購入商品一覧.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgvプロモーション_実績_購入商品一覧.RowHeadersDefaultCellStyle.Font,
                                              dgvプロモーション_実績_購入商品一覧.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "dgvプロモーション_実績_購入商品一覧_RowPostPaint", ex);
            }
        }

        private void dgvプロモーション_実績_購入顧客一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgvプロモーション_実績_購入顧客一覧.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgvプロモーション_実績_購入顧客一覧.RowHeadersDefaultCellStyle.Font,
                                              dgvプロモーション_実績_購入顧客一覧.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "dgvプロモーション_実績_購入顧客一覧_RowPostPaint", ex);
            }
        }

        private void dgvプロモーション_実績_新規顧客一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgvプロモーション_実績_新規顧客一覧.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgvプロモーション_実績_新規顧客一覧.RowHeadersDefaultCellStyle.Font,
                                              dgvプロモーション_実績_新規顧客一覧.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "dgvプロモーション_実績_新規顧客一覧_RowPostPaint", ex);
            }
        }

        private void dgvプロモーション_実績_見込顧客一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgvプロモーション_実績_見込顧客一覧.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgvプロモーション_実績_見込顧客一覧.RowHeadersDefaultCellStyle.Font,
                                              dgvプロモーション_実績_見込顧客一覧.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "dgvプロモーション_実績_見込顧客一覧_RowPostPaint", ex);
            }
        }

        private void dgvプロモーション_実績_掘起顧客一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgvプロモーション_実績_掘起顧客一覧.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgvプロモーション_実績_掘起顧客一覧.RowHeadersDefaultCellStyle.Font,
                                              dgvプロモーション_実績_掘起顧客一覧.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "dgvプロモーション_実績_掘起顧客一覧_RowPostPaint", ex);
            }
        }

        private void btnプロモーション_予定_広告検索_Click(object sender, EventArgs e)
        {
            try
            {
                _601広告検索 _115広告検索 = null;
                _115広告検索 = new _601広告検索();
                C01FormCommon.画面最小サイズに変更(_115広告検索, false);

                _115広告検索.mstr選択済み広告No = C01FormCommon.Get選択画面の選択アイテムNo(
                    dgvプロモーション_予定_対象広告, プロモーション_予定_対象広告.byt広告No);

                if (_115広告検索.ShowDialog() == DialogResult.Cancel)
                    return;

                d17PR履歴.D17プロモーション予定_対象広告.Clear();

                foreach (D16広告.D16広告検索Row dr広告検索結果 in _115広告検索.dt広告検索結果)
                {
                    D17PR履歴.D17プロモーション予定_対象広告Row drプロモーション予定_対象広告
                        = d17PR履歴.D17プロモーション予定_対象広告.NewD17プロモーション予定_対象広告Row();

                    drプロモーション予定_対象広告.広告No = dr広告検索結果.広告No;
                    drプロモーション予定_対象広告.広告名 = dr広告検索結果.広告名;
                    drプロモーション予定_対象広告.担当者名 = dr広告検索結果.担当者名;
                    drプロモーション予定_対象広告.TEL = dr広告検索結果.TEL;
                    drプロモーション予定_対象広告.FAX = dr広告検索結果.FAX;
                    drプロモーション予定_対象広告.メールアドレス = dr広告検索結果.メールアドレス;
                    drプロモーション予定_対象広告.URL = dr広告検索結果.URL;

                    d17PR履歴.D17プロモーション予定_対象広告.AddD17プロモーション予定_対象広告Row(
                        drプロモーション予定_対象広告);
                }

                d17PR履歴.D17プロモーション予定_対象広告.AcceptChanges();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "btnプロモーション_予定_広告検索_Click", ex);
            }
        }

        private void btnプロモーション_予定_商品検索_Click(object sender, EventArgs e)
        {
            try
            {
                _603商品検索 _603商品検索 = null;
                _603商品検索 = new _603商品検索();
                C01FormCommon.画面最小サイズに変更(_603商品検索, false);

                _603商品検索.mstr選択済み商品No = C01FormCommon.Get選択画面の選択アイテムNo(
                    dgvプロモーション_予定_対象商品, プロモーション_予定_対象商品.byt商品No);

                if (_603商品検索.ShowDialog() == DialogResult.Cancel)
                    return;

                d17PR履歴.D17プロモーション予定_対象商品.Clear();

                foreach (D06商品一覧.D06商品Row dr商品検索結果 in _603商品検索.dt商品検索結果)
                {
                    D17PR履歴.D17プロモーション予定_対象商品Row drプロモーション予定_対象商品
                        = d17PR履歴.D17プロモーション予定_対象商品.NewD17プロモーション予定_対象商品Row();

                    drプロモーション予定_対象商品.商品No = dr商品検索結果.商品No;
                    drプロモーション予定_対象商品.商品ID = dr商品検索結果.商品ID;
                    drプロモーション予定_対象商品.商品名 = dr商品検索結果.商品名;
                    drプロモーション予定_対象商品.商品単価 = dr商品検索結果.商品単価;

                    d17PR履歴.D17プロモーション予定_対象商品.AddD17プロモーション予定_対象商品Row(
                        drプロモーション予定_対象商品);
                }

                d17PR履歴.D17プロモーション予定_対象商品.AcceptChanges();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "btnプロモーション_予定_商品検索_Click", ex);
            }
        }

        private void btnプロモーション_予定_顧客検索_Click(object sender, EventArgs e)
        {
            try
            {
                _602顧客検索 _602顧客検索 = null;
                _602顧客検索 = new _602顧客検索();
                C01FormCommon.画面最小サイズに変更(_602顧客検索, false);

                _602顧客検索.mstr選択済み顧客No = C01FormCommon.Get選択画面の選択アイテムNo(
                    dgvプロモーション_予定_対象顧客, プロモーション_予定_対象顧客.byt顧客No);

                if (_602顧客検索.ShowDialog() == DialogResult.Cancel)
                    return;

                d17PR履歴.D17プロモーション予定_対象顧客.Clear();

                foreach (D10顧客.D10顧客検索Row dr顧客検索結果 in _602顧客検索.dt顧客検索結果)
                {
                    D17PR履歴.D17プロモーション予定_対象顧客Row drプロモーション予定_対象顧客
                        = d17PR履歴.D17プロモーション予定_対象顧客.NewD17プロモーション予定_対象顧客Row();

                    drプロモーション予定_対象顧客.顧客No = dr顧客検索結果.顧客No;
                    drプロモーション予定_対象顧客.顧客ID = dr顧客検索結果.顧客ID;
                    drプロモーション予定_対象顧客.氏名 = dr顧客検索結果.氏名;
                    drプロモーション予定_対象顧客.氏名カナ = dr顧客検索結果.氏名カナ;
                    drプロモーション予定_対象顧客.性別 = dr顧客検索結果.性別;
                    drプロモーション予定_対象顧客.生年月日 = dr顧客検索結果.生年月日;
                    drプロモーション予定_対象顧客.郵便番号 = dr顧客検索結果.郵便番号;
                    drプロモーション予定_対象顧客.住所 = dr顧客検索結果.住所;
                    drプロモーション予定_対象顧客.TEL = dr顧客検索結果.TEL;
                    drプロモーション予定_対象顧客.メールアドレス = dr顧客検索結果.メールアドレス;

                    d17PR履歴.D17プロモーション予定_対象顧客.AddD17プロモーション予定_対象顧客Row(
                        drプロモーション予定_対象顧客);
                }

                d17PR履歴.D17プロモーション予定_対象顧客.AcceptChanges();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "btnプロモーション_予定_顧客検索_Click", ex);
            }
        }

        private void btnプロモーション_予定_FM分析から顧客を抽出_Click(object sender, EventArgs e)
        {
            try
            {
                _407FM分析 _407FM分析 = null;
                _407FM分析 = new _407FM分析();
                _407FM分析.mb呼出し元画面名 = this.Text;
                C01FormCommon.画面最小サイズに変更(_407FM分析, true);

                if (_407FM分析.ShowDialog() == DialogResult.Cancel)
                    return;

                d17PR履歴.D17プロモーション予定_対象顧客.Clear();

                D10顧客.D10RFM顧客抽出DataTable dtRFM顧客抽出 = new D10顧客.D10RFM顧客抽出DataTable();
				//C02業務共通処理.顧客抽出FM(_407FM分析.mbF, _407FM分析.mbM, _407FM分析.ms年, _407FM分析.mb月
				//    , dtRFM顧客抽出, "");
				//C02業務共通処理.顧客抽出FM(_407FM分析.mbF, _407FM分析.mbM, _407FM分析.ms年, _407FM分析.mb月
				//    , dtRFM顧客抽出, "");
				string str抽出条件 = "";
				C02業務共通処理.顧客抽出FM(_407FM分析.mbF, _407FM分析.mbM, _407FM分析.ms年, _407FM分析.mb月
					, dtRFM顧客抽出, ref str抽出条件);

                //foreach (D10顧客.D10RFM顧客抽出Row drRFM顧客抽出 in dtRFM顧客抽出)
                //{
                //    D17PR履歴.D17プロモーション予定_対象顧客Row drプロモーション予定_対象顧客
                //        = d17PR履歴.D17プロモーション予定_対象顧客.NewD17プロモーション予定_対象顧客Row();
                //    drプロモーション予定_対象顧客.顧客No = drRFM顧客抽出.顧客No;
                //    drプロモーション予定_対象顧客.顧客ID = drRFM顧客抽出.顧客ID;
                //    drプロモーション予定_対象顧客.氏名 = drRFM顧客抽出.氏名;
                //    drプロモーション予定_対象顧客.氏名カナ = drRFM顧客抽出.氏名カナ;
                //    drプロモーション予定_対象顧客.性別 = drRFM顧客抽出.性別;
                //    drプロモーション予定_対象顧客.生年月日 = drRFM顧客抽出.生年月日;
                //    drプロモーション予定_対象顧客.郵便番号 = drRFM顧客抽出.郵便番号;
                //    drプロモーション予定_対象顧客.住所 = drRFM顧客抽出.住所;
                //    drプロモーション予定_対象顧客.TEL = drRFM顧客抽出.TEL;
                //    drプロモーション予定_対象顧客.メールアドレス = drRFM顧客抽出.メールアドレス;
                //    d17PR履歴.D17プロモーション予定_対象顧客.AddD17プロモーション予定_対象顧客Row(
                //        drプロモーション予定_対象顧客);
                //}
                //d17PR履歴.D17プロモーション予定_対象顧客.AcceptChanges();
                Setプロモーション予定_対象顧客(dtRFM顧客抽出);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "btnプロモーション_予定_FM分析から顧客を抽出_Click", ex);
            }
        }

        private void btnプロモーション_予定_RFM分析から顧客を抽出_Click(object sender, EventArgs e)
        {
            try
            {
                _401RFM分析 _401RFM分析 = null;
                _401RFM分析 = new _401RFM分析();
                _401RFM分析.mb呼出し元画面名 = this.Text;
                C01FormCommon.画面最小サイズに変更(_401RFM分析, true);

                if (_401RFM分析.ShowDialog() == DialogResult.Cancel)
                    return;

                d17PR履歴.D17プロモーション予定_対象顧客.Clear();

                D10顧客.D10RFM顧客抽出DataTable dtRFM顧客抽出 = new D10顧客.D10RFM顧客抽出DataTable();
                //C02業務共通処理.顧客抽出RFM(_401RFM分析.mbR, _401RFM分析.mbF, _401RFM分析.mbM, dtRFM顧客抽出, "");
				string str抽出条件 = "";
				C02業務共通処理.顧客抽出RFM(_401RFM分析.mbR, _401RFM分析.mbF, _401RFM分析.mbM, dtRFM顧客抽出, ref str抽出条件);

                //foreach (D10顧客.D10RFM顧客抽出Row drRFM顧客抽出 in dtRFM顧客抽出)
                //{
                //    D17PR履歴.D17プロモーション予定_対象顧客Row drプロモーション予定_対象顧客
                //        = d17PR履歴.D17プロモーション予定_対象顧客.NewD17プロモーション予定_対象顧客Row();
                //    drプロモーション予定_対象顧客.顧客No = drRFM顧客抽出.顧客No;
                //    drプロモーション予定_対象顧客.顧客ID = drRFM顧客抽出.顧客ID;
                //    drプロモーション予定_対象顧客.氏名 = drRFM顧客抽出.氏名;
                //    drプロモーション予定_対象顧客.氏名カナ = drRFM顧客抽出.氏名カナ;
                //    drプロモーション予定_対象顧客.性別 = drRFM顧客抽出.性別;
                //    drプロモーション予定_対象顧客.生年月日 = drRFM顧客抽出.生年月日;
                //    drプロモーション予定_対象顧客.郵便番号 = drRFM顧客抽出.郵便番号;
                //    drプロモーション予定_対象顧客.住所 = drRFM顧客抽出.住所;
                //    drプロモーション予定_対象顧客.TEL = drRFM顧客抽出.TEL;
                //    drプロモーション予定_対象顧客.メールアドレス = drRFM顧客抽出.メールアドレス;
                //    d17PR履歴.D17プロモーション予定_対象顧客.AddD17プロモーション予定_対象顧客Row(
                //        drプロモーション予定_対象顧客);
                //}
                //d17PR履歴.D17プロモーション予定_対象顧客.AcceptChanges();
                Setプロモーション予定_対象顧客(dtRFM顧客抽出);

            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "btnプロモーション_予定_RFM分析から顧客を抽出_Click", ex);
            }
        }

        private void btnプロモーション_予定_広告_選択行を削除_Click(object sender, EventArgs e)
        {
            try
            {
                C01FormCommon.DGV選択行削除(dgvプロモーション_予定_対象広告, this.Text);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "btnプロモーション_予定_広告_選択行を削除_Click", ex);
            }
        }

        private void btnプロモーション_予定_商品_選択行を削除_Click(object sender, EventArgs e)
        {
            try
            {
                C01FormCommon.DGV選択行削除(dgvプロモーション_予定_対象商品, this.Text);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "btnプロモーション_予定_商品_選択行を削除_Click", ex);
            }
        }

        private void btnプロモーション_予定_顧客_選択行を削除_Click(object sender, EventArgs e)
        {
            try
            {
                C01FormCommon.DGV選択行削除(dgvプロモーション_予定_対象顧客, this.Text);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "btnプロモーション_予定_顧客_選択行を削除_Click", ex);
            }
        }

        private void btnプロモーション_予定の基本情報をコピー_Click(object sender, EventArgs e)
        {
            try
            {
                dtpプロモーション_実績_公開日.Text = dtpプロモーション_予定_公開日.Text;
                dtpプロモーション_実績_実施期間fr.Value = dtpプロモーション_予定_予定期間fr.Value;
                dtpプロモーション_実績_実施期間to.Value = dtpプロモーション_予定_予定期間to.Value;
                txtプロモーション_実績_総費用.Text = txtプロモーション_予定_総費用.Text;
                txtプロモーション_実績_内容.Text = txtプロモーション_予定_内容.Text;
                txtプロモーション_実績_備考.Text = txtプロモーション_予定_備考.Text;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "btnプロモーション_予定の基本情報をコピー_Click", ex);
            }
        }

        //private void btnプロモーション_予定の広告一覧をコピー_Click(object sender, EventArgs e)
        //{
        //    try
        //    {
        //        d17PR履歴.D17プロモーション実績_対象広告.Clear();

        //        foreach (D17PR履歴.D17プロモーション予定_対象広告Row dr予定対象広告 in d17PR履歴.D17プロモーション予定_対象広告)
        //        {
        //            D17PR履歴.D17プロモーション実績_対象広告Row drプロモーション実績_対象広告
        //                = d17PR履歴.D17プロモーション実績_対象広告.NewD17プロモーション実績_対象広告Row();

        //            drプロモーション実績_対象広告.広告No = dr予定対象広告.広告No;
        //            drプロモーション実績_対象広告.広告名 = dr予定対象広告.広告名;
        //            drプロモーション実績_対象広告.担当者名 = dr予定対象広告.担当者名;
        //            drプロモーション実績_対象広告.TEL = dr予定対象広告.TEL;
        //            drプロモーション実績_対象広告.FAX = dr予定対象広告.FAX;
        //            drプロモーション実績_対象広告.メールアドレス = dr予定対象広告.メールアドレス;
        //            drプロモーション実績_対象広告.URL = dr予定対象広告.URL;

        //            d17PR履歴.D17プロモーション実績_対象広告.AddD17プロモーション実績_対象広告Row(
        //                drプロモーション実績_対象広告);
        //        }

        //        d17PR履歴.D17プロモーション実績_対象広告.AcceptChanges();
        //    }
        //    catch (Exception ex)
        //    {
        //        C04システム共通.ErrorLog("_211PR詳細", "btnプロモーション_予定の広告一覧をコピー_Click", ex);
        //    }
        //}

        //private void btnプロモーション_実績_広告検索_Click(object sender, EventArgs e)
        //{
        //    try
        //    {
        //        _601広告検索 _115広告検索 = null;
        //        _115広告検索 = new _601広告検索();
        //        C01FormCommon.画面最小サイズに変更(_115広告検索, false);

        //        _115広告検索.mstr選択済み広告No = C01FormCommon.Get選択画面の選択アイテムNo(
        //            dgvプロモーション_実績_対象広告, (int)enmプロモーション_実績_対象広告.広告No);

        //        if (_115広告検索.ShowDialog() == DialogResult.Cancel)
        //            return;

        //        d17PR履歴.D17プロモーション実績_対象広告.Clear();

        //        foreach (D16広告.D16広告検索Row dr広告検索結果 in _115広告検索.dt広告検索結果)
        //        {
        //            D17PR履歴.D17プロモーション実績_対象広告Row drプロモーション実績_対象広告
        //                = d17PR履歴.D17プロモーション実績_対象広告.NewD17プロモーション実績_対象広告Row();

        //            drプロモーション実績_対象広告.広告No = dr広告検索結果.広告No;
        //            drプロモーション実績_対象広告.広告名 = dr広告検索結果.広告名;
        //            drプロモーション実績_対象広告.担当者名 = dr広告検索結果.担当者名;
        //            drプロモーション実績_対象広告.TEL = dr広告検索結果.TEL;
        //            drプロモーション実績_対象広告.FAX = dr広告検索結果.FAX;
        //            drプロモーション実績_対象広告.メールアドレス = dr広告検索結果.メールアドレス;
        //            drプロモーション実績_対象広告.URL = dr広告検索結果.URL;

        //            d17PR履歴.D17プロモーション実績_対象広告.AddD17プロモーション実績_対象広告Row(
        //                drプロモーション実績_対象広告);
        //        }

        //        d17PR履歴.D17プロモーション実績_対象広告.AcceptChanges();
        //    }
        //    catch (Exception ex)
        //    {
        //        C04システム共通.ErrorLog("_211PR詳細", "btnプロモーション_実績_広告検索_Click", ex);
        //    }
        //}

        //private void btnプロモーション_実績_広告_選択行を削除_Click(object sender, EventArgs e)
        //{
        //    try
        //    {
        //        C01FormCommon.DGV選択行削除(dgvプロモーション_実績_対象広告, this.Text);
        //    }
        //    catch (Exception ex)
        //    {
        //        C04システム共通.ErrorLog("_211PR詳細", "btnプロモーション_実績_広告_選択行を削除_Click", ex);
        //    }
        //}

        private void btnCSVファイル出力_Click(object sender, EventArgs e)
        {
            try
            {
                //ファイル参照ダイアログを表示する
                SaveFileDialog sfd = new SaveFileDialog();
                sfd.Filter = "CSV " + Properties.Resources.MSG_I_ファイル + "(*.csv)|*.csv";

                if (sfd.ShowDialog() != DialogResult.OK)
                    return;

				Cursor.Current = Cursors.WaitCursor;

				//グリッドの内容をCSV形式で出力する

                CreateCSVファイル_プロモーション(sfd.FileName);

                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_007);

                MessageBox.Show(Properties.Resources.MSG_I_ファイル出力が完了しました, this.Text, MessageBoxButtons.OK,
                    MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "btnCSVファイル出力_Click", ex);
            }
			finally
			{
				Cursor.Current = Cursors.Arrow;
			}
		}

        private void btn確定_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                if (false == IsValidate())
                    return;

                if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_入力した内容を登録しますか
                    , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
                    return;

				C06DB共通.d17PR履歴ta.UpdatePR履歴((int)cmbPR区分.SelectedValue, txtPR名.Text
                    , C02業務共通処理.miログインスタッフNo, mintPR履歴No);


                if ((int)cmbPR区分.SelectedValue == C_プロモーション区分.プロモーション)
                {
                    if (mbytMode == C_予定実績Mode.予定)
                    {
                        Updateプロモーション予定_基本情報();
                        Updateプロモーション予定_対象広告();
                        Updateプロモーション予定_対象商品();
                        Updateプロモーション予定_対象顧客();
                    }
                    else if (mbytMode == C_予定実績Mode.実績)
                    {
                        Updateプロモーション実績_基本情報();
                    }
                }

                MessageBox.Show(Properties.Resources.MSG_I_登録が完了しました, this.Text, MessageBoxButtons.OK,
                    MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "btn確定_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_211PR詳細", "btnキャンセル_Click", ex);
            }
        }

        #endregion

    }
}
