﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using SystemCommon;
using ClientCommon;


namespace 顧客分析君
{
    public partial class _210PR履歴 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // 内部クラス
        ////////////////////////////////////////////////////////////////////////
        #region CSV取込処理内部クラス

        private class 取込処理内部クラス : C03CSV取込処理基底
        {
			//private enum enmCSV取込列
			//{
			//    PR区分 = 0,
			//    PR名 = 1,
			//    公開予定日 = 2,
			//    公開実施日 = 3
			//}
			private static class CSV取込列
			{
                public const byte bytPR区分 = 0;
                public const byte bytPR名 = 1;
                public const byte byt公開予定日 = 2;
                public const byte byt公開実施日 = 3;
			}

            protected override int 基底CSV取込クラスからの列数取得()
            {
                return CSV取込列.byt公開実施日 + 1;
            }

            protected override bool 基底CSV取込クラスからの検証(int rowIndex, int colIndex, string value)
            {
                switch (colIndex)
                {
                    case CSV取込列.bytPR区分:
                        if (!IsValidate共通(value, true, C_最大文字数.PR区分名, C_正規表現.なし, "PR区分"))
                            return false;

                        break;

                    case CSV取込列.bytPR名:
                        if (!IsValidate共通(value, true, C_最大文字数.PR名, C_正規表現.なし, "PR名"))
                            return false;

                        break;

                    case CSV取込列.byt公開予定日:
                        if (!IsValidate共通(value, true, C_最大文字数.年月日, C_正規表現.半角英数, "公開予定日"))
                            return false;

                        // 日付型チェック
                        DateTime dt公開予定日;
                        if (DateTime.TryParse(value, out dt公開予定日) == false)
                        {
                            mErrorDetail = string.Format(Properties.Resources.MSG_W_Aが日付として正しくありません, "公開予定日");
                            return false;
                        }

                        // 日付範囲チェック
                        if (dt公開予定日.Year < C_最小値.年 || C_最大値.年 < dt公開予定日.Year)
                        {
                            mErrorDetail = string.Format(Properties.Resources.MSG_W_Aには_B_C年以外の値を_入力できません, "公開予定日"
                                , C_最小値.年, C_最大値.年);
                            return false;
                        }

                        break;

                    case CSV取込列.byt公開実施日:
                        if (!IsValidate共通(value, true, C_最大文字数.年月日, C_正規表現.半角英数, "公開実施日"))
                            return false;

                        // 日付型チェック
                        DateTime dt公開実施日;
                        if (DateTime.TryParse(value, out dt公開実施日) == false)
                        {
                            mErrorDetail = string.Format(Properties.Resources.MSG_W_Aが日付として正しくありません, "公開実施日");
                            return false;
                        }

                        // 日付範囲チェック
                        if (dt公開実施日.Year < C_最小値.年 || C_最大値.年 < dt公開実施日.Year)
                        {
                            mErrorDetail = string.Format(Properties.Resources.MSG_W_Aには_B_C年以外の値を_入力できません, "公開実施日"
                                , C_最小値.年, C_最大値.年);
                            return false;
                        }

                        break;

                }
                return true;
            }

            protected override void 基底CSV取込クラスからのデータ変換(int rowIndex, List<string> values, DataTable dt)
            {
                D17PR履歴.D17PR履歴DataTable dtPR履歴 = (D17PR履歴.D17PR履歴DataTable)dt;
                D17PR履歴.D17PR履歴Row row = dtPR履歴.NewD17PR履歴Row();
                
                row.新規 = true;
                row.PR区分No = C02業務共通処理.GetPR区分No(values[CSV取込列.bytPR区分]);
                row.PR名 = values[CSV取込列.bytPR名];
                row.公開予定日 = DateTime.Parse(values[CSV取込列.byt公開予定日]);
                row.公開実施日 = DateTime.Parse(values[CSV取込列.byt公開実施日]);

                dtPR履歴.AddD17PR履歴Row(row);
            }
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        private class 検索条件
        {
            public Nullable<int> PR区分 { get; set; }
            public string PR名 { get; set; }
            public DateTime 公開予定日fr { get; set; }
            public DateTime 公開予定日to { get; set; }
            public Nullable<DateTime> 公開実施日fr { get; set; }
            public Nullable<DateTime> 公開実施日to { get; set; }

			private 顧客分析君.D17PR履歴TableAdapters.D17PR履歴ta d17PR履歴ta;
			private 顧客分析君.D01業務共通TableAdapters.D01PR区分ta d01PR区分ta;
		}

		//private enum enmPR履歴Cell : int
		//{
		//    新規 = 0,
		//    変更 = 1,
		//    削除 = 2,
		//    PR履歴No = 3,
		//    PR区分No = 4,
		//    PR名 = 5,
		//    プロモーション予定No = 6,
		//    公開予定日 = 7,
		//    プロモーション実績No = 8,
		//    公開実施日 = 9,
		//}
		private static class PR履歴Cell
		{
            public const byte byt新規 = 0;
            public const byte byt変更 = 1;
            public const byte byt削除 = 2;
            public const byte bytPR履歴No = 3;
            public const byte bytPR区分No = 4;
            public const byte bytPR名 = 5;
            public const byte bytプロモーション予定No = 6;
            public const byte byt公開予定日 = 7;
            public const byte bytプロモーション実績No = 8;
			public const byte byt公開実施日 = 9;
        }

		//private 顧客分析君.D17PR履歴TableAdapters.D17PR履歴ta d17PR履歴ta;
		//private 顧客分析君.D01業務共通TableAdapters.D01PR区分ta d01PR区分ta;
		
		#endregion

        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド 
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _210PR履歴()
        {
            InitializeComponent();

			//this.d01PR区分ta = new 顧客分析君.D01業務共通TableAdapters.D01PR区分ta();
			//this.d17PR履歴ta = new 顧客分析君.D17PR履歴TableAdapters.D17PR履歴ta();

			//this.d01PR区分ta.ClearBeforeFill = true;
			//this.d17PR履歴ta.ClearBeforeFill = true;
		}


        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
		////////////////////////////////////////////////////////////////////////
		#region 非公開 共通メソッド Static

		//最終行でかつ全項目未入力となっているかを返す
		//private bool IsRowEmpty(int iRow)
		//{
		//    // 0行じゃなければデータ入力されたとみなす。
		//    if ((dgvPR履歴.RowCount - 1) != iRow)
		//        return false;

		//    // 0行じゃなくても、必須チェック。
		//    if ((dgvPR履歴.Rows[iRow].Cells[PR履歴Cell.bytPR区分No].FormattedValue.ToString() == string.Empty) &&
		//        (dgvPR履歴.Rows[iRow].Cells[PR履歴Cell.bytPR名].FormattedValue.ToString() == string.Empty) &&
		//        (dgvPR履歴.Rows[iRow].Cells[PR履歴Cell.bytプロモーション予定No].FormattedValue.ToString() == string.Empty) &&
		//        (dgvPR履歴.Rows[iRow].Cells[PR履歴Cell.byt公開予定日].FormattedValue.ToString() == string.Empty) &&
		//        (dgvPR履歴.Rows[iRow].Cells[PR履歴Cell.bytプロモーション実績No].FormattedValue.ToString() == string.Empty) &&
		//        (dgvPR履歴.Rows[iRow].Cells[PR履歴Cell.byt公開実施日].FormattedValue.ToString() == string.Empty))
		//    {
		//        return true;
		//    }

		//    return false;
		//}
		private static bool 最終行or全項目未入力(DataGridView dgv, int rowIndex)
		{
			if ((dgv.RowCount - 1) != rowIndex)
				return false;

			if ((dgv.Rows[rowIndex].Cells[PR履歴Cell.bytPR履歴No].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[PR履歴Cell.bytPR区分No].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[PR履歴Cell.bytPR名].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[PR履歴Cell.bytプロモーション予定No].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[PR履歴Cell.byt公開予定日].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[PR履歴Cell.bytプロモーション実績No].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[PR履歴Cell.byt公開実施日].FormattedValue.ToString() == string.Empty))
			{
				return true;
			}

			return false;
		}

		private static bool IsValidate未入力行(DataGridViewRow row)
		{
			if ((row.Cells[PR履歴Cell.bytPR履歴No].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[PR履歴Cell.bytPR区分No].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[PR履歴Cell.bytPR名].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[PR履歴Cell.bytプロモーション予定No].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[PR履歴Cell.byt公開予定日].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[PR履歴Cell.bytプロモーション実績No].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[PR履歴Cell.byt公開実施日].FormattedValue.ToString() == string.Empty))
				return true;
			else
				return false;
		}

		private static bool IsValidate新規変更削除チェック状態(DataGridView dgv, string strFormTitle)
		{
			string strErrMsg = "";
			for (int iRow = 0; iRow < dgv.RowCount; iRow++)
			{
				if (最終行or全項目未入力(dgv, iRow) == true)
					continue;

				strErrMsg = "";
				if (!C11ValidateOnForm.IsValidate新規変更削除チェック状態(dgv, iRow,
					PR履歴Cell.byt新規, PR履歴Cell.byt変更, PR履歴Cell.byt削除,
					PR履歴Cell.bytPR履歴No, ref strErrMsg))
				{
					MessageBox.Show(strErrMsg, strFormTitle, MessageBoxButtons.OK, MessageBoxIcon.Warning);
					return false;
				}
			}

			return true;
		}

		private static bool IsValidateDGVPR履歴(DataGridView dgv, int iRow)
		{
			if (iRow < 0)
				return true;

			bool ret = true;

			if (最終行or全項目未入力(dgv, iRow))
				return ret;

			string value;
			for (int iCol = 0; iCol < dgv.ColumnCount; iCol++)
			{
				value = dgv.Rows[iRow].Cells[iCol].FormattedValue.ToString();

				switch (iCol)
				{
					case PR履歴Cell.bytPR区分No:
						if (!C11ValidateOnForm.IsValidateCell必須入力(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						break;

					case PR履歴Cell.bytPR名:
						if (!C11ValidateOnForm.IsValidateCell必須入力(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						break;

					case PR履歴Cell.byt公開予定日:
						if (!C11ValidateOnForm.IsValidateCell必須入力(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						if (!C11ValidateOnForm.IsValidateCell日時型(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						break;
				}
			}

			return ret;
		}



		#endregion


		#region 非公開 共通メソッド Non Static

		private void Set列幅()
        {

            dgvPR履歴.Columns[PR履歴Cell.byt新規].Visible = false;
            dgvPR履歴.Columns[PR履歴Cell.byt変更].Visible = false;
            dgvPR履歴.Columns[PR履歴Cell.byt削除].Width = C_列幅.削除;
            dgvPR履歴.Columns[PR履歴Cell.bytPR履歴No].Visible = false;
            dgvPR履歴.Columns[PR履歴Cell.bytPR区分No].Width = C_列幅.PR区分名;
            dgvPR履歴.Columns[PR履歴Cell.bytPR名].Width = C_列幅.PR名;
            dgvPR履歴.Columns[PR履歴Cell.bytプロモーション予定No].Visible = false;
            dgvPR履歴.Columns[PR履歴Cell.byt公開予定日].Width = C_列幅.年月日;
            dgvPR履歴.Columns[PR履歴Cell.bytプロモーション実績No].Visible = false;
            dgvPR履歴.Columns[PR履歴Cell.byt公開実施日].Width = C_列幅.年月日;
        }

        //検索で使用するSQLパラメータの取得
        private 検索条件 Get検索条件()
        {
            検索条件 row = new 検索条件();

            if (cmbPR区分.Text == "")
                row.PR区分 = null;
            else
                row.PR区分 = (int)cmbPR区分.SelectedValue;

            if (txtPR名.Text == "")
                row.PR名 = null;
            else
                row.PR名 = txtPR名.Text;

            if (dtp公開予定日fr.Checked == true)
                row.公開予定日fr = dtp公開予定日fr.Value.Date;
            else
                row.公開予定日fr = dtp公開予定日fr.MinDate;

            if (dtp公開予定日to.Checked == true)
                row.公開予定日to = dtp公開予定日to.Value.Date.AddDays(1).AddSeconds(-1);
            else
                row.公開予定日to = dtp公開予定日to.MaxDate;

            if (dtp公開実施日fr.Checked == true)
                row.公開実施日fr = dtp公開実施日fr.Value.Date;
            else
                row.公開実施日fr = null;

            if (dtp公開実施日to.Checked == true)
                row.公開実施日to = dtp公開実施日to.Value.Date.AddDays(1).AddSeconds(-1);
            else
                row.公開実施日to = null;

            return row;
        }

		private bool IsValidate検索()
		{
			//if (txt商品ID.Text != "")
			//{
			//    if (C02業務共通処理.IsValidate半角英数(txt商品ID.Text, "商品ID") == false)
			//        return false;
			//}

			//if (txt商品単価.Text != "")
			//{
			//    if (C11ValidateOnForm.IsValidate符号無し数値型(txt商品単価.Text, "商品単価") == false)
			//        return false;
			//}

			return true;
		}

		private bool IsValidate()
        {
            //必須入力欄
			if ((dgvPR履歴.RowCount == 1) && (最終行or全項目未入力(dgvPR履歴, 0)))
            {
                MessageBox.Show(Properties.Resources.MSG_W_販売履歴が入力されていません, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                dgvPR履歴.Focus();
                return false;
            }

            if (IsValidate新規変更削除チェック状態(dgvPR履歴, this.Text) == false)
                return false;

            //未入力
            bool b新規変更削除にチェック有り = false;
            for (int iRow = 0; iRow < dgvPR履歴.RowCount; iRow++)
            {
				if (最終行or全項目未入力(dgvPR履歴, iRow) == true)
                    continue;

                if ((Boolean)dgvPR履歴.Rows[iRow].Cells[PR履歴Cell.byt新規].Value == false &&
                    (Boolean)dgvPR履歴.Rows[iRow].Cells[PR履歴Cell.byt変更].Value == false &&
                    (Boolean)dgvPR履歴.Rows[iRow].Cells[PR履歴Cell.byt削除].Value == false)
                    continue;

                b新規変更削除にチェック有り = true;
                break;
            }

            if (b新規変更削除にチェック有り == false)
            {
                MessageBox.Show(Properties.Resources.MSG_W_編集された行がありません, this.Text, MessageBoxButtons.OK,
                    MessageBoxIcon.Warning);
                dgvPR履歴.Focus();
                return false;
            }

            //編集されたセルを全てチェックする
            bool isValid = true;
            for (int iRow = 0; iRow < dgvPR履歴.RowCount; iRow++)
            {
				if (最終行or全項目未入力(dgvPR履歴, iRow) == true)
                    continue;

                if ((Boolean)dgvPR履歴.Rows[iRow].Cells[PR履歴Cell.byt新規].Value == false &&
                    (Boolean)dgvPR履歴.Rows[iRow].Cells[PR履歴Cell.byt変更].Value == false &&
                    (Boolean)dgvPR履歴.Rows[iRow].Cells[PR履歴Cell.byt削除].Value == false)
                    continue;

				if (!IsValidateDGVPR履歴(dgvPR履歴, iRow))
                    isValid = false;
            }

            if (!isValid)
            {
                MessageBox.Show(string.Format(Properties.Resources.MSG_W_Aの入力内容に誤りがある為_登録を完了できません, Properties.Resources.MSG_TTL_PR履歴)
                    , this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);

                dgvPR履歴.Focus();
                return false;
            }

            return true;
        }

        private void InsertPR履歴()
        {
            D17PR履歴.D17PR履歴Row[] dr = (D17PR履歴.D17PR履歴Row[])d17PR履歴._D17PR履歴.Select(
                Properties.Resources.DGV列名_新規 + " = true");

			//string strPR名リスト = "";
			int iPR履歴No = 0;
			for (int iRow = 0; iRow < dr.Length; iRow++)
            {
                iPR履歴No = 0;
				C06DB共通.d17PR履歴ta.InsertPR履歴(dr[iRow].PR区分No, dr[iRow].PR名, C02業務共通処理.miログインスタッフNo, out iPR履歴No);
				C06DB共通.d17PR履歴ta.Insertプロモーション予定(iPR履歴No, dr[iRow].公開予定日, null, null, 0, 0, 0, 0, 0, 0, 0, "", ""
                    , C02業務共通処理.miログインスタッフNo);
                if (dr[iRow].Is公開実施日Null() == false)
					C06DB共通.d17PR履歴ta.Insertプロモーション実績(iPR履歴No, dr[iRow].公開実施日, null, null, 0, "", ""
                        , C02業務共通処理.miログインスタッフNo);

				//strPR名リスト += dr[iRow].PR名 + ", ";
            }

            if (dr.Length > 0)
			{
				//C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_014
				//    + "=" + strPR名リスト.Substring(0, strPR名リスト.Length - 2));
				C02業務共通処理.Insert操作履歴(this.Text, "新規登録：" + dr.Length.ToString() + "件");
			}
		}

        private void UpdatePR履歴()
        {
            D17PR履歴.D17PR履歴Row[] dr = (D17PR履歴.D17PR履歴Row[])d17PR履歴._D17PR履歴.Select(
                Properties.Resources.DGV列名_変更 + " = true");

			//string strPR名リスト = "";
            for (int iRow = 0; iRow < dr.Length; iRow++)
            {
				C06DB共通.d17PR履歴ta.UpdatePR履歴(dr[iRow].PR区分No, dr[iRow].PR名, C02業務共通処理.miログインスタッフNo
                    , dr[iRow].PR履歴No);
				C06DB共通.d17PR履歴ta.Updateプロモーション予定(dr[iRow].PR履歴No, dr[iRow].公開予定日, null, null, 0, 0, 0, 0, 0, 0, 0
                    , "", "", C02業務共通処理.miログインスタッフNo, dr[iRow].プロモーション予定No);
                if (dr[iRow].Is公開実施日Null() == false)
                {
                    if (dr[iRow].Isプロモーション実績NoNull() == true)
						C06DB共通.d17PR履歴ta.Insertプロモーション実績(dr[iRow].PR履歴No, dr[iRow].公開実施日, null, null, 0, "", ""
                            , C02業務共通処理.miログインスタッフNo);
                    else
						C06DB共通.d17PR履歴ta.Updateプロモーション実績(dr[iRow].PR履歴No, dr[iRow].公開実施日, null, null, 0, "", ""
                            , C02業務共通処理.miログインスタッフNo, dr[iRow].プロモーション実績No);
                }


				//strPR名リスト += dr[iRow].PR名 + ", ";
            }

            if (dr.Length > 0)
			{
				//C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_015
				//    + "=" + strPR名リスト.Substring(0, strPR名リスト.Length - 2));
				C02業務共通処理.Insert操作履歴(this.Text, "更新：" + dr.Length.ToString() + "件");
			}
		}

        private void DeletePR履歴()
        {
			//string strPR名リスト = "";
            int i削除行数 = 0;
            for (int iRow = 0; iRow < dgvPR履歴.RowCount; iRow++)
            {
                if (dgvPR履歴.Rows[iRow].Cells[PR履歴Cell.byt削除].Value == null)
                    continue;

                if ((Boolean)dgvPR履歴.Rows[iRow].Cells[PR履歴Cell.byt削除].Value == false)
                    continue;

                if (dgvPR履歴.Rows[iRow].Cells[PR履歴Cell.bytPR履歴No].Value.ToString() == "")
                    continue;

				C06DB共通.d17PR履歴ta.DeletePR履歴(int.Parse(dgvPR履歴.Rows[iRow]
                    .Cells[PR履歴Cell.bytPR履歴No].Value.ToString()));
				C06DB共通.d17PR履歴ta.Deleteプロモーション予定(int.Parse(dgvPR履歴.Rows[iRow]
                    .Cells[PR履歴Cell.bytPR履歴No].Value.ToString()));
				C06DB共通.d17PR履歴ta.Deleteプロモーション実績(int.Parse(dgvPR履歴.Rows[iRow]
                    .Cells[PR履歴Cell.bytPR履歴No].Value.ToString()));

				//strPR名リスト += dgvPR履歴.Rows[iRow].Cells[PR履歴Cell.bytPR名].Value.ToString() + ", ";

                i削除行数++;
            }

            if (i削除行数 > 0)
			{
				//C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_016
				//    + "=" + strPR名リスト.Substring(0, strPR名リスト.Length - 2));
				C02業務共通処理.Insert操作履歴(this.Text, "削除：" + i削除行数.ToString() + "件");
			}
		}

        private void Set属性マスタ()
        {
			C06DB共通.d01PR区分ta.Fill(d01業務共通.D01PR区分);
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ


        private void _210PR履歴_Load(object sender, EventArgs e)
        {
            try
            {
                Set属性マスタ();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_210PR履歴", "_210PR履歴_Load", ex);
            }
            finally
            {
                Set列幅();
            }
        }

        private void _210PR履歴_Resize(object sender, EventArgs e)
        {
            try
            {
                C01FormCommon.画面最小サイズに変更(this, true);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_210PR履歴", "_210PR履歴_Resize", ex);
            }
        }

        private void dgvPR履歴_CellValidating(object sender, DataGridViewCellValidatingEventArgs e)
        {
            try
            {
                //列が変わった場合は書式チェックを実施
                string value = e.FormattedValue.ToString();

                switch (e.ColumnIndex)
                {
                    case PR履歴Cell.bytPR区分No:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell必須入力(dgvPR履歴, e.RowIndex, e.ColumnIndex, value))
                                break;

                            dgvPR履歴.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case PR履歴Cell.bytPR名:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell必須入力(dgvPR履歴, e.RowIndex, e.ColumnIndex, value))
                                break;

                            dgvPR履歴.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case PR履歴Cell.byt公開予定日:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell必須入力(dgvPR履歴, e.RowIndex, e.ColumnIndex, value))
                                break;

                            dgvPR履歴.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_210PR履歴", "dgvPR履歴_CellValidating", ex);
            }
        }

        private void dgvPR履歴_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            try
            {
                C11ValidateOnForm.新規変更削除列のチェック状態変更(e, PR履歴Cell.bytPR履歴No,
                    PR履歴Cell.byt新規, PR履歴Cell.byt変更, PR履歴Cell.byt削除,
                    ref dgvPR履歴);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_210PR履歴", "dgvPR履歴_CellValueChanged", ex);
            }
        }

        private void dgvPR履歴_DataError(object sender, DataGridViewDataErrorEventArgs e)
        {
            try
            {
                e.Cancel = true;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_210PR履歴", "dgvPR履歴_DataError", ex);
            }
        }

        private void dgvPR履歴_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgvPR履歴.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgvPR履歴.RowHeadersDefaultCellStyle.Font,
                                              dgvPR履歴.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_210PR履歴", "dgvPR履歴_RowPostPaint", ex);
            }
        }

        private void dgvPR履歴_RowValidating(object sender, DataGridViewCellCancelEventArgs e)
        {
            try
            {
                //行が変わった場合は必須入力チェックを実施
                if (e.RowIndex <= dgvPR履歴.RowCount)
                {
					IsValidateDGVPR履歴(dgvPR履歴, e.RowIndex);
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_210PR履歴", "dgvPR履歴_RowValidating", ex);
            }
        }

        private void btn検索条件をクリア_Click(object sender, EventArgs e)
        {
            try
            {
                cmbPR区分.Text = "";
                txtPR名.Text = "";
                dtp公開予定日fr.Value = DateTime.Today;
                dtp公開予定日to.Value = DateTime.Today;
                dtp公開予定日fr.Checked = false;
                dtp公開予定日to.Checked = false;
                dtp公開実施日fr.Value = DateTime.Today;
                dtp公開実施日to.Value = DateTime.Today;
                dtp公開実施日fr.Checked = false;
                dtp公開実施日to.Checked = false;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_210PR履歴", "btn検索条件をクリア_Click", ex);
            }
        }

        private void btn検索_Click(object sender, EventArgs e)
        {
            try
            {
                //入力値検証
                if (false == IsValidate検索())
                    return;

                Cursor.Current = Cursors.WaitCursor;
                d17PR履歴bs.DataSource = null;

                検索条件 row = Get検索条件();

                //検索実行
				C06DB共通.d17PR履歴ta.FillBy検索(d17PR履歴._D17PR履歴
                                        , row.PR区分
                                        , row.PR名
                                        , row.公開予定日fr
                                        , row.公開予定日to
                                        , row.公開実施日fr
                                        , row.公開実施日to);

                //見つからない場合はメッセージ表示
                if (d17PR履歴._D17PR履歴.Rows.Count == 0)
                    MessageBox.Show(Properties.Resources.MSG_W_データは見つかりませんでした
						, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);

            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_201販売履歴", "btn検索_Click", ex);
            }
            finally
            {
                d17PR履歴bs.DataSource = d17PR履歴._D17PR履歴;
				lbl件数.Text = "検索結果：" + d17PR履歴._D17PR履歴.Count.ToString() + " 件";

                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btnCSVファイル読込_Click(object sender, EventArgs e)
        {
            bool b正常終了 = true;

            try
            {
                OpenFileDialog dlg = new OpenFileDialog();
                dlg.Filter = "CSV " + Properties.Resources.MSG_I_ファイル + "(*.csv)|*.csv";
                if (dlg.ShowDialog(this) == DialogResult.Cancel)
                    return;

                Cursor.Current = Cursors.WaitCursor;

                d17PR履歴bs.DataSource = null;

                取込処理内部クラス 取込処理 = new 取込処理内部クラス();
                D16広告.D16広告DataTable dt = new D16広告.D16広告DataTable();

                if (!取込処理.CSV変換(dlg.FileName, dt, 2))
                {
					//string errmsg = 取込処理.LastErrorMessage 
					//    + "\n\n【" + Properties.Resources.MSG_I_詳細 + "】\n" + 取込処理.ErrorDetail;
					string errmsg = 取込処理.LastErrorMessage;
					MessageBox.Show(errmsg, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                if (dt.Count > C_最大値.CSV取込件数)
                {
                    string errmsg = string.Format(Properties.Resources.MSG_W_最大取込件数A件を超えています, (long)C_最大値.CSV取込件数);
                    MessageBox.Show(errmsg, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

				d17PR履歴._D17PR履歴.Clear();
				d17PR履歴._D17PR履歴.Merge(dt);

				lbl件数.Text = "検索結果：" + d17PR履歴._D17PR履歴.Count.ToString() + " 件";
			}
            catch (Exception ex)
            {
                b正常終了 = false;
                C04システム共通.ErrorLog("_210PR履歴", "btnCSVファイル読込_Click", ex);
            }
            finally
            {
                d17PR履歴bs.DataSource = d17PR履歴._D17PR履歴;

                Cursor.Current = Cursors.Arrow;
            }

            if (b正常終了 == true)
                MessageBox.Show(Properties.Resources.MSG_I_読込が完了しました, this.Text, MessageBoxButtons.OK
                    , MessageBoxIcon.Information);
            else
                MessageBox.Show(Properties.Resources.MSG_W_ファイルの読込に失敗しました, this.Text, MessageBoxButtons.OK
                    , MessageBoxIcon.Warning);
        }

        private void btn選択行の削除を全てチェック_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgvPR履歴.SelectedRows)
                {
                    if (IsValidate未入力行(row))
                        continue;

                    row.Cells[PR履歴Cell.byt新規].Value = false;
                    row.Cells[PR履歴Cell.byt変更].Value = false;
                    row.Cells[PR履歴Cell.byt削除].Value = true;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_210PR履歴", "btn選択行の削除を全てチェック_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn選択行のチェックを全て外す_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgvPR履歴.SelectedRows)
                {
                    row.Cells[PR履歴Cell.byt新規].Value = false;
                    row.Cells[PR履歴Cell.byt変更].Value = false;
                    row.Cells[PR履歴Cell.byt削除].Value = false;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_210PR履歴", "btn選択行のチェックを全て外す_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn検索結果をクリア_Click(object sender, EventArgs e)
        {
            try
            {
                if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_検索結果をクリアしますか
                    , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
                    return;

                d17PR履歴._D17PR履歴.Clear();
				lbl件数.Text = "";
			}
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_210PR履歴", "btn検索結果をクリア_Click", ex);
            }
        }

        private void btnCSVファイル出力_Click(object sender, EventArgs e)
        {
            try
            {
                if (dgvPR履歴.SelectedRows.Count == 0)
                {
                    MessageBox.Show(Properties.Resources.MSG_W_073, this.Text, MessageBoxButtons.OK
                        , MessageBoxIcon.Warning);
                    return;
                }

                SaveFileDialog sfd = new SaveFileDialog();
                sfd.Filter = "CSV " + Properties.Resources.MSG_I_ファイル + "(*.csv)|*.csv";

                if (sfd.ShowDialog() != DialogResult.OK)
                    return;

                Cursor.Current = Cursors.WaitCursor;

				//C06CSV.CreateCSVファイル(dgvPR履歴, sfd.FileName, true, 4, true, "");
				if (C06CSV.CreateCSVファイル(dgvPR履歴, sfd.FileName, true, 4, true, null) == false)
					return;

                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_007);

                MessageBox.Show(Properties.Resources.MSG_I_ファイル出力が完了しました, this.Text, MessageBoxButtons.OK, 
                    MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_210PR履歴", "btn選択行をCSVファイルに出力_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void PR予定実績表示(byte bytMode)
        {
            if (C02業務共通処理.チェック閲覧権限(this.Text, C_画面名.PR詳細) == false)
                return;

            //if (IsRowEmpty(dgvPR履歴.SelectedCells[0].RowIndex) == true)
			if (最終行or全項目未入力(dgvPR履歴, dgvPR履歴.SelectedCells[0].RowIndex) == true)
            {
                MessageBox.Show(Properties.Resources.MSG_W_行が選択されていません, Text, MessageBoxButtons.OK,
                    MessageBoxIcon.Warning);
                return;
            }

            if (int.Parse(dgvPR履歴.Rows[dgvPR履歴.SelectedCells[0].RowIndex].Cells[PR履歴Cell.bytPR履歴No]
                .Value.ToString()) < 1)
            {
                MessageBox.Show(Properties.Resources.MSG_W_確定が済んでいない行では_詳細画面を表示することはできません
					, Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            _211PR詳細 _211PR詳細 = null;
            _211PR詳細 = new _211PR詳細();
            _211PR詳細.mbytMode = bytMode;
            C01FormCommon.画面最小サイズに変更(_211PR詳細, true);

            _211PR詳細.mintPR履歴No = int.Parse(dgvPR履歴.Rows[dgvPR履歴.SelectedCells[0].RowIndex]
                .Cells[PR履歴Cell.bytPR履歴No].Value.ToString());
            _211PR詳細.mintPR区分No = int.Parse(dgvPR履歴.Rows[dgvPR履歴.SelectedCells[0].RowIndex]
                .Cells[PR履歴Cell.bytPR区分No].Value.ToString());
            _211PR詳細.mstrPR名 = dgvPR履歴.Rows[dgvPR履歴.SelectedCells[0].RowIndex]
                .Cells[PR履歴Cell.bytPR名].Value.ToString();
            _211PR詳細.mintプロモーション予定No = int.Parse(dgvPR履歴.Rows[dgvPR履歴.SelectedCells[0].RowIndex]
                .Cells[PR履歴Cell.bytプロモーション予定No].Value.ToString());
            _211PR詳細.mdt公開予定日 = DateTime.Parse(dgvPR履歴.Rows[dgvPR履歴.SelectedCells[0].RowIndex]
                .Cells[PR履歴Cell.byt公開予定日].Value.ToString());

            if (dgvPR履歴.Rows[dgvPR履歴.SelectedCells[0].RowIndex].Cells[PR履歴Cell.bytプロモーション実績No]
                .Value.ToString() == "")
            {
                _211PR詳細.mintプロモーション実績No = null;
                _211PR詳細.mdt公開実施日 = null;
            }
            else
            {
                _211PR詳細.mintプロモーション実績No = int.Parse(dgvPR履歴.Rows[dgvPR履歴.SelectedCells[0].RowIndex]
                    .Cells[PR履歴Cell.bytプロモーション実績No].Value.ToString());
                _211PR詳細.mdt公開実施日 = DateTime.Parse(dgvPR履歴.Rows[dgvPR履歴.SelectedCells[0].RowIndex]
                    .Cells[PR履歴Cell.byt公開実施日].Value.ToString());
            }

            _211PR詳細.ShowDialog();
        }

        private void btnPR詳細_Click(object sender, EventArgs e)
        {
            try
            {
                //if (C02業務共通処理.チェック閲覧権限(this.Text, C_画面名.PR詳細.ToString()) == false)
                //    return;

                //if (IsRowEmpty(dgvPR履歴.SelectedCells[0].RowIndex) == true)
                //{
                //    MessageBox.Show(Properties.Resources.MSG_INF_069, Text, MessageBoxButtons.OK,
                //        MessageBoxIcon.Warning);
                //    return;
                //}

                //if (int.Parse(dgvPR履歴.Rows[dgvPR履歴.SelectedCells[0].RowIndex].Cells[PR履歴Cell.bytPR履歴No]
                //    .Value.ToString()) < 1)
                //{
                //    MessageBox.Show(Properties.Resources.MSG_INF_066, Text, MessageBoxButtons.OK,
                //        MessageBoxIcon.Warning);
                //    return;
                //}

                //_211PR詳細 _211PR詳細 = null;
                //_211PR詳細 = new _211PR詳細();
                //C01FormCommon.画面最小サイズに変更(_211PR詳細, true);

                //_211PR詳細.mintPR履歴No = int.Parse(dgvPR履歴.Rows[dgvPR履歴.SelectedCells[0].RowIndex]
                //    .Cells[PR履歴Cell.bytPR履歴No].Value.ToString());
                //_211PR詳細.mintPR区分No = int.Parse(dgvPR履歴.Rows[dgvPR履歴.SelectedCells[0].RowIndex]
                //    .Cells[PR履歴Cell.bytPR区分No].Value.ToString());
                //_211PR詳細.mstrPR名 = dgvPR履歴.Rows[dgvPR履歴.SelectedCells[0].RowIndex]
                //    .Cells[PR履歴Cell.bytPR名].Value.ToString();
                //_211PR詳細.mintプロモーション予定No = int.Parse(dgvPR履歴.Rows[dgvPR履歴.SelectedCells[0].RowIndex]
                //    .Cells[PR履歴Cell.bytプロモーション予定No].Value.ToString());
                //_211PR詳細.mdt公開予定日 = DateTime.Parse(dgvPR履歴.Rows[dgvPR履歴.SelectedCells[0].RowIndex]
                //    .Cells[PR履歴Cell.byt公開予定日].Value.ToString());

                //if (dgvPR履歴.Rows[dgvPR履歴.SelectedCells[0].RowIndex].Cells[PR履歴Cell.bytプロモーション実績No]
                //    .Value.ToString() == "")
                //{
                //    _211PR詳細.mintプロモーション実績No = null;
                //    _211PR詳細.mdt公開実施日 = null;
                //}
                //else
                //{
                //    _211PR詳細.mintプロモーション実績No = int.Parse(dgvPR履歴.Rows[dgvPR履歴.SelectedCells[0].RowIndex]
                //        .Cells[PR履歴Cell.bytプロモーション実績No].Value.ToString());
                //    _211PR詳細.mdt公開実施日 = DateTime.Parse(dgvPR履歴.Rows[dgvPR履歴.SelectedCells[0].RowIndex]
                //        .Cells[PR履歴Cell.byt公開実施日].Value.ToString());
                //}

                //_211PR詳細.ShowDialog();
                PR予定実績表示(C_予定実績Mode.予定);

                
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_210PR履歴", "btnPR履歴_Click", ex);
            }
        }

        private void btnPR実績詳細_Click(object sender, EventArgs e)
        {
            try
            {
                PR予定実績表示(C_予定実績Mode.実績);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_210PR履歴", "btnPR履歴_Click", ex);
            }
        }

        private void btn確定_Click(object sender, EventArgs e)
        {
            try
            {
				if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_入力した内容を登録しますか
					, this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
					return;

				Cursor.Current = Cursors.WaitCursor;

                if (false == IsValidate())
                    return;

                InsertPR履歴();
                UpdatePR履歴();
                DeletePR履歴();

                d17PR履歴._D17PR履歴.Clear();

                MessageBox.Show(Properties.Resources.MSG_I_登録が完了しました, this.Text, MessageBoxButtons.OK,
                    MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_210PR履歴", "btn確定_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_210PR履歴", "btnキャンセル_Click", ex);
            }
        }

        #endregion



    }
}
