﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using SystemCommon;
using ClientCommon;


namespace 顧客分析君
{
    public partial class _406相関商品一覧 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

		private class 検索条件
		{
			public string 元商品ID { get; set; }
			public string 元商品名 { get; set; }
			public Nullable<long> 元商品単価From { get; set; }
			public Nullable<long> 元商品単価To { get; set; }
			public string 先商品ID { get; set; }
			public string 先商品名 { get; set; }
			public Nullable<long> 先商品単価From { get; set; }
			public Nullable<long> 先商品単価To { get; set; }
		}

		//private enum enm商品一覧Cell
		//{
		//    元商品ID = 0,
		//    元商品名 = 1,
		//    元商品単価 = 2,
		//    先商品ID = 3,
		//    先商品名 = 4,
		//    先商品単価 = 5,
		//    類似度 = 6
		//}
		private static class 商品一覧Cell
		{
            public const byte byt元商品ID = 0;
            public const byte byt元商品名 = 1;
            public const byte byt元商品単価 = 2;
            public const byte byt先商品ID = 3;
            public const byte byt先商品名 = 4;
            public const byte byt先商品単価 = 5;
			public const byte byt類似度 = 6;
		}

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド 
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _406相関商品一覧()
        {
            InitializeComponent();
        }

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド

        private void Set列幅()
        {
            dgv商品一覧.Columns[商品一覧Cell.byt元商品ID].Width = C_列幅.商品ID;
            dgv商品一覧.Columns[商品一覧Cell.byt元商品名].Width = C_列幅.商品名;
            dgv商品一覧.Columns[商品一覧Cell.byt元商品単価].Width = C_列幅.商品単価;
            dgv商品一覧.Columns[商品一覧Cell.byt先商品ID].Width = C_列幅.商品ID;
            dgv商品一覧.Columns[商品一覧Cell.byt先商品名].Width = C_列幅.商品名;
            dgv商品一覧.Columns[商品一覧Cell.byt先商品単価].Width = C_列幅.商品単価;
            dgv商品一覧.Columns[商品一覧Cell.byt類似度].Width = C_列幅.類似度;
        }

		private bool IsValidate検索()
		{
			if (txt元商品ID.Text != "")
			{
				if (C11ValidateOnForm.IsValidate半角英数(txt元商品ID.Text, "元商品ID") == false)
					return false;
			}

			if (txt元商品単価From.Text != "")
			{
				if (C11ValidateOnForm.IsValidate符号無し数値型(txt元商品単価From.Text
					, "元商品単価") == false)
					return false;
			}

			if (txt元商品単価To.Text != "")
			{
				if (C11ValidateOnForm.IsValidate符号無し数値型(txt元商品単価To.Text
					, "元商品単価") == false)
					return false;
			}

			if (txt先商品ID.Text != "")
			{
				if (C11ValidateOnForm.IsValidate半角英数(txt先商品ID.Text, "先商品ID") == false)
					return false;
			}

			if (txt先商品単価From.Text != "")
			{
				if (C11ValidateOnForm.IsValidate符号無し数値型(txt先商品単価From.Text
					, "先商品単価") == false)
					return false;
			}

			if (txt先商品単価To.Text != "")
			{
				if (C11ValidateOnForm.IsValidate符号無し数値型(txt先商品単価To.Text
					, "先商品単価") == false)
					return false;
			}

			return true;
		}

		//検索で使用するSQLパラメータの取得
		private 検索条件 Get検索条件()
		{
			検索条件 row = new 検索条件();

			if (txt元商品ID.Text == "")
				row.元商品ID = null;
			else
				row.元商品ID = txt元商品ID.Text;

			if (txt元商品名.Text == "")
				row.元商品名 = null;
			else
				row.元商品名 = txt元商品名.Text;

			if (txt元商品単価From.Text == "")
				row.元商品単価From = null;
			else
				row.元商品単価From = int.Parse(txt元商品単価From.Text);

			if (txt元商品単価To.Text == "")
				row.元商品単価To = null;
			else
				row.元商品単価To = int.Parse(txt元商品単価To.Text);

			if (txt先商品ID.Text == "")
				row.先商品ID = null;
			else
				row.先商品ID = txt先商品ID.Text;

			if (txt先商品名.Text == "")
				row.先商品名 = null;
			else
				row.先商品名 = txt先商品名.Text;

			if (txt先商品単価From.Text == "")
				row.先商品単価From = null;
			else
				row.先商品単価From = int.Parse(txt先商品単価From.Text);

			if (txt先商品単価To.Text == "")
				row.先商品単価To = null;
			else
				row.先商品単価To = int.Parse(txt先商品単価To.Text);

			return row;
		}		
		#endregion


        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _406相関商品一覧_Load(object sender, EventArgs e)
        {
			//bool b正常終了 = true;

			//try
			//{

			//    //計算済みチェック
			//    if (C02業務共通処理.最後に計算した日時() == "")
			//    {
			//        b正常終了 = false;
			//        MessageBox.Show(Properties.Resources.MSG_W_計算が完了していない為_分析結果を表示できません, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
			//        this.Close();
			//        return;
			//    }

			//    Cursor.Current = Cursors.WaitCursor;

			//    d09相関商品一覧bs.DataSource = null;

			//    検索条件 row = Get検索条件();
				
			//    this.d09相関商品一覧ta.Fill(d09相関商品一覧._D09相関商品一覧);

			//}
			//catch (Exception ex)
			//{
			//    C04システム共通.ErrorLog("_406相関商品一覧", "_406相関商品一覧_Load", ex);
			//}
			//finally
			//{
			//    d09相関商品一覧bs.DataSource = d09相関商品一覧._D09相関商品一覧;
				
			//    //dgv商品一覧.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.AllCells;
			//    if (b正常終了 == true)
                    Set列幅();

			//    Cursor.Current = Cursors.Arrow;
			//}
        }


        private void _406相関商品一覧_Resize(object sender, EventArgs e)
        {
            try
            {
                C01FormCommon.画面最小サイズに変更(this, true);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_406相関商品一覧", "_406相関商品一覧_Resize", ex);
            }
        }

        
        private void dgv商品一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
					e.RowBounds.Location.Y,
					dgv商品一覧.RowHeadersWidth,
					e.RowBounds.Height,
					e.Graphics,
					e.RowIndex,
					dgv商品一覧.RowHeadersDefaultCellStyle.Font,
					dgv商品一覧.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_406相関商品一覧", "dgv商品一覧_RowPostPaint", ex);
            }

        }


        private void btnCSVファイル出力_Click(object sender, EventArgs e)
        {
            try
            {
                //ファイル参照ダイアログを表示する
                SaveFileDialog sfd = new SaveFileDialog();
                sfd.Filter = "CSV " + Properties.Resources.MSG_I_ファイル + "(*.csv)|*.csv";

                if (sfd.ShowDialog() != DialogResult.OK)
                    return;

				Cursor.Current = Cursors.WaitCursor;
				
				//グリッドの内容をCSV形式で出力する
				//C06CSV.CreateCSVファイル(dgv商品一覧, sfd.FileName, true, 0, false, "");
				if (C06CSV.CreateCSVファイル(dgv商品一覧, sfd.FileName, true, 0, false, "") == false)
					return;

                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_007);

                MessageBox.Show(Properties.Resources.MSG_I_ファイル出力が完了しました
					, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_406相関商品一覧", "btnCSVファイル出力_Click", ex);
            }
			finally
			{
				Cursor.Current = Cursors.Arrow;
			}
		}

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_406相関商品一覧", "btnキャンセル_Click", ex);
            }
        }

        private void btn検索条件をクリア_Click(object sender, EventArgs e)
        {
			txt元商品ID.Text = "";
			txt元商品名.Text = "";
			txt元商品単価From.Text = "";
			txt元商品単価To.Text = "";

			txt先商品ID.Text = "";
			txt先商品名.Text = "";
			txt先商品単価From.Text = "";
			txt先商品単価To.Text = "";
        }

        private void btn検索_Click(object sender, EventArgs e)
        {
            bool b正常終了 = true;

            try
            {
                if (IsValidate検索() == false)
                    return;

				//計算済みチェック
                if (C02業務共通処理.最後に計算した日時() == "")
                {
                    b正常終了 = false;
                    MessageBox.Show(Properties.Resources.MSG_W_計算が完了していない為_分析結果を表示できません
						, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    this.Close();
                    return;
                }

                Cursor.Current = Cursors.WaitCursor;

                d09相関商品一覧bs.DataSource = null;

				検索条件 row = Get検索条件();

                this.d09相関商品一覧ta.Fill(d09相関商品一覧._D09相関商品一覧
					, row.元商品ID, row.元商品名, row.元商品単価From, row.元商品単価To
					, row.先商品ID, row.先商品名, row.先商品単価From, row.先商品単価To);

                //見つからない場合はメッセージ表示
                if (d09相関商品一覧._D09相関商品一覧.Rows.Count == 0)
                    MessageBox.Show(Properties.Resources.MSG_W_データは見つかりませんでした
						, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);

            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_406相関商品一覧", "_406相関商品一覧_Load", ex);
            }
            finally
            {
                d09相関商品一覧bs.DataSource = d09相関商品一覧._D09相関商品一覧;
				lbl件数.Text = "検索結果：" + d09相関商品一覧._D09相関商品一覧.Count.ToString() + " 件";

                if (b正常終了 == true)
                    Set列幅();

                Cursor.Current = Cursors.Arrow;
            }
        }


        #endregion


    }
}
