﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
//using System.Reflection;

using SystemCommon;
using ClientCommon;


namespace 顧客分析君
{
    public partial class _403抽出顧客一覧 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        //public const byte mcbtMode_RFM分析 = 1;
        //public const byte mcbtMode_顧客動向表 = 2;
        //public const byte mcbtMode_FM分析 = 3;
        public byte mbMode = 1;  // 1：RFM分析　2：顧客動向表　3：FM分析

        // 「1：RFM分析」用パラメータ
        public byte[] mbR;
        public byte[] mbF;     // 「3：FM分析」共有
        public byte[] mbM;     // 「3：FM分析」共有

        // 「2：顧客動向表」用パラメータ
        public short ms年;    // 「3：FM分析」共有
        public byte mb月;      // 「3：FM分析」共有
        public byte mbRFM種別;
        public byte mbRFMランク;

		//public enum enm顧客リストRFMCell : int
		//{
		//    顧客No = 0,
		//    R = 1,
		//    F = 2,
		//    M = 3,
		//    顧客ID = 4,
		//    氏名 = 5,
		//    氏名カナ = 6,
		//    性別 = 7,
		//    //年齢 = 8,
		//    生年月日 = 8,
		//    郵便番号 = 9,
		//    住所 = 10,
		//    TEL = 11,
		//    メールアドレス = 12,
		//    メルマガ許諾 = 13,
		//    備考 = 14
		//}
		private static class 顧客リストRFMCell
		{
            public const byte byt顧客No = 0;
            public const byte bytR = 1;
            public const byte bytF = 2;
            public const byte bytM = 3;
            public const byte byt顧客ID = 4;
            public const byte byt氏名 = 5;
            public const byte byt氏名カナ = 6;
            public const byte byt性別 = 7;
            //public const byte byt年齢 = 8;
            public const byte byt生年月日 = 8;
            public const byte byt郵便番号 = 9;
            public const byte byt住所 = 10;
            public const byte bytTEL = 11;
            public const byte bytメールアドレス = 12;
            public const byte bytメルマガ許諾 = 13;
			public const byte byt備考 = 14;
		}

		//public enum enm顧客リストCell : int
		//{
		//    顧客No = 0,
		//    顧客ID = 1,
		//    氏名 = 2,
		//    氏名カナ = 3,
		//    性別 = 4,
		//    //年齢 = 5,
		//    生年月日 = 5,
		//    郵便番号 = 6,
		//    住所 = 7,
		//    TEL = 8,
		//    メールアドレス = 9,
		//    メルマガ許諾 = 10,
		//    備考 = 11
		//}
		private static class 顧客リストCell
		{
            public const byte byt顧客No = 0;
            public const byte byt顧客ID = 1;
            public const byte byt氏名 = 2;
            public const byte byt氏名カナ = 3;
            public const byte byt性別 = 4;
            //public const byte byt年齢 = 5;
            public const byte byt生年月日 = 5;
            public const byte byt郵便番号 = 6;
            public const byte byt住所 = 7;
            public const byte bytTEL = 8;
            public const byte bytメールアドレス = 9;
            public const byte bytメルマガ許諾 = 10;
			public const byte byt備考 = 11;
		}

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド 
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _403抽出顧客一覧()
        {
            InitializeComponent();

            Set表示項目();
        }

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド

        private void Set表示項目()
        {

#if 顧客分析君2010
            btnメール配信.Visible = false;
#endif
        }

        private void Set列幅_RFM(byte btMode)
        {
            if (btMode == C_抽出顧客Mode.RFM分析)
                dgvRFM顧客リスト.Columns[顧客リストRFMCell.bytR].Width = C_列幅.RFMランク;
            else if (btMode == C_抽出顧客Mode.FM分析)
                dgvRFM顧客リスト.Columns[顧客リストRFMCell.bytR].Visible = false;

            dgvRFM顧客リスト.Columns[顧客リストRFMCell.bytF].Width = C_列幅.RFMランク;
            dgvRFM顧客リスト.Columns[顧客リストRFMCell.bytM].Width = C_列幅.RFMランク;
            dgvRFM顧客リスト.Columns[顧客リストRFMCell.byt顧客No].Visible = false;
            dgvRFM顧客リスト.Columns[顧客リストRFMCell.byt顧客ID].Width = C_列幅.顧客ID;
            dgvRFM顧客リスト.Columns[顧客リストRFMCell.byt氏名].Width = C_列幅.氏名;
            dgvRFM顧客リスト.Columns[顧客リストRFMCell.byt氏名カナ].Width = C_列幅.氏名カナ;
            dgvRFM顧客リスト.Columns[顧客リストRFMCell.byt性別].Width = C_列幅.性別;
            dgvRFM顧客リスト.Columns[顧客リストRFMCell.byt生年月日].Width = C_列幅.年月日;
            dgvRFM顧客リスト.Columns[顧客リストRFMCell.byt郵便番号].Width = C_列幅.郵便番号;
            dgvRFM顧客リスト.Columns[顧客リストRFMCell.byt住所].Width = C_列幅.住所;
            dgvRFM顧客リスト.Columns[顧客リストRFMCell.bytTEL].Width = C_列幅.TEL;
            dgvRFM顧客リスト.Columns[顧客リストRFMCell.bytメールアドレス].Width = C_列幅.メールアドレス;
            dgvRFM顧客リスト.Columns[顧客リストRFMCell.bytメルマガ許諾].Width = C_列幅.メルマガ許諾;
            dgvRFM顧客リスト.Columns[顧客リストRFMCell.byt備考].Width = C_列幅.備考;
        }

        private void Set列幅()
        {
            dgv顧客リスト.Columns[顧客リストCell.byt顧客No].Visible = false;
            dgv顧客リスト.Columns[顧客リストCell.byt顧客ID].Width = C_列幅.顧客ID;
            dgv顧客リスト.Columns[顧客リストCell.byt氏名].Width = C_列幅.氏名;
            dgv顧客リスト.Columns[顧客リストCell.byt氏名カナ].Width = C_列幅.氏名カナ;
            dgv顧客リスト.Columns[顧客リストCell.byt性別].Width = C_列幅.性別;
            dgv顧客リスト.Columns[顧客リストCell.byt生年月日].Width = C_列幅.年月日;
            dgv顧客リスト.Columns[顧客リストCell.byt郵便番号].Width = C_列幅.郵便番号;
            dgv顧客リスト.Columns[顧客リストCell.byt住所].Width = C_列幅.住所;
            dgv顧客リスト.Columns[顧客リストCell.bytTEL].Width = C_列幅.TEL;
            dgv顧客リスト.Columns[顧客リストCell.bytメールアドレス].Width = C_列幅.メールアドレス;
            dgv顧客リスト.Columns[顧客リストCell.bytメルマガ許諾].Width = C_列幅.メルマガ許諾;
            dgv顧客リスト.Columns[顧客リストCell.byt備考].Width = C_列幅.備考;
        }


        #endregion


        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _403抽出顧客一覧_Load(object sender, EventArgs e)
        {
            try
            {
#if RELEASE
                btnメール配信.Visible = false;
#endif

                Cursor.Current = Cursors.WaitCursor;

                d10顧客bs.DataSource = null;
                d10RFM顧客抽出bs.DataSource = null;

                d10顧客._D10顧客.Clear();
                d10顧客.D10RFM顧客抽出.Clear();

				string str抽出条件 = "";
                //検索実行
                if (mbMode == C_抽出顧客Mode.RFM分析)
                {
                    //txt抽出条件.Text = "RFM：";
                    //D10顧客.D10RFM顧客抽出DataTable dt = new D10顧客.D10RFM顧客抽出DataTable();
                    //for (int iCnt = 0; iCnt < mbR.Length; iCnt++)
                    //{
                    //    d10RFM顧客抽出ta.Fill(dt, mbR[iCnt], mbF[iCnt], mbM[iCnt]);
                    //    //抽出条件表示
                    //    txt抽出条件.Text += " " + mbR[iCnt].ToString() + "," + mbF[iCnt].ToString() 
                    //        + "," + mbM[iCnt].ToString();
                    //    d10顧客.D10RFM顧客抽出.Merge(dt);
                    //}

                    //C02業務共通処理.顧客抽出RFM(mbR, mbF, mbM, d10顧客.D10RFM顧客抽出, txt抽出条件.Text);
                    C02業務共通処理.顧客抽出RFM(mbR, mbF, mbM, d10顧客.D10RFM顧客抽出, ref str抽出条件);
                }
                else if (mbMode == C_抽出顧客Mode.顧客動向表)
                {
                    d10顧客ta.FillBy顧客動向表(d10顧客._D10顧客, ms年, mb月, mbRFM種別, mbRFMランク);

                    //抽出条件表示
                    string strRFM種別 = "";
                    if (mbRFM種別 == 2)
                        strRFM種別 = "F";
                    else if (mbRFM種別 == 3)
                        strRFM種別 = "M";

					//txt抽出条件.Text = "顧客動向表   " + ms年.ToString() + "年" + mb月.ToString() + "月" 
					//    + "  " + strRFM種別 + mbRFMランク;
                    str抽出条件 = "顧客動向表   " + ms年.ToString() + "年" + mb月.ToString() + "月" 
                        + "  " + strRFM種別 + mbRFMランク;
                }
                else if (mbMode == C_抽出顧客Mode.FM分析)
                {
                    //txt抽出条件.Text = "FM：";
                    //D10顧客.D10RFM顧客抽出DataTable dt = new D10顧客.D10RFM顧客抽出DataTable();
                    //for (int iCnt = 0; iCnt < mbF.Length; iCnt++)
                    //{
                    //    d10RFM顧客抽出ta.FillByFM分析からの抽出(dt, mbF[iCnt], mbM[iCnt], ms年, mb月);
                    //    //抽出条件表示
                    //    txt抽出条件.Text += " " + mbF[iCnt].ToString() + "," + mbM[iCnt].ToString();
                    //    d10顧客.D10RFM顧客抽出.Merge(dt);
                    //}
                    //C02業務共通処理.顧客抽出FM(mbF, mbM, ms年, mb月, d10顧客.D10RFM顧客抽出, txt抽出条件.Text);

					//C02業務共通処理.顧客抽出FM(mbF, mbM, ms年, mb月, d10顧客.D10RFM顧客抽出, txt抽出条件.Text);
					C02業務共通処理.顧客抽出FM(mbF, mbM, ms年, mb月, d10顧客.D10RFM顧客抽出, ref str抽出条件);
				}

				txt抽出条件.Text = str抽出条件;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_403抽出顧客一覧", "_403抽出顧客一覧_Load", ex);
            }
            finally
            {
                if (mbMode == C_抽出顧客Mode.RFM分析)
                {
                    d10RFM顧客抽出bs.DataSource = d10顧客.D10RFM顧客抽出;
					lbl件数.Text = "検索結果：" + d10顧客.D10RFM顧客抽出.Count.ToString() + " 件";

					Set列幅_RFM(C_抽出顧客Mode.RFM分析);
                    dgv顧客リスト.Visible = false;
                    dgvRFM顧客リスト.Visible = true;
                }
                else if (mbMode == C_抽出顧客Mode.顧客動向表)
                {
                    d10顧客bs.DataSource = d10顧客._D10顧客;
					lbl件数.Text = "検索結果：" + d10顧客._D10顧客.Count.ToString() + " 件";

					Set列幅();
                    dgv顧客リスト.Visible = true;
                    dgvRFM顧客リスト.Visible = false;
                }
                else if (mbMode == C_抽出顧客Mode.FM分析)
                {
                    d10RFM顧客抽出bs.DataSource = d10顧客.D10RFM顧客抽出;
					lbl件数.Text = "検索結果：" + d10顧客.D10RFM顧客抽出.Count.ToString() + " 件";

					Set列幅_RFM(C_抽出顧客Mode.FM分析);
                    dgv顧客リスト.Visible = false;
                    dgvRFM顧客リスト.Visible = true;
                }

                Cursor.Current = Cursors.Arrow;
            }
        }

        private void _403抽出顧客一覧_Resize(object sender, EventArgs e)
        {
            try
            {
                C01FormCommon.画面最小サイズに変更(this, true);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_403抽出顧客一覧", "_403抽出顧客一覧_Resize", ex);
            }
        }

        private void btn顧客詳細_Click(object sender, EventArgs e)
        {
            try
            {
                if (mbMode == C_抽出顧客Mode.RFM分析 || mbMode == C_抽出顧客Mode.FM分析)
                {
                    if (dgvRFM顧客リスト.SelectedCells.Count == 0)
                    {
                        MessageBox.Show(Properties.Resources.MSG_W_セルが選択されていません, this.Text, MessageBoxButtons.OK, 
                            MessageBoxIcon.Warning);
                        return;
                    }
                }
                else if (mbMode == C_抽出顧客Mode.顧客動向表)
                {
                    if (dgv顧客リスト.SelectedCells.Count == 0)
                    {
                        MessageBox.Show(Properties.Resources.MSG_W_セルが選択されていません, this.Text, MessageBoxButtons.OK, 
                            MessageBoxIcon.Warning);
                        return;
                    }
                }

                _405顧客詳細 _顧客詳細 = null;
                _顧客詳細 = new _405顧客詳細();
                if (mbMode == C_抽出顧客Mode.RFM分析 || mbMode == C_抽出顧客Mode.FM分析)
                {
                    _顧客詳細.mint顧客No = (int)dgvRFM顧客リスト.Rows[dgvRFM顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストRFMCell.byt顧客No].Value;
                    _顧客詳細.mstr顧客ID = dgvRFM顧客リスト.Rows[dgvRFM顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストRFMCell.byt顧客ID].Value.ToString();
                    _顧客詳細.mstr氏名 = dgvRFM顧客リスト.Rows[dgvRFM顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストRFMCell.byt氏名].Value.ToString();
                    _顧客詳細.mstr氏名カナ = dgvRFM顧客リスト.Rows[dgvRFM顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストRFMCell.byt氏名カナ].Value.ToString();
                    _顧客詳細.mstr性別 = dgvRFM顧客リスト.Rows[dgvRFM顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストRFMCell.byt性別].Value.ToString();
                    _顧客詳細.mstr生年月日 = dgvRFM顧客リスト.Rows[dgvRFM顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストRFMCell.byt生年月日].Value.ToString();
                    _顧客詳細.mstr郵便番号 = dgvRFM顧客リスト.Rows[dgvRFM顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストRFMCell.byt郵便番号].Value.ToString();
                    _顧客詳細.mstr住所 = dgvRFM顧客リスト.Rows[dgvRFM顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストRFMCell.byt住所].Value.ToString();
                    _顧客詳細.mstrTEL = dgvRFM顧客リスト.Rows[dgvRFM顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストRFMCell.bytTEL].Value.ToString();
                    _顧客詳細.mstrメールアドレス = dgvRFM顧客リスト.Rows[dgvRFM顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストRFMCell.bytメールアドレス].Value.ToString();

                    _顧客詳細.mstrメルマガ許諾 = C02業務共通処理.Getメルマガ許諾No(dgvRFM顧客リスト
                        .Rows[dgvRFM顧客リスト.SelectedCells[0].RowIndex].Cells[顧客リストRFMCell.bytメルマガ許諾].Value.ToString())
                        .ToString();

                    _顧客詳細.mstr備考 = dgvRFM顧客リスト.Rows[dgvRFM顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストRFMCell.byt備考].Value.ToString();
                }
                else if (mbMode == C_抽出顧客Mode.顧客動向表)
                {
                    _顧客詳細.mint顧客No = (int)dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストCell.byt顧客No].Value;
                    _顧客詳細.mstr顧客ID = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストCell.byt顧客ID].Value.ToString();
                    _顧客詳細.mstr氏名 = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストCell.byt氏名].Value.ToString();
                    _顧客詳細.mstr氏名カナ = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストCell.byt氏名カナ].Value.ToString();
                    _顧客詳細.mstr性別 = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストCell.byt性別].Value.ToString();
                    _顧客詳細.mstr生年月日 = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストCell.byt生年月日].Value.ToString();
                    _顧客詳細.mstr郵便番号 = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストCell.byt郵便番号].Value.ToString();
                    _顧客詳細.mstr住所 = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストCell.byt住所].Value.ToString();
                    _顧客詳細.mstrTEL = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストCell.bytTEL].Value.ToString();
                    _顧客詳細.mstrメールアドレス = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex].Cells[顧客リストCell.bytメールアドレス].Value.ToString();
                    _顧客詳細.mstrメルマガ許諾 = C02業務共通処理.Getメルマガ許諾No(dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex].Cells[顧客リストCell.bytメルマガ許諾].Value.ToString()).ToString();


                    _顧客詳細.mstr備考 = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex]
                        .Cells[顧客リストCell.byt備考].Value.ToString();
                }

                C01FormCommon.画面最小サイズに変更(_顧客詳細, true);
                _顧客詳細.ShowDialog();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_403抽出顧客一覧", "btn顧客詳細_Click", ex);
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_403抽出顧客一覧", "btnキャンセル_Click", ex);
            }
        }

        private void dgv顧客リスト_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgv顧客リスト.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgv顧客リスト.RowHeadersDefaultCellStyle.Font,
                                              dgv顧客リスト.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_403抽出顧客一覧", "dgv顧客リスト_RowPostPaint", ex);
            }
        }

        private void btnCSVファイル出力_Click(object sender, EventArgs e)
        {
            try
            {
                //行が選択されていない場合はメッセージを表示
                if (mbMode == C_抽出顧客Mode.RFM分析 || mbMode == C_抽出顧客Mode.FM分析)
                {
                    if (dgvRFM顧客リスト.Rows.Count == 0)
                    {
                        MessageBox.Show(Properties.Resources.MSG_W_セルが選択されていません, this.Text, MessageBoxButtons.OK, 
                            MessageBoxIcon.Warning);
                        return;
                    }
                }
                else if (mbMode == C_抽出顧客Mode.顧客動向表)
                {
                    if (dgv顧客リスト.Rows.Count == 0)
                    {
                        MessageBox.Show(Properties.Resources.MSG_W_セルが選択されていません, this.Text, MessageBoxButtons.OK,
                            MessageBoxIcon.Warning);
                        return;
                    }
                }

                //ファイル参照ダイアログを表示する
                SaveFileDialog sfd = new SaveFileDialog();
                sfd.Filter = "CSV " + Properties.Resources.MSG_I_ファイル + "(*.csv)|*.csv";

                if (sfd.ShowDialog() != DialogResult.OK)
                    return;

				Cursor.Current = Cursors.WaitCursor;

				//グリッドの内容をCSV形式で出力する
                if (mbMode == C_抽出顧客Mode.RFM分析 || mbMode == C_抽出顧客Mode.FM分析)
				{
					//C06CSV.CreateCSVファイル(dgvRFM顧客リスト, sfd.FileName, true, 1, false, txt抽出条件.Text);
					if (C06CSV.CreateCSVファイル(dgvRFM顧客リスト, sfd.FileName, true, 1, false, "") == false)
						return;
				}
				else if (mbMode == C_抽出顧客Mode.顧客動向表)
				{
					//C06CSV.CreateCSVファイル(dgv顧客リスト, sfd.FileName, true, 1, false, txt抽出条件.Text);
					if (C06CSV.CreateCSVファイル(dgv顧客リスト, sfd.FileName, true, 1, false, "") == false)
						return;
				}

                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_007);

                MessageBox.Show(Properties.Resources.MSG_I_ファイル出力が完了しました, this.Text, MessageBoxButtons.OK, 
                    MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_403抽出顧客一覧", "btnCSVファイル出力_Click", ex);
            }
			finally
			{
				Cursor.Current = Cursors.Arrow;
			}
		}

        private void btnメール配信_Click(object sender, EventArgs e)
        {
            try
            {
                _205メール配信 _205メール配信 = null;
                _205メール配信 = new _205メール配信();
                C01FormCommon.画面最小サイズに変更(_205メール配信, false);

                //if (mbMode == mcbtMode_RFM分析 || mbMode == mcbtMode_FM分析)
                //    C02業務共通処理.メール宛先抽出(dgvRFM顧客リスト, 顧客リストRFMCell.byt顧客No, 
                //        顧客リストRFMCell.byt顧客ID, 顧客リストRFMCell.byt氏名, 
                //        顧客リストRFMCell.bytメールアドレス, ref _205メール配信.mdt宛先);
                //else if (mbMode == mcbtMode_顧客動向表)
                //    C02業務共通処理.メール宛先抽出(dgv顧客リスト, 顧客リストCell.byt顧客No, 
                //        顧客リストCell.byt顧客ID, 顧客リストCell.byt氏名, 
                //        顧客リストCell.bytメールアドレス, ref _205メール配信.mdt宛先);

                _205メール配信.ShowDialog();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_403抽出顧客一覧", "btnメール配信_Click", ex);
            }
        }

        private void dgvRFM顧客リスト_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgvRFM顧客リスト.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgvRFM顧客リスト.RowHeadersDefaultCellStyle.Font,
                                              dgvRFM顧客リスト.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_403抽出顧客一覧", "dgvRFM顧客リスト_RowPostPaint", ex);
            }
        }

        #endregion

    }
}
