﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using SystemCommon;


namespace 顧客分析君
{
    public partial class _203操作履歴 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        private class 検索条件
        {
            public DateTime 操作日fr { get; set; }
            public DateTime 操作日to { get; set; }
            public string 操作端末名 { get; set; }
            public string 操作スタッフ氏名 { get; set; }
            public string 操作画面 { get; set; }
            public string 操作内容 { get; set; }
        }

		//private enum enm販売履歴Cell
		//{
		//    操作日時 = 0,
		//    操作端末名 = 1,
		//    操作スタッフ氏名 = 2,
		//    操作画面 = 3,
		//    操作内容 = 4,
		//    登録スタッフNo = 5,
		//    登録日時 = 6,
		//    更新スタッフNo = 7,
		//    更新日時 = 8
		//}
		private static class 販売履歴Cell
		{
			//public const byte byt新規 = 0;
			public const byte byt操作日時 = 0;
			public const byte byt操作端末名 = 1;
			public const byte byt操作スタッフ氏名 = 2;
			public const byte byt操作画面 = 3;
			public const byte byt操作内容 = 4;
			//public const byte byt登録スタッフNo = 5;
			//public const byte byt登録日時 = 6;
			//public const byte byt更新スタッフNo = 7;
			//public const byte byt更新日時 = 8;
		}

		#endregion

        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド 
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _203操作履歴()
        {
            InitializeComponent();
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
		////////////////////////////////////////////////////////////////////////
		#region 非公開 共通メソッド Static


		#endregion


		#region 非公開 共通メソッド Non Static

		private void Set列幅()
        {
            dgv操作履歴.Columns[販売履歴Cell.byt操作日時].Width = C_列幅.日時;
            dgv操作履歴.Columns[販売履歴Cell.byt操作端末名].Width = C_列幅.端末名;
            dgv操作履歴.Columns[販売履歴Cell.byt操作スタッフ氏名].Width = C_列幅.氏名;
            dgv操作履歴.Columns[販売履歴Cell.byt操作画面].Width = C_列幅.画面名;
            dgv操作履歴.Columns[販売履歴Cell.byt操作内容].Width = C_列幅.操作内容;
			//dgv操作履歴.Columns[販売履歴Cell.byt登録スタッフNo].Visible = false;
			//dgv操作履歴.Columns[販売履歴Cell.byt登録日時].Visible = false;
			//dgv操作履歴.Columns[販売履歴Cell.byt更新スタッフNo].Visible = false;
			//dgv操作履歴.Columns[販売履歴Cell.byt更新日時].Visible = false;
        }

        private 検索条件 Get検索条件()
        {
            検索条件 row = new 検索条件();

            if (dtp操作日fr.Checked == true)
                row.操作日fr = dtp操作日fr.Value.Date;
            else
                row.操作日fr = dtp操作日fr.MinDate;

            if (dtp操作日to.Checked == true)
                row.操作日to = dtp操作日to.Value.Date.AddDays(1).AddSeconds(-1);
            else
                row.操作日to = dtp操作日to.MaxDate;

            if (txt操作端末名.Text == "")
                row.操作端末名 = null;
            else
                row.操作端末名 = txt操作端末名.Text;

            if (txt操作スタッフ氏名.Text == "")
                row.操作スタッフ氏名 = null;
            else
                row.操作スタッフ氏名 = txt操作スタッフ氏名.Text;

            if (txt操作画面.Text == "")
                row.操作画面 = null;
            else
                row.操作画面 = txt操作画面.Text;

            if (txt操作内容.Text == "")
                row.操作内容 = null;
            else
                row.操作内容 = txt操作内容.Text;

            return row;
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _110操作履歴_Load(object sender, EventArgs e)
        {
            try
            {
                //d14操作履歴ta.Fill(d14操作履歴._D14操作履歴);

            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_110操作履歴_Load", "_110操作履歴_Load", ex);
            }
            finally
            {
                Set列幅();
            }
        }

        private void btn検索条件をクリア_Click(object sender, EventArgs e)
        {
            try
            {
                dtp操作日fr.Value = DateTime.Today;
                dtp操作日to.Value = DateTime.Today;
                txt操作端末名.Text = "";
                txt操作スタッフ氏名.Text = "";
                txt操作画面.Text = "";
                txt操作内容.Text = "";
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_110操作履歴_Load", "btn検索条件をクリア_Click", ex);
            }
        }

        private void btn検索_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                d14操作履歴bs.DataSource = null;

                検索条件 row = Get検索条件();

                d14操作履歴ta.FillBy検索(d14操作履歴._D14操作履歴
                                        , row.操作日fr, row.操作日to
                                        , row.操作端末名, row.操作スタッフ氏名
                                        , row.操作画面, row.操作内容);

                if (d14操作履歴._D14操作履歴.Rows.Count == 0)
                    MessageBox.Show(Properties.Resources.MSG_W_データは見つかりませんでした, this.Text, MessageBoxButtons.OK, 
                        MessageBoxIcon.Warning);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_110操作履歴_Load", "btn検索_Click", ex);
            }
            finally
            {
                d14操作履歴bs.DataSource = d14操作履歴._D14操作履歴;
				lbl件数.Text = "検索結果：" + d14操作履歴._D14操作履歴.Count.ToString() + " 件";

                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn検索結果をクリア_Click(object sender, EventArgs e)
        {
            try
            {
                if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_検索結果をクリアしますか
                    , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
                    return;

                d14操作履歴._D14操作履歴.Clear();
				lbl件数.Text = "";
			}
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_110操作履歴_Load", "btn検索結果をクリア_Click", ex);
            }
        }

        private void btnCSVファイル出力_Click(object sender, EventArgs e)
        {
            try
            {
                if (dgv操作履歴.SelectedRows.Count == 0)
                {
                    MessageBox.Show(Properties.Resources.MSG_W_073, this.Text, MessageBoxButtons.OK, 
                        MessageBoxIcon.Warning);
                    return;
                }

                SaveFileDialog sfd = new SaveFileDialog();
                sfd.Filter = "CSV " + Properties.Resources.MSG_I_ファイル + "(*.csv)|*.csv";

                if (sfd.ShowDialog() != DialogResult.OK)
                    return;

                Cursor.Current = Cursors.WaitCursor;

				if (C06CSV.CreateCSVファイル(dgv操作履歴, sfd.FileName, true, 0, true, "") == false)
					return;

                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_007);

                MessageBox.Show(Properties.Resources.MSG_I_ファイル出力が完了しました, this.Text, MessageBoxButtons.OK, 
                    MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_110操作履歴_Load", "btnCSVファイル出力_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_110操作履歴_Load", "btnキャンセル_Click", ex);
            }
        }

        #endregion

    }
}
