﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

using SystemCommon;


namespace 顧客分析君
{
    public partial class _100初期化 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        public bool mb初期化 = false;   //　false：初期化に失敗　true：初期化に成功
		public string strDataPath;

        //コントロールの値を変更するためのデリゲート
        private delegate void DelegateSet初期化状況(string str処理詳細, int num);
        private delegate void DelegateFormClose();


        //別処理をするためのスレッド
        private System.Threading.Thread thread;

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド 
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _100初期化()
        {
            InitializeComponent();
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド

        private void CreateDBThread()
        {
            DelegateSet初期化状況 dlgSet初期化状況 = new DelegateSet初期化状況(D処理状況変更);

            if (DB初期化(dlgSet初期化状況, false, strDataPath) == false)
            {
                this.Invoke(dlgSet初期化状況
                    , new object[] { Properties.Resources.MSG_I_DBの初期化に失敗した為_SQLSERVERを再起動しています, 0 });

				C05DBCommon.SQLServer再起動(Properties.Settings.Default.SQLSERVER_MACHIN_NAME
					, Properties.Settings.Default.SQLSERVER_SERVICE_NAME);

                if (DB初期化(dlgSet初期化状況, true, strDataPath) == false)
                    mb初期化 = false;
            }

            DelegateFormClose dlgFormClose = new DelegateFormClose(DFormClose);
            this.Invoke(dlgFormClose);
        }

		//private bool CreateDB(DelegateSet初期化状況 dlgSet初期化状況, string strDataPath)
		//{
		//    //bool bStatus = true;
		//    String strSQL;
		//    SqlCommand scmd;
		//    SqlConnection scnMASTER = new SqlConnection(Properties.Settings.Default.MASTER);

		//    this.Invoke(dlgSet初期化状況, new object[] { Properties.Resources.MSG_I_DBファイルを作成中, 0 });

		//    try
		//    {
		//        //if (File.Exists(Properties.Settings.Default.DataPath + "\\KB2010.ldf") == true)
		//        //    File.Delete(Properties.Settings.Default.DataPath + "\\KB2010.ldf");

		//        //if (File.Exists(Properties.Settings.Default.DataPath + "\\KB2010.mdf") == true)
		//        //    File.Delete(Properties.Settings.Default.DataPath + "\\KB2010.mdf");

		//        strSQL = "                                                                       " +
		//                 "CREATE DATABASE KB2010 ON PRIMARY (                                    " +
		//                 "NAME = KB2010_Data,                                                    " +
		//                 "FILENAME = '" + Properties.Settings.Default.DataPath + "\\KB2010.mdf', " +
		//                 "SIZE = 100MB,                                                          " +
		//                 "MAXSIZE = UNLIMITED ,                                                  " +
		//                 "FILEGROWTH = 10%)                                                      " +
		//                 "LOG ON (NAME = KB2010_Log,                                             " +
		//                 "FILENAME = '" + Properties.Settings.Default.DataPath + "\\KB2010.ldf', " +
		//                 "SIZE = 100MB,                                                          " +
		//                 "MAXSIZE = 500MB,                                                       " +
		//                 "FILEGROWTH = 10%)                                                      ";
				

		//        scnMASTER.Open();
		//        scmd = new SqlCommand(strSQL, scnMASTER);
		//        scmd.ExecuteNonQuery();
		//    }
		//    catch (System.Exception ex)
		//    {
		//        C04システム共通.ErrorLog("_100初期化", "CreateDB", ex);
		//        return false;
		//    }
		//    finally
		//    {
		//        if (scnMASTER.State == ConnectionState.Open)
		//            scnMASTER.Close();
		//    }

		//    return true;
		//}

        private bool CreateSP(DelegateSet初期化状況 dlgSet初期化状況)
        {
            //bool bStatus = true;
            SqlCommand scmd;
            SqlConnection scnKB = new SqlConnection(Properties.Settings.Default.KB);

            this.Invoke(dlgSet初期化状況, new object[] { Properties.Resources.MSG_I_ストアドプロシージャを登録中, 0 });

            try
            {
                scnKB.Open();

                scmd = new SqlCommand(Properties.Resources.SP_DROP_SP, scnKB);
                scmd.ExecuteNonQuery();

                scmd = new SqlCommand(Properties.Resources.SP_DROP_TABLE, scnKB);
                scmd.ExecuteNonQuery();

                scmd = new SqlCommand(Properties.Resources.SP_CREATE_TABLE, scnKB);
                scmd.ExecuteNonQuery();

                scmd = new SqlCommand(Properties.Resources.SP_CREATE_INDEX, scnKB);
                scmd.ExecuteNonQuery();

                scmd = new SqlCommand(Properties.Resources.SP_INSERT_初期値, scnKB);
                scmd.ExecuteNonQuery();
            }
            catch (System.Exception ex)
            {
                C04システム共通.ErrorLog("_100初期化", "CreateSP", ex);
				return false;
			}
            finally
            {
                if (scnKB.State == ConnectionState.Open)
                    scnKB.Close();
            }

			return true;
		}

        private bool ExecSP(DelegateSet初期化状況 dlgSet初期化状況)
        {
            if (CreateSP(dlgSet初期化状況) == false)
                return false;

            this.Invoke(dlgSet初期化状況, new object[] { Properties.Resources.MSG_I_テーブルを登録中, 0 });

            if (C05DBCommon.ExecuteNonQuery("EXEC	SP_CREATE_TABLE"
                , Properties.Settings.Default.KB) == false)
                return false;

            this.Invoke(dlgSet初期化状況, new object[] { Properties.Resources.MSG_I_インデックスを登録中, 0 });

            if (C05DBCommon.ExecuteNonQuery("EXEC	SP_CREATE_INDEX"
                , Properties.Settings.Default.KB) == false)
                return false;

            this.Invoke(dlgSet初期化状況, new object[] { Properties.Resources.MSG_I_初期値を登録中, 0 });

            if (C05DBCommon.ExecuteNonQuery("EXEC	SP_INSERT_初期値"
                , Properties.Settings.Default.KB) == false)
                return false;

            return true;
        }


		private bool DB初期化(DelegateSet初期化状況 dlgSet初期化状況, bool bエラー通知, string strDataPath)
        {
            try
            {
				//if (C05DBCommon.IsExistDB(Properties.Settings.Default.MASTER, "KB2010") == false)
				//{
				//    if (CreateDB(dlgSet初期化状況, strDataPath) == false)
				//    {
				//        if (bエラー通知 == true)
				//            MessageBox.Show(Properties.Resources.MSG_ERR_004, this.Text
				//                , MessageBoxButtons.OK
				//                , MessageBoxIcon.Warning);

				//        return false;
				//    }
				//}

				//if (C05DBCommon.IsExistSP(Properties.Settings.Default.MASTER, "KB2010") == false)
				//{
                    if (ExecSP(dlgSet初期化状況) == false)
                    {
                        if (bエラー通知 == true)
                            MessageBox.Show(Properties.Resources.MSG_ERR_004, this.Text
                                , MessageBoxButtons.OK
                                , MessageBoxIcon.Warning);

                        return false;
                    }
				//}

                return true;
            }
            catch (Exception ex)
            {
                if (bエラー通知 == true)
                    C04システム共通.ErrorLog("_100初期化", "DB初期化", ex);

                return false;
            }
        }

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 非公開 delegateメソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 delegateメソッド

        private void D処理状況変更(string str処理詳細, int num)
        {
            lbl初期化中の処理詳細.Text = str処理詳細;
            pgs初期化.Value = num;
        }

        private void DFormClose()
        {
            this.Close();
        }

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _100初期化_Load(object sender, EventArgs e)
        {
            try
            {
                //CountUpメソッドを別スレッドで処理する
                thread = new System.Threading.Thread(new System.Threading.ThreadStart(CreateDBThread));
                thread.IsBackground = true;
                thread.Start();

                mb初期化 = true;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_100初期化", "_100初期化_Load", ex);
                mb初期化 = false;
            }
        }



        //private void btn初期化開始_Click(object sender, EventArgs e)
        //{
        //    try
        //    {
        //        mb初期化 = true;
        //        if (DB初期化(false) == false)
        //        {
        //            // 初期化に失敗したらSQLSERVERを再起動し、再度、初期化を試みる。
        //            C02業務共通処理.SQLServer再起動();

        //            if (DB初期化(true) == false)
        //                mb初期化 = false;
        //        }

        //        this.Close();
        //    }
        //    catch (Exception ex)
        //    {
        //        C04システム共通.ErrorLog("_100初期化", "btn初期化開始_Click", ex);
        //    }
        //}

        #endregion

    }
}
