﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using SystemCommon;


namespace 顧客分析君
{
    //TODO：Datetime.Now は全て、SQL上のgetdate()に置き換える。
    public partial class _502スタッフ詳細 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        public int miMode = 0;          // 0：通常　1：初回ログイン時のスタッフ登録
        public bool mb登録 = false;     // false：未登録　true：登録完了

        public int miスタッフNo = 0;
        public string mstrスタッフID = "";
        public string mstrパスワード = "";
        public int mi役職No = 0;
        public string mstr氏名 = "";
        public int mi権限No = 0;
        public string mstr備考 = "";

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _502スタッフ詳細()
        {
            InitializeComponent();
        }


        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド

        #endregion



        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _502スタッフ詳細_Load(object sender, EventArgs e)
        {
            try
            {
                this.d01権限ta.Fill(this.d01業務共通.D01権限);
                this.d01役職ta.Fill(this.d01業務共通.D01役職);

                txt氏名.Text = mstr氏名;
                txt備考.Text = mstr備考;
                txtスタッフID.Text = mstrスタッフID;
                txtパスワード.Text = mstrパスワード;
                txtパスワード確認.Text = mstrパスワード;

                if (mi役職No == 0)
                    cmb役職.SelectedIndex = 0;
                else
                    cmb役職.SelectedValue = mi役職No;

                txt氏名.Text = mstr氏名;

                if (mi権限No == 0)
                    cmb権限.SelectedIndex = 0;
                else
                    cmb権限.SelectedValue = mi権限No;

                txt備考.Text = mstr備考;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_502スタッフ詳細", "_502スタッフ詳細_Load", ex);
            }
        }

        private bool IsValidate()
        {
            if (txtスタッフID.Text == "")
            {
                MessageBox.Show(Properties.Resources.MSG_W_Aが入力されていません, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                this.ActiveControl = this.txtスタッフID;

                return false;
            }

            if (txtパスワード.Text == "")
            {
                MessageBox.Show(Properties.Resources.MSG_W_パスワードが入力されていません, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                this.ActiveControl = this.txtパスワード;
                return false;
            }

            if (cmb権限.Text == "")
            {
                MessageBox.Show(Properties.Resources.MSG_W_権限が選択されていません, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                this.ActiveControl = this.cmb権限;
                return false;
            }

            if (txt氏名.Text == "")
            {
                MessageBox.Show(Properties.Resources.MSG_W_氏名が入力されていません, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                this.ActiveControl = this.txt氏名;
                return false;
            }

            if (txtパスワード.Text != txtパスワード確認.Text)
            {
                MessageBox.Show(Properties.Resources.MSG_W_パスワードが一致していません, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                this.ActiveControl = this.txtパスワード;
                return false;
            }

            if (miスタッフNo == 0)
            {
                if (d12スタッフta.ScalarスタッフID重複チェック(txtスタッフID.Text) > 0)
                {
                    MessageBox.Show(Properties.Resources.MSG_W_スタッフIDが重複しています, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    this.ActiveControl = this.txtスタッフID;
                    return false;
                }

                if (d12スタッフta.Scalar氏名重複チェック(txt氏名.Text) > 0)
                {
                    MessageBox.Show(Properties.Resources.MSG_W_氏名が重複しています, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    this.ActiveControl = this.txt氏名;
                    return false;
                }
            }
            else
            {
                if (d12スタッフta.Scalar自分以外でスタッフID重複チェック(miスタッフNo, txtスタッフID.Text) > 0)
                {
                    MessageBox.Show(Properties.Resources.MSG_W_スタッフIDが重複しています, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    this.ActiveControl = this.txtスタッフID;
                    return false;
                }

                if (d12スタッフta.Scalar自分以外で氏名重複チェック(txt氏名.Text, miスタッフNo) > 0)
                {
                    MessageBox.Show(Properties.Resources.MSG_W_氏名が重複しています, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    this.ActiveControl = this.txt氏名;
                    return false;
                }
            }

            if (miMode == 1)
                if (cmb権限.Text != "管理者")
                {
                    MessageBox.Show(Properties.Resources.MSG_W_最初に登録するスタッフは_権限を管理者にしなければなりません, this.Text, MessageBoxButtons.OK
                        , MessageBoxIcon.Warning);
                    this.ActiveControl = this.cmb権限;
                    return false;
                }

            if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_入力した内容を登録しますか
                , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
                return false;

            return true;
        }

        private void btn確定_Click(object sender, EventArgs e)
        {
            try
            {
                if (IsValidate() == false)
                    return;

                if (miスタッフNo == 0)
                {
					//d12スタッフta.Insert(   txtスタッフID.Text, 
					//                        txtパスワード.Text, 
					//                        txt氏名.Text,
					//                        int.Parse(cmb役職.SelectedValue.ToString()),
					//                        int.Parse(cmb権限.SelectedValue.ToString()), 
					//                        txt備考.Text, 
					//                        C02業務共通処理.miログインスタッフNo);
					d12スタッフta.Insert(txtスタッフID.Text,
						txtパスワード.Text,
						txt氏名.Text,
						int.Parse(cmb役職.SelectedValue.ToString()),
						int.Parse(cmb権限.SelectedValue.ToString()),
						txt備考.Text,
						C02業務共通処理.miログインスタッフNo);


					if (miMode == 0)
					{
						//C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_020
						//    + "=" + txtスタッフID.Text);
						C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_020
							+ "=" + txtスタッフID.Text);
					}
                }
                else
                {
					//d12スタッフta.Update(txtスタッフID.Text, txtパスワード.Text, int.Parse(cmb役職.SelectedValue.ToString()), txt氏名.Text,
					//    int.Parse(cmb権限.SelectedValue.ToString()), txt備考.Text, C02業務共通処理.miログインスタッフNo, miスタッフNo);
					d12スタッフta.Update(txtスタッフID.Text, txtパスワード.Text, int.Parse(cmb役職.SelectedValue.ToString()), txt氏名.Text,
						int.Parse(cmb権限.SelectedValue.ToString()), txt備考.Text, C02業務共通処理.miログインスタッフNo, miスタッフNo);

					//C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_021
					//    + "=" + txtスタッフID.Text);
					C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_021
						+ "=" + txtスタッフID.Text);

                }

                mstrスタッフID = txtスタッフID.Text;
                mstrパスワード = txtパスワード.Text;

                mb登録 = true;

                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_502スタッフ詳細", "btn確定_Click", ex);
            }

        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_502スタッフ詳細", "btnキャンセル_Click", ex);
            }
        }

        #endregion

        private void d01業務共通BindingSource_CurrentChanged(object sender, EventArgs e)
        {

        }

    }
}
