﻿using System;
using System.Data;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.Drawing;
using Microsoft.VisualBasic.FileIO;
using System.Net;
using System.Net.Mail;
using System.Data.SqlClient;
using System.Reflection;

using SystemCommon;


namespace 顧客分析君
{
    class C02業務共通処理
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        //int mProcessID;
        //TraceSource mTraceSource;
		public static string mstr分析手法 = "";
		public static int miログインスタッフNo = 0;
		public static int miRFM分析 = 1;
		public static int miFM分析 = 2;


		////文字列判定処理にて使用する正規表現一覧
		////※C_正規表現と対になる
		//public string[] C01固定値.m正規表現配列 = {
		//    "",
		//    "^[ -~｡-ﾟ]*$",  /*半角文字*/
		//    "^[0-9]+$",     /*半角数字*/
		//    "^[あ-を０-９　]+$",   /*全角平仮名*/
		//    "^[ァ-ー０-９　]+$",   /*全角カタカナ*/
		//    @"^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,6})+$"   /*メールアドレス*/
		//    //@"^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,6})+$"   /*メールアドレス*/
		//};

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 共通メソッド 
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        //コンストラクタ
        public C02業務共通処理()
        {

        }

		//public string Get選択画面の選択アイテムNo(DataGridView dgv, int 列No)
		//{
		//    // in検索用にNo文字列を作成
		//    string str選択アイテムNo = "";
		//    for (int iRow = 0; iRow < dgv.RowCount; iRow++)
		//    {
		//        str選択アイテムNo += dgv.Rows[iRow].Cells[列No].Value.ToString() + ",";
		//    }

		//    // 最後の不要カンマを削除
		//    if (str選択アイテムNo.Length > 0)
		//        str選択アイテムNo = str選択アイテムNo.Substring(0, str選択アイテムNo.Length - 1);

		//    return str選択アイテムNo;
		//}

		///// <summary>
		///// 必須入力項目が未入力だった場合、入力欄の色を変える。
		///// </summary>
		//public Color Color変更_txt(System.Windows.Forms.TextBox txtColor変更対象, string str対象)
		//{
		//    if (str対象 == string.Empty)
		//        return txtColor変更対象.BackColor = Color.PeachPuff;

		//    else
		//        return txtColor変更対象.BackColor = Color.White;
		//}
		//public Color Color変更_cmb(System.Windows.Forms.ComboBox cmbColor変更対象, string str対象)
		//{
		//    if (str対象 == string.Empty)
		//        return cmbColor変更対象.BackColor = Color.PeachPuff;

		//    else
		//        return cmbColor変更対象.BackColor = Color.White;
		//}

        /// <summary>
        /// 正規表現と一致する対象が入力文字列内で見つかったかどうかを示します
        /// </summary>
		//public bool IsMatch(string value, C_正規表現 正規表現idx)
		//{
		//    return (Regex.IsMatch(value, C01固定値.m正規表現配列[(int)正規表現idx]));
		//}


		//public bool メール送信内容チェック(string strTo, string strFrom, string str控えメール送付先)
		//{

		//    string strTmp = strTo.Replace("\r\n", "\n");
		//    string[] strメールアドレス = strTmp.Split('\n');
		//    for (int iRow = 0; iRow < strメールアドレス.Length; iRow++)
		//    {
		//        if ((Regex.IsMatch(strメールアドレス[iRow], C01固定値.m正規表現配列[C_正規表現.メールアドレス]) == true) 
		//            || (strメールアドレス[iRow] == ""))
		//            continue;

		//        MessageBox.Show("「To」欄に入力された以下の文字列は、メールアドレスとして認識できません。\r\n\r\n"
		//            + strメールアドレス[iRow], Properties.Resources.MSG_TTL_入力エラー, MessageBoxButtons.OK, MessageBoxIcon.Warning);
		//        return false;
		//    }

		//    //if (Regex.IsMatch(strFrom, C01固定値.m正規表現配列[C_正規表現.メールアドレス]) == false)
		//    if ((Regex.IsMatch(strFrom, C01固定値.m正規表現配列[C_正規表現.メールアドレス]) == false) && (strFrom != ""))
		//    {
		//        MessageBox.Show("「From」欄に入力された以下の文字列は、メールアドレスとして認識できません。\r\n\r\n"
		//            + strFrom, Properties.Resources.MSG_TTL_入力エラー, MessageBoxButtons.OK, MessageBoxIcon.Warning);
		//        return false;
		//    }

		//    strTmp = str控えメール送付先.Replace("\r\n", "\n");
		//    strメールアドレス = strTmp.Split('\n');
		//    for (int iRow = 0; iRow < strメールアドレス.Length; iRow++)
		//    {
		//        if ((Regex.IsMatch(strメールアドレス[iRow], C01固定値.m正規表現配列[C_正規表現.メールアドレス]) == true) 
		//            || (strメールアドレス[iRow] == ""))
		//            continue;

		//        MessageBox.Show("「控えメール送付先」欄に入力された以下の文字列は、メールアドレスとして認識できません。\r\n\r\n"
		//            + strメールアドレス[iRow], Properties.Resources.MSG_TTL_入力エラー, MessageBoxButtons.OK, MessageBoxIcon.Warning);
		//        return false;
		//    }


		//    return true;
		//}

		//public bool メール送信内容チェック(string strTo, string strFrom, string str件名, string str本文, string str控えメール送付先)
		//{
		//    // エラーチェック
		//    if (strTo == "")
		//    {
		//        MessageBox.Show("To が入力されていません", Properties.Resources.MSG_TTL_入力エラー, MessageBoxButtons.OK, MessageBoxIcon.Warning);
		//        return false;
		//    }

		//    if (strFrom == "")
		//    {
		//        MessageBox.Show("From が入力されていません", Properties.Resources.MSG_TTL_入力エラー, MessageBoxButtons.OK, MessageBoxIcon.Warning);
		//        return false;
		//    }

		//    if (str件名 == "")
		//    {
		//        MessageBox.Show("件名 が入力されていません", Properties.Resources.MSG_TTL_入力エラー, MessageBoxButtons.OK, MessageBoxIcon.Warning);
		//        return false;
		//    }

		//    if (str本文 == "")
		//    {
		//        MessageBox.Show("本文 が入力されていません", Properties.Resources.MSG_TTL_入力エラー, MessageBoxButtons.OK, MessageBoxIcon.Warning);
		//        return false;
		//    }

		//    if (str控えメール送付先 == "")
		//    {
		//        MessageBox.Show("控えメール送付先 が入力されていません", Properties.Resources.MSG_TTL_入力エラー, MessageBoxButtons.OK, 
		//            MessageBoxIcon.Warning);
		//        return false;
		//    }

		//    string strTmp = strTo.Replace("\r\n", "\n");
		//    string[] strメールアドレス = strTmp.Split('\n');
		//    for (int iRow = 0; iRow < strメールアドレス.Length; iRow++)
		//    {
		//        if ((Regex.IsMatch(strメールアドレス[iRow], C01固定値.m正規表現配列[C_正規表現.メールアドレス]) == true) 
		//            || (strメールアドレス[iRow] == ""))
		//            continue;

		//        MessageBox.Show("「To」欄に入力された以下の文字列は、メールアドレスとして認識できません。\r\n\r\n"
		//            + strメールアドレス[iRow], Properties.Resources.MSG_TTL_入力エラー, MessageBoxButtons.OK, MessageBoxIcon.Warning);
		//        return false;
		//    }

		//    if (Regex.IsMatch(strFrom, C01固定値.m正規表現配列[C_正規表現.メールアドレス]) == false)
		//    {
		//        MessageBox.Show("「From」欄に入力された以下の文字列は、メールアドレスとして認識できません。\r\n\r\n"
		//            + strFrom, Properties.Resources.MSG_TTL_入力エラー, MessageBoxButtons.OK, MessageBoxIcon.Warning);
		//        return false;
		//    }

		//    strTmp = str控えメール送付先.Replace("\r\n", "\n");
		//    strメールアドレス = strTmp.Split('\n');
		//    for (int iRow = 0; iRow < strメールアドレス.Length; iRow++)
		//    {
		//        if ((Regex.IsMatch(strメールアドレス[iRow], C01固定値.m正規表現配列[C_正規表現.メールアドレス]) == true) 
		//            || (strメールアドレス[iRow] == ""))
		//            continue;

		//        MessageBox.Show("「控えメール送付先」欄に入力された以下の文字列は、メールアドレスとして認識できません。\r\n\r\n"
		//            + strメールアドレス[iRow], Properties.Resources.MSG_TTL_入力エラー, MessageBoxButtons.OK, MessageBoxIcon.Warning);
		//        return false;
		//    }

		//    return true;
		//}

		public static bool メール送信(string strTo, string strFrom, string str件名, string str本文)
        {
            MailMessage msg = new MailMessage(strFrom, strTo, str件名, str本文);
            SmtpClient sc = new SmtpClient(Properties.Settings.Default.SMTPサーバー, 
                int.Parse(Properties.Settings.Default.SMTPサーバーのポート番号));
            sc.Credentials = new System.Net.NetworkCredential(Properties.Settings.Default.ユーザーID, 
                Properties.Settings.Default.パスワード);
            sc.EnableSsl = false;
            sc.Send(msg);

            //後始末
            msg.Dispose();

            return true;
        }

		public static bool チェック閲覧権限(string str表示元画面名, string str表示先画面名)
        {
            D12スタッフTableAdapters.D12権限画面一覧ta ta = new D12スタッフTableAdapters.D12権限画面一覧ta();
            if (ta.Scalarチェック閲覧権限(C02業務共通処理.miログインスタッフNo, str表示先画面名) < 1)
            {
                MessageBox.Show(Properties.Resources.MSG_W_権限が無い為_画面を表示できません, str表示元画面名, MessageBoxButtons.OK,
                    MessageBoxIcon.Warning);
                return false;
            }

            return true;
        }

		//public bool チェック選択数(DataGridView dgv, int 列No, string str画面名, string str項目名)
		//{
		//    // この処理はバインドのバグによって使えない。
		//    //d16広告.D16広告検索Row[] dr = (d16広告.D16広告検索Row[])d16広告.D16広告検索.Select("選択 = True");
		//    // 妥協ロジック
		//    int i選択数 = 0;
		//    for (int iRow = 0; iRow < dgv.RowCount; iRow++)
		//    {
		//        if ((Boolean)dgv.Rows[iRow].Cells[列No].Value == true)
		//            i選択数++;
		//    }

		//    //チェックがされていなければエラー
		//    if (i選択数 < 1)
		//    {
		//        MessageBox.Show(string.Format(Properties.Resources.MSG_W_Aが選択されていません, str項目名)
		//            , str画面名, MessageBoxButtons.OK, MessageBoxIcon.Warning);

		//        dgv.Focus();
		//        return false;
		//    }

		//    return true;
		//}

		//public void DGV選択行削除(DataGridView dgv, string str画面名)
		//{
		//    if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_選択されいる行を削除しますか
		//        , str画面名, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
		//        return;

		//    foreach (DataGridViewRow dgvRow in dgv.SelectedRows)
		//    {
		//        if (!dgvRow.IsNewRow)
		//        {
		//            dgv.Rows.Remove(dgvRow);
		//        }
		//    }
		//}

		//public int Get年齢計算(DateTime dt誕生日)
		//{
		//    //DateTime dt今日 = DateTime.Now; //基準日
		//    long d1 = Convert.ToInt64(DateTime.Now.ToString("yyyyMMdd")); //基準日を数値に変換
		//    long d2 = Convert.ToInt64(dt誕生日.ToString("yyyyMMdd")); //誕生日を数値に変換
		//    return (int)Math.Floor((double)((d1 - d2) / 10000));
		//}

		public static int Get計算対象月数(Nullable<DateTime> dtFrom, Nullable<DateTime> dtTo)
        {
            D05計算.D05販売期間DataTable dt = new D05計算.D05販売期間DataTable();
            D05計算TableAdapters.D05販売期間ta ta = new D05計算TableAdapters.D05販売期間ta();
            ta.Fill(dt, dtFrom, dtTo);

            bool b未満 = true;
            int int月数 = 0;
            int int年月カウント用 = 0;
            int int終了年月 = int.Parse(dt[0].販売日時MAX.Year.ToString() + dt[0].販売日時MAX.Month.ToString("00"));
            do
            {
                int年月カウント用 = int.Parse(dt[0].販売日時MIN.AddMonths(int月数).Year.ToString()
                    + dt[0].販売日時MIN.AddMonths(int月数).Month.ToString("00"));

                if (int年月カウント用 < int終了年月)
                    int月数++;
                else
                    b未満 = false;
            }
            while (b未満 == true);

            return int月数;
        }

		public static DateTime Get最大販売日時(Nullable<DateTime> dtFrom, Nullable<DateTime> dtTo)
        {
            D05計算.D05販売期間DataTable dt = new D05計算.D05販売期間DataTable();
            D05計算TableAdapters.D05販売期間ta ta = new D05計算TableAdapters.D05販売期間ta();
            ta.Fill(dt, dtFrom, dtTo);
            return dt[0].販売日時MAX;
        }

		public static DateTime Get最小販売日時(Nullable<DateTime> dtFrom, Nullable<DateTime> dtTo)
        {
            D05計算.D05販売期間DataTable dt = new D05計算.D05販売期間DataTable();
            D05計算TableAdapters.D05販売期間ta ta = new D05計算TableAdapters.D05販売期間ta();
            ta.Fill(dt, dtFrom, dtTo);
            return dt[0].販売日時MIN;
        }


		public static int Get商品No(string str商品ID, string str商品名, long int商品単価)
        {
            D03販売履歴TableAdapters.D03商品ta d03商品ta = new D03販売履歴TableAdapters.D03商品ta();

            // 商品IDが、M02商品に登録されているかチェック
            if ((int)d03商品ta.Scalar同一商品ID(str商品ID) == 0)
            {
                //登録されていなかったら、新商品として、M02商品に登録。
                //d03商品ta.Insert(str商品ID, str商品名, int商品単価);
                D06商品一覧TableAdapters.D06商品マスタta d06商品マスタta = new 顧客分析君.D06商品一覧TableAdapters.D06商品マスタta();
                d06商品マスタta.Insert(str商品ID, str商品名, int商品単価, miログインスタッフNo);
            }

            D03販売履歴.D03商品DataTable dt商品 = new D03販売履歴.D03商品DataTable();
            d03商品ta.FillBy商品No取得(dt商品, str商品ID);
            return dt商品[0].商品No;
        }

		public static int Get性別No(string str性別名)
        {
            //if (str性別名 == "")
            //{
            //    //TODO：メソッドパラメータを追加して、null を返すか 0 を返すか切り替えた方が良いかも。
            //    //return null;
            //    return 0;
            //}
            if (str性別名 == null)
                str性別名 = "";

            D01業務共通TableAdapters.D01属性ta ta = new D01業務共通TableAdapters.D01属性ta();
            return (int)ta.Scalar属性No(C_属性区分.性別, str性別名);
        }

		public static int Getメルマガ許諾No(int iメルマガ許諾No, string strメルマガ許諾名)
        {
            if (iメルマガ許諾No != 0)
                return iメルマガ許諾No;

            if (strメルマガ許諾名 == null)
                strメルマガ許諾名 = "";

            D01業務共通TableAdapters.D01属性ta ta = new D01業務共通TableAdapters.D01属性ta();
            return (int)ta.Scalar属性No(C_属性区分.メルマガ許諾, strメルマガ許諾名);
        }

		public static int Getメルマガ許諾No(string strメルマガ許諾名)
        {
            if (strメルマガ許諾名 == null)
                strメルマガ許諾名 = "";

            D01業務共通TableAdapters.D01属性ta ta = new D01業務共通TableAdapters.D01属性ta();
            return (int)ta.Scalar属性No(C_属性区分.メルマガ許諾, strメルマガ許諾名);
        }

		public static int GetバウンドNo(int iバウンドNo, string strバウンド名)
        {
            if (iバウンドNo != 0)
                return iバウンドNo;

            if (strバウンド名 == null)
                strバウンド名 = "";

            D01業務共通TableAdapters.D01属性ta ta = new D01業務共通TableAdapters.D01属性ta();
            return (int)ta.Scalar属性No(C_属性区分.バウンド, strバウンド名);
        }

		public static int Get補足名No(string str補足名)
        {
            if (str補足名 == null)
                str補足名 = "";

            D01業務共通TableAdapters.D01属性ta ta = new D01業務共通TableAdapters.D01属性ta();
            return (int)ta.Scalar属性No(C_属性区分.顧客補足情報, str補足名);
        }

		public static int GetPR区分No(string strPR区分名)
        {
            if (strPR区分名 == null)
                strPR区分名 = "";

            D01業務共通TableAdapters.D01属性ta ta = new D01業務共通TableAdapters.D01属性ta();
            return (int)ta.Scalar属性No(C_属性区分.PR区分名, strPR区分名);
        }

		public static int GetツールNo(int iツールNo, string strツール名)
        {
            if (iツールNo != 0)
                return iツールNo;

            if (strツール名 == null)
                strツール名 = "";

            D01業務共通TableAdapters.D01属性ta ta = new D01業務共通TableAdapters.D01属性ta();
            return (int)ta.Scalar属性No(C_属性区分.ツール, strツール名);
        }

		public static int GetコンタクトスタッフNo(int iコンタクトスタッフNo, string strコンタクトスタッフ名)
        {
            if (iコンタクトスタッフNo != 0)
                return iコンタクトスタッフNo;

            if (strコンタクトスタッフ名 == null)
                strコンタクトスタッフ名 = "";

            D12スタッフTableAdapters.D12スタッフta ta = new D12スタッフTableAdapters.D12スタッフta();
            Nullable<int> iスタッフNo = ta.ScalarスタッフNo(strコンタクトスタッフ名);

            if (iスタッフNo == null)
                return 0;
            else
                return (int)iスタッフNo;
        }

		public static int Get顧客No(string str顧客ID)
        {
            D10顧客TableAdapters.D10顧客ta d10顧客ta = new D10顧客TableAdapters.D10顧客ta();

            // 顧客IDが、M03顧客に登録されているかチェック
            // 登録されていない場合、顧客一覧画面の登録処理で保管。ここでは顧客の新規登録は行わず、M03顧客の更新処理で、H01販売履歴の顧客Noを更新する
            D10顧客.D10顧客DataTable dt顧客 = new D10顧客.D10顧客DataTable();
            d10顧客ta.FillBy顧客No取得(dt顧客, str顧客ID);

            if (dt顧客.Count > 0)
                return dt顧客[0].顧客No;
            else
            {
                //return 0;
                D10顧客TableAdapters.D10顧客2ta d10顧客2ta = new D10顧客TableAdapters.D10顧客2ta();

                d10顧客2ta.Insert(str顧客ID,
                                  "",
                                  "",
                                  1,
                                  DateTime.Parse("1900/1/1"),
                                  "",
                                  "",
                                  "",
                                  "",
                                  1,
                                  "",
                                  C02業務共通処理.miログインスタッフNo);

                d10顧客ta.FillBy顧客No取得(dt顧客, str顧客ID);
                return dt顧客[0].顧客No;
            }
        }

		public static void 顧客抽出RFM(byte[] bR, byte[] bF, byte[] bM, D10顧客.D10RFM顧客抽出DataTable dtRFM顧客抽出
            , ref string str抽出条件)
        {
            str抽出条件 = "RFM：";

            D10顧客TableAdapters.D10RFM顧客抽出ta ta = new 顧客分析君.D10顧客TableAdapters.D10RFM顧客抽出ta();
            D10顧客.D10RFM顧客抽出DataTable dt = new D10顧客.D10RFM顧客抽出DataTable();
            for (int iCnt = 0; iCnt < bR.Length; iCnt++)
            {
                str抽出条件 += " " + bR[iCnt].ToString() + "," + bF[iCnt].ToString()
                    + "," + bM[iCnt].ToString();

                ta.Fill(dt, bR[iCnt], bF[iCnt], bM[iCnt]);
                dtRFM顧客抽出.Merge(dt);
            }

        }

		public static void 顧客抽出FM(byte[] bF, byte[] bM, short s年, byte b月, D10顧客.D10RFM顧客抽出DataTable dtRFM顧客抽出
            , ref string str抽出条件)
        {
            str抽出条件 = "FM：";

            D10顧客TableAdapters.D10RFM顧客抽出ta ta = new 顧客分析君.D10顧客TableAdapters.D10RFM顧客抽出ta();
            D10顧客.D10RFM顧客抽出DataTable dt = new D10顧客.D10RFM顧客抽出DataTable();
            for (int iCnt = 0; iCnt < bF.Length; iCnt++)
            {
                ta.FillByFM分析からの抽出(dt, bF[iCnt], bM[iCnt], s年, b月);

                //抽出条件表示
                str抽出条件 += " " + bF[iCnt].ToString() + "," + bM[iCnt].ToString();

                dtRFM顧客抽出.Merge(dt);
            }
        }

        // 最新日時を持つ商品名・単価で、M02商品を更新
        public static void M02商品を更新()
        {
            D03販売履歴TableAdapters.D03商品ta d03商品ta = new D03販売履歴TableAdapters.D03商品ta();
            D03販売履歴TableAdapters.D03販売履歴ta d03販売履歴ta = new D03販売履歴TableAdapters.D03販売履歴ta();

            D03販売履歴.D03商品DataTable dt商品 = new D03販売履歴.D03商品DataTable();
            //d03商品ta.Fill(dt商品);
			d03商品ta.FillBy直近変更販売履歴(dt商品);

            D03販売履歴.D03販売履歴DataTable dt販売履歴 = new D03販売履歴.D03販売履歴DataTable();
            for (int iRow = 0; iRow < dt商品.Count; iRow++)
            {
                d03販売履歴ta.FillBy最新商品情報(dt販売履歴, dt商品[iRow].商品No);
                if (dt販売履歴.Count < 1)
                    continue;

                d03商品ta.Update(dt販売履歴[0].商品名, dt販売履歴[0].商品単価, dt商品[iRow].商品No);
            }
        }

		public static void Insert操作履歴(string str操作画面名, string str操作内容)
        {
            if (miログインスタッフNo == 0)
                return;

            D12スタッフTableAdapters.D12スタッフta taスタッフ = new D12スタッフTableAdapters.D12スタッフta();
            D14操作履歴TableAdapters.D14操作履歴ta ta = new D14操作履歴TableAdapters.D14操作履歴ta();
            ta.Insert(Dns.GetHostName(), 
                taスタッフ.Scalar氏名(miログインスタッフNo), 
                str操作画面名, 
                str操作内容, 
                miログインスタッフNo);
        }

		//public void 画面最小サイズに変更(object pClass, bool bメイン画面)
		//{
		//    if (bメイン画面 == true)
		//        画面最小サイズに変更(pClass, C_画面最小サイズ.メイン_縦, C_画面最小サイズ.メイン_幅);
		//    else
		//        画面最小サイズに変更(pClass, C_画面最小サイズ.その他_縦, C_画面最小サイズ.その他_幅);
		//}

		//public void 画面最小サイズに変更(object pClass, int i縦, int i幅)
		//{
		//    if (((Form)pClass).Height < i縦)
		//        ((Form)pClass).Height = i縦;

		//    if (((Form)pClass).Width < i幅)
		//        ((Form)pClass).Width = i幅;
		//}

		//public string NULLを空文字に変換(object str)
		//{
		//    if (str == null)
		//        return "";
		//    else
		//        return (string)str;
		//}

        public static void 未登録顧客の顧客Noを0にする()
        {
            D03販売履歴TableAdapters.D03販売履歴ta ta = new 顧客分析君.D03販売履歴TableAdapters.D03販売履歴ta();
            ta.Update未登録顧客の顧客Noを0にする();
        }


        #endregion


		//////////////////////////////////////////////////////////////////////////
		//// TextBox用
		//////////////////////////////////////////////////////////////////////////
		//#region TextBox用

		///// <summary>
		///// 符号無し数値チェックを行う。<br/>
		///// 各グリッドの CellValidating イベント、RowValidating イベント等で使用する。
		///// </summary>
		///// <param name="value">判定元データ</param>
		///// <param name="strName">判定対象のオブジェクト名</param>
		///// <returns>検証に成功した場合は true。失敗した場合は false を返す。</returns>
		//public bool IsValidate符号無し数値型(string stValue, string strName)
		//{
		//    long res;
		//    bool bStatus = true;
		//    if (!long.TryParse(stValue, out res))
		//            bStatus = false;
		//    else if (res < 0)
		//            bStatus  = false;

		//    if (bStatus == true)
		//        return true;
		//    else
		//    {
		//        string strErrMsg = string.Format(Properties.Resources.MSG_W_Aには_0_999999999_の値のみ_入力することができます, strName);
		//        MessageBox.Show(strErrMsg, Properties.Resources.MSG_TTL_入力エラー, MessageBoxButtons.OK, MessageBoxIcon.Warning);
		//        return false;
		//    }
		//}

		///// <summary>
		///// 年齢チェックを行う。<br/>
		///// 各グリッドの CellValidating イベント、RowValidating イベント等で使用する。
		///// </summary>
		///// <param name="value">判定元データ</param>
		///// <param name="strName">判定対象のオブジェクト名</param>
		///// <returns>検証に成功した場合は true。失敗した場合は false を返す。</returns>
		//public bool IsValidate年齢型(string stValue, string strName)
		//{
		//    int res;
		//    bool bStatus = true;
		//    if (!int.TryParse(stValue, out res))
		//        bStatus = false;
		//    else if (res < 0 || 150 < res)
		//        bStatus = false;

		//    if (bStatus == true)
		//        return true;
		//    else
		//    {
		//        string strErrMsg = string.Format(Properties.Resources.MSG_W_Aには_0_150以外の値を入力できません, strName);
		//        MessageBox.Show(strErrMsg, Properties.Resources.MSG_TTL_入力エラー, MessageBoxButtons.OK, MessageBoxIcon.Warning);
		//        return false;
		//    }
		//}

		///// <summary>
		///// 日時チェックを行う。<br/>
		///// </summary>
		///// <param name="value">判定元データ</param>
		///// <param name="strName">判定対象のオブジェクト名</param>
		///// <returns>検証に成功した場合は true。失敗した場合は false を返す。</returns>
		//public bool IsValidate日時(string stValue, string strName)
		//{
		//    DateTime dt;
		//    if (DateTime.TryParse(stValue, out dt) == false)
		//    {
		//        string strErrMsg = string.Format(Properties.Resources.MSG_W_Aが日付として正しくありません, strName);
		//        MessageBox.Show(strErrMsg, Properties.Resources.MSG_TTL_入力エラー, MessageBoxButtons.OK, MessageBoxIcon.Warning);
		//        return false;
		//    }

		//    return true;
		//}

		///// <summary>
		///// 半角英数チェックを行う。<br/>
		///// </summary>
		///// <param name="value">判定元データ</param>
		///// <param name="strName">判定対象のオブジェクト名</param>
		///// <returns>検証に成功した場合は true。失敗した場合は false を返す。</returns>
		//public bool IsValidate半角英数(string stValue, string strName)
		//{
		//    if (!C10Validate.IsMatch(stValue, C_正規表現.半角英数))
		//    {
		//        string strErrMsg = string.Format(Properties.Resources.MSG_WAR_Aには半角英数のみ入力することができます, strName);
		//        MessageBox.Show(strErrMsg, Properties.Resources.MSG_TTL_入力エラー, MessageBoxButtons.OK, MessageBoxIcon.Warning);
		//        return false;
		//    }

		//    return true;
		//}

		///// <summary>
		///// 全角カナチェックを行う。<br/>
		///// </summary>
		///// <param name="value">判定元データ</param>
		///// <param name="strName">判定対象のオブジェクト名</param>
		///// <returns>検証に成功した場合は true。失敗した場合は false を返す。</returns>
		//public bool IsValidate全角カナ型(string stValue, string strName)
		//{
		//    if (!C10Validate.IsMatch(stValue, C_正規表現.全角カタカナ))
		//    {
		//        string strErrMsg = string.Format(Properties.Resources.MSG_W_Aは全角カタカナで入力してください, strName);
		//        MessageBox.Show(strErrMsg, Properties.Resources.MSG_TTL_入力エラー, MessageBoxButtons.OK, MessageBoxIcon.Warning);
		//        return false;
		//    }

		//    return true;
		//}

		//#endregion

		//////////////////////////////////////////////////////////////////////////
		//// DataGridView用
		//////////////////////////////////////////////////////////////////////////
		//#region DataGridView用

		///// <summary>
		///// グリッドビューの入力項目に対する必須チェックを行う。<br/>
		///// 各グリッドの CellValidating イベント、RowValidating イベント等で使用する。
		///// </summary>
		///// <param name="grid">判定元となるグリッドビューを指定する</param>
		///// <param name="rowIndex">判定対象の RowIndex を指定する</param>
		///// <param name="colIndex">判定対象の ColumnIndex を指定する</param>
		///// <param name="value">判定対象の値を指定する</param>
		///// <returns>検証に成功した場合は true。失敗した場合は false を返す。</returns>
		//public bool IsValidateCell必須入力(DataGridView grid, int rowIndex, int colIndex, string value)
		//{
		//    grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Empty;

		//    if (value.Trim() == string.Empty)
		//    {
		//        grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Format(Properties.Resources.MSG_W_Aは必須入力です, 
		//            grid.Columns[colIndex].HeaderText);

		//        return false;
		//    }
		//    return true;
		//}
		///// <summary>
		///// グリッドビューの入力項目に対するNo型チェックを行う。<br/>
		///// 各グリッドの CellValidating イベント、RowValidating イベント等で使用する。
		///// </summary>
		///// <param name="grid">判定元となるグリッドビューを指定する</param>
		///// <param name="rowIndex">判定対象の RowIndex を指定する</param>
		///// <param name="colIndex">判定対象の ColumnIndex を指定する</param>
		///// <param name="value">判定対象の値を指定する</param>
		///// <returns>検証に成功した場合は true。失敗した場合は false を返す。</returns>
		//public bool IsValidateCellNo型(DataGridView grid, int rowIndex, int colIndex, string value)
		//{
		//    grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Empty;

		//    int res;
		//    if (!int.TryParse(value, out res))
		//    {
		//        grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Format(Properties.Resources.MSG_W_AタブのBに_半角数値以外が入力されています, 
		//            grid.Columns[colIndex].HeaderText);
		//        return false;
		//    }

		//    if (res < 0)
		//    {
		//        grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Format(Properties.Resources.MSG_W_AタブのBに_半角数値以外が入力されています, 
		//            grid.Columns[colIndex].HeaderText);
		//        return false;
		//    }

		//    return true;
		//}
		///// <summary>
		///// グリッドビューの入力項目に対する日付型チェックを行う。<br/>
		///// 各グリッドの CellValidating イベント、RowValidating イベント等で使用する。
		///// </summary>
		///// <param name="grid">判定元となるグリッドビューを指定する</param>
		///// <param name="rowIndex">判定対象の RowIndex を指定する</param>
		///// <param name="colIndex">判定対象の ColumnIndex を指定する</param>
		///// <param name="value">判定対象の値を指定する</param>
		///// <returns>検証に成功した場合は true。失敗した場合は false を返す。</returns>
		//public bool IsValidateCell日付型(DataGridView grid, int rowIndex, int colIndex, string value)
		//{
		//    grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Empty;

		//    DateTime res;
		//    if (!DateTime.TryParseExact(value, "yyyy/MM/dd", null, System.Globalization.DateTimeStyles.None, out res))
		//    {
		//        grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Format(Properties.Resources.MSG_W_AはBの形式で入力してください, 
		//            grid.Columns[colIndex].HeaderText);
		//        return false;
		//    }
		//    return true;
		//}
		///// <summary>
		///// グリッドビューの入力項目に対する日時型チェックを行う。<br/>
		///// 各グリッドの CellValidating イベント、RowValidating イベント等で使用する。
		///// </summary>
		///// <param name="grid">判定元となるグリッドビューを指定する</param>
		///// <param name="rowIndex">判定対象の RowIndex を指定する</param>
		///// <param name="colIndex">判定対象の ColumnIndex を指定する</param>
		///// <param name="value">判定対象の値を指定する</param>
		///// <returns>検証に成功した場合は true。失敗した場合は false を返す。</returns>
		//public bool IsValidateCell日時型(DataGridView grid, int rowIndex, int colIndex, string value)
		//{
		//    grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Empty;

		//    DateTime res;
		//    //if (!DateTime.TryParseExact(value, "yyyy/MM/dd hh:mm:ss", null, System.Globalization.DateTimeStyles.None, out res))
		//    if (!DateTime.TryParse(value, out res))
		//    {
		//        grid.Rows[rowIndex].Cells[colIndex].ErrorText
		//            = string.Format(Properties.Resources.MSG_W_AはBの形式で入力してください, grid.Columns[colIndex].HeaderText);
		//        return false;
		//    }
		//    //else if (res.Year > C_最大値.年)
		//    else if (res.Year < C_最小値.年 || C_最大値.年 < res.Year)
		//    {
		//        //grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Format(Properties.Resources.MSG_INF_080, C_最大値.年);
		//        grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Format(Properties.Resources.MSG_W_Aには_B_C年以外の値を_入力できません
		//            , "販売日時", C_最小値.年, C_最大値.年);
		//        return false;
		//    }

		//    return true;
		//}

		///// <summary>
		///// グリッドビューの入力項目に対する通貨型チェックを行う。<br/>
		///// 各グリッドの CellValidating イベント、RowValidating イベント等で使用する。
		///// </summary>
		///// <param name="grid">判定元となるグリッドビューを指定する</param>
		///// <param name="rowIndex">判定対象の RowIndex を指定する</param>
		///// <param name="colIndex">判定対象の ColumnIndex を指定する</param>
		///// <param name="value">判定対象の値を指定する</param>
		///// <returns>検証に成功した場合は true。失敗した場合は false を返す。</returns>
		//public bool IsValidateCell通貨型(DataGridView grid, int rowIndex, int colIndex, string value)
		//{
		//    grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Empty;

		//    decimal res;
		//    if (!decimal.TryParse(value, NumberStyles.AllowThousands | NumberStyles.AllowDecimalPoint, null, out res))
		//    {
		//        grid.Rows[rowIndex].Cells[colIndex].ErrorText
		//            = string.Format(Properties.Resources.MSG_W_Aには_0_Bまでの値以外を入力できません, grid.Columns[colIndex].HeaderText, (long)C_最大値.販売金額);
		//        return false;
		//    }
		//    return true;
		//}
		///// <summary>
		///// グリッドビューの入力項目に対する符号付数値チェックを行う。<br/>
		///// 各グリッドの CellValidating イベント、RowValidating イベント等で使用する。
		///// </summary>
		///// <param name="grid">判定元となるグリッドビューを指定する</param>
		///// <param name="rowIndex">判定対象の RowIndex を指定する</param>
		///// <param name="colIndex">判定対象の ColumnIndex を指定する</param>
		///// <param name="value">判定対象の値を指定する</param>
		///// <returns>検証に成功した場合は true。失敗した場合は false を返す。</returns>
		//public bool IsValidateCell符号付数値型(DataGridView grid, int rowIndex, int colIndex, string value)
		//{
		//    grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Empty;

		//    int res;
		//    if (!int.TryParse(value, out res))
		//    {
		//        grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Format(Properties.Resources.MSG_W_Aには_0_999999999_の値のみ_入力することができます, 
		//            grid.Columns[colIndex].HeaderText);
		//        return false;
		//    }
		//    return true;
		//}
		///// <summary>
		///// グリッドビューの入力項目に対する符号付数値チェックを行う。<br/>
		///// 各グリッドの CellValidating イベント、RowValidating イベント等で使用する。
		///// </summary>
		///// <param name="grid">判定元となるグリッドビューを指定する</param>
		///// <param name="rowIndex">判定対象の RowIndex を指定する</param>
		///// <param name="colIndex">判定対象の ColumnIndex を指定する</param>
		///// <param name="value">判定対象の値を指定する</param>
		///// <returns>検証に成功した場合は true。失敗した場合は false を返す。</returns>
		//public bool IsValidateCell符号無し数値型(DataGridView grid, int rowIndex, int colIndex, string value)
		//{
		//    grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Empty;

		//    long res;
		//    if (!long.TryParse(value, out res))
		//    {
		//        grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Format(Properties.Resources.MSG_W_Aには_0_999999999_の値のみ_入力することができます, 
		//            grid.Columns[colIndex].HeaderText);
		//        return false;
		//    }
		//    else
		//    {
		//        if (res < 0)
		//        {
		//            grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Format(Properties.Resources.MSG_W_Aには_0_999999999_の値のみ_入力することができます, 
		//                grid.Columns[colIndex].HeaderText);
		//            return false;
		//        }
		//    }

		//    return true;
		//}
		///// <summary>
		///// グリッドビューの入力項目に対する、年齢チェックを行う。<br/>
		///// 各グリッドの CellValidating イベント、RowValidating イベント等で使用する。
		///// </summary>
		///// <param name="grid">判定元となるグリッドビューを指定する</param>
		///// <param name="rowIndex">判定対象の RowIndex を指定する</param>
		///// <param name="colIndex">判定対象の ColumnIndex を指定する</param>
		///// <param name="value">判定対象の値を指定する</param>
		///// <returns>検証に成功した場合は true。失敗した場合は false を返す。</returns>
		//public bool IsValidateCell年齢型(DataGridView grid, int rowIndex, int colIndex, string value)
		//{
		//    grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Empty;

		//    int res;
		//    if (!int.TryParse(value, out res))
		//    {
		//        grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Format(Properties.Resources.MSG_W_Aには_0_150以外の値を入力できません,
		//            grid.Columns[colIndex].HeaderText);
		//        return false;
		//    }
		//    else
		//    {
		//        if (res < 0 || 150 < res)
		//        {
		//            grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Format(Properties.Resources.MSG_W_Aには_0_150以外の値を入力できません,
		//                grid.Columns[colIndex].HeaderText);
		//            return false;
		//        }
		//    }

		//    return true;
		//}
		///// <summary>
		///// グリッドビューの入力項目に対する半角文字チェックを行う。<br/>
		///// 各グリッドの CellValidating イベント、RowValidating イベント等で使用する。
		///// </summary>
		///// <param name="grid">判定元となるグリッドビューを指定する</param>
		///// <param name="rowIndex">判定対象の RowIndex を指定する</param>
		///// <param name="colIndex">判定対象の ColumnIndex を指定する</param>
		///// <param name="value">判定対象の値を指定する</param>
		///// <returns>検証に成功した場合は true。失敗した場合は false を返す。</returns>
		//public bool IsValidateCell禁止文字(DataGridView grid, int rowIndex, int colIndex, string value)
		//{
		//    grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Empty;

		//    Encoding enc = Encoding.GetEncoding("Shift_JIS");

		//    string str禁止文字 = "'";
		//    if (Regex.IsMatch(value, str禁止文字))
		//    {
		//        grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Format(Properties.Resources.MSG_W_AにBを使用することはできません,
		//            grid.Columns[colIndex].HeaderText, str禁止文字);
		//        return false;
		//    }
		//    return true;
		//}
		///// <summary>
		///// グリッドビューの入力項目に対する半角文字チェックを行う。<br/>
		///// 各グリッドの CellValidating イベント、RowValidating イベント等で使用する。
		///// </summary>
		///// <param name="grid">判定元となるグリッドビューを指定する</param>
		///// <param name="rowIndex">判定対象の RowIndex を指定する</param>
		///// <param name="colIndex">判定対象の ColumnIndex を指定する</param>
		///// <param name="value">判定対象の値を指定する</param>
		///// <returns>検証に成功した場合は true。失敗した場合は false を返す。</returns>
		//public bool IsValidateCell半角入力(DataGridView grid, int rowIndex, int colIndex, string value)
		//{
		//    grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Empty;

		//    Encoding enc = Encoding.GetEncoding("Shift_JIS");

		//    if (value.Length != enc.GetByteCount(value))
		//    {
		//        grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Format(Properties.Resources.MSG_WAR_Aには半角英数のみ入力することができます, 
		//            grid.Columns[colIndex].HeaderText);
		//        return false;
		//    }
		//    return true;
		//}
		///// <summary>
		///// グリッドビューの入力項目に対する、全角カナチェックを行う。<br/>
		///// 各グリッドの CellValidating イベント、RowValidating イベント等で使用する。
		///// </summary>
		///// <param name="grid">判定元となるグリッドビューを指定する</param>
		///// <param name="rowIndex">判定対象の RowIndex を指定する</param>
		///// <param name="colIndex">判定対象の ColumnIndex を指定する</param>
		///// <param name="value">判定対象の値を指定する</param>
		///// <returns>検証に成功した場合は true。失敗した場合は false を返す。</returns>
		//public bool IsValidateCell全角カナ(DataGridView grid, int rowIndex, int colIndex, string value)
		//{
		//    grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Empty;

		//    if (!C10Validate.IsMatch(value, C_正規表現.全角カタカナ))
		//    {
		//        grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Format(Properties.Resources.MSG_W_Aは全角カタカナで入力してください,
		//            grid.Columns[colIndex].HeaderText);
		//        return false;
		//    }
		//    return true;
		//}

		///// <summary>
		///// グリッドビューの入力項目に対する、全角カナチェックを行う。<br/>
		///// 各グリッドの CellValidating イベント、RowValidating イベント等で使用する。
		///// </summary>
		///// <param name="grid">判定元となるグリッドビューを指定する</param>
		///// <param name="rowIndex">判定対象の RowIndex を指定する</param>
		///// <param name="colIndex">判定対象の ColumnIndex を指定する</param>
		///// <param name="value">判定対象の値を指定する</param>
		///// <returns>検証に成功した場合は true。失敗した場合は false を返す。</returns>
		//public bool IsValidateCellメールアドレス(DataGridView grid, int rowIndex, int colIndex, string value)
		//{
		//    grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Empty;

		//    if (!C10Validate.IsMatch(value, C_正規表現.メールアドレス))
		//    {
		//        grid.Rows[rowIndex].Cells[colIndex].ErrorText = 
		//            string.Format(Properties.Resources.MSG_W_AはBでなければなりません, grid.Columns[colIndex].HeaderText, C_正規表現.メールアドレス);
		//        return false;
		//    }
		//    return true;
		//}
        
		///// <summary>
		///// グリッドビューの入力項目に対する通貨型チェックを行う。<br/>
		///// 各グリッドの CellValidating イベント、RowValidating イベント等で使用する。
		///// </summary>
		///// <param name="grid">判定元となるグリッドビューを指定する</param>
		///// <param name="rowIndex">判定対象の RowIndex を指定する</param>
		///// <param name="colIndex">判定対象の ColumnIndex を指定する</param>
		///// <param name="value">判定対象の値を指定する</param>
		///// <param name="length">対象のFormat後の桁数を指定する</param>
		///// <param name="valueLength">判定対象の桁数を指定する</param>
		///// <returns>検証に成功した場合は true。失敗した場合は false を返す。</returns>
		//public bool IsValidateCell桁数(DataGridView grid, int rowIndex, int colIndex, string value, 
		//    int valueLength, int length)
		//{
		//    grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Empty;

		//    //decimal res;
		//    if (value.Length > valueLength)
		//    {
		//        grid.Rows[rowIndex].Cells[colIndex].ErrorText = string.Format(Properties.Resources.MSG_W_AがB桁を超えているため登録できません, 
		//            grid.Columns[colIndex].HeaderText, length);
		//        return false;
		//    }
		//    return true;
		//}

		///// <summary>
		///// 入力値検証。「新規」「変更」「削除」のチェック状態
		///// </summary>
		///// <param name="value">検証値を指定する</param>
		///// <param name="Is必須入力チェックを行う">必須入力の場合はtrue。そうでない場合はfalseを指定する。</param>
		///// <param name="maxlength">最大桁数を指定する</param>
		///// <param name="正規表現idx">正規表現を指定する</param>
		///// <returns>検証が成功した場合はtrue。そうでない場合はfalseを指定する。</returns>
		//public bool IsValidate新規変更削除チェック状態(DataGridView dgv, int iRow, int iCol新規, int iCol変更, int iCol削除, int iNo, ref string strErrMsg)
		//{
		//    int intチェック数 = 0;
		//    if ((Boolean)dgv.Rows[iRow].Cells[iCol新規].Value == true)
		//        intチェック数++;
		//    if ((Boolean)dgv.Rows[iRow].Cells[iCol変更].Value == true)
		//        intチェック数++;
		//    if ((Boolean)dgv.Rows[iRow].Cells[iCol削除].Value == true)
		//        intチェック数++;

		//    if (intチェック数 > 1)
		//    {
		//        strErrMsg = string.Format(Properties.Resources.MSG_W_A行目の_新規_変更_削除_が複数選択されていますが_いずれか１つのみチェックできます, (iRow + 1).ToString());
		//        return false;
		//    }

		//    if ((Boolean)dgv.Rows[iRow].Cells[iCol新規].Value == true &&
		//        int.Parse(dgv.Rows[iRow].Cells[iNo].Value.ToString()) > 0)
		//    {
		//        strErrMsg = string.Format(Properties.Resources.MSG_W_A行目は新規登録行ではない為_新規_をチェックすることはできません, (iRow + 1).ToString());
		//        return false;
		//    }

		//    if (((Boolean)dgv.Rows[iRow].Cells[iCol変更].Value == true ||
		//        (Boolean)dgv.Rows[iRow].Cells[iCol削除].Value == true) &&
		//        int.Parse(dgv.Rows[iRow].Cells[iNo].Value.ToString()) < 0)
		//    {
		//        strErrMsg = string.Format(Properties.Resources.MSG_W_A行目は新規登録の為_変更_削除_をチェックすることはできません, (iRow + 1).ToString());
		//        return false;
		//    }

		//    return true;
		//}


		//#endregion



        ////////////////////////////////////////////////////////////////////////
        // CSV処理
        ////////////////////////////////////////////////////////////////////////
        #region CSV処理

		////データグリッドビューのヘッダ情報をファイル出力する
		//public void Writeグリッドヘッダ(StreamWriter sw, DataGridView grid, int i開始列)
		//{
		//    string value;

		//    for (int iCol = i開始列; iCol < grid.Columns.Count; iCol++)   // プライマリーキー列以降を出力
		//    {
		//        //値取得
		//        value = CSV規定書式変換(grid.Columns[iCol].HeaderText);
		//        sw.Write("\"" + value + "\"");

		//        //カンマ編集
		//        if ((grid.Columns.Count - 1) > iCol)
		//            sw.Write(',');
		//    }

		//    sw.Write("\r\n");
		//}

		///// <summary>
		///// グリッドの内容をCSV形式で出力する
		///// </summary>
		///// <param name="grid">出力したいグリッドビューを指定する</param>
		///// <param name="fileName">出力するファイル名を指定する</param>
		///// <param name="IsHeader">ヘッダを出力したい場合は true。出力しない場合は false を指定する。</param>
		///// <param name="i開始列">CSVファイルに出力する、グリッドの開始列。</param>
		///// <param name="b選択行のみ">true：選択行のみ　false：全行</param>
		//public void CreateCSVファイル(DataGridView grid, string fileName, bool IsHeader, int i開始列, bool b選択行のみ, string str検索条件)
		//{
		//    string 一時ファイル = string.Format(@"{0}{1}.csv", Path.GetTempPath(), DateTime.Now.ToString("yyyyMMddHHmmss"));

		//    using (StreamWriter sw = new StreamWriter(一時ファイル, false, Encoding.GetEncoding("Shift_JIS")))
		//    {
		//        if (str検索条件 != "")
		//            sw.Write("\"" + str検索条件 + "\"\r\n\r\n");

		//        if (IsHeader)
		//            Writeグリッドヘッダ(sw, grid, i開始列);

		//        if (b選択行のみ == true)
		//            Writeグリッド明細_Selected(sw, grid, i開始列);
		//        else
		//            Writeグリッド明細(sw, grid, i開始列);
		//    }

		//    File.Copy(一時ファイル, fileName, true);

		//    if (File.Exists(一時ファイル))
		//        File.Delete(一時ファイル);
		//}

		public static void メール宛先抽出(DataGridView grid, int i顧客No列No, int i顧客ID列No, int i氏名列No, int iメールアドレス列No, ref D11メール配信.D11宛先DataTable dt)
        {
            dt = new D11メール配信.D11宛先DataTable();
            foreach (DataGridViewRow row in grid.SelectedRows)
            {
                D11メール配信.D11宛先Row 宛先Row = dt.NewD11宛先Row();

                宛先Row.顧客No = int.Parse(row.Cells[i顧客No列No].ToString());
                宛先Row.顧客ID = row.Cells[i顧客ID列No].Value.ToString();
                宛先Row.氏名 = row.Cells[i氏名列No].Value.ToString();
                宛先Row.メールアドレス = row.Cells[iメールアドレス列No].Value.ToString();

                dt.AddD11宛先Row(宛先Row);
            }
        }

		///// <summary>
		///// グリッドの内容をCSV形式で出力する
		///// </summary>
		///// <param name="grid">出力したいグリッドビューを指定する</param>
		///// <param name="fileName">出力するファイル名を指定する</param>
		///// <param name="IsHeader">ヘッダを出力したい場合は true。出力しない場合は false を指定する。</param>
		///// <param name="i開始列">CSVファイルに出力する、グリッドの開始列。</param>
		///// <param name="b選択行のみ">true：選択行のみ　false：全行</param>
		//public void CreateCSVファイル_旧顧客詳細(DataGridView dgv購買履歴, DataGridView dgvお勧め商品, string fileName,
		//    string str基本情報)
		//{
		//    string 一時ファイル = string.Format(@"{0}{1}.csv", Path.GetTempPath(), DateTime.Now.ToString("yyyyMMddHHmmss"));

		//    using (StreamWriter sw = new StreamWriter(一時ファイル, false, Encoding.GetEncoding("Shift_JIS")))
		//    {
		//        sw.Write(str基本情報);
		//        sw.Write("\r\n");

		//        Writeグリッドヘッダ(sw, dgv購買履歴, 1);
		//        Writeグリッド明細(sw, dgv購買履歴, 1);

		//        sw.Write("\r\n");

		//        Writeグリッドヘッダ(sw, dgvお勧め商品, 1);
		//        Writeグリッド明細(sw, dgvお勧め商品, 1);
		//    }

		//    File.Copy(一時ファイル, fileName, true);

		//    if (File.Exists(一時ファイル))
		//        File.Delete(一時ファイル);
		//}


		////CSV出力形式に見合った書式へ変換する
		//private string CSV規定書式変換(string field)
		//{
		//    string ret = field;
		//    if ((field.IndexOf('"') > -1)
		//        || (field.IndexOf(',') > -1)
		//        || (field.IndexOf('\r') > -1)
		//        || (field.IndexOf('\n') > -1)
		//        || (field.StartsWith(" "))
		//        || (field.StartsWith("\t"))
		//        || (field.EndsWith(" "))
		//        || (field.EndsWith("\t")))
		//    {
		//        if (field.IndexOf('"') > -1)
		//        {
		//            //"を""とする
		//            ret = field.Replace("\"", "\"\"");
		//        }
		//        ret = "\"" + field + "\"";
		//    }
		//    return ret;
		//}

		////データグリッドビューの明細情報をファイル出力する
		//private void Writeグリッド明細_Selected(StreamWriter sw, DataGridView grid, int i開始列)
		//{
		//    //string value;

		//    foreach (DataGridViewRow row in grid.SelectedRows)
		//    {
		//        string strRowData = "";
		//        for (int iCol = i開始列; iCol < row.Cells.Count; iCol++)   // プライマリーキー列以降を出力
		//        {
		//            //値取得
		//            //value = CSV規定書式変換(row.Cells[iCol].FormattedValue.ToString());
		//            //strRowData += "\"" + value + "\"";
		//            strRowData += "\"" + row.Cells[iCol].FormattedValue.ToString() + "\"";

		//            //カンマ編集
		//            if ((grid.Columns.Count - 1) > iCol)
		//            {
		//                //sw.Write(',');
		//                strRowData += ",";
		//            }
		//        }

		//        string strTmp = strRowData.Replace(",", "").Replace("\"", "");
		//        if (strTmp.Length == 0)
		//            continue;

		//        sw.Write(strRowData);
		//        sw.Write("\r\n");
		//    }
		//}

		////データグリッドビューの明細情報をファイル出力する
		//public void Writeグリッド明細(StreamWriter sw, DataGridView grid, int i開始列)
		//{

		//    foreach (DataGridViewRow row in grid.Rows)
		//    {
		//        string strRowData = "";
		//        for (int iCol = i開始列; iCol < row.Cells.Count; iCol++)   // プライマリーキー列以降を出力
		//        {
		//            //値取得
		//            //value = CSV規定書式変換(row.Cells[iCol].FormattedValue.ToString());
		//            //strRowData += "\"" + value + "\"";
		//            strRowData += "\"" + row.Cells[iCol].FormattedValue.ToString() + "\"";

		//            //カンマ編集
		//            if ((grid.Columns.Count - 1) > iCol)
		//            {
		//                //sw.Write(',');
		//                strRowData += ",";
		//            }
		//        }

		//        string strTmp = strRowData.Replace(",", "").Replace("\"", "");
		//        if (strTmp.Length == 0)
		//            continue;

		//        sw.Write(strRowData);
		//        sw.Write("\r\n");
		//    }
		//}

		////依頼者宛にメールを送信する
		//public void 行数表示(int intX, int intY, int intRowHeadersWidth, int intRowBoundsHeight,
		//    Graphics gra, int intRow, Font fnt, Color clrFore)
		//{
		//    // 行ヘッダのセル領域を、行番号を描画する長方形とする
		//    // （ただし右端に4ドットのすき間を空ける）
		//    Rectangle rect = new Rectangle(intX, intY,
		//                                   intRowHeadersWidth - 4,
		//                                   intRowBoundsHeight);

		//    // 上記の長方形内に行番号を縦方向中央＆右詰めで描画する
		//    // フォントや前景色は行ヘッダの既定値を使用する
		//    TextRenderer.DrawText(gra, (intRow + 1).ToString(),
		//                          fnt, rect, clrFore,   
		//                          TextFormatFlags.VerticalCenter | TextFormatFlags.Right);
		//}

        //　最後に計算した日時を返す
		public static string 最後に計算した日時()
        {
            顧客分析君.D01業務共通TableAdapters.D01属性ta d01属性ta;
            d01属性ta = new 顧客分析君.D01業務共通TableAdapters.D01属性ta();

            // 計算時間を取得
            return d01属性ta.Scalar値(4);
        }

        //　分析手法を返す
		public static string 分析手法を取得()
        {
            if (mstr分析手法 == "")
            {
                顧客分析君.D01業務共通TableAdapters.D01属性ta d01属性ta;
                d01属性ta = new 顧客分析君.D01業務共通TableAdapters.D01属性ta();

                // 計算時間を取得
                mstr分析手法 = d01属性ta.Scalar値(15);

                return mstr分析手法;
            }
            else
            { 
                return mstr分析手法;
            }
        }


        //　分析手法を変更する
		public static void 分析手法を変更(string str分析手法)
        {
            顧客分析君.D01業務共通TableAdapters.D01属性ta d01属性ta;
            d01属性ta = new 顧客分析君.D01業務共通TableAdapters.D01属性ta();

            // 計算時間を取得
            d01属性ta.Update(str分析手法, C02業務共通処理.miログインスタッフNo, 15);
            mstr分析手法 = str分析手法;
        }

		// i分析モード：1=RFM分析 2=FM分析
		public static void ランク毎の顧客数取得(ref int[] iランク毎の顧客数, int i分析モード)
        {
            SqlConnection scnKB = new SqlConnection(Properties.Settings.Default.KB);

            String strSQL;

            // 総顧客数を取得
            //strSQL = " SELECT COUNT(*) AS cnt FROM M03顧客 ";
            strSQL = "";
            strSQL += " SELECT COUNT(*) AS cnt ";
            strSQL += " FROM	( ";
            strSQL += "		SELECT MAX(販売日時) as 販売日時 ";
			strSQL += "		FROM   H01販売履歴 ";
			strSQL += "		group by 顧客No ";
			strSQL += " ) as a ";

            scnKB.Open();
            SqlCommand cmd = new SqlCommand(strSQL, scnKB);
            SqlDataReader rdr = cmd.ExecuteReader();
            rdr.Read();
            int i総顧客数 = int.Parse(rdr[0].ToString());
            rdr.Close();
			scnKB.Close();

			if (i分析モード == miRFM分析)
			{
				// RFMランク毎の顧客数を計算
				int i余り = i総顧客数 % 5;
				for (int iCnt = 0; iCnt < 5; iCnt++)
				{
					iランク毎の顧客数[iCnt] = i総顧客数 / 5;

					if (i余り > 0)
					{
						iランク毎の顧客数[iCnt]++;
						i余り--;
					}
				}
			}
			else if (i分析モード == miFM分析)
			{
				// FMランク毎の顧客数を計算
				int i余り = i総顧客数 % 3;
				for (int iCnt = 0; iCnt < 3; iCnt++)
				{
					iランク毎の顧客数[iCnt] = i総顧客数 / 3;

					if (i余り > 0)
					{
						iランク毎の顧客数[iCnt]++;
						i余り--;
					}
				}
			}
			
        }

		public static bool Rパラメータ計算(ref string[] strR, int i分析モード)
        {
            int[] iランク毎の顧客数 = new int[5];
			ランク毎の顧客数取得(ref iランク毎の顧客数, i分析モード);

            SqlConnection scnKB = new SqlConnection(Properties.Settings.Default.KB);
            scnKB.Open();

            // R5のパラメータ
            String strSQL = " SELECT MIN(b.販売日時) ";
            strSQL += " FROM ";
            strSQL += " ( ";
            strSQL += "   SELECT TOP " + iランク毎の顧客数[0].ToString() + " a.販売日時 ";
            strSQL += "   FROM ";
            strSQL += "   ( ";
            strSQL += "     SELECT MAX(販売日時) as 販売日時 ";
            strSQL += "     FROM   H01販売履歴 ";
            strSQL += "     group by 顧客No ";
            strSQL += "   ) as a ";
            strSQL += "   ORDER BY a.販売日時 DESC ";
            strSQL += " ) as b ";
            SqlCommand cmd = new SqlCommand(strSQL, scnKB);
            SqlDataReader rdr = cmd.ExecuteReader();
            rdr.Read();
            if (rdr[0] == DBNull.Value) return false;
            DateTime dtランク毎の最小日時 = DateTime.Parse(rdr[0].ToString());
            rdr.Close();
            TimeSpan ts最小日と今日との差 = (TimeSpan)(DateTime.Today - dtランク毎の最小日時);
            strR[0] = ((int)ts最小日と今日との差.TotalDays + 1).ToString();

            int i顧客数Cnt = iランク毎の顧客数[0];

			int iCntMax = 4;
			if (i分析モード == miFM分析)
				iCntMax = 2;
			
			// R4～R2のパラメータ
			for (int iCnt = 1; iCnt < iCntMax; iCnt++)
            {
                strSQL = " SELECT MIN(b.販売日時) ";
                strSQL += " FROM ";
                strSQL += " ( ";
                strSQL += "   SELECT TOP " + iランク毎の顧客数[iCnt].ToString() + " a.販売日時, a.顧客No ";
                strSQL += "   FROM ";
                strSQL += "   ( ";
                strSQL += "     SELECT MAX(販売日時) AS 販売日時, 顧客No AS 顧客No ";
                strSQL += "     FROM   H01販売履歴 ";
                strSQL += "     WHERE  顧客No NOT IN ";
                strSQL += "     ( ";
                strSQL += "       SELECT TOP " + i顧客数Cnt + " c.顧客No ";
                strSQL += "       FROM ";
                strSQL += "       ( ";
                strSQL += "         SELECT MAX(販売日時) AS 販売日時, 顧客No AS 顧客No ";
                strSQL += "         FROM   H01販売履歴 ";
                strSQL += "         GROUP BY 顧客No ";
                strSQL += "       ) AS c ";
                strSQL += "       ORDER BY c.販売日時 DESC ";
                strSQL += "     ) ";
                strSQL += "     GROUP BY 顧客No ";
                strSQL += "   ) AS a ";
                strSQL += "   ORDER BY a.販売日時 DESC ";
                strSQL += " ) AS b ";
                cmd = new SqlCommand(strSQL, scnKB);
                rdr = cmd.ExecuteReader();
                rdr.Read();
                if (rdr[0] == DBNull.Value) return false;
                dtランク毎の最小日時 = DateTime.Parse(rdr[0].ToString());
                rdr.Close();
                ts最小日と今日との差 = (TimeSpan)(DateTime.Today - dtランク毎の最小日時);

                // １つ前のパラメータと同一か、小さい値の場合、
                if ((int)ts最小日と今日との差.TotalDays <= int.Parse(strR[iCnt - 1]))
                    strR[iCnt] = (int.Parse(strR[iCnt - 1]) + 1).ToString();
                else
                    strR[iCnt] = ((int)ts最小日と今日との差.TotalDays + 1).ToString();

                i顧客数Cnt += iランク毎の顧客数[iCnt];
            }
                
            scnKB.Close();

            return true;
        }

		public static bool Fパラメータ計算(ref string[] strF, int i分析モード)
        {
            int[] iランク毎の顧客数 = new int[5];
            ランク毎の顧客数取得(ref iランク毎の顧客数, i分析モード);

            SqlConnection scnKB = new SqlConnection(Properties.Settings.Default.KB);
            scnKB.Open();

            // F5のパラメータ
            String strSQL;
            strSQL  = " SELECT MIN(cnt) AS cnt ";
            strSQL += " FROM ";
            strSQL += " ( ";
            strSQL += "   SELECT TOP " + iランク毎の顧客数[0].ToString() + " COUNT(販売日時) AS cnt, 顧客No ";
            strSQL += "   FROM ";
            strSQL += "   ( ";
            strSQL += "       SELECT DISTINCT 販売日時, 顧客No ";
            strSQL += "       FROM            H01販売履歴 ";
            strSQL += "   ) as a ";
            strSQL += "   GROUP BY 顧客No ";
            strSQL += "   ORDER BY cnt DESC ";
            strSQL += " ) AS d ";
            SqlCommand cmd = new SqlCommand(strSQL, scnKB);
            SqlDataReader rdr = cmd.ExecuteReader();
            rdr.Read();
            if (rdr[0] == DBNull.Value) return false;
            strF[0] = rdr[0].ToString();
            rdr.Close();

            int i顧客数Cnt = iランク毎の顧客数[0];

			int iCntMax = 4;
			if (i分析モード == miFM分析)
				iCntMax = 2;

            // F4～F2のパラメータ
			for (int iCnt = 1; iCnt < iCntMax; iCnt++)
			//for (int iCnt = 1; iCnt < 4; iCnt++)
			{
                strSQL =  " SELECT MIN(cnt) AS cnt ";
                strSQL += " FROM ";
                strSQL += " ( ";
                strSQL += "   SELECT TOP " + iランク毎の顧客数[iCnt].ToString() + " COUNT(販売日時) AS cnt, 顧客No ";
                strSQL += "   FROM ";
                strSQL += "   ( ";
                strSQL += "     SELECT DISTINCT 販売日時, 顧客No ";
                strSQL += "     FROM            H01販売履歴 ";
                strSQL += "     WHERE 顧客No NOT IN  ";
                strSQL += "     ( ";
                strSQL += "       SELECT 顧客No ";
                strSQL += "       FROM ";
                strSQL += "       ( ";
                strSQL += "         SELECT TOP " + i顧客数Cnt.ToString() + " COUNT(販売日時) AS cnt, 顧客No ";
                strSQL += "         FROM ";
                strSQL += "         ( ";
                strSQL += "           SELECT DISTINCT 販売日時, 顧客No ";
                strSQL += "           FROM            H01販売履歴 ";
                strSQL += "         ) AS a ";
                strSQL += "         GROUP BY 顧客No ";
                strSQL += "         ORDER BY cnt DESC ";
                strSQL += "       ) AS b ";
                strSQL += "     ) ";
                strSQL += "   ) AS c ";
                strSQL += "   GROUP BY 顧客No ";
                strSQL += "   ORDER BY cnt DESC ";
                strSQL += " ) AS d ";
                cmd = new SqlCommand(strSQL, scnKB);
                rdr = cmd.ExecuteReader();
                rdr.Read();
                if (rdr[0] == DBNull.Value) return false;

                // １つ前のパラメータと同一か、小さい値の場合、
                if (int.Parse(strF[iCnt]) >= int.Parse(strF[iCnt - 1]))
                    strF[iCnt] = (int.Parse(strF[iCnt - 1]) - 1).ToString();
                else
                    strF[iCnt] = rdr[0].ToString();

                rdr.Close();

                i顧客数Cnt += iランク毎の顧客数[iCnt];
            }

            scnKB.Close();

            return true;
        }

		public static bool Mパラメータ計算(ref string[] strM, int i分析モード)
        {
            int[] iランク毎の顧客数 = new int[5];
			ランク毎の顧客数取得(ref iランク毎の顧客数, i分析モード);

            SqlConnection scnKB = new SqlConnection(Properties.Settings.Default.KB);
            scnKB.Open();

            // M5のパラメータ
            String strSQL;
            strSQL =  " SELECT MIN(sum) AS sum ";
            strSQL += " FROM ";
            strSQL += " ( ";
            strSQL += "   SELECT TOP " + iランク毎の顧客数[0].ToString() + " SUM(販売金額) AS sum, 顧客No ";
            strSQL += "   FROM   H01販売履歴 ";
            strSQL += "   GROUP BY 顧客No ";
            strSQL += "   ORDER BY sum DESC ";
            strSQL += " ) AS d ";
            SqlCommand cmd = new SqlCommand(strSQL, scnKB);
            SqlDataReader rdr = cmd.ExecuteReader();
            rdr.Read();
            if (rdr[0] == DBNull.Value) return false;
            strM[0] = rdr[0].ToString();
            rdr.Close();

            int i顧客数Cnt = iランク毎の顧客数[0];

			int iCntMax = 4;
			if (i分析モード == miFM分析)
				iCntMax = 2;
			
			// M4～M2のパラメータ
			for (int iCnt = 1; iCnt < iCntMax; iCnt++)
            {
                strSQL =  " SELECT MIN(sum) AS sum ";
                strSQL += " FROM ";
                strSQL += " ( ";
                strSQL += "   SELECT TOP " + iランク毎の顧客数[iCnt].ToString() + " SUM(販売金額) AS sum, 顧客No ";
                strSQL += "   FROM H01販売履歴 ";
                strSQL += "   WHERE 顧客No NOT IN  ";
                strSQL += "   ( ";
                strSQL += "     SELECT 顧客No ";
                strSQL += "     FROM ";
                strSQL += "     ( ";
                strSQL += "       SELECT TOP " + i顧客数Cnt.ToString() + " SUM(販売金額) AS sum, 顧客No ";
                strSQL += "       FROM            H01販売履歴 ";
                strSQL += "       GROUP BY 顧客No ";
                strSQL += "       ORDER BY sum DESC ";
                strSQL += "     ) AS b ";
                strSQL += "   ) ";
                strSQL += "   GROUP BY 顧客No ";
                strSQL += "   ORDER BY sum DESC ";
                strSQL += " ) AS d ";
                cmd = new SqlCommand(strSQL, scnKB);
                rdr = cmd.ExecuteReader();
                rdr.Read();
                if (rdr[0] == DBNull.Value) return false;

                // １つ前のパラメータと同一か、小さい値の場合、
                if (long.Parse(strM[iCnt]) >= long.Parse(strM[iCnt - 1]))
                    strM[iCnt] = (long.Parse(strM[iCnt - 1]) - 1).ToString();
                else
                    strM[iCnt] = rdr[0].ToString();

                rdr.Close();

                i顧客数Cnt += iランク毎の顧客数[iCnt];
            }

            scnKB.Close();

            return true;
        }

		//public bool IsValidate共通(string value, bool Is必須入力チェックを行う, int maxlength, int 正規表現idx, string header, ref string strErrorDetail)
		//{
		//    if (Is必須入力チェックを行う)
		//    {
		//        if (value == string.Empty)
		//        {
		//            strErrorDetail = string.Format(Properties.Resources.MSG_W_Aは必須入力です, header);
		//            return false;
		//        }
		//    }

		//    if (value.Length > maxlength)
		//    {
		//        strErrorDetail = string.Format(Properties.Resources.MSG_W_AがB桁を超えているため登録できません, header, maxlength);
		//        return false;
		//    }


		//    if (value == "") return true;   // データが無ければ、後のチェックを行わない。

		//    if (!C10Validate.IsMatch(value, 正規表現idx))
		//    {
		//        if (((正規表現idx == C_正規表現.半角数字) || (正規表現idx == C_正規表現.メールアドレス)) &&
		//            (value == string.Empty))
		//        {
		//            //半角数字、メールアドレス、IPアドレスの場合で空文字の場合はエラーとしない
		//            return true;
		//        }

		//        if (正規表現idx == C_正規表現.半角数字)
		//        {
		//            if (header == "商品単価")
		//                strErrorDetail = string.Format(Properties.Resources.MSG_W_Aには_0_Bまでの値以外を入力できません, header, (long)C_最大値.商品単価);
		//            else if (header == "販売個数")
		//                strErrorDetail = string.Format(Properties.Resources.MSG_W_Aには_0_Bまでの値以外を入力できません, header, (long)C_最大値.販売個数);
		//            //else if (header == "年齢")
		//            //    strErrorDetail = string.Format(Properties.Resources.MSG_INF_100, header, (long)C_最大値.年齢);
		//            else if (header == "シリアルキー購入数")
		//                strErrorDetail = string.Format(Properties.Resources.MSG_W_Aには_0_Bまでの値以外を入力できません, header, (long)C_最大値.シリアルキー購入数);
		//        }
		//        else
		//        {
		//            strErrorDetail = string.Format(Properties.Resources.MSG_W_AはBでなければなりません, header, 正規表現idx.ToString());
		//        }

		//        return false;
		//    }

		//    return true;
		//}

		public static bool スタッフ認証(string strスタッフID, string strパスワード)
        {
            D12スタッフ.D12スタッフDataTable dt = new D12スタッフ.D12スタッフDataTable();
            D12スタッフTableAdapters.D12スタッフta ta = new D12スタッフTableAdapters.D12スタッフta();
            ta.FillBy認証(dt, strスタッフID, strパスワード);
            if (dt.Count > 0)
            {
                miログインスタッフNo = dt[0].スタッフNo;
                return true;
            }
            else
                return false;
        }

		//public void 新規変更削除列のチェック状態変更(DataGridViewCellEventArgs e, int iColNo, int iCol新規, int iCol変更, int iCol削除, ref DataGridView dgv)
		//{
		//    if (e.RowIndex < 0)
		//        return;

		//    if (e.ColumnIndex < 3)
		//        return;

		//    if (dgv.Rows[e.RowIndex].Cells[iColNo].Value == null)
		//        return;

		//    if (int.Parse(dgv.Rows[e.RowIndex].Cells[iColNo].Value.ToString()) < 1)
		//    {
		//        // 「新規」列をチェック状態にする
		//        dgv.Rows[e.RowIndex].Cells[iCol新規].Value = true;
		//        dgv.Rows[e.RowIndex].Cells[iCol変更].Value = false;
		//        dgv.Rows[e.RowIndex].Cells[iCol削除].Value = false;
		//    }
		//    else
		//    {
		//        // 「変更」列をチェック状態にする
		//        dgv.Rows[e.RowIndex].Cells[iCol新規].Value = false;
		//        dgv.Rows[e.RowIndex].Cells[iCol変更].Value = true;
		//        dgv.Rows[e.RowIndex].Cells[iCol削除].Value = false;
		//    }
		//}

        #endregion
    }


}
