﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Net.Mail;

using SystemCommon;
using ClientCommon;


namespace 顧客分析君
{
    public partial class _205メール配信 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        public D11メール配信.D11宛先DataTable mdt宛先;
        private string mstrメールテンプレートNo;

		//private enum enm宛先Cell : int
		//{
		//    顧客No = 0,
		//    顧客ID = 1,
		//    氏名 = 2,
		//    メールアドレス = 3
		//}
		private static class 宛先Cell
		{
            public const byte byt顧客No = 0;
            public const byte byt顧客ID = 1;
            public const byte byt氏名 = 2;
			public const byte bytメールアドレス = 3;
		}


        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド 
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _205メール配信()
        {
            InitializeComponent();
        }

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド

        private void Set列幅()
        {
            dgv宛先.Columns[宛先Cell.byt顧客ID].Width = C_列幅.顧客ID;
            dgv宛先.Columns[宛先Cell.byt氏名].Width = C_列幅.氏名;
            dgv宛先.Columns[宛先Cell.bytメールアドレス].Width = C_列幅.メールアドレス;
        }

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _201メール作成_Load(object sender, EventArgs e)
        {
            try
            {
                d11宛先bs.DataSource = mdt宛先;




            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_205メール配信", "_201メール作成_Load", ex);
            }
            finally
            {
                Set列幅();
            }
        }

        private void dgv宛先_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgv宛先.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgv宛先.RowHeadersDefaultCellStyle.Font,
                                              dgv宛先.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_205メール配信", "dgv宛先_RowPostPaint", ex);
            }
        }

        private void btnメールテンプレート一覧から取得_Click(object sender, EventArgs e)
        {
            try
            {
                _207メールテンプレート一覧 _207メールテンプレート一覧 = null;
                _207メールテンプレート一覧 = new _207メールテンプレート一覧();
                C01FormCommon.画面最小サイズに変更(_207メールテンプレート一覧, false);
                if (_207メールテンプレート一覧.ShowDialog() != DialogResult.OK)
                    return;

                mstrメールテンプレートNo = _207メールテンプレート一覧.mstrメールテンプレートNo;

                txtテストメール送信先.Text = _207メールテンプレート一覧.mstrテストメール配信先;
                txt作成_from.Text = _207メールテンプレート一覧.mstrメールテンプレートNo;
                txtテンプレート名.Text = _207メールテンプレート一覧.mstrメールテンプレート名;
                txt作成_from.Text = _207メールテンプレート一覧.mstrFromアドレス;
                txt作成_件名.Text = _207メールテンプレート一覧.mstr件名;
                txt作成_本文1.Text = _207メールテンプレート一覧.mstr本文1;

                if (_207メールテンプレート一覧.mstrお勧め商品掲載 == "有り")
                    chkお勧め商品を掲載.Checked = true;
                else
                    chkお勧め商品を掲載.Checked = false;

                if (_207メールテンプレート一覧.mstrお勧め商品区分 == "顧客別")
                    rdo顧客別.Checked = true;
                else
                    rdoRFMランク別.Checked = true;

                txt作成_本文2.Text = _207メールテンプレート一覧.mstr本文2;
                txt作成_署名.Text = _207メールテンプレート一覧.mstr署名;

            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_205メール配信", "btn初期値設定_Click", ex);
            }
        }

        private void chkお勧め商品を掲載_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (chkお勧め商品を掲載.Checked == false)
                {
                    rdo顧客別.Checked = false;
                    rdoRFMランク別.Checked = false;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_205メール配信", "chkお勧め商品を掲載_CheckedChanged", ex);
            }
        }

        private void rdo顧客別_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (rdo顧客別.Checked == false)
                {
                    txt顧客別ヘッダー.Text = "";
                    txt顧客別ヘッダー.Enabled = false;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_205メール配信", "rdo顧客別_CheckedChanged", ex);
            }
        }

        private void rdoRFMランク別_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (rdoRFMランク別.Checked == false)
                {
                    txtRFMランク別ヘッダー.Text = "";
                    txtRFMランク別ヘッダー.Enabled = false;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_205メール配信", "rdoRFMランク別_CheckedChanged", ex);
            }
        }

        private void btnテンプレートとして保存_Click(object sender, EventArgs e)
        {
            try
            {
                byte btお勧め商品を掲載;
                if (chkお勧め商品を掲載.Checked == true)
                    btお勧め商品を掲載 = 1;
                else
                    btお勧め商品を掲載 = 2;

                byte btお勧め商品区分;
                if (rdo顧客別.Checked == true)
                    btお勧め商品区分 = 1;
                else
                    btお勧め商品区分 = 2;

                if (mstrメールテンプレートNo == "")
                    d11メールテンプレートta.Insert(txtテンプレート名.Text, txt作成_from.Text, txt作成_件名.Text, 
                        txt作成_本文1.Text, btお勧め商品を掲載, btお勧め商品区分, txt作成_本文2.Text, 
                        txt作成_署名.Text, txtテンプレート名.Text);
                else
                    d11メールテンプレートta.Update(txtテンプレート名.Text, txt作成_from.Text, txt作成_件名.Text, 
                        txt作成_本文1.Text,btお勧め商品を掲載, btお勧め商品区分, txt作成_本文2.Text, 
                        txt作成_署名.Text, txtテンプレート名.Text, int.Parse(mstrメールテンプレートNo));

            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_205メール配信", "btnテンプレートとして保存_Click", ex);
            }
        }

        private string Create本文(int i顧客No)
        {
            string str本文 = "";

            str本文 += txt作成_本文1.Text;

            if (chkお勧め商品を掲載.Checked == true)
            {
                if (rdo顧客別.Checked == true)
                {
                    str本文 += txt顧客別ヘッダー.Text;

                    d10お勧め商品_顧客毎ta.Fill(d10顧客.D10お勧め商品_顧客毎, i顧客No);
                    for (int iRow = 0; iRow < d10顧客.D10お勧め商品_顧客毎.Count; iRow++)
                    {
                        str本文 += d10顧客.D10お勧め商品_顧客毎[iRow].商品名 + "\r\n";
                    }
                }
                else
                {
                    str本文 += txtRFMランク別ヘッダー.Text;


                }
            
            }

            str本文 += txt作成_本文2.Text;
            str本文 += txt作成_署名.Text;

            return str本文;
        }

        private void btnテストメール送信_Click(object sender, EventArgs e)
        {
            try
            {
                try
                {
                    C02業務共通処理.メール送信(txtテストメール送信先.Text, txt作成_from.Text, txt作成_件名.Text, 
                        Create本文(int.Parse(dgv宛先.Rows[0].Cells[宛先Cell.byt顧客No].ToString())));
                }
                catch
                //catch (Exception ex)
                {
                    //MessageBox.Show(strTo[iRow] + " へのメール送信が失敗しました。\r\nこの後の処理は中断されました。\r\n\r\nメールアドレスが間違っているか、SMTPサーバーの設定が間違っているか、不正な文字が含まれている可能性があります。\r\n\r\n\r\n" + ex.Message, "メール送信エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_205メール配信", "btnテストメール送信_Click", ex);
            }
        }

        private void btnメール配信開始_Click(object sender, EventArgs e)
        {
            try
            {
                for (int iRow = 0; iRow < dgv宛先.Rows.Count; iRow++)
                {
                    try
                    {
                        C02業務共通処理.メール送信(dgv宛先.Rows[iRow].Cells[宛先Cell.bytメールアドレス].ToString(),
                            txt作成_from.Text, txt作成_件名.Text, Create本文(int.Parse(dgv宛先.Rows[iRow].Cells[
                            宛先Cell.byt顧客No].ToString())));
                    }
                    catch
                    //catch (Exception ex)
                    {
                        //MessageBox.Show(strTo[iRow] + " へのメール送信が失敗しました。\r\nこの後の処理は中断されました。\r\n\r\nメールアドレスが間違っているか、SMTPサーバーの設定が間違っているか、不正な文字が含まれている可能性があります。\r\n\r\n\r\n" + ex.Message, "メール送信エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    }
                }

                MessageBox.Show("メールの送信が完了しました。", "メール送信", MessageBoxButtons.OK, MessageBoxIcon.Information);

            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_205メール配信", "btnメール配信開始_Click", ex);
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_205メール配信", "btnキャンセル_Click", ex);
            }

        }




        #endregion




    }
}
