/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.thin;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import jp.terasoluna.fw.web.RequestUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * T[oǏԂǂ̃`FbNsB
 * 
 * <p>
 * ̃NXł̓uEŨNGXgɑ΂tB^A 
 * fvCgfBXNv^iweb.xmlj
 * w肳ꂽCӂ{@link ServerBlockageController}CX^XĂяoA 
 * w肳ꂽpXƖǏԂǂ̃`FbNϏB
 * </p>
 * 
 * <h5>T[oǃ`FbN@\</h5>
 * <p>
 * T[oǏԂꍇ́A{@link ServerBlockageException}X[B
 * </p>
 * <h5>gp@</h5>
 * <p>
 * ̋@\gpɂ̓fvCgfBXNv^iweb.xmlj
 * Bean`t@CɈȉ̂悤ɐݒ肷B
 * ̂ƂABean`t@Cɒ`idA
 * sampleServerBlockageControllerł&lt;bean&gt;vf
 * classɂ́A{@link ServerBlockageController}C^tF[X
 * NXݒ肷B<br>
 * <br>
 * fvCgfBXNv^iweb.xmlj
 * <code><pre>
 * &lt;filter&gt;
 *   &lt;filter-name&gt;serverBlockageControlFilter&lt;/filter-name&gt;
 *   &lt;filter-class&gt;
 *     jp.terasoluna.fw.web.common.ServerBlockageControlFilter
 *   &lt;/filter-class&gt;
 *   &lt;init-param&gt;
 *     &lt;param-name&gt;controller&lt;/param-name&gt;
 *     &lt;param-value&gt;
 *       "sampleServerBlockageController"
 *     &lt;/param-value&gt;
 *   &lt;/init-param&gt;
 * &lt;/filter&gt;
 *
 * &lt;filter-mapping&gt;
 *   &lt;filter-name&gt;serverBlockageControlFilter&lt;/filter-name&gt;
 *   &lt;url-pattern&gt;/*&lt;/url-pattern&gt;
 * &lt;/filter-mapping&gt;
 * </pre></code>
 * 
 * Bean`t@C
 * <code><pre>
 * &lt;bean id="sampleServerBlockageController"
 *       class="jp.terasolunacSampleServerBlockageController" /&gt;
 * </pre></code>
 * 
 * ȂABean`t@Cɒ`&lt;bean&gt;vfidftHglł
 * "serverBlockageController"ɐݒ肷ꍇɂ́AfvCgfBXNv^
 * iweb.xmlj&lt;filter&gt;vf&lt;init-param&gt;vfȗ邱Ƃ
 * łB
 *  
 * @see jp.terasoluna.fw.web.thin.AuthorizationControlFilter
 * @see jp.terasoluna.fw.web.thin.AuthorizationController
 * @see jp.terasoluna.fw.web.thin.AuthenticationControlFilter
 * @see jp.terasoluna.fw.web.thin.AuthenticationController
 * @see jp.terasoluna.fw.web.thin.BlockageControlFilter
 * @see jp.terasoluna.fw.web.thin.BlockageController
 * @see jp.terasoluna.fw.web.thin.ServerBlockageController
 * 
 */
public class ServerBlockageControlFilter 
        extends AbstractControlFilter<ServerBlockageController> {
    
    /**
     * NGXgtB^ʉ߂ƂNGXg̃L[B
     */
    public static final String SERVER_BLOCKAGE_THRU_KEY 
        = "SERVER_BLOCKAGE_THRU_KEY";   
    
    /**
     * DIReiRg[[̎NX擾邽߂
     * &lt;bean&gt;vfidɎgpftHgidB
     */
    public static final String DEFAULT_SERVER_BLOCKAGE_BEAN_ID
        = "serverBlockageController";
    
    /**
     * T[o[ǃRg[̐sG[R[hB
     */
    private static final String SERVER_BLOCKAGE_CONTROLLER_ERROR 
        = "errors.server.blockage.controller";

    /**
     * T[o[ǏϏRg[NXB
     */
    private static final Class SERVER_BLOCKAGE_CONTROLLER_CLASS 
        = ServerBlockageController.class;
   
    /**
     * ONXB
     */
    private static Log log 
       = LogFactory
           .getLog(ServerBlockageControlFilter.class);

    /**
     * ServerBlockageControllerCX^XB
     */
    protected static ServerBlockageController controller = null;

    /**
     * ServerBlockageController ԂB
     * 
     * @return ServerBlockageController
     */
    public static ServerBlockageController getServerBlockageController() {
        return controller;
    }

    /**
     * tB^T[rXJnԂɂȂۂɁAReiɂČĂяoB 
     * 
     * ReíAFilterCX^XɁAinit\bh
     * 1 񂾂ĂяoB<br>
     * FilterɃtB^Ƃs悤ɗvɂ́A
     * init \bh IĂȂ΂ȂȂB
     * init\bh ̂ꂩ̏Ԃ̏ꍇARei
     * FilterT[rXԂɂłȂB<br>
     * <ul>
     *  <li>ServletException X[B</li>
     *  <li>ReiɂĒ`ꂽԓɁAAȂB</li>
     *  <li>ݒ肳ꂽRg[̎NX݂ȂA 
     *      ܂͐ݒُ펞B</li>
     * </ul>
     * 
     * @param config FilterConfigCX^XB
     * 
     * @throws javax.servlet.ServletException ُ펞ɃX[OB
     *             
     * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
     * @see jp.terasoluna.fw.web.thin.AbstractControlFilter
     */
    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        if (controller == null) {
            controller = getController();
        }
    }
    
    /**
     * T[oǃ`FbNsB
     * 
     * @param req
     *            HTTPNGXg
     * @param res
     *            HTTPX|X
     * @param chain
     *            tB^`F[
     * @throws IOException
     *             I/OG[
     * @throws ServletException
     *             T[ubgO
     * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest,
     *                                    javax.servlet.ServletResponse,
     *                                    javax.servlet.FilterChain)
     */
    @Override
    public void doFilter(ServletRequest req,
                         ServletResponse res,
                         FilterChain chain)
            throws IOException, 
                   ServletException {
     
        // NGXgtB^ʉ߂ǂ𔻒B
        if (req.getAttribute(SERVER_BLOCKAGE_THRU_KEY) == null) {

            // tB^̒ʉߏZbg
            req.setAttribute(SERVER_BLOCKAGE_THRU_KEY, "true");

            // T[oǃ`FbN
            if (controller
                .isBlockaded(RequestUtil.getPathInfo(req))) {
                if (log.isDebugEnabled()) {
                    log.debug("isBlockaded() failed.");
                }
                throw new ServerBlockageException();
            }
        }

        // ̃tB^܂̓T[ubg
        chain.doFilter(req, res);
    }

    /**
     * ANZXsNXׂC^tF[XԂB
     * 
     * @return ̃tB^ŎgpRg[̃NX
     */
    @Override
    protected Class getControllerClass() {
        return SERVER_BLOCKAGE_CONTROLLER_CLASS;
    }

    /**
     * Rg[̐sG[R[hԂB
     * 
     * @return G[R[h
     */
    @Override
    protected String getErrorCode() {
        return SERVER_BLOCKAGE_CONTROLLER_ERROR;
    }

    /**
     * DIReiRg[擾ۂ̃ftHgidԂB
     * 
     * @return ftHgidl
     */
    @Override
    public String getDefaultControllerBeanId() {
        return DEFAULT_SERVER_BLOCKAGE_BEAN_ID;
    }
    
}
