
    /*$RCSfile: validateZenkakuKanaString.js,v $ $Revision: 1.1.1.1 $ $Date: 2009/11/02 07:44:32 $ */
    /**
    * Check to see if fields are a zenkaku kana.
    * Fields are not checked if they are disabled.
    * <p>
    * @param form The form validation is taking place on.
    */
    function validateZenkakuKanaString(form) {
        var bValid = true;
        var focusField = null;
        var i = 0;
        var fields = new Array();
        var formName = form.getAttributeNode("name"); 
        var focus = true;

        oInteger = eval('new ' + formName.value + '_zenkakuKanaString()');
        for (x in oInteger) {
            var field = form[oInteger[x][0]];

            if ((field.type == 'hidden' ||
                field.type == 'text' ||
                field.type == 'textarea' ||
                field.type == 'select-one' ||
                field.type == 'radio') &&
                field.disabled == false) {

                var value = '';
                // get field's value
                if (field.type == "select-one") {
                    var si = field.selectedIndex;
                    if (si >= 0) {
                        value = field.options[si].value;
                    }
                } else {
                    value = field.value;
                }

                if (value.length > 0) {

                    for (index = 0; index < value.length; index++) {
                        valueChar = value.charAt(index);
                        if (!isZenkakuKanaChar(valueChar, zenkakuKanaList)) {
                            if (field.type != 'hidden' && focus) {
                                focusField = field;
                                focus = false;
                            }
                            fields[i++] = oInteger[x][1];
                            bValid = false;
                            break;
                        }
                    }
                }
            }
        }
        if (fields.length > 0) {
            if (focusField != null) {
                focusField.focus();
            }
            alert(fields.join('\n'));
        }
        return bValid;
    }
