/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.message;

import java.sql.ResultSet;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.object.MappingSqlQuery;

/**
 * bZ[W\[X擾RDBMSIy[VNXB<br>
 * DB擾bZ[W\[XDBMessageIuWFNgɊi[AԋpB
 * <br>
 * DBMessageIuWFNgɂ̓bZ[WR[hAR[hAR[hA
 * oAgR[hAbZ[W{̂i[BAR[hAR[h
 * yуoAgR[h͕K{ł͂ȂB݂Ȃꍇ́ADBMessageIuWFNg
 * ԋpɊYnullݒ肷B
 * 
 * @see jp.terasoluna.fw.message.DataSourceMessageSource
 * @see jp.terasoluna.fw.message.DBMessage
 * @see jp.terasoluna.fw.message.DBMessageResourceDAO
 * @see jp.terasoluna.fw.message.DBMessageResourceDAOImpl
 * 
 */
public class DBMessageQuery extends MappingSqlQuery {
  
    /**
     * bZ[WR[hi[ʃZbg̃JB
     */
    protected String rsCodeColumn = null;
    
    /**
     * bZ[W̌R[hi[ʃZbg̃JB
     */
    protected String rsLanguageColumn = null;
    
    /**
     * bZ[W̍R[hi[ʃZbg̃JB
     */
    protected String rsCountryColumn = null;
    
    /**
     * bZ[W̃oAgR[hi[ʃZbg̃JB
     */
    protected String rsVariantColumn = null;
    
    /**
     * bZ[W{̂i[ʃZbg̃JB
     */
    protected String rsMessageColumn = null;
    
    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(DBMessageQuery.class);
    
    /**
     * RXgN^ŐeNXSQLnARpCB
     * RpCOɃJɕsȒlnĂȂ`FbNB
     * K{JibZ[WR[hAbZ[W{́jnull`FbNyы󕶎
     * `FbN{B̑̃J͋󕶎`FbN݂̂{B
     * 
     * @param ds
     *            bZ[W\[Xi[f[^ZbgB
     * @param sql
     *            DB烁bZ[W\[X擾SQLB
     * @param codeColumn
     *            bZ[WR[hi[ꂽDB̃JB
     *            ݂Ȃꍇ͌xoB
     * @param languageColumn
     *            bZ[W̌R[hi[ꂽDB̃JB
     *            ΏۂƂȂꍇnullƂB
     * @param countryColumn
     *            bZ[W̍R[hi[ꂽDB̃JB
     *            ΏۂƂȂꍇnullƂB
     * @param variantColumn
     *            bZ[W̃oAgR[hi[ꂽDB̃JB
     *            ΏۂƂȂꍇnullƂB
     * @param messageColumn
     *            bZ[W{̂i[ꂽDB̃JB
     *            ݂Ȃꍇ͌xoB
     * 
     */
    public DBMessageQuery(DataSource ds, String sql, String codeColumn,
            String languageColumn, String countryColumn, String variantColumn,
            String messageColumn) {
        super(ds, sql);
        rsCodeColumn = codeColumn;
        rsLanguageColumn = languageColumn;
        rsCountryColumn = countryColumn;
        rsVariantColumn = variantColumn;
        rsMessageColumn = messageColumn;
        compile();
    }
    
    /**
     * DB擾bZ[W\[XDBMessageIuWFNgɊi[AԋpB
     * ƂēnꂽʃZbǧݍs̓eɂč쐬DBMessage
     * IuWFNgԂB
     * 
     * @return bZ[W\[Xi[DBMessageIuWFNg
     * 
     * @param rs
     *            DB擾lێ錋ʃZbg
     * @param rowNum
     *            Ă錋ʃZbg̍sԍ
     * 
     * @throws SQLException
     *             SQLO
     */
    @Override
    protected Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        // bZ[WR[hB
        String code = null;
        // bZ[W̌R[hB
        String language = null;
        // bZ[W̍R[hB
        String country = null;
        // bZ[W̃oAgR[hB
        String variant = null;
        // bZ[W{́B
        String message = null;

        // bZ[WR[h݂ȂꍇAxB
        code = rs.getString(rsCodeColumn);
        if (code == null) {
            code = "";
            if (log.isWarnEnabled()) {
                log.warn("MessageCode is null");
            }
        }

        // R[hJ݂邪AR[h݂ȂꍇA󕶎B
        if (rsLanguageColumn != null) {
            language = rs.getString(rsLanguageColumn);
            if (language == null) {
                language = "";
            }
        }

        // R[hJ݂邪AR[h݂ȂꍇA󕶎B
        if (rsCountryColumn != null) {
            country = rs.getString(rsCountryColumn);
            if (country == null) {
                country = "";
            }
        }

        // oAgR[hJ݂邪AoAgR[h݂ȂꍇA
        // 󕶎B
        if (rsVariantColumn != null) {
            variant = rs.getString(rsVariantColumn);
            if (variant == null) {
                variant = "";
            }
        }

        // bZ[W{݂̂ȂꍇA󕶎B
        message = rs.getString(rsMessageColumn);
        if (message == null) {
            message = "";
        }
        
        if (log.isDebugEnabled()) {
            log.debug(code + "," + language + "," + country + "," + variant
                    + "," + message);
        }
        return new DBMessage(code, language, country, variant, message);
    }
}